var snippetDataManager;

(function() {

    var tools = ace.require("ace/ext/language_tools");
    var snippetManager = ace.require("./snippets").snippetManager;
    var lang = ace.require("./lib/lang");
    var autoComplete = ace.require("ace/autocomplete");

    var lastContext;
    var lastContextTs = 0;

    // decode value
    function deco(str) {
        return decodeURIComponent(str);
    }

    // ext-language_tools:542
    // added description, previous list, mode
    var parseSnippetFile = function(str) {
        str = str.replace(/\r/g, "");
        var list = [], snippet = {};
        var re = /^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;
        var m;
        while (m = re.exec(str)) {
            if (m[1]) {
                try {
                    snippet = JSON.parse(m[1]);
                    list.push(snippet);
                } catch (e) {}
            } if (m[4]) {
                snippet.content = m[4].replace(/^\t/gm, "");
                list.push(snippet);
                snippet = {};
            } else {
                var key = m[2], val = m[3];
                if (key == "regex") {
                    var guardRe = /\/((?:[^\/\\]|\\.)*)|$/g;
                    snippet.guard = guardRe.exec(val)[1];
                    snippet.trigger = guardRe.exec(val)[1];
                    snippet.endTrigger = guardRe.exec(val)[1];
                    snippet.endGuard = guardRe.exec(val)[1];
                } else if (key == "snippet") {
                    snippet.tabTrigger = val.match(/^\S*/)[0];
                    if (!snippet.name)
                        snippet.name = val;
                } else {
                    snippet[key] = val;
                }
            }
        }
        return list;
    }

    function escapeSnipVars(str) {
        return str.replace(/\$\{[0-9]+\:([^}]+)\}/g, "$1");
    }

    function parseSnippetDataFile(data, mode, list) {
        if (!list)
            list = [];
        var s;
        for (var i = 0; i < data.length; i++) {
            s = data[i];
            s.mode = mode;
            s.name = s.name || s.title;
            s.tabTrigger = null;
            if (browser.touchEventsSupported) {
                str = escapeSnipVars(str);
            }
            list.push(s);
        }
        return list;
    };

    snippetManager.parseSnippetFile = function(str) {
        // Added code
        var list = []
        if (str && (str.events || str.actions || str.js)) {
            if (str.events)
                list = parseSnippetDataFile(str.events, "events"); // added mode parameter
            if (str.actions)
                list = parseSnippetDataFile(str.actions, "actions", list); // added mode, list parameters
            if (str.js)
                list = parseSnippetDataFile(str.js, "js", list); // added mode, list parameters
            return list;
        }
        // Added code

        return parseSnippetFile(str); // old one
    };

    // ext-language_tools:1421
    // after inserting, reopen if necessary
    autoComplete.Autocomplete.prototype.insertMatch = function(data, options) {
        if (!data)
            data = this.popup.getData(this.popup.getRow());
        if (!data)
            return false;

        if (data.completer && data.completer.insertMatch) {
            data.completer.insertMatch(this.editor, data);
        } else {
            if (this.completions.filterText) {
                var ranges = this.editor.selection.getAllRanges();
                for (var i = 0, range; range = ranges[i]; i++) {
                    range.start.column -= this.completions.filterText.length;
                    this.editor.session.remove(range);
                }
            }
            if (data.snippet)
                snippetManager.insertSnippet(this.editor, data.snippet);
            else
                this.editor.execCommand("insertstring", data.value || data);
        }
        this.detach();

        // HACK: added reopen if necessary
        var pos = fileManager.editor.getSelection().lead;
        var col = Math.min(pos.column, fileManager.editor.getSelection().anchor.column);
        var c = getContext(fileManager.editor.session, {row:pos.row, column:col});
        if (c.type)
            ace.require("ace/autocomplete").Autocomplete.startCommand.exec(fileManager.editor);
        // HACK

    };


    // ext-language_tools:1260
    // when there's a selection, always position at the beginning (ignore the selection content)
    var util = ace.require("ace/autocomplete/util");
    util.getCompletionPrefix = function (editor) {
        var pos = editor.getCursorPosition();
        // HACK: when there's a selection, always take the beginning
        pos = {row:pos.row, column:Math.min(editor.selection.anchor.column,pos.column)};
        // HACK
        var line = editor.session.getLine(pos.row);
        var prefix;
        editor.completers.forEach(function(completer) {
            if (completer.identifierRegexps) {
                completer.identifierRegexps.forEach(function(identifierRegex) {
                    if (!prefix && identifierRegex)
                        prefix = this.retrievePrecedingIdentifier(line, pos.column, identifierRegex);
                }.bind(this));
            }
        }.bind(this));
        return prefix || this.retrievePrecedingIdentifier(line, pos.column);
    };

    function getContext(session, opt) {
        // optimiztion. same ts?
        var now = new Date().getTime();
        if (lastContext && now-lastContextTs <= 20) {
            return lastContext;
        }

        var mode = "events";
        // assume it's a comma action until proven wrong?
        // 1: could be, check until beginning of line if :
        // 2: check end of the line: if first valid character is "," 1, otherwise 0
        // 0: not an action
        var checkAction = (opt.scope == "javascript" ? 0 : 1); // if scope is index.js, don't check for actions
        // find first {
        var line,
            row = opt.row,
            col = opt.column - 1;
        // at this column the context begins
        // (in case of actions, after the event if on same line or the , if more actions)
        var contextBeginCol = 0;
        var ob = 0;
        var c;
        var pc;
        var inString = false;
        while (row >= 0 && mode != "js") {
            line = session.getLine(row);
            if (col == null)
                col = line.length - 1;

            while (col >= 0) {
                pushToken = true;
                pc = c;
                c = line[col];
                if (inString) {
                    if (c == '"' && pc != "\\")
                        inString = false;
                } else {
                    switch (c) {
                        // check js
                        case "}":
                            ob--;
                            break;
                        case "{":
                            ob++;
                            break;
                        case ":":
                            if (ob == 0 && checkAction == 1) {
                                mode = "actions";
                                if (!contextBeginCol && row == opt.row)
                                    contextBeginCol = col;
                                checkAction = 0;
                            }
                            break;
                        default:
                            if (checkAction == 2) {
                                if (c == ",") {
                                    checkAction = 1;
                                } else if (c != " " && c != "\t") {
                                    checkAction = 0;
                                }
                            }
                            if (c == '"') {
                                inString = !inString;
                            } else if (!contextBeginCol && c == ',' && row == opt.row) {
                                contextBeginCol = col+1;
                            }
                            break;
                    }
                }
                if (ob > 0)
                    mode = "js";
                col--;
            }
            if (checkAction) {
                checkAction = 2;
            }
            col = null;
            c = null; // so pc will be null
            row--;
        }

        // tokens

        // type
        var type = "";
        var tokens = [];
        var token = "";
        line = session.getLine(opt.row);
        if (mode == "js") {
            var func = "";
            var params = []; // current function param
            var inJSFunctionParams = 0;
            var inString = false;
            c = null;
            var pc = null;
            var col = opt.column;
            for (var i = 0; i < col; i++) {
                pc = c;
                c = line[i];
                if (inString) {
                    token += c;
                    if (c == '"' && pc != "\\")
                        inString = false;
                } else {
                    switch (c) {
                        case '"':
                            inString = !inString;
                            token += c;
                            break;
                        case "(":
                            if (!inJSFunctionParams) { // in params, push only on commas
                                if (token) {
                                    func = token;
                                    token = "";
                                }
                            }
                            inJSFunctionParams++;
                            break;
                        case ")":
                            inJSFunctionParams--;
                            // function done, reset params
                            func = "";
                            params = [];
                            break;
                        case ",":
                            if (inJSFunctionParams == 1) {
                                params.push(token.trim());
                            }
                            break;
                        case " ":
                        case "\t":
                            token = ""; // reset token
                            break;
                        default:
                            token += c;
                            break;
                    }
                }
            }

            switch (func) {
                case "uiSet":
                case "uiSessionSet":
                    if (params.length == 0 && !token)
                        type = "ui_id";
                    else if (params.length == 1 && !token)
                        type = "ui_attr";
                    else
                        type = "none";
                    break;
                case "varGet":
                case "varSet":
                    if (params == 0 && !token)
                        type = "var";
                    else
                        type = "none";
                    break;
                case "ioGet":
                case "ioSet":
                    if (params == 0 && !token)
                        type = "io";
                    else
                        type = "none";
                    break;
            }

            lastContext = {mode:mode, type:type, params:params};
        } else {
            line = line.substr(contextBeginCol,opt.column-contextBeginCol).toLowerCase();
            if (mode == "events") {
                // get rid of ( and )
                line = line.replace(/\(\)/g, "");
            }
            tokens = line.split(/[\s\t:]+/);
            if (tokens.length && !tokens[0])
                tokens.shift();
            var t = tokens[tokens.length-2];
            t = t ? t.toLowerCase() : "";
            if (mode == "events") {
                if (opt.scope == "javascript") {
                    mode = "js";
                    if (t == "function") {
                        type = "fun"; // function already written, cut it from snippets
                    } else {
                        type = "callback"; // full callback (all snippets starting with function)
                    }
                } else {
                    switch (t) {
                        case "io":
                            type = "io";
                            break;
                        case "function":
                            type = "fun";
                            break;
                        case "and":
                        case "or":
                        case "not":
                            type = "evt";
                            break;
                    }
                }
            } else if (mode == "actions") {
                switch (t) {
                    case "uisessionset":
                    case "uiset":
                        type = "ui";
                        break;
                    case "io":
                        type = "io";
                        break;
                }
            }

            if (!type && tokens.length>1) {
                type = "none";
            }

            lastContext = {mode:mode, type:type};
        }

        // return
        lastContextTs = now;
        return lastContext;
    }

    var baseUrl = "http://wiki.hsyco.com/3.7/index.php/"
    var urls = {
    	"Events": "Event_Keywords",
    	"Actions": "Action_Keywords",
    	"Javascript Callback Functions": "JavaScript_Callback_Functions_API",
    	"Javascript Command and Utility Functions": "JavaScript_Command_and_Utility_Functions_API",
    	"Javascript": "Index.js"
    };

    // ext-language_tools:1790
    tools.snippetCompleter = {
        getCompletions: function(editor, session, pos, prefix, callback) {
            editor.completer.exactMatch = true; // HACK: do it here???

            var snippetMap = snippetManager.snippetMap;
            var completions = [];
            //snippetManager.getActiveScopes(editor).forEach(function(scope) {
            //}, this);
            var scope = snippetManager.$getScope(editor);
            var col = Math.min(pos.column, editor.getSelection().anchor.column);
            context = getContext(session, {row:pos.row, column:col, scope:scope});

            // expecting variables?
            if (context.type &&
                context.type != "fun" &&
                context.type != "callback" &&
                context.type != "evt")
                return;

            var snippets = snippetMap[scope] || [];
            var s,caption;
            var jse,isfun;
            for (var i = snippets.length; i--;) {
                s = snippets[i];
                if (!s.mode || s.mode == context.mode) { // add only if mode is the same
                    caption = s.name || s.tabTrigger;
                    if (!caption)
                        continue;
                    jse = (context.type == "fun" || context.type == "callback"); // add js event/callback(index.js) snippets
                    isfun = (caption.indexOf("function ")==0);
                    if (jse && !isfun)
                        continue; // not a js event
                    if (isfun &&
                        ((!context.type && s.mode == "js")||
                         context.type == "evt"))
                        continue; // in js, no events/callback
                    completions.push({
                        title: s.title,
                        subTitle: s.subTitle,

                        caption: context.type == "fun" ? caption.substr(9) : caption,
                        snippet: context.type == "fun" ? s.content.substr(9) : s.content,
                        doc: s.docHTML,
                        meta: s.tabTrigger && !s.name ? s.tabTrigger + "\u21E5 " : context.mode ? context.mode : "snippet",
                        type: "snippet"
                    });
                }
            }
            callback(null, completions);
        },
        getDocTooltip: function(item) {
            if (item.type == "snippet" && !item.docHTML) {
                // custom format
                if (item.title && item.subTitle) {
                    var title = lang.escapeHTML(item.title).trim();
                    var url = urls[item.subTitle.split(",")[0]];
                    if (url) {
                        var f = title.indexOf("function ");
                        url = baseUrl+url+"#"+(f==0 ? title.substr(9): title).split(/[(\s]/)[0];
    				    title = "<a href='#' onmousedown='window.open(\""+url+"\")'>"+title+"</a>";
                    }
                    item.docHTML = "<b>" + title + "</b><br>" +
                                    "<div class='ace_tooltip_subtitle'>"+lang.escapeHTML(item.subTitle).trim() + "</div>";
                    if (item.doc.trim())
                        item.docHTML +=
                                    "<hr></hr>" +
                                    "<div class='ace_tooltip_descr custom_descr'>"+item.doc.trim()+"</div>";
                } else {
                    item.docHTML = [
                        "<b>", lang.escapeHTML(item.caption), "</b>", "<hr></hr>",
                        item.doc ? item.doc : "<pre>"+lang.escapeHTML(item.snippet)+"</pre>"
                    ].join("");
                }
            }
        }
    };

    var hscVarsCompleter = {
        getCompletions: function(editor, session, pos, prefix, callback) {
            var completions = [];

            //snippetManager.getActiveScopes(editor).forEach(function(scope) {
            //});
            var scope = snippetManager.$getScope(editor);
            if (scope != "events" && scope != "javascript")
                return;
            var col = Math.min(pos.column, editor.getSelection().anchor.column);
            context = getContext(session, {row:pos.row, column:col, scope:scope});
            //console.log("vars "+context.mode+" | "+context.type);

            var t,n,v,d,a;
            var _d = "<style='font-size:80%'>"
            // IO
            if (context.type == "io")
            for (n in snippetDataManager.data.io) {
                v = snippetDataManager.data.io[n];
                //v[1] =  deco(v[1]); // not encoded?
                t = n = deco(n);
                if (context.mode == "js")
                    n = '"'+ t + '"';
                d = v[1];
                completions.push({
                    title: t,
                    subTitle: "I/O Datapoint",

                    caption: n,
                    snippet: n.replace(/\$/g,"\\$"),
                    doc: d,
                    meta: "I/O Datapoint",
                    type: "snippet"
                });
            }

            // ui
            if (context.type && context.type.indexOf("ui") == 0)
            for (n in snippetDataManager.data.ui) {
                v = deco(snippetDataManager.data.ui[n]);
                t = n = deco(n);
                var meta = "UI Attribute";
                a = n.split(".");
                d = a.pop();
                if (context.type == "ui_id") {
                    t = a.join(".");
                    n = '"'+ t + '"';
                    meta = "UI ID";
                    v = "";
                } else if (context.type == "ui_attr") {
                    if ('"'+a.join(".")+'"' != context.params[0])
                        continue;
                    n = '"'+ d + '"';
                }
                completions.push({
                    title: n,
                    subTitle: meta,

                    caption: n,
                    snippet: n.replace(/\$/g,"\\$"),
                    doc: v,
                    meta: meta,
                    type: "snippet"
                });
            }

            // vars
            if ((!context.type && scope!="javascript") || context.type == "var")
            for (n in snippetDataManager.data.vars) {
                v = deco(snippetDataManager.data.vars[n]);
                t = n = deco(n);
                if (context.mode == "js")
                    n = '"'+ t + '"';
                completions.push({
                    title: t,
                    subTitle: "Variable",

                    caption: n,
                    snippet: n.replace(/\$/g,"\\$"),
                    doc: v,
                    meta: "Variable",
                    type: "snippet"
                });
            }

            callback(null, completions);
        },
        getDocTooltip: function(item) {
            return;
            if (item.type == "snippet" && !item.docHTML) {
                item.docHTML = [
                    "<b>", lang.escapeHTML(item.caption), "</b>", "<hr></hr>",
                    item.doc ? item.doc : lang.escapeHTML(item.snippet)
                ].join("");
            }
        }
    };

    // ext-language_tools:1679
    autoComplete.FilteredList.prototype.filterCompletions = function(items, needle) {
        var results = [];

        var upper = needle.toUpperCase();
        var lower = needle.toLowerCase();
        loop: for (var i = 0, item; item = items[i]; i++) {
            var caption = item.value || item.caption || item.snippet;
            if (!caption) continue;
            var lastIndex = -1;
            var matchMask = 0;
            var penalty = 0;
            var index, distance;

            if (this.exactMatch) {
                if (needle.toLowerCase() !== caption.substr(0, needle.length).toLowerCase()) // HACK: added toLowerCase
                    continue loop;
            }else{
                for (var j = 0; j < needle.length; j++) {
                    var i1 = caption.indexOf(lower[j], lastIndex + 1);
                    var i2 = caption.indexOf(upper[j], lastIndex + 1);
                    index = (i1 >= 0) ? ((i2 < 0 || i1 < i2) ? i1 : i2) : i2;
                    if (index < 0)
                        continue loop;
                    distance = index - lastIndex - 1;
                    if (distance > 0) {
                        if (lastIndex === -1)
                            penalty += 10;
                        penalty += distance;
                    }
                    matchMask = matchMask | (1 << index);
                    lastIndex = index;
                }
            }
            item.matchMask = matchMask;
            item.exactMatch = penalty ? 0 : 1;
            item.score = (item.score || 0) - penalty;
            results.push(item);
        }
        return results;
    };


    // tools.textCompleter,
    //tools.setCompleters([tools.snippetCompleter, tools.keyWordCompleter, hscVarsCompleter]);
    tools.setCompleters([tools.snippetCompleter, hscVarsCompleter]);

    snippetDataManager = new (function(){
        var started = false;
        var req;
        // data to be displayed
    	this.data = {io:{}, ui:{}, vars:{}};

        this.showSessionData = false;

        var lastInputTs = 0;
        var maxIdleTime = 10000; // after n seconds, suspend

    	// timestamps
    	var ioLastReq = 0;
    	var uiLastReq = 0;
    	var varsLastReq = 0;

        var timeout;

        var self = this;

        var cReq =  -1;
        var resType = "";

        this.start = function() {
            // TODO: REMOVE? autocompleteEnabled is not there anymore?!
            /*
            if (!started) {
                fileManager.editor.textInput.getElement().onkeyup = function (e) {
                    if (!fileManager.autocompleteEnabled || browser.touchEventsSupported)
                        return;
        			var code;
        			if (e.keyCode) code = e.keyCode;
        			else if (e.which) code = e.which;

        			if (code == 32 || code == 9) { // space or tab
                        var scope = snippetManager.$getScope(fileManager.editor);
                        var pos = fileManager.editor.getSelection().lead;
                        var col = Math.min(pos.column, fileManager.editor.getSelection().anchor.column);
                        var c = getContext(fileManager.editor.session, {row:pos.row, column:col, scope:scope});

        				ace.require("ace/autocomplete").Autocomplete.startCommand.exec(fileManager.editor);
        			}
        		};
            }
            */
           started = true;

            if (!req) {
                req = new XMLReq();
                req.onLoaded = onResourceLoaded;
        		req.retryOnErrorDelay = 500;
            }

            lastInputTs = new Date().getTime();

            cReq = -1;
            self.load();
        };
        this.stop = function () {
            if (!started)
                return;
            started = false;
            if (timeout) {
    			clearTimeout(timeout);
    			timeout = null;
    		}
            if (req)
    	       req.stop();
        }

        // repeat
    	this.repeat = function (ms) {
    		timeout = setTimeout(self.load, ms);
    	}

    	// load a file
    	this.load = function () {
    		if (timeout) {
    			clearTimeout(timeout);
    			timeout = null;
    		}

            cReq++;
            if (cReq>2) cReq = 0;
            resType = ["io","ui","vars"][cReq];

    		var url = "";
    		switch (resType) {
            case "io":
    			var url = "/x/getio?"+ioLastReq;
    			break;
    		case "ui":
    			var url = "/x/getstate?-"+uiLastReq;
    			if (this.showSessionData)
    				url += ".latest.null.null."+(new Date()).getTime();
    			break;
    		case "vars":
    			var url = "/x/getvars?"+varsLastReq;
    			break;
    		}

            if (req)
    	       req.open(url,10);
    	}

    	// on resource loaded event
    	function onResourceLoaded() {
    		if (timeout) {
    			clearTimeout(timeout);
    			timeout = null;
    		}

        	var data = this.getResponseJSON();
            // update data object. {io:..., {vars:... , {hsycostate:{ui:...
            var uo;
            // local data object
            var lo = self.data[resType];

    	    switch(resType) {
        	    case "io":
        	    	if (data && data.timestamp) {
        	    		ioLastReq = data.timestamp;
        		    	uo = data.io;
        	    	}
        	    	break;
        	    case "ui":
        	    	if (data && data.hsycostate && data.hsycostate.timestamp) {
        	    		uiLastReq = data.hsycostate.timestamp;
        		    	uo = data.hsycostate.ui;
        	    	}
        	    	break;
        	    case "vars":
        	    	varsLastReq = (new Date()).getTime();
                    uo = data.vars;
        	    	break;
    	    }

            // changed?
            if (uo) {
                for (i in uo) {
                    if (!lo[i] ||
                        ((resType!="io" && lo[i] != uo[i]) ||
                         (resType=="io" && !lo[i].same(uo[i])))) { // io has arrays
                        if (resType == "io")
                            lo[i] = uo[i].clone();
                        else
                            lo[i] = uo[i];
                        changed = true;
                    }
                }
            }

            if (new Date().getTime()-lastInputTs <= maxIdleTime) {
                self.repeat(3000);
            } else {
                // pause
            }
    	} // onResourceLoaded()

    	// on resource error
    	function onResourceError() {
    		if (timeout) {
    			clearTimeout(timeout);
    			timeout = null;
    		}

        	// error
        	manager.clearNotice();
            if (new Date().getTime()-lastInputTs <= maxIdleTime) {
                this.repeat(3000);
            } else {
                // pause
            }
    	} // onResourceError()

        this.onInput = function () {
            if (!started)
                return;
            var n = new Date().getTime();
            if (n-lastInputTs >= maxIdleTime) {
                this.load(); // restart
            }
            lastInputTs = n;
        };

    	// on server restart
    	this.onRestart = function () {
    		self.data = {io:{}, ui:{}, vars:{}}; // reset
    		// force update
    		ioLastReq = 0;
    		uiLastReq = 0;
    		varsLastReq = 0;
            if (started)
    	       self.load(); // force update now
    	} // onRestart()

    })();

})();
