/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GENERIC {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readTotalEnergy(String gateway, int unitid, String subaddress) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        try {
            byte[] data;
            String[] sa = subaddress.split(":");
            int function = Integer.parseInt(sa[0]);
            int quantity = Integer.parseInt(sa[2]);
            double mult = Double.parseDouble(sa[3]);
            switch (function) {
                case 3: {
                    data = user.modbusReadHoldingRegisters(gateway, unitid, Integer.parseInt(sa[1], 16), quantity);
                    break;
                }
                case 100: {
                    data = user.modbusReadHoldingRegisters(gateway, unitid, Integer.parseInt(sa[1]), quantity);
                    break;
                }
                case 4: {
                    data = user.modbusReadInputRegisters(gateway, unitid, Integer.parseInt(sa[1], 16), quantity);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (data.length != 2 + 2 * quantity) {
                return null;
            }
            long value = Math.round((double)GENERIC.decodeInteger(data, 2, 2 * quantity, false).longValue() * mult);
            bb.putLong(value);
            return bb.array();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Hashtable<String, Long> decodeTotalEnergy(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", GENERIC.decodeInteger(data, 0, 8, false).longValue());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalEnergy(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("Ea", GENERIC.decodeInteger(data, 0, 8, false).toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

