/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class F4 {
    private static final String[] PF_SECTOR_STRING = new String[]{"", " IND", " CAP"};

    public static byte[] readTotalCounter(String gateway, int unitid, String subaddress) {
        ByteBuffer bb = ByteBuffer.allocate(14);
        byte[] data = null;
        try {
            int port = Integer.parseInt(subaddress.substring(2));
            data = user.modbusReadHoldingRegisters(gateway, unitid, 4 * (port - 1), 4);
            bb.put(data, 2, 8);
            data = user.modbusReadHoldingRegisters(gateway, unitid, 32775 + port - 1, 1);
            bb.put(data, 2, 2);
            data = user.modbusReadHoldingRegisters(gateway, unitid, 32787 + port - 1, 1);
            bb.put(data, 2, 2);
            data = user.modbusReadHoldingRegisters(gateway, unitid, 32799 + port - 1, 1);
            return bb.put(data, 2, 2).array();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Hashtable<String, Long> decodeTotalEnergyCounter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int multiplier = F4.toInteger(data, 8, false);
            int denominator = F4.toInteger(data, 10, false);
            int unit = F4.toInteger(data, 12, false);
            switch (unit) {
                case 1: {
                    values.put("Ea", (long)(F4.toVeryLong(data, 0, false) * (double)multiplier / (double)denominator));
                    break;
                }
                case 4: {
                    values.put("Ea", (long)(F4.toVeryLong(data, 0, false) * 1000.0 * (double)multiplier / (double)denominator));
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalEnergyCounter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = F4.decodeTotalEnergyCounter(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static Hashtable<String, Long> decodeTotalM3Counter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int multiplier = F4.toInteger(data, 8, false);
            int denominator = F4.toInteger(data, 10, false);
            int unit = F4.toInteger(data, 12, false);
            switch (unit) {
                case 23: {
                    values.put("Ea", (long)(F4.toVeryLong(data, 0, false) * 1000.0 * (double)multiplier / (double)denominator));
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalM3Counter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = F4.decodeTotalM3Counter(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static byte[] readTotalCounter12(String gateway, int unitid, String subaddress) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = null;
        try {
            int port = Integer.parseInt(subaddress.substring(2));
            data = user.modbusReadHoldingRegisters(gateway, unitid, 4096 + 2 * (port - 1), 2);
            bb.put(data, 2, 4);
            data = user.modbusReadHoldingRegisters(gateway, unitid, 4144 + 2 * (port - 1), 2);
            bb.put(data, 2, 4);
            data = user.modbusReadHoldingRegisters(gateway, unitid, 4120 + 2 * (port - 1), 2);
            return bb.put(data, 2, 4).array();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Hashtable<String, Long> decodeTotalEnergyCounter12(byte[] data) {
        double[] WEIGHT_TABLE = new double[]{0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0};
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            double weight = WEIGHT_TABLE[F4.toLong(data, 4, false)];
            int unit = F4.toLong(data, 8, false);
            switch (unit) {
                case 1: {
                    values.put("Ea", (long)((double)((long)F4.toLong(data, 0, false) * 1000L) * weight));
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalEnergyCounter12(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = F4.decodeTotalEnergyCounter12(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static Hashtable<String, Long> decodeTotalM3Counter12(byte[] data) {
        double[] WEIGHT_TABLE = new double[]{0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0};
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            double weight = WEIGHT_TABLE[F4.toLong(data, 4, false)];
            int unit = F4.toLong(data, 8, false);
            switch (unit) {
                case 4: {
                    values.put("Ea", (long)((double)((long)F4.toLong(data, 0, false) * 1000L) * weight));
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalM3Counter12(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = F4.decodeTotalM3Counter12(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static byte[] readVIFN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(42);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4096, 20);
        bb.put(data, 2, 40);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4134, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIFN200(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", F4.toLong(data, 0, false));
            values.put("V2", F4.toLong(data, 4, false));
            values.put("V3", F4.toLong(data, 8, false));
            values.put("I1", F4.toLong(data, 12, false));
            values.put("I2", F4.toLong(data, 16, false));
            values.put("I3", F4.toLong(data, 20, false));
            values.put("In", F4.toLong(data, 24, false));
            values.put("U12", F4.toLong(data, 28, false));
            values.put("U23", F4.toLong(data, 32, false));
            values.put("U31", F4.toLong(data, 36, false));
            values.put("F", F4.toInteger(data, 40, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIFN200(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", F4.toLongString(data, 0, 4, 3, false));
            values.put("V2", F4.toLongString(data, 4, 4, 3, false));
            values.put("V3", F4.toLongString(data, 8, 4, 3, false));
            values.put("I1", F4.toLongString(data, 12, 4, 3, false));
            values.put("I2", F4.toLongString(data, 16, 4, 3, false));
            values.put("I3", F4.toLongString(data, 20, 4, 3, false));
            values.put("In", F4.toLongString(data, 24, 4, 3, false));
            values.put("U12", F4.toLongString(data, 28, 4, 3, false));
            values.put("U23", F4.toLongString(data, 32, 4, 3, false));
            values.put("U31", F4.toLongString(data, 36, 4, 3, false));
            values.put("F", F4.toIntegerString(data, 40, 4, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPowerN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(84);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4608, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4116, 8);
        bb.put(data, 2, 16);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4132, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4140, 30);
        bb.put(data, 2, 60);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePowerN200(byte[] data, int ctvtscale) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long ctvt = F4.toInteger(data, 0, false) * F4.toInteger(data, 2, false) / ctvtscale;
            int i2 = data[17] == 0 ? F4.toLong(data, 4, false) : -F4.toLong(data, 4, false);
            values.put("P", i2 /= ctvt < 5000L ? 1000 : 10);
            i2 = data[19] == 0 ? F4.toLong(data, 8, false) : -F4.toLong(data, 8, false);
            values.put("Q", i2 /= ctvt < 5000L ? 1000 : 10);
            i2 = F4.toLong(data, 12, false);
            values.put("S", i2 /= ctvt < 5000L ? 1000 : 10);
            values.put("PF", 10 * F4.toInteger(data, 20, true));
            values.put("PFSECTOR", Integer.valueOf(data[23]));
            i2 = data[37] == 0 ? F4.toLong(data, 24, false) : -F4.toLong(data, 24, false);
            values.put("P1", i2 /= ctvt < 5000L ? 1000 : 10);
            i2 = data[39] == 0 ? F4.toLong(data, 28, false) : -F4.toLong(data, 28, false);
            values.put("P2", i2 /= ctvt < 5000L ? 1000 : 10);
            i2 = data[41] == 0 ? F4.toLong(data, 32, false) : -F4.toLong(data, 32, false);
            values.put("P3", i2 /= ctvt < 5000L ? 1000 : 10);
            i2 = data[55] == 0 ? F4.toLong(data, 42, false) : -F4.toLong(data, 42, false);
            values.put("Q1", i2 /= ctvt < 5000L ? 1000 : 10);
            i2 = data[57] == 0 ? F4.toLong(data, 46, false) : -F4.toLong(data, 46, false);
            values.put("Q2", i2 /= ctvt < 5000L ? 1000 : 10);
            i2 = data[59] == 0 ? F4.toLong(data, 50, false) : -F4.toLong(data, 50, false);
            values.put("Q3", i2 /= ctvt < 5000L ? 1000 : 10);
            values.put("S1", F4.toLong(data, 60, false) / (ctvt < 5000L ? 1000 : 10));
            values.put("S2", F4.toLong(data, 64, false) / (ctvt < 5000L ? 1000 : 10));
            values.put("S3", F4.toLong(data, 68, false) / (ctvt < 5000L ? 1000 : 10));
            values.put("PF1", 10 * F4.toInteger(data, 72, true));
            values.put("PF2", 10 * F4.toInteger(data, 74, true));
            values.put("PF3", 10 * F4.toInteger(data, 76, true));
            values.put("PF1SECTOR", Integer.valueOf(data[79]));
            values.put("PF2SECTOR", Integer.valueOf(data[81]));
            values.put("PF3SECTOR", Integer.valueOf(data[83]));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPowerN200(byte[] data, int ctvtscale) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = F4.decodePowerN200(data, ctvtscale);
            values.put("P", F4.toLongString(decoded.get("P"), 4, 2, true));
            values.put("Q", F4.toLongString(decoded.get("Q"), 4, 2, true));
            values.put("S", F4.toLongString(decoded.get("S"), 4, 2, false));
            values.put("PF", String.valueOf(F4.toLongString(decoded.get("PF"), 4, 3, true)) + PF_SECTOR_STRING[decoded.get("PFSECTOR")]);
            values.put("PF1", String.valueOf(F4.toLongString(decoded.get("PF1"), 4, 3, true)) + PF_SECTOR_STRING[decoded.get("PF1SECTOR")]);
            values.put("PF2", String.valueOf(F4.toLongString(decoded.get("PF2"), 4, 3, true)) + PF_SECTOR_STRING[decoded.get("PF2SECTOR")]);
            values.put("PF3", String.valueOf(F4.toLongString(decoded.get("PF3"), 4, 3, true)) + PF_SECTOR_STRING[decoded.get("PF3SECTOR")]);
            values.put("P1", F4.toLongString(decoded.get("P1"), 4, 2, true));
            values.put("P2", F4.toLongString(decoded.get("P2"), 4, 2, true));
            values.put("P3", F4.toLongString(decoded.get("P3"), 4, 2, true));
            values.put("Q1", F4.toLongString(decoded.get("Q1"), 4, 2, true));
            values.put("Q2", F4.toLongString(decoded.get("Q2"), 4, 2, true));
            values.put("Q3", F4.toLongString(decoded.get("Q3"), 4, 2, true));
            values.put("S1", F4.toLongString(decoded.get("S1"), 4, 2, true));
            values.put("S2", F4.toLongString(decoded.get("S2"), 4, 2, true));
            values.put("S3", F4.toLongString(decoded.get("S3"), 4, 2, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHDN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(14);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8203, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4170, 6);
        return bb.put(data, 2, 12).array();
    }

    public static byte[] readTHDN300(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(14);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8192, 16);
        bb.put(data, 24, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4170, 6);
        return bb.put(data, 2, 12).array();
    }

    public static Hashtable<String, Integer> decodeTHDN200(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[1]) {
                case 0: 
                case 3: 
                case 4: {
                    values.put("THDV1", F4.toInteger(data, 2, false));
                    values.put("THDV2", F4.toInteger(data, 4, false));
                    values.put("THDV3", F4.toInteger(data, 6, false));
                    break;
                }
                default: {
                    values.put("THDU12", F4.toInteger(data, 2, false));
                    values.put("THDU23", F4.toInteger(data, 4, false));
                    values.put("THDU31", F4.toInteger(data, 6, false));
                }
            }
            values.put("THDI1", F4.toInteger(data, 8, false));
            values.put("THDI2", F4.toInteger(data, 10, false));
            values.put("THDI3", F4.toInteger(data, 12, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHDN200(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            switch (data[1]) {
                case 0: 
                case 3: 
                case 4: {
                    values.put("THDV1", F4.toIntegerString(data, 2, 3, 1, false));
                    values.put("THDV2", F4.toIntegerString(data, 4, 3, 1, false));
                    values.put("THDV3", F4.toIntegerString(data, 6, 3, 1, false));
                    break;
                }
                default: {
                    values.put("THDU12", F4.toIntegerString(data, 2, 3, 1, false));
                    values.put("THDU23", F4.toIntegerString(data, 4, 3, 1, false));
                    values.put("THDU31", F4.toIntegerString(data, 6, 3, 1, false));
                }
            }
            values.put("THDI1", F4.toIntegerString(data, 8, 3, 1, false));
            values.put("THDI2", F4.toIntegerString(data, 10, 3, 1, false));
            values.put("THDI3", F4.toIntegerString(data, 12, 3, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPosN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4608, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4124, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPosN200(byte[] data, int ctvtscale) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            long ctvt = F4.toInteger(data, 0, false) * F4.toInteger(data, 2, false) / ctvtscale;
            long i2 = (long)F4.toLong(data, 4, false) * 1000L;
            i2 = ctvt < 10L ? (i2 /= 100L) : (ctvt < 100L ? (i2 /= 10L) : (ctvt < 1000L ? (i2 /= 1L) : (ctvt < 10000L ? (i2 *= 10L) : (ctvt < 100000L ? (i2 *= 100L) : (i2 *= 1000L)))));
            values.put("Ea", i2);
            i2 = (long)F4.toLong(data, 8, false) * 1000L;
            i2 = ctvt < 10L ? (i2 /= 100L) : (ctvt < 100L ? (i2 /= 10L) : (ctvt < 1000L ? (i2 /= 1L) : (ctvt < 10000L ? (i2 *= 10L) : (ctvt < 100000L ? (i2 *= 100L) : (i2 *= 1000L)))));
            values.put("Er", i2);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPosN200(byte[] data, int ctvtscale) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = F4.decodeEnergyPosN200(data, ctvtscale);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNegN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4608, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4128, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyNegN200(byte[] data, int ctvtscale) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            long ctvt = F4.toInteger(data, 0, false) * F4.toInteger(data, 2, false) / ctvtscale;
            long i2 = (long)F4.toLong(data, 4, false) * 1000L;
            i2 = ctvt < 10L ? (i2 /= 100L) : (ctvt < 100L ? (i2 /= 10L) : (ctvt < 1000L ? (i2 /= 1L) : (ctvt < 10000L ? (i2 *= 10L) : (ctvt < 100000L ? (i2 *= 100L) : (i2 *= 1000L)))));
            values.put("Ea-", i2);
            i2 = (long)F4.toLong(data, 8, false) * 1000L;
            i2 = ctvt < 10L ? (i2 /= 100L) : (ctvt < 100L ? (i2 /= 10L) : (ctvt < 1000L ? (i2 /= 1L) : (ctvt < 10000L ? (i2 *= 10L) : (ctvt < 100000L ? (i2 *= 100L) : (i2 *= 1000L)))));
            values.put("Er-", i2);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyNegN200(byte[] data, int ctvtscale) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = F4.decodeEnergyNegN200(data, ctvtscale);
            values.put("Ea-", Long.toString(decoded.get("Ea-")));
            values.put("Er-", Long.toString(decoded.get("Er-")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBaseN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(28);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4608, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4182, 6);
        bb.put(data, 2, 12);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4214, 6);
        bb.put(data, 2, 12);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxBaseN200(byte[] data, int ctvtscale) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long ctvt = F4.toInteger(data, 0, false) * F4.toInteger(data, 2, false) / ctvtscale;
            values.put("maxI1", F4.toLong(data, 4, false));
            values.put("maxI2", F4.toLong(data, 8, false));
            values.put("maxI3", F4.toLong(data, 12, false));
            values.put("maxP+", F4.toLong(data, 16, false) / (ctvt < 5000L ? 100 : 1));
            values.put("maxQ+", F4.toLong(data, 20, false) / (ctvt < 5000L ? 100 : 1));
            values.put("maxS", F4.toLong(data, 24, false) / (ctvt < 5000L ? 100 : 1));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBaseN200(byte[] data, int ctvtscale) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = F4.decodeMaxBaseN200(data, ctvtscale);
            values.put("maxI1", F4.toLongString(decoded.get("maxI1"), 4, 3, false));
            values.put("maxI2", F4.toLongString(decoded.get("maxI2"), 4, 3, false));
            values.put("maxI3", F4.toLongString(decoded.get("maxI3"), 4, 3, false));
            values.put("maxP+", F4.toLongString(decoded.get("maxP+"), 4, 3, true));
            values.put("maxQ+", F4.toLongString(decoded.get("maxQ+"), 4, 3, true));
            values.put("maxS", F4.toLongString(decoded.get("maxS"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxExtN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(14);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8203, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4196, 6);
        return bb.put(data, 2, 12).array();
    }

    public static byte[] readMaxExtN300(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(14);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8192, 16);
        bb.put(data, 24, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4196, 6);
        return bb.put(data, 2, 12).array();
    }

    public static Hashtable<String, Integer> decodeMaxExtN200(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[1]) {
                case 0: 
                case 3: 
                case 4: {
                    values.put("maxV1", F4.toLong(data, 2, false));
                    values.put("maxV2", F4.toLong(data, 6, false));
                    values.put("maxV3", F4.toLong(data, 10, false));
                    break;
                }
                default: {
                    values.put("maxU12", F4.toLong(data, 2, false));
                    values.put("maxU23", F4.toLong(data, 6, false));
                    values.put("maxU31", F4.toLong(data, 10, false));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxExtN200(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            switch (data[1]) {
                case 0: 
                case 3: 
                case 4: {
                    values.put("maxV1", F4.toLongString(data, 2, 4, 3, false));
                    values.put("maxV2", F4.toLongString(data, 6, 4, 3, false));
                    values.put("maxV3", F4.toLongString(data, 10, 4, 3, false));
                    break;
                }
                default: {
                    values.put("maxU12", F4.toLongString(data, 2, 4, 3, false));
                    values.put("maxU23", F4.toLongString(data, 6, 4, 3, false));
                    values.put("maxU31", F4.toLongString(data, 10, 4, 3, false));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readAvgExtN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(28);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4608, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4176, 6);
        bb.put(data, 2, 12);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4208, 6);
        return bb.put(data, 2, 12).array();
    }

    public static Hashtable<String, Integer> decodeAvgExtN200(byte[] data, int ctvtscale) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long ctvt = F4.toInteger(data, 0, false) * F4.toInteger(data, 2, false) / ctvtscale;
            values.put("avgI1", F4.toLong(data, 4, false));
            values.put("avgI2", F4.toLong(data, 8, false));
            values.put("avgI3", F4.toLong(data, 12, false));
            values.put("avgP+", F4.toLong(data, 16, false) / (ctvt < 5000L ? 100 : 1));
            values.put("avgQ+", F4.toLong(data, 20, false) / (ctvt < 5000L ? 100 : 1));
            values.put("avgS", F4.toLong(data, 24, false) / (ctvt < 5000L ? 100 : 1));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayAvgExtN200(byte[] data, int ctvtscale) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = F4.decodeAvgExtN200(data, ctvtscale);
            values.put("avgI1", F4.toLongString(decoded.get("avgI1"), 4, 3, false));
            values.put("avgI2", F4.toLongString(decoded.get("avgI2"), 4, 3, false));
            values.put("avgI3", F4.toLongString(decoded.get("avgI3"), 4, 3, false));
            values.put("avgP+", F4.toLongString(decoded.get("avgP+"), 4, 3, false));
            values.put("avgQ+", F4.toLongString(decoded.get("avgQ+"), 4, 3, false));
            values.put("avgS", F4.toLongString(decoded.get("avgS"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicIN200(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(72);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 28674, 23);
        int i2 = 0;
        while (i2 < 12) {
            bb.put(data, 2 + i2 * 4, 2);
            ++i2;
        }
        data = user.modbusReadHoldingRegisters(gateway, unitid, 28738, 23);
        i2 = 0;
        while (i2 < 12) {
            bb.put(data, 2 + i2 * 4, 2);
            ++i2;
        }
        data = user.modbusReadHoldingRegisters(gateway, unitid, 28802, 23);
        i2 = 0;
        while (i2 < 12) {
            bb.put(data, 2 + i2 * 4, 2);
            ++i2;
        }
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeHarmonicIN200(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "I1", F4.toInteger(data, 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "I2", F4.toInteger(data, 24 + 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "I3", F4.toInteger(data, 48 + 2 * i2, false));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicIN200(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(F4.toIntegerString(data, 0, 3, 1, false));
            sb2.append(F4.toIntegerString(data, 24, 3, 1, false));
            sb3.append(F4.toIntegerString(data, 48, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(F4.toIntegerString(data, 2 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(F4.toIntegerString(data, 24 + 2 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(F4.toIntegerString(data, 48 + 2 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HI1", sb1.toString());
            values.put("HI2", sb2.toString());
            values.put("HI3", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicVN200(String gateway, int unitid) {
        boolean neutral;
        ByteBuffer bb = ByteBuffer.allocate(72);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8203, 1);
        switch (data[3]) {
            case 0: 
            case 3: 
            case 4: {
                neutral = true;
                break;
            }
            default: {
                neutral = false;
            }
        }
        if (neutral) {
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28866, 23);
            int i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28930, 23);
            i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28994, 23);
            i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
        }
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeHarmonicVN200(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "V1", F4.toInteger(data, 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "V2", F4.toInteger(data, 24 + 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "V3", F4.toInteger(data, 48 + 2 * i2, false));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicVN200(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(F4.toIntegerString(data, 0, 3, 1, false));
            sb2.append(F4.toIntegerString(data, 24, 3, 1, false));
            sb3.append(F4.toIntegerString(data, 48, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(F4.toIntegerString(data, 2 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(F4.toIntegerString(data, 24 + 2 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(F4.toIntegerString(data, 48 + 2 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HV1", sb1.toString());
            values.put("HV2", sb2.toString());
            values.put("HV3", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicUN200(String gateway, int unitid) {
        boolean neutral;
        ByteBuffer bb = ByteBuffer.allocate(72);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8203, 1);
        switch (data[3]) {
            case 0: 
            case 3: 
            case 4: {
                neutral = true;
                break;
            }
            default: {
                neutral = false;
            }
        }
        if (!neutral) {
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28866, 23);
            int i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28930, 23);
            i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28994, 23);
            i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
        }
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeHarmonicUN200(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "U12", F4.toInteger(data, 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "U23", F4.toInteger(data, 24 + 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "U31", F4.toInteger(data, 48 + 2 * i2, false));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicUN200(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(F4.toIntegerString(data, 0, 3, 1, false));
            sb2.append(F4.toIntegerString(data, 24, 3, 1, false));
            sb3.append(F4.toIntegerString(data, 48, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(F4.toIntegerString(data, 2 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(F4.toIntegerString(data, 24 + 2 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(F4.toIntegerString(data, 48 + 2 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HU12", sb1.toString());
            values.put("HU23", sb2.toString());
            values.put("HU31", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicVN300(String gateway, int unitid) {
        boolean neutral;
        ByteBuffer bb = ByteBuffer.allocate(72);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8192, 16);
        switch (data[25]) {
            case 0: 
            case 3: 
            case 4: {
                neutral = true;
                break;
            }
            default: {
                neutral = false;
            }
        }
        if (neutral) {
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28866, 23);
            int i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28930, 23);
            i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28994, 23);
            i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
        }
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeHarmonicVN300(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "V1", F4.toInteger(data, 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "V2", F4.toInteger(data, 24 + 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "V3", F4.toInteger(data, 48 + 2 * i2, false));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicVN300(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(F4.toIntegerString(data, 0, 3, 1, false));
            sb2.append(F4.toIntegerString(data, 24, 3, 1, false));
            sb3.append(F4.toIntegerString(data, 48, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(F4.toIntegerString(data, 2 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(F4.toIntegerString(data, 24 + 2 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(F4.toIntegerString(data, 48 + 2 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HV1", sb1.toString());
            values.put("HV2", sb2.toString());
            values.put("HV3", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicUN300(String gateway, int unitid) {
        boolean neutral;
        ByteBuffer bb = ByteBuffer.allocate(72);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8192, 16);
        switch (data[25]) {
            case 0: 
            case 3: 
            case 4: {
                neutral = true;
                break;
            }
            default: {
                neutral = false;
            }
        }
        if (!neutral) {
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28866, 23);
            int i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28930, 23);
            i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
            data = user.modbusReadHoldingRegisters(gateway, unitid, 28994, 23);
            i2 = 0;
            while (i2 < 12) {
                bb.put(data, 2 + i2 * 4, 2);
                ++i2;
            }
        }
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeHarmonicUN300(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "U12", F4.toInteger(data, 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "U23", F4.toInteger(data, 24 + 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "U31", F4.toInteger(data, 48 + 2 * i2, false));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicUN300(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(F4.toIntegerString(data, 0, 3, 1, false));
            sb2.append(F4.toIntegerString(data, 24, 3, 1, false));
            sb3.append(F4.toIntegerString(data, 48, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(F4.toIntegerString(data, 2 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(F4.toIntegerString(data, 24 + 2 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(F4.toIntegerString(data, 48 + 2 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HU12", sb1.toString());
            values.put("HU23", sb2.toString());
            values.put("HU31", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    private static boolean checkHarmonicN400(String gateway, int unitid) {
        byte[] data;
        block3: {
            try {
                data = user.modbusReadHoldingRegisters(gateway, unitid, 4610, 4);
                if (data[6] != 17 || data[7] != 18) break block3;
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return data[4] == 72;
    }

    public static byte[] readHarmonicIN400(String gateway, int unitid) {
        if (F4.checkHarmonicN400(gateway, unitid)) {
            return F4.readHarmonicIN200(gateway, unitid);
        }
        return ByteBuffer.allocate(72).array();
    }

    public static byte[] readHarmonicVN400(String gateway, int unitid) {
        if (F4.checkHarmonicN400(gateway, unitid)) {
            return F4.readHarmonicVN300(gateway, unitid);
        }
        return ByteBuffer.allocate(72).array();
    }

    public static byte[] readHarmonicUN400(String gateway, int unitid) {
        if (F4.checkHarmonicN400(gateway, unitid)) {
            return F4.readHarmonicUN300(gateway, unitid);
        }
        return ByteBuffer.allocate(72).array();
    }

    public static int toInteger(byte[] data, int index, boolean signed) {
        return F4.decodeInteger(data, index, 2, signed).intValue();
    }

    private static String toIntegerString(byte[] data, int index, int digits, int decimals, boolean signed) {
        int val = F4.decodeInteger(data, index, 2, signed).intValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    public static int toLong(byte[] data, int index, boolean signed) {
        return F4.decodeInteger(data, index, 4, signed).intValue();
    }

    public static String toLongString(byte[] data, int index, boolean signed) {
        long val = F4.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "";
        }
        return Long.toString(val);
    }

    private static String toLongString(byte[] data, int index, int digits, int decimals, boolean signed) {
        long val = F4.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0L) {
            return "0";
        }
        if (val > 0L) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static String toLongString(int val, int digits, int decimals, boolean signed) {
        if (signed && val == Integer.MAX_VALUE || !signed && val == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    public static double toVeryLong(byte[] data, int index, boolean signed) {
        return F4.decodeInteger(data, index, 8, signed).doubleValue();
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static Float decodeFloat(byte[] data, int index) {
        try {
            return Float.valueOf(Float.intBitsToFloat((data[3 + index] & 0xFF) + ((data[2 + index] & 0xFF) << 8) + ((data[1 + index] & 0xFF) << 16) + ((data[index] & 0xFF) << 24)));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String toFloatString(byte[] data, int index) {
        return Long.toString(F4.decodeFloat(data, index).longValue());
    }
}

