/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import plugins.wsmeasure.EMSInterface;
import plugins.wsmeasure.GatewayCache;
import plugins.wsmeasure.LINK;
import plugins.wsmeasure.Polling;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMS {
    public static final int[] EN50160LIMITS = new int[]{50, 60, 50, 15, 35, 30, 5, 20, 15, 5, 15, 15};
    private static final long SERVICE_SESSION_ERROR_TIMEOUT_MILLIS = 70000L;
    private static Hashtable<String, HashSet<String>> interfaceCache = new Hashtable();
    private static Hashtable<String, Long> serviceSessionErrorTimestampCache = new Hashtable();
    private static Hashtable<String, Vector<LINK>> interfaceLinkCache = new Hashtable();

    public static void discoveryReset(String gateway, int unitid) {
        interfaceCache.remove(String.valueOf(gateway) + ":" + unitid);
    }

    public static boolean discoveryCheck(String gateway, int unitid, String objids) {
        HashSet<String> objects = interfaceCache.get(String.valueOf(gateway) + ":" + unitid);
        if (objects != null) {
            String[] objida = objids.split(",");
            int i2 = 0;
            while (i2 < objida.length) {
                if (objects.contains(objida[i2])) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public static String discoveryGet(String gateway, int unitid) {
        StringBuffer sb = new StringBuffer();
        HashSet<String> objects = interfaceCache.get(String.valueOf(gateway) + ":" + unitid);
        if (objects != null) {
            for (String object : objects) {
                String capability = object.equals("4201") ? "generic.input" : (object.equals("4202") || object.equals("4207") ? "breaker.state" : (object.equals("4204") ? "breaker.general" : (object.equals("4203") ? "breaker.position" : (object.equals("4208") ? "contactor.state" : (object.equals("420A") ? "generic.output" : (object.equals("420B") ? "breaker.command" : (object.equals("420C") ? "breaker.spring" : (object.equals("420E") ? "contactor.command" : (object.equals("420F") ? "contactor.state\",\"contactor.command" : (object.equals("5002") || object.equals("5003") || object.equals("5004") || object.equals("5005") || object.equals("5006") || object.equals("5007") || object.equals("5008") || object.equals("5009") || object.equals("500A") ? "measure" : null))))))))));
                if (capability == null) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(capability);
                sb.append('\"');
            }
            return sb.toString();
        }
        return "";
    }

    public static boolean discovery(String gateway, int unitid, int retries, boolean reset) {
        return EMS.discovery(gateway, unitid, 0, retries, reset);
    }

    public static boolean discovery(String gateway, int unitid, int interfaceid, int retries, boolean reset) {
        if (reset || !interfaceCache.containsKey(String.valueOf(gateway) + ":" + unitid)) {
            int i2 = 0;
            while (i2 <= retries) {
                if (i2 > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (EMS.discovery(gateway, unitid, interfaceid)) {
                    return true;
                }
                ++i2;
            }
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private static boolean discovery(String gateway, int unitid, int interfaceaddress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 39[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isLinked(String gateway, int deviceaddress) {
        SensorCache sensor = Polling.searchSensorCache(gateway, deviceaddress);
        Vector<LINK> links = interfaceLinkCache.get(String.valueOf(gateway) + ":" + (sensor == null || sensor.interfaceaddress == 0 ? deviceaddress - deviceaddress % 10 : sensor.interfaceaddress));
        if (links != null) {
            int i2 = 0;
            while (i2 < links.size()) {
                LINK link = links.elementAt(i2);
                if (link.modbusAddressLeft == deviceaddress || link.modbusAddressRight == deviceaddress) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    private static void discoveryLinkReset(String gateway, int deviceaddress) {
        SensorCache sensor = Polling.searchSensorCache(gateway, deviceaddress);
        interfaceLinkCache.remove(String.valueOf(gateway) + ":" + (sensor == null || sensor.interfaceaddress == 0 ? deviceaddress - deviceaddress % 10 : sensor.interfaceaddress));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean discoveryLink(String gateway, int deviceaddress, int retries) {
        try {
            int interfaceaddress;
            SensorCache sensor = Polling.searchSensorCache(gateway, deviceaddress);
            int n2 = interfaceaddress = sensor == null || sensor.interfaceaddress == 0 ? deviceaddress - deviceaddress % 10 : sensor.interfaceaddress;
            if (interfaceLinkCache.containsKey(String.valueOf(gateway) + ":" + interfaceaddress)) {
                return true;
            }
            int i2 = 0;
            while (true) {
                if (i2 > retries) {
                    return false;
                }
                if (i2 > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (EMS.discoveryLink(gateway, interfaceaddress)) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean discoveryLink(String gateway, int interfaceaddress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 28[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean linkSwap(String objidl, String objidr) {
        block41: {
            block40: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        block29: {
                                                            block28: {
                                                                block27: {
                                                                    block26: {
                                                                        block25: {
                                                                            block24: {
                                                                                block23: {
                                                                                    if (!objidr.equals("5002")) break block23;
                                                                                    return true;
                                                                                }
                                                                                if (!objidr.equals("5003")) break block24;
                                                                                return true;
                                                                            }
                                                                            if (!objidr.equals("5004")) break block25;
                                                                            return true;
                                                                        }
                                                                        if (!objidr.equals("5005")) break block26;
                                                                        return true;
                                                                    }
                                                                    if (!objidr.equals("5006")) break block27;
                                                                    return true;
                                                                }
                                                                if (!objidr.equals("5007")) break block28;
                                                                return true;
                                                            }
                                                            if (!objidr.equals("5008")) break block29;
                                                            return true;
                                                        }
                                                        if (!objidr.equals("5009")) break block30;
                                                        return true;
                                                    }
                                                    if (!objidr.equals("500A")) break block31;
                                                    return true;
                                                }
                                                if (!objidr.equals("4202")) break block32;
                                                return true;
                                            }
                                            if (!objidr.equals("4203")) break block33;
                                            return true;
                                        }
                                        if (!objidr.equals("4204")) break block34;
                                        return true;
                                    }
                                    if (!objidr.equals("4207")) break block35;
                                    return true;
                                }
                                if (!objidr.equals("4208")) break block36;
                                return true;
                            }
                            if (!objidr.equals("420C")) break block37;
                            return true;
                        }
                        if (!objidl.equals("420A")) break block38;
                        return true;
                    }
                    if (!objidl.equals("420B")) break block39;
                    return true;
                }
                if (!objidl.equals("420E")) break block40;
                return true;
            }
            if (!objidr.equals("4201")) break block41;
            if (objidl.equals("420F")) {
                return true;
            }
        }
        try {
            if (objidr.equals("420F") && objidl.equals("420F")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String selectAllLinks() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("[");
            Enumeration<String> keys = interfaceLinkCache.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String[] aa = key.split("[:]");
                GatewayCache gateway = aa.length < 3 ? Polling.searchGatewayCache(aa[0]) : Polling.searchGatewayCache(String.valueOf(aa[0]) + ":" + aa[1]);
                Vector<LINK> links = interfaceLinkCache.get(key);
                int i2 = 0;
                while (i2 < links.size()) {
                    SensorCache sensor;
                    LINK link = links.elementAt(i2);
                    if (sb.charAt(sb.length() - 1) == ']') {
                        sb.append(",");
                    }
                    sb.append("[");
                    if (link.objIdLeft != null) {
                        sensor = Polling.searchSensorCache(gateway.address, link.modbusAddressLeft);
                        sb.append("\"");
                        sb.append(sensor.sensorid);
                        sb.append("\",\"");
                        sb.append(URLEncoder.encode(sensor.name, "UTF-8").replace('+', ' '));
                        sb.append("\",\"");
                        sb.append(link.objIdLeft);
                        sb.append("\",\"");
                        sb.append(sensor.address);
                    } else {
                        sb.append("\"\",\"\",\"\",\"");
                    }
                    sb.append("\",\"");
                    sb.append(gateway.gatewayid);
                    sb.append("\",\"");
                    sb.append(URLEncoder.encode(gateway.name, "UTF-8").replace('+', ' '));
                    sb.append("\"],[");
                    if (link.objIdRight != null) {
                        sensor = Polling.searchSensorCache(gateway.address, link.modbusAddressRight);
                        sb.append("\"");
                        sb.append(sensor.sensorid);
                        sb.append("\",\"");
                        sb.append(URLEncoder.encode(sensor.name, "UTF-8").replace('+', ' '));
                        sb.append("\",\"");
                        sb.append(link.objIdRight);
                        sb.append("\",\"");
                        sb.append(sensor.address);
                    } else {
                        sb.append("\"\",\"\",\"\",\"");
                    }
                    sb.append("\",\"");
                    sb.append(gateway.gatewayid);
                    sb.append("\",\"");
                    sb.append(URLEncoder.encode(gateway.name, "UTF-8").replace('+', ' '));
                    sb.append("\"]");
                    ++i2;
                }
            }
            sb.append("]");
            return sb.toString();
        }
        catch (Exception e2) {
            return "[]";
        }
    }

    public static Integer readBreakerState(String gateway, int unitid) {
        byte[] data;
        if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "4202,4204,4207") && (data = user.modbusReadDiscreteInputs(gateway, unitid, 16384, 3)).length == 3) {
            if ((data[2] & 4) != 0) {
                return -1;
            }
            switch (data[2] & 3) {
                case 0: {
                    return -2;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
        }
        return null;
    }

    public static BitSet readContactorState(String gateway, int unitid) {
        byte[] data;
        BitSet bits = new BitSet();
        if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "4208,420F") && (data = user.modbusReadDiscreteInputs(gateway, unitid, 16640, 4)).length == 3) {
            int i2 = 0;
            while (i2 < 4) {
                bits.set(i2 + 1, (data[2] & 1 << i2) != 0);
                ++i2;
            }
            return bits;
        }
        return null;
    }

    public static BitSet readBreakerPosition(String gateway, int unitid) {
        byte[] data;
        BitSet bits = new BitSet();
        if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "4203") && (data = user.modbusReadDiscreteInputs(gateway, unitid, 17408, 3)).length == 3) {
            int i2 = 0;
            while (i2 < 3) {
                bits.set(i2 + 1, (data[2] & 1 << i2) != 0);
                ++i2;
            }
            return bits;
        }
        return null;
    }

    public static BitSet readGenericInput(String gateway, int unitid) {
        byte[] data;
        BitSet bits = new BitSet();
        if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "4201") && (data = user.modbusReadDiscreteInputs(gateway, unitid, 4096, 3)).length == 3) {
            int i2 = 0;
            while (i2 < 3) {
                bits.set(i2 + 1, (data[2] & 1 << i2) != 0);
                ++i2;
            }
            return bits;
        }
        return null;
    }

    public static BitSet readSpringState(String gateway, int unitid) {
        byte[] data;
        BitSet bits = new BitSet();
        if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "420C") && (data = user.modbusReadDiscreteInputs(gateway, unitid, 17664, 3)).length == 3) {
            int i2 = 0;
            while (i2 < 3) {
                bits.set(i2 + 1, (data[2] & 1 << i2) != 0);
                ++i2;
            }
            return bits;
        }
        return null;
    }

    public static BitSet readBreakerCommand(String gateway, int unitid) {
        byte[] data;
        BitSet bits = new BitSet();
        if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "420B") && (data = user.modbusReadCoils(gateway, unitid, 18432, 2)).length == 3) {
            int i2 = 0;
            while (i2 < 2) {
                bits.set(i2 + 1, (data[2] & 1 << i2) != 0);
                ++i2;
            }
            return bits;
        }
        return null;
    }

    public static boolean writeBreakerCommand(String gateway, int unitid, boolean open, boolean on) {
        byte[] data;
        return EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "420B") && (data = user.modbusWriteSingleCoil(gateway, unitid, open ? 18432 : 18433, on)).length == 5;
    }

    public static Boolean readContactorCommand(String gateway, int unitid) {
        byte[] data;
        if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "420E,420F") && (data = user.modbusReadCoils(gateway, unitid, 18688, 1)).length == 3) {
            if (data[2] != 0) {
                return true;
            }
            return false;
        }
        return null;
    }

    public static boolean writeContactorCommand(String gateway, int unitid, boolean energize) {
        byte[] data;
        return EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "420E,420F") && (data = user.modbusWriteSingleCoil(gateway, unitid, 18688, energize)).length == 5;
    }

    public static BitSet readGenericOutput(String gateway, int unitid) {
        byte[] data;
        BitSet bits = new BitSet();
        if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "420A") && (data = user.modbusReadCoils(gateway, unitid, 4352, 2)).length == 3) {
            int i2 = 0;
            while (i2 < 2) {
                bits.set(i2 + 1, (data[2] & 1 << i2) != 0);
                ++i2;
            }
            return bits;
        }
        return null;
    }

    public static boolean writeGenericOutput(String gateway, int unitid, int index, boolean value) {
        byte[] data;
        return EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "420A") && (data = user.modbusWriteSingleCoil(gateway, unitid, 4352 + index - 1, value)).length == 5;
    }

    public static Hashtable<String, String> getBreaker(SensorCache sensor) {
        Hashtable<String, String> data = new Hashtable<String, String>();
        try {
            BitSet bits;
            Integer state = EMS.readBreakerState(sensor.gatewayaddress, sensor.address);
            if (state != null) {
                switch (state) {
                    case 0: {
                        data.put("state", "open");
                        break;
                    }
                    case 1: {
                        data.put("state", "closed");
                        break;
                    }
                    case -1: {
                        data.put("state", "tripped");
                        break;
                    }
                    case -2: {
                        data.put("state", "noinput");
                    }
                }
            }
            if ((bits = EMS.readBreakerCommand(sensor.gatewayaddress, sensor.address)) != null) {
                data.put("command.open", bits.get(1) ? "true" : "false");
                data.put("command.close", bits.get(2) ? "true" : "false");
            }
            if ((bits = EMS.readBreakerPosition(sensor.gatewayaddress, sensor.address)) != null) {
                if (bits.get(3)) {
                    data.put("position", "test");
                } else if (bits.get(1)) {
                    data.put("position", "drawout");
                } else if (bits.get(2)) {
                    data.put("position", "inserted");
                }
            }
            if ((bits = EMS.readSpringState(sensor.gatewayaddress, sensor.address)) != null) {
                data.put("spring.charged", bits.get(2) ? "true" : "false");
                data.put("spring.ready", bits.get(3) ? "true" : "false");
            }
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Hashtable<String, String> getContactor(SensorCache sensor) {
        Hashtable<String, String> data = new Hashtable<String, String>();
        try {
            Boolean c2;
            BitSet bits = EMS.readContactorState(sensor.gatewayaddress, sensor.address);
            if (bits != null) {
                int i2 = 1;
                while (i2 <= 4) {
                    data.put("contact." + i2, bits.get(i2) ? "on" : "off");
                    ++i2;
                }
            }
            if ((c2 = EMS.readContactorCommand(sensor.gatewayaddress, sensor.address)) != null) {
                data.put("command", c2 != false ? "energize" : "deenergize");
            }
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Hashtable<String, String> getGeneric(SensorCache sensor) {
        Hashtable<String, String> data = new Hashtable<String, String>();
        try {
            int i2;
            BitSet bits = EMS.readGenericInput(sensor.gatewayaddress, sensor.address);
            if (bits != null) {
                i2 = 1;
                while (i2 <= 3) {
                    data.put("in." + i2, bits.get(i2) ? "on" : "off");
                    ++i2;
                }
            }
            if ((bits = EMS.readGenericOutput(sensor.gatewayaddress, sensor.address)) != null) {
                i2 = 1;
                while (i2 <= 2) {
                    data.put("out." + i2, bits.get(i2) ? "on" : "off");
                    ++i2;
                }
            }
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Hashtable<String, String> commandBreaker(SensorCache sensor, boolean open) {
        try {
            if (EMS.writeBreakerCommand(sensor.gatewayaddress, sensor.address, open, !EMS.readBreakerCommand(sensor.gatewayaddress, sensor.address).get(open ? 1 : 2))) {
                return EMS.getBreaker(sensor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Hashtable<String, String> commandContactor(SensorCache sensor) {
        try {
            if (EMS.writeContactorCommand(sensor.gatewayaddress, sensor.address, EMS.readContactorCommand(sensor.gatewayaddress, sensor.address) == false)) {
                return EMS.getContactor(sensor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Hashtable<String, String> commandGeneric(SensorCache sensor, int index) {
        try {
            if (EMS.writeGenericOutput(sensor.gatewayaddress, sensor.address, index, !EMS.readGenericOutput(sensor.gatewayaddress, sensor.address).get(index))) {
                return EMS.getGeneric(sensor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Hashtable<String, String> commandGeneric(SensorCache sensor, int index, boolean value) {
        try {
            if (EMS.writeGenericOutput(sensor.gatewayaddress, sensor.address, index, value)) {
                return EMS.getGeneric(sensor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static byte[] readTotalCounter(String gateway, int unitid, String subaddress) {
        byte[] data = null;
        try {
            int port;
            if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "5001") && (data = user.modbusReadHoldingRegisters(gateway, unitid, 29696 + 4 * ((port = Integer.parseInt(subaddress.substring(2))) - 1), 4)).length == 10) {
                return Arrays.copyOfRange(data, 2, data.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Hashtable<String, Long> decodeTotalEnergyCounter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int weight = EMS.toInteger(data, 2);
            int unit = EMS.toInteger(data, 0);
            switch (unit) {
                case 0: {
                    values.put("Ea", Long.valueOf(EMS.toLong(data, 4) * weight / 100));
                    break;
                }
                case 1: {
                    values.put("Ea", Long.valueOf(EMS.toLong(data, 4) * weight * 10));
                    break;
                }
                case 2: {
                    values.put("Ea", Long.valueOf(EMS.toLong(data, 4) * weight * 10000));
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalEnergyCounter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = EMS.decodeTotalEnergyCounter(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static Hashtable<String, Long> decodeTotalM3Counter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int weight = EMS.toInteger(data, 2);
            int unit = EMS.toInteger(data, 0);
            switch (unit) {
                case 9: {
                    values.put("Ea", Long.valueOf(EMS.toLong(data, 4) * weight * 10));
                    break;
                }
                case 10: {
                    values.put("Ea", (long)(EMS.toLong(data, 4) * weight * 10) * 1000000000L);
                    break;
                }
                case 11: {
                    values.put("Ea", (long)(EMS.toLong(data, 4) * weight * 10) * 1000000000L * 1000000000L);
                    break;
                }
                case 23: {
                    values.put("Ea", Long.valueOf(EMS.toLong(data, 4) * weight / 100));
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalM3Counter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = EMS.decodeTotalM3Counter(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static byte[] readVIF(String gateway, int unitid) {
        byte[] byArray = new byte[4];
        byArray[2] = -128;
        byte[] np = byArray;
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20480, 3);
        byte[] data1 = user.modbusReadInputRegisters(gateway, unitid, 20483, 1);
        byte[] data2 = user.modbusReadInputRegisters(gateway, unitid, 20494, 3);
        byte[] data3 = user.modbusReadInputRegisters(gateway, unitid, 20497, 3);
        byte[] data4 = user.modbusReadInputRegisters(gateway, unitid, 20529, 1);
        byte[] data5 = user.modbusReadInputRegisters(gateway, unitid, 20484, 1);
        byte[] data0 = user.modbusReadHoldingRegisters(gateway, unitid, 20487, 2);
        if (data5.length != 4) {
            data5 = np;
        }
        if (data1.length == 4 && data2.length == 8 && data3.length == 8 && data4.length == 4) {
            ByteBuffer bb = ByteBuffer.allocate(28);
            bb.put(data, 2, 6);
            bb.put(data1, 2, 2);
            bb.put(data2, 2, 6);
            bb.put(data3, 2, 6);
            bb.put(data4, 2, 2);
            bb.put(data5, 2, 2);
            bb.put(data0, 2, 4);
            return bb.array();
        }
        if (data1.length == 4) {
            ByteBuffer bb = ByteBuffer.allocate(14);
            bb.put(data, 2, 6);
            bb.put(data1, 2, 2);
            bb.put(data5, 2, 2);
            bb.put(data0, 2, 4);
            return bb.array();
        }
        ByteBuffer bb = ByteBuffer.allocate(12);
        bb.put(data, 2, 6);
        bb.put(data5, 2, 2);
        bb.put(data0, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data.length) {
                case 12: {
                    int divi = EMS.toInteger(data, 10);
                    if (EMS.isValid(data, 0, 2)) {
                        values.put("I1", 1000 * EMS.toInteger(data, 0) / divi);
                    }
                    if (EMS.isValid(data, 2, 2)) {
                        values.put("I2", 1000 * EMS.toInteger(data, 2) / divi);
                    }
                    if (!EMS.isValid(data, 4, 2)) break;
                    values.put("I3", 1000 * EMS.toInteger(data, 4) / divi);
                    break;
                }
                case 14: {
                    int divi = EMS.toInteger(data, 12);
                    if (EMS.isValid(data, 0, 2)) {
                        values.put("I1", 1000 * EMS.toInteger(data, 0) / divi);
                    }
                    if (EMS.isValid(data, 2, 2)) {
                        values.put("I2", 1000 * EMS.toInteger(data, 2) / divi);
                    }
                    if (EMS.isValid(data, 4, 2)) {
                        values.put("I3", 1000 * EMS.toInteger(data, 4) / divi);
                    }
                    if (!EMS.isValid(data, 6, 2)) break;
                    values.put("In", 1000 * EMS.toInteger(data, 6) / divi);
                    break;
                }
                case 28: {
                    int divv = EMS.toInteger(data, 24);
                    int divi = EMS.toInteger(data, 26);
                    if (EMS.isValid(data, 0, 2)) {
                        values.put("I1", 1000 * EMS.toInteger(data, 0) / divi);
                    }
                    if (EMS.isValid(data, 2, 2)) {
                        values.put("I2", 1000 * EMS.toInteger(data, 2) / divi);
                    }
                    if (EMS.isValid(data, 4, 2)) {
                        values.put("I3", 1000 * EMS.toInteger(data, 4) / divi);
                    }
                    if (EMS.isValid(data, 6, 2)) {
                        values.put("In", 1000 * EMS.toInteger(data, 6) / divi);
                    }
                    if (EMS.isValid(data, 8, 2)) {
                        values.put("V1", 1000 * EMS.toInteger(data, 8) / divv);
                    }
                    if (EMS.isValid(data, 10, 2)) {
                        values.put("V2", 1000 * EMS.toInteger(data, 10) / divv);
                    }
                    if (EMS.isValid(data, 12, 2)) {
                        values.put("V3", 1000 * EMS.toInteger(data, 12) / divv);
                    }
                    if (EMS.isValid(data, 14, 2)) {
                        values.put("U12", 1000 * EMS.toInteger(data, 14) / divv);
                    }
                    if (EMS.isValid(data, 16, 2)) {
                        values.put("U31", 1000 * EMS.toInteger(data, 16) / divv);
                    }
                    if (EMS.isValid(data, 18, 2)) {
                        values.put("U23", 1000 * EMS.toInteger(data, 18) / divv);
                    }
                    if (!EMS.isValid(data, 0, 2)) break;
                    values.put("F", EMS.toInteger(data, 20));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = EMS.decodeVIF(data);
            switch (data.length) {
                case 12: {
                    values.put("I1", EMS.toLongString(decoded.get("I1"), 4, 3, false));
                    values.put("I2", EMS.toLongString(decoded.get("I2"), 4, 3, false));
                    values.put("I3", EMS.toLongString(decoded.get("I3"), 4, 3, false));
                    break;
                }
                case 14: {
                    values.put("I1", EMS.toLongString(decoded.get("I1"), 4, 3, false));
                    values.put("I2", EMS.toLongString(decoded.get("I2"), 4, 3, false));
                    values.put("I3", EMS.toLongString(decoded.get("I3"), 4, 3, false));
                    values.put("In", EMS.toLongString(decoded.get("In"), 4, 3, false));
                    break;
                }
                case 28: {
                    values.put("I1", EMS.toLongString(decoded.get("I1"), 4, 3, false));
                    values.put("I2", EMS.toLongString(decoded.get("I2"), 4, 3, false));
                    values.put("I3", EMS.toLongString(decoded.get("I3"), 4, 3, false));
                    values.put("In", EMS.toLongString(decoded.get("In"), 4, 3, false));
                    values.put("V1", EMS.toLongString(decoded.get("V1"), 4, 3, false));
                    values.put("V2", EMS.toLongString(decoded.get("V2"), 4, 3, false));
                    values.put("V3", EMS.toLongString(decoded.get("V3"), 4, 3, false));
                    values.put("U12", EMS.toLongString(decoded.get("U12"), 4, 3, false));
                    values.put("U31", EMS.toLongString(decoded.get("U31"), 4, 3, false));
                    values.put("U23", EMS.toLongString(decoded.get("U23"), 4, 3, false));
                    values.put("F", EMS.toLongString(decoded.get("F"), 4, 2, false));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(36);
        try {
            if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "5002,5003,5004,5005,5006,5007,5008,5009,500A")) {
                byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20522, 6);
                if (inverted) {
                    int v = -EMS.decodeInteger(data, 2, 2, true).intValue();
                    data[2] = (byte)(v >>> 8);
                    data[3] = (byte)v;
                }
                bb.put(data, 2, 4);
                bb.put(data, 10, 4);
                data = user.modbusReadInputRegisters(gateway, unitid, 20544, 6);
                if (inverted) {
                    int i2 = 2;
                    while (i2 < 8) {
                        int v = -EMS.decodeInteger(data, i2, 2, true).intValue();
                        data[i2] = (byte)(v >>> 8);
                        data[i2 + 1] = (byte)v;
                        i2 += 2;
                    }
                }
                bb.put(data, 2, 12);
                data = user.modbusReadInputRegisters(gateway, unitid, 20556, 6);
                bb.put(data, 2, 12);
                data = user.modbusReadHoldingRegisters(gateway, unitid, 20489, 2);
                bb.put(data, 2, 4);
                return bb.array();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodePower(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int divp = EMS.toInteger(data, 32);
            int divfp = EMS.toInteger(data, 34);
            if (EMS.isValid(data, 0, 2)) {
                values.put("P", 1000 * EMS.toIntegerSigned(data, 0) / divp);
            }
            if (EMS.isValid(data, 2, 2)) {
                values.put("Q", 1000 * EMS.toIntegerSigned(data, 2) / divp);
            }
            if (EMS.isValid(data, 4, 2)) {
                values.put("S", 1000 * EMS.toIntegerSigned(data, 4) / divp);
            }
            if (EMS.isValid(data, 6, 2)) {
                values.put("PF", EMS.toIntegerSigned(data, 6));
            }
            if (EMS.isValid(data, 8, 2)) {
                values.put("P1", 1000 * EMS.toIntegerSigned(data, 8) / divfp);
            }
            if (EMS.isValid(data, 10, 2)) {
                values.put("P2", 1000 * EMS.toIntegerSigned(data, 10) / divfp);
            }
            if (EMS.isValid(data, 12, 2)) {
                values.put("P3", 1000 * EMS.toIntegerSigned(data, 12) / divfp);
            }
            if (EMS.isValid(data, 14, 2)) {
                values.put("Q1", 1000 * EMS.toIntegerSigned(data, 14) / divfp);
            }
            if (EMS.isValid(data, 16, 2)) {
                values.put("Q2", 1000 * EMS.toIntegerSigned(data, 16) / divfp);
            }
            if (EMS.isValid(data, 18, 2)) {
                values.put("Q3", 1000 * EMS.toIntegerSigned(data, 18) / divfp);
            }
            if (EMS.isValid(data, 20, 2)) {
                values.put("S1", 1000 * EMS.toIntegerSigned(data, 20) / divfp);
            }
            if (EMS.isValid(data, 22, 2)) {
                values.put("S2", 1000 * EMS.toIntegerSigned(data, 22) / divfp);
            }
            if (EMS.isValid(data, 24, 2)) {
                values.put("S3", 1000 * EMS.toIntegerSigned(data, 24) / divfp);
            }
            if (EMS.isValid(data, 26, 2)) {
                values.put("PF1", EMS.toIntegerSigned(data, 26));
            }
            if (EMS.isValid(data, 28, 2)) {
                values.put("PF2", EMS.toIntegerSigned(data, 28));
            }
            if (EMS.isValid(data, 30, 2)) {
                values.put("PF3", EMS.toIntegerSigned(data, 30));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = EMS.decodePower(data);
            values.put("P", EMS.toLongString(decoded.get("P"), 4, 3, true));
            values.put("Q", EMS.toLongString(decoded.get("Q"), 4, 3, true));
            values.put("S", EMS.toLongString(decoded.get("S"), 4, 3, true));
            values.put("PF", EMS.toLongString(decoded.get("PF"), 4, 2, true));
            values.put("P1", EMS.toLongString(decoded.get("P1"), 4, 3, true));
            values.put("P2", EMS.toLongString(decoded.get("P2"), 4, 3, true));
            values.put("P3", EMS.toLongString(decoded.get("P3"), 4, 3, true));
            values.put("Q1", EMS.toLongString(decoded.get("Q1"), 4, 3, true));
            values.put("Q2", EMS.toLongString(decoded.get("Q2"), 4, 3, true));
            values.put("Q3", EMS.toLongString(decoded.get("Q3"), 4, 3, true));
            values.put("S1", EMS.toLongString(decoded.get("S1"), 4, 3, true));
            values.put("S2", EMS.toLongString(decoded.get("S2"), 4, 3, true));
            values.put("S3", EMS.toLongString(decoded.get("S3"), 4, 3, true));
            values.put("PF1", EMS.toLongString(decoded.get("PF1"), 4, 2, true));
            values.put("PF2", EMS.toLongString(decoded.get("PF2"), 4, 2, true));
            values.put("PF3", EMS.toLongString(decoded.get("PF3"), 4, 2, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHD(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(20);
        try {
            if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "5002,5003,5004,5005,5006,5007,5008,5009,500A")) {
                byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20512, 10);
                return bb.put(data, 2, 20).array();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeTHD(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            if (EMS.isValid(data, 0, 2)) {
                values.put("THDI1", EMS.toInteger(data, 0) * 10);
            }
            if (EMS.isValid(data, 2, 2)) {
                values.put("THDI2", EMS.toInteger(data, 2) * 10);
            }
            if (EMS.isValid(data, 4, 2)) {
                values.put("THDI3", EMS.toInteger(data, 4) * 10);
            }
            if (EMS.isValid(data, 6, 2)) {
                values.put("THDIn", EMS.toInteger(data, 6) * 10);
            }
            if (EMS.isValid(data, 8, 2)) {
                values.put("THDV1", EMS.toInteger(data, 8) * 10);
            }
            if (EMS.isValid(data, 10, 2)) {
                values.put("THDV2", EMS.toInteger(data, 10) * 10);
            }
            if (EMS.isValid(data, 12, 2)) {
                values.put("THDV3", EMS.toInteger(data, 12) * 10);
            }
            if (EMS.isValid(data, 14, 2)) {
                values.put("THDU12", EMS.toInteger(data, 140));
            }
            if (EMS.isValid(data, 16, 2)) {
                values.put("THDU31", EMS.toInteger(data, 16) * 10);
            }
            if (EMS.isValid(data, 18, 2)) {
                values.put("THDU23", EMS.toInteger(data, 18) * 10);
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHD(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("THDI1", EMS.toIntegerString(data, 0, 3, 0, 1, true));
            values.put("THDI2", EMS.toIntegerString(data, 2, 3, 0, 1, true));
            values.put("THDI3", EMS.toIntegerString(data, 4, 3, 0, 1, true));
            values.put("THDIn", EMS.toIntegerString(data, 6, 3, 0, 1, true));
            values.put("THDV1", EMS.toIntegerString(data, 8, 3, 0, 1, true));
            values.put("THDV2", EMS.toIntegerString(data, 10, 3, 0, 1, true));
            values.put("THDV3", EMS.toIntegerString(data, 12, 3, 0, 1, true));
            values.put("THDU12", EMS.toIntegerString(data, 14, 3, 0, 1, true));
            values.put("THDU31", EMS.toIntegerString(data, 16, 3, 0, 1, true));
            values.put("THDU23", EMS.toIntegerString(data, 18, 3, 0, 1, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static boolean chechTHD(byte[] data) {
        try {
            return EMS.toInteger(data, 14) >= 80 || EMS.toInteger(data, 16) >= 80 || EMS.toInteger(data, 18) >= 80;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static byte[] readEnergyPos(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(10);
        try {
            if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "5002,5003,5004,5005,5006,5007,5008,5009,500A")) {
                byte[] data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20534 : 20532, 2);
                bb.put(data, 2, 4);
                data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20540 : 20538, 2);
                bb.put(data, 2, 4);
                byte[] data0 = user.modbusReadHoldingRegisters(gateway, unitid, 20491, 1);
                bb.put(data0, 2, 2);
                return bb.array();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new byte[0];
    }

    public static Hashtable<String, Long> decodeEnergyPos(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        int dive = EMS.toInteger(data, 8);
        try {
            if (EMS.isValid(data, 0, 4)) {
                values.put("Ea", 1000L * (long)EMS.toLong(data, 0) / (long)dive);
            }
            if (EMS.isValid(data, 4, 4)) {
                values.put("Er", 1000L * (long)EMS.toLong(data, 4) / (long)dive);
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = EMS.decodeEnergyPos(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNeg(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(10);
        try {
            if (EMS.discovery(gateway, unitid, 0, false) && EMS.discoveryCheck(gateway, unitid, "5002,5003,5004,5005,5006,5007,5008,5009,500A")) {
                byte[] data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20532 : 20534, 2);
                bb.put(data, 2, 4);
                data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20538 : 20540, 2);
                bb.put(data, 2, 4);
                byte[] data0 = user.modbusReadHoldingRegisters(gateway, unitid, 20491, 1);
                bb.put(data0, 2, 2);
                return bb.array();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new byte[0];
    }

    public static Hashtable<String, Long> decodeEnergyNeg(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            if (EMS.isValid(data, 0, 4)) {
                values.put("Ea-", 1000L * (long)EMS.toLong(data, 0) / (long)EMS.toInteger(data, 8));
            }
            if (EMS.isValid(data, 4, 4)) {
                values.put("Er-", 1000L * (long)EMS.toLong(data, 4) / (long)EMS.toInteger(data, 8));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyNeg(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = EMS.decodeEnergyNeg(data);
            values.put("Ea-", Long.toString(decoded.get("Ea-")));
            values.put("Er-", Long.toString(decoded.get("Er-")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicI(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(56);
        if (EMS.discovery(gateway, unitid, 0, false)) {
            if (EMS.discoveryCheck(gateway, unitid, "5002,5005")) {
                byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20603, 25);
                return bb.put(data, 2, 50).array();
            }
            if (EMS.discoveryCheck(gateway, unitid, "5003,5004,5006,5007,5008,5009,500A")) {
                byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20603, 28);
                return bb.put(data, 2, 56).array();
            }
        }
        return null;
    }

    public static Hashtable<String, Integer> decodeHarmonicI(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 7) {
                if (EMS.isValid(data, 8 * i2, 2)) {
                    values.put("H" + (2 * i2 + 3) + "I1", 10 * EMS.toInteger(data, 8 * i2));
                }
                if (EMS.isValid(data, 2 + 8 * i2, 2)) {
                    values.put("H" + (2 * i2 + 3) + "I2", 10 * EMS.toInteger(data, 2 + 8 * i2));
                }
                if (EMS.isValid(data, 4 + 8 * i2, 2)) {
                    values.put("H" + (2 * i2 + 3) + "I3", 10 * EMS.toInteger(data, 4 + 8 * i2));
                }
                if (EMS.isValid(data, 6 + 8 * i2, 2)) {
                    values.put("H" + (2 * i2 + 3) + "In", 10 * EMS.toInteger(data, 6 + 8 * i2));
                }
                ++i2;
            }
            i2 = 7;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "I1", 0);
                values.put("H" + (2 * i2 + 3) + "I2", 0);
                values.put("H" + (2 * i2 + 3) + "I3", 0);
                values.put("H" + (2 * i2 + 3) + "In", 0);
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicI(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        StringBuffer sbn = new StringBuffer("[");
        try {
            sb1.append(EMS.toIntegerString(data, 0, 3, 1, -10, false));
            sb2.append(EMS.toIntegerString(data, 2, 3, 1, -10, false));
            sb3.append(EMS.toIntegerString(data, 4, 3, 1, -10, false));
            sbn.append(EMS.toIntegerString(data, 6, 3, 1, -10, false));
            int i2 = 1;
            while (i2 < 7) {
                sb1.append(',');
                sb1.append(EMS.toIntegerString(data, 8 * i2, 3, 1, -10, false));
                sb2.append(',');
                sb2.append(EMS.toIntegerString(data, 2 + 8 * i2, 3, 1, -10, false));
                sb3.append(',');
                sb3.append(EMS.toIntegerString(data, 4 + 8 * i2, 3, 1, -10, false));
                sbn.append(',');
                sbn.append(EMS.toIntegerString(data, 6 + 8 * i2, 3, 1, -10, false));
                ++i2;
            }
            i2 = 7;
            while (i2 < 12) {
                sb1.append(",0");
                sb2.append(",0");
                sb3.append(",0");
                sbn.append(",0");
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            sbn.append(']');
            values.put("HI1", sb1.toString());
            values.put("HI2", sb2.toString());
            values.put("HI3", sb3.toString());
            values.put("HIn", sbn.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicV(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(42);
        if (EMS.discovery(gateway, unitid, 0, false)) {
            if (EMS.discoveryCheck(gateway, unitid, "5002,5005")) {
                byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20687, 19);
                return bb.put(data, 2, 38).array();
            }
            if (EMS.discoveryCheck(gateway, unitid, "5003,5004,5006,5007,5008,5009,500A")) {
                byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20687, 21);
                return bb.put(data, 2, 42).array();
            }
        }
        return null;
    }

    public static Hashtable<String, Integer> decodeHarmonicV(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 7) {
                if (EMS.isValid(data, 6 * i2, 2)) {
                    values.put("H" + (2 * i2 + 3) + "V1", 10 * EMS.toInteger(data, 6 * i2));
                }
                if (EMS.isValid(data, 2 + 6 * i2, 2)) {
                    values.put("H" + (2 * i2 + 3) + "V2", 10 * EMS.toInteger(data, 2 + 6 * i2));
                }
                if (EMS.isValid(data, 4 + 6 * i2, 2)) {
                    values.put("H" + (2 * i2 + 3) + "V3", 10 * EMS.toInteger(data, 4 + 6 * i2));
                }
                ++i2;
            }
            i2 = 7;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "V1", 0);
                values.put("H" + (2 * i2 + 3) + "V2", 0);
                values.put("H" + (2 * i2 + 3) + "V3", 0);
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicV(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(EMS.toIntegerString(data, 0, 3, 1, -10, false));
            sb2.append(EMS.toIntegerString(data, 2, 3, 1, -10, false));
            sb3.append(EMS.toIntegerString(data, 4, 3, 1, -10, false));
            int i2 = 1;
            while (i2 < 7) {
                sb1.append(',');
                sb1.append(EMS.toIntegerString(data, 6 * i2, 3, 1, -10, false));
                sb2.append(',');
                sb2.append(EMS.toIntegerString(data, 2 + 6 * i2, 3, 1, -10, false));
                sb3.append(',');
                sb3.append(EMS.toIntegerString(data, 4 + 6 * i2, 3, 1, -10, false));
                ++i2;
            }
            i2 = 7;
            while (i2 < 12) {
                sb1.append(",0");
                sb2.append(",0");
                sb3.append(",0");
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HV1", sb1.toString());
            values.put("HV2", sb2.toString());
            values.put("HV3", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static void clock() {
        Hashtable<String, EMSInterface> emsInterfaceList = new Hashtable<String, EMSInterface>();
        String sync = user.varGet("timesync!");
        if (sync != null && sync.equals("1")) {
            try {
                Object k2;
                Enumeration<Integer> e2 = Polling.sensorCache.keys();
                while (e2.hasMoreElements()) {
                    k2 = e2.nextElement();
                    SensorCache sensor = Polling.sensorCache.get(k2);
                    if (!sensor.enabled || sensor.modelid != 62 && sensor.modelid != 188 && sensor.modelid != 189 && sensor.modelid != 190 || !Polling.gatewayCache.get((Object)Integer.valueOf((int)sensor.gatewayid)).enabled) continue;
                    int interfaceAddress = EMS.getInterfaceAddress(sensor);
                    String interfaceId = String.valueOf(sensor.gatewayaddress) + ":" + interfaceAddress;
                    if (emsInterfaceList.containsKey(interfaceId)) continue;
                    emsInterfaceList.put(interfaceId, new EMSInterface(interfaceAddress, sensor.gatewayname, sensor.gatewayaddress));
                }
                e2 = emsInterfaceList.keys();
                while (e2.hasMoreElements()) {
                    k2 = (String)((Object)e2.nextElement());
                    EMSInterface iface = (EMSInterface)emsInterfaceList.get(k2);
                    GregorianCalendar cal = new GregorianCalendar();
                    Calendar now = GregorianCalendar.getInstance();
                    byte[] data = user.modbusReadHoldingRegisters(iface.gatewayaddress, iface.address, 144, 3);
                    if (data == null || data.length != 8) continue;
                    cal.set(2000 + data[2], data[3] - 1, data[4], data[5], data[6], data[7]);
                    long delta = (cal.getTimeInMillis() - now.getTimeInMillis()) / 1000L;
                    if (Math.abs(delta) <= 2L) continue;
                    now = GregorianCalendar.getInstance();
                    byte[] nowData = new byte[]{(byte)(now.get(1) - 2000), (byte)(now.get(2) + 1), (byte)now.get(5), (byte)now.get(11), (byte)now.get(12), (byte)now.get(13)};
                    byte[] pdu = user.modbusWriteMultipleRegisters(iface.gatewayaddress, iface.address, 144, nowData);
                    if (pdu != null && pdu.length == 5 && pdu[0] == 16) {
                        user.messageLog("EMS CLOCK SET FOR INTERFACE: " + iface.gatewayaddress + " - " + iface.address + " DELTASEC=" + delta);
                        continue;
                    }
                    user.messageLog("EMS CLOCK SET ERRROR FOR INTERFACE: " + iface.gatewayaddress + " - " + iface.address + " DELTASEC=" + delta);
                }
            }
            catch (Exception e3) {
                user.errorLog("EMS CLOCK POLLING EXCEPTION: " + e3.getMessage());
            }
        }
    }

    public static int getInterfaceAddress(SensorCache sensor) {
        if (sensor.interfaceaddress > 0) {
            return sensor.interfaceaddress;
        }
        return sensor.address - sensor.address % 10;
    }

    private static int toLong(byte[] data, int index) {
        return EMS.decodeInteger(data, index, 4, false).intValue();
    }

    public static int toInteger(byte[] data, int index) {
        return EMS.decodeInteger(data, index, 2, false).intValue();
    }

    private static int toIntegerSigned(byte[] data, int index) {
        return EMS.decodeInteger(data, index, 2, true).intValue();
    }

    public static String toLongString(byte[] data, int index, int divideby, boolean signed) {
        long val = EMS.decodeInteger(data, index, 4, signed).longValue();
        return Long.toString(val);
    }

    private static String toLongString(Integer val, int digits, int decimals, boolean signed) {
        if (val == null || val == Integer.MIN_VALUE) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val.intValue() / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val.intValue() / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    public static String toIntegerString(byte[] data, int index, int scale) {
        if (data[index] == -128 && data[index + 1] == 0) {
            return "";
        }
        return Integer.toString(EMS.decodeInteger(data, index, 2, false).intValue() * scale);
    }

    private static String toIntegerString(byte[] data, int index, int digits, int decimals, int divideby, boolean signed) {
        int val = divideby > 0 ? EMS.decodeInteger(data, index, 2, signed).intValue() / divideby : EMS.decodeInteger(data, index, 2, signed).intValue() * -divideby;
        if (data[index] == -128 && data[index + 1] == 0) {
            return "";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                if ((d2[0] & 0xFFFFFF80) != 0) {
                    d2[0] = (byte)(d2[0] & 0x7F);
                    return new BigInteger(-1, d2);
                }
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        try {
            int i2 = 0;
            while (i2 < data.length) {
                String s = Integer.toHexString(data[i2] & 0xFF).toUpperCase();
                if (s.length() == 1) {
                    sb.append('0');
                }
                sb.append(s);
                ++i2;
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValid(byte[] data, int offset, int length) {
        try {
            if (data[offset] != -128) {
                return true;
            }
            int i2 = offset + 1;
            while (true) {
                if (i2 >= offset + length) {
                    return false;
                }
                if (data[i2] != 0) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }
}

