/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMX3DPX3EMS {
    public static Integer readBreakerState(String gateway, int unitid) {
        byte[] data = user.modbusReadDiscreteInputs(gateway, unitid, 16384, 3);
        if (data.length == 3) {
            if ((data[2] & 4) != 0) {
                return -1;
            }
            switch (data[2] & 3) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
            return null;
        }
        return null;
    }

    public static byte[] readVIF(String gateway, int unitid) {
        byte[][] data = new byte[8][];
        ByteBuffer bb = ByteBuffer.allocate(30);
        byte[] byArray = new byte[2];
        byArray[0] = -128;
        byte[] np = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[1] = 1;
        byte[] one = byArray2;
        try {
            data[0] = user.modbusReadInputRegisters(gateway, unitid, 20480, 3);
            data[1] = user.modbusReadInputRegisters(gateway, unitid, 20483, 1);
            data[2] = user.modbusReadInputRegisters(gateway, unitid, 20494, 3);
            data[3] = user.modbusReadInputRegisters(gateway, unitid, 20497, 3);
            data[4] = user.modbusReadInputRegisters(gateway, unitid, 20529, 1);
            data[5] = user.modbusReadInputRegisters(gateway, unitid, 20484, 1);
            data[6] = user.modbusReadInputRegisters(gateway, unitid, 20485, 1);
            data[7] = user.modbusReadHoldingRegisters(gateway, unitid, 20487, 2);
            int i2 = 0;
            while (i2 < data.length) {
                switch (i2) {
                    case 0: 
                    case 2: 
                    case 3: {
                        if (data[i2].length == 8) {
                            bb.put(data[i2], 2, 6);
                            break;
                        }
                        bb.put(np);
                        bb.put(np);
                        bb.put(np);
                        break;
                    }
                    case 7: {
                        if (data[i2].length == 6 && data[i2][2] != -128 && data[i2][3] != 0) {
                            bb.put(data[i2], 2, 4);
                            break;
                        }
                        bb.put(one);
                        bb.put(one);
                        break;
                    }
                    default: {
                        if (data[i2].length == 4) {
                            bb.put(data[i2], 2, 2);
                            break;
                        }
                        bb.put(np);
                    }
                }
                ++i2;
            }
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Integer> decodeVIF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int divv = DMX3DPX3EMS.toInteger(data, 26);
            int divi = DMX3DPX3EMS.toInteger(data, 28);
            DMX3DPX3EMS.putInteger(values, "I1", data, 0, 1000, divi);
            DMX3DPX3EMS.putInteger(values, "I2", data, 2, 1000, divi);
            DMX3DPX3EMS.putInteger(values, "I3", data, 4, 1000, divi);
            DMX3DPX3EMS.putInteger(values, "In", data, 6, 1000, divi);
            DMX3DPX3EMS.putInteger(values, "V1", data, 8, 1000, divv);
            DMX3DPX3EMS.putInteger(values, "V2", data, 10, 1000, divv);
            DMX3DPX3EMS.putInteger(values, "V3", data, 12, 1000, divv);
            DMX3DPX3EMS.putInteger(values, "U12", data, 14, 1000, divv);
            DMX3DPX3EMS.putInteger(values, "U31", data, 16, 1000, divv);
            DMX3DPX3EMS.putInteger(values, "U23", data, 18, 1000, divv);
            DMX3DPX3EMS.putInteger(values, "F", data, 20);
            DMX3DPX3EMS.putInteger(values, "Ig", data, 22);
            DMX3DPX3EMS.putInteger(values, "Id", data, 24);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = DMX3DPX3EMS.decodeVIF(data);
            values.put("I1", DMX3DPX3EMS.toIntegerString(decoded.get("I1"), 4, 3, false));
            values.put("I2", DMX3DPX3EMS.toIntegerString(decoded.get("I2"), 4, 3, false));
            values.put("I3", DMX3DPX3EMS.toIntegerString(decoded.get("I3"), 4, 3, false));
            values.put("In", DMX3DPX3EMS.toIntegerString(decoded.get("In"), 4, 3, false));
            values.put("V1", DMX3DPX3EMS.toIntegerString(decoded.get("V1"), 4, 3, false));
            values.put("V2", DMX3DPX3EMS.toIntegerString(decoded.get("V2"), 4, 3, false));
            values.put("V3", DMX3DPX3EMS.toIntegerString(decoded.get("V3"), 4, 3, false));
            values.put("U12", DMX3DPX3EMS.toIntegerString(decoded.get("U12"), 4, 3, false));
            values.put("U31", DMX3DPX3EMS.toIntegerString(decoded.get("U31"), 4, 3, false));
            values.put("U23", DMX3DPX3EMS.toIntegerString(decoded.get("U23"), 4, 3, false));
            values.put("F", DMX3DPX3EMS.toIntegerString(decoded.get("F"), 4, 2, false));
            values.put("Ig", DMX3DPX3EMS.toIntegerString(decoded.get("Ig"), 4, 3, true));
            values.put("Id", DMX3DPX3EMS.toIntegerString(decoded.get("Id"), 4, 0, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower(String gateway, int unitid, boolean inverted) {
        byte[][] data = new byte[4][];
        ByteBuffer bb = ByteBuffer.allocate(24);
        byte[] byArray = new byte[2];
        byArray[0] = -128;
        byte[] np = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[1] = 1;
        byte[] one = byArray2;
        try {
            int v;
            int i2;
            data[0] = user.modbusReadInputRegisters(gateway, unitid, 20522, 2);
            data[1] = user.modbusReadInputRegisters(gateway, unitid, 20526, 2);
            data[2] = user.modbusReadInputRegisters(gateway, unitid, 20544, 6);
            data[3] = user.modbusReadHoldingRegisters(gateway, unitid, 20489, 2);
            if (data[0].length == 6) {
                if (inverted) {
                    i2 = 2;
                    while (i2 < 6) {
                        v = -DMX3DPX3EMS.decodeInteger(data[0], i2, 2, true).intValue();
                        data[0][i2] = (byte)(v >>> 8);
                        data[0][i2 + 1] = (byte)v;
                        i2 += 2;
                    }
                }
                bb.put(data[0], 2, 4);
            } else {
                bb.put(np);
                bb.put(np);
            }
            if (data[1].length == 6) {
                bb.put(data[1], 2, 4);
            } else {
                bb.put(np);
                bb.put(np);
            }
            if (data[2].length == 14) {
                if (inverted) {
                    i2 = 2;
                    while (i2 < 8) {
                        v = -DMX3DPX3EMS.decodeInteger(data[2], i2, 2, true).intValue();
                        data[2][i2] = (byte)(v >>> 8);
                        data[2][i2 + 1] = (byte)v;
                        i2 += 2;
                    }
                }
                bb.put(data[2], 2, 12);
            } else {
                bb.put(np);
                bb.put(np);
                bb.put(np);
                bb.put(np);
                bb.put(np);
                bb.put(np);
            }
            if (data[3].length == 6 && data[3][2] != -128 && data[3][3] != 0) {
                bb.put(data[3], 2, 4);
            } else {
                bb.put(one);
                bb.put(one);
            }
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Integer> decodePower(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int divp = DMX3DPX3EMS.toInteger(data, 20);
            int divfp = DMX3DPX3EMS.toInteger(data, 22);
            DMX3DPX3EMS.putInteger(values, "P", data, 0, 1000, divp);
            DMX3DPX3EMS.putInteger(values, "Q", data, 2, 1000, divp);
            DMX3DPX3EMS.putInteger(values, "S", data, 4, 1000, divp);
            DMX3DPX3EMS.putInteger(values, "PF", data, 6);
            DMX3DPX3EMS.putInteger(values, "P1", data, 8, 1000, divfp);
            DMX3DPX3EMS.putInteger(values, "P2", data, 10, 1000, divfp);
            DMX3DPX3EMS.putInteger(values, "P3", data, 12, 1000, divfp);
            DMX3DPX3EMS.putInteger(values, "Q1", data, 14, 1000, divfp);
            DMX3DPX3EMS.putInteger(values, "Q2", data, 16, 1000, divfp);
            DMX3DPX3EMS.putInteger(values, "Q3", data, 18, 1000, divfp);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = DMX3DPX3EMS.decodePower(data);
            values.put("P", DMX3DPX3EMS.toIntegerString(decoded.get("P"), 5, 3, true));
            values.put("Q", DMX3DPX3EMS.toIntegerString(decoded.get("Q"), 5, 3, true));
            values.put("S", DMX3DPX3EMS.toIntegerString(decoded.get("S"), 5, 3, true));
            values.put("PF", DMX3DPX3EMS.toIntegerString(decoded.get("PF"), 4, 2, true));
            values.put("P1", DMX3DPX3EMS.toIntegerString(decoded.get("P1"), 5, 3, true));
            values.put("P2", DMX3DPX3EMS.toIntegerString(decoded.get("P2"), 5, 3, true));
            values.put("P3", DMX3DPX3EMS.toIntegerString(decoded.get("P3"), 5, 3, true));
            values.put("Q1", DMX3DPX3EMS.toIntegerString(decoded.get("Q1"), 5, 3, true));
            values.put("Q2", DMX3DPX3EMS.toIntegerString(decoded.get("Q2"), 5, 3, true));
            values.put("Q3", DMX3DPX3EMS.toIntegerString(decoded.get("Q3"), 5, 3, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHD(String gateway, int unitid) {
        byte[][] data = new byte[3][];
        ByteBuffer bb = ByteBuffer.allocate(20);
        byte[] byArray = new byte[2];
        byArray[0] = -128;
        byte[] np = byArray;
        try {
            data[0] = user.modbusReadInputRegisters(gateway, unitid, 20512, 3);
            data[1] = user.modbusReadInputRegisters(gateway, unitid, 20515, 4);
            data[2] = user.modbusReadInputRegisters(gateway, unitid, 20519, 3);
            if (data[0].length == 8) {
                bb.put(data[0], 2, 6);
            } else {
                bb.put(np);
                bb.put(np);
                bb.put(np);
            }
            if (data[1].length == 10) {
                bb.put(data[1], 2, 8);
            } else {
                bb.put(np);
                bb.put(np);
                bb.put(np);
                bb.put(np);
            }
            if (data[2].length == 8) {
                bb.put(data[2], 2, 6);
            } else {
                bb.put(np);
                bb.put(np);
                bb.put(np);
            }
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Integer> decodeTHD(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            DMX3DPX3EMS.putInteger(values, "THDI1", data, 0, 10);
            DMX3DPX3EMS.putInteger(values, "THDI2", data, 2, 10);
            DMX3DPX3EMS.putInteger(values, "THDI3", data, 4, 10);
            DMX3DPX3EMS.putInteger(values, "THDIn", data, 6, 10);
            DMX3DPX3EMS.putInteger(values, "THDV1", data, 8, 10);
            DMX3DPX3EMS.putInteger(values, "THDV2", data, 10, 10);
            DMX3DPX3EMS.putInteger(values, "THDV3", data, 12, 10);
            DMX3DPX3EMS.putInteger(values, "THDU12", data, 14, 10);
            DMX3DPX3EMS.putInteger(values, "THDU31", data, 16, 10);
            DMX3DPX3EMS.putInteger(values, "THDU23", data, 18, 10);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHD(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = DMX3DPX3EMS.decodeTHD(data);
            values.put("THDI1", DMX3DPX3EMS.toIntegerString(decoded.get("THDI1"), 3, 1, true));
            values.put("THDI2", DMX3DPX3EMS.toIntegerString(decoded.get("THDI2"), 3, 1, true));
            values.put("THDI3", DMX3DPX3EMS.toIntegerString(decoded.get("THDI3"), 3, 1, true));
            values.put("THDIn", DMX3DPX3EMS.toIntegerString(decoded.get("THDIn"), 3, 1, true));
            values.put("THDV1", DMX3DPX3EMS.toIntegerString(decoded.get("THDV1"), 3, 1, true));
            values.put("THDV2", DMX3DPX3EMS.toIntegerString(decoded.get("THDV2"), 3, 1, true));
            values.put("THDV3", DMX3DPX3EMS.toIntegerString(decoded.get("THDV3"), 3, 1, true));
            values.put("THDU12", DMX3DPX3EMS.toIntegerString(decoded.get("THDU12"), 3, 1, true));
            values.put("THDU31", DMX3DPX3EMS.toIntegerString(decoded.get("THDU31"), 3, 1, true));
            values.put("THDU23", DMX3DPX3EMS.toIntegerString(decoded.get("THDU23"), 3, 1, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static boolean chechTHD(byte[] data) {
        try {
            return DMX3DPX3EMS.toInteger(data, 14) >= 80 || DMX3DPX3EMS.toInteger(data, 16) >= 80 || DMX3DPX3EMS.toInteger(data, 18) >= 80;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static byte[] readEnergyPos(String gateway, int unitid, boolean inverted) {
        byte[][] data = new byte[3][];
        ByteBuffer bb = ByteBuffer.allocate(10);
        byte[] byArray = new byte[4];
        byArray[0] = -128;
        byte[] np = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[1] = 1;
        byte[] one = byArray2;
        try {
            data[0] = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20534 : 20532, 2);
            data[1] = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20540 : 20538, 2);
            data[2] = user.modbusReadHoldingRegisters(gateway, unitid, 20491, 1);
            int i2 = 0;
            while (i2 < 2) {
                if (data[i2].length == 6) {
                    bb.put(data[i2], 2, 4);
                } else {
                    bb.put(np);
                }
                ++i2;
            }
            if (data[2].length == 4 && data[2][2] != -128 && data[2][3] != 0) {
                bb.put(data[2], 2, 2);
            } else {
                bb.put(one);
            }
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Long> decodeEnergyPos(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        int dive = DMX3DPX3EMS.toInteger(data, 8);
        try {
            if (DMX3DPX3EMS.isValid(data, 0, 4)) {
                values.put("Ea", 1000L * (long)DMX3DPX3EMS.toLongSigned(data, 0) / (long)dive);
            }
            if (DMX3DPX3EMS.isValid(data, 4, 4)) {
                values.put("Er", 1000L * (long)DMX3DPX3EMS.toLongSigned(data, 4) / (long)dive);
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = DMX3DPX3EMS.decodeEnergyPos(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNeg(String gateway, int unitid, boolean inverted) {
        byte[][] data = new byte[3][];
        ByteBuffer bb = ByteBuffer.allocate(10);
        byte[] byArray = new byte[4];
        byArray[0] = -128;
        byte[] np = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[1] = 1;
        byte[] one = byArray2;
        try {
            data[0] = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20532 : 20534, 2);
            data[1] = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20538 : 20540, 2);
            data[2] = user.modbusReadHoldingRegisters(gateway, unitid, 20491, 1);
            int i2 = 0;
            while (i2 < 2) {
                if (data[i2].length == 6) {
                    bb.put(data[i2], 2, 4);
                } else {
                    bb.put(np);
                }
                ++i2;
            }
            if (data[2].length == 4 && data[2][2] != -128 && data[2][3] != 0) {
                bb.put(data[2], 2, 2);
            } else {
                bb.put(one);
            }
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Long> decodeEnergyNeg(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        int dive = DMX3DPX3EMS.toInteger(data, 8);
        try {
            if (DMX3DPX3EMS.isValid(data, 0, 4)) {
                values.put("Ea-", 1000L * (long)DMX3DPX3EMS.toLongSigned(data, 0) / (long)dive);
            }
            if (DMX3DPX3EMS.isValid(data, 4, 4)) {
                values.put("Er-", 1000L * (long)DMX3DPX3EMS.toLongSigned(data, 4) / (long)dive);
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyNeg(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = DMX3DPX3EMS.decodeEnergyNeg(data);
            values.put("Ea-", Long.toString(decoded.get("Ea-")));
            values.put("Er-", Long.toString(decoded.get("Er-")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicI(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(56);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20603, 28);
        if (data.length == 58) {
            return bb.put(data, 2, 56).array();
        }
        return null;
    }

    public static Hashtable<String, Integer> decodeHarmonicI(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 7) {
                DMX3DPX3EMS.putInteger(values, "H" + (2 * i2 + 3) + "I1", data, 8 * i2, 10);
                DMX3DPX3EMS.putInteger(values, "H" + (2 * i2 + 3) + "I2", data, 2 + 8 * i2, 10);
                DMX3DPX3EMS.putInteger(values, "H" + (2 * i2 + 3) + "I3", data, 4 + 8 * i2, 10);
                DMX3DPX3EMS.putInteger(values, "H" + (2 * i2 + 3) + "In", data, 6 + 8 * i2, 10);
                ++i2;
            }
            i2 = 7;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "I1", 0);
                values.put("H" + (2 * i2 + 3) + "I2", 0);
                values.put("H" + (2 * i2 + 3) + "I3", 0);
                values.put("H" + (2 * i2 + 3) + "In", 0);
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicI(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        StringBuffer sbn = new StringBuffer("[");
        try {
            Hashtable<String, Integer> decoded = DMX3DPX3EMS.decodeHarmonicI(data);
            int i2 = 0;
            while (i2 < 7) {
                Integer value;
                if (i2 > 0) {
                    sb1.append(',');
                    sb2.append(',');
                    sb3.append(',');
                    sbn.append(',');
                }
                sb1.append((value = decoded.get("H" + (2 * i2 + 3) + "I1")) == null ? "0" : DMX3DPX3EMS.toIntegerString(value, 3, 1, false));
                value = decoded.get("H" + (2 * i2 + 3) + "I2");
                sb2.append(value == null ? "0" : DMX3DPX3EMS.toIntegerString(value, 3, 1, false));
                value = decoded.get("H" + (2 * i2 + 3) + "I3");
                sb3.append(value == null ? "0" : DMX3DPX3EMS.toIntegerString(value, 3, 1, false));
                value = decoded.get("H" + (2 * i2 + 3) + "In");
                sbn.append(value == null ? "0" : DMX3DPX3EMS.toIntegerString(value, 3, 1, false));
                ++i2;
            }
            i2 = 7;
            while (i2 < 12) {
                sb1.append(",0");
                sb2.append(",0");
                sb3.append(",0");
                sbn.append(",0");
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            sbn.append(']');
            values.put("HI1", sb1.toString());
            values.put("HI2", sb2.toString());
            values.put("HI3", sb3.toString());
            values.put("HIn", sbn.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicV(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(42);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20687, 21);
        if (data.length == 44) {
            return bb.put(data, 2, 42).array();
        }
        return null;
    }

    public static Hashtable<String, Integer> decodeHarmonicV(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 7) {
                DMX3DPX3EMS.putInteger(values, "H" + (2 * i2 + 3) + "V1", data, 6 * i2, 10);
                DMX3DPX3EMS.putInteger(values, "H" + (2 * i2 + 3) + "V2", data, 2 + 6 * i2, 10);
                DMX3DPX3EMS.putInteger(values, "H" + (2 * i2 + 3) + "V3", data, 4 + 6 * i2, 10);
                ++i2;
            }
            i2 = 7;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "V1", 0);
                values.put("H" + (2 * i2 + 3) + "V2", 0);
                values.put("H" + (2 * i2 + 3) + "V3", 0);
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicV(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            Hashtable<String, Integer> decoded = DMX3DPX3EMS.decodeHarmonicV(data);
            int i2 = 0;
            while (i2 < 7) {
                Integer value;
                if (i2 > 0) {
                    sb1.append(',');
                    sb2.append(',');
                    sb3.append(',');
                }
                sb1.append((value = decoded.get("H" + (2 * i2 + 3) + "V1")) == null ? "0" : DMX3DPX3EMS.toIntegerString(value, 3, 1, false));
                value = decoded.get("H" + (2 * i2 + 3) + "V2");
                sb2.append(value == null ? "0" : DMX3DPX3EMS.toIntegerString(value, 3, 1, false));
                value = decoded.get("H" + (2 * i2 + 3) + "V3");
                sb3.append(value == null ? "0" : DMX3DPX3EMS.toIntegerString(value, 3, 1, false));
                ++i2;
            }
            i2 = 7;
            while (i2 < 12) {
                sb1.append(",0");
                sb2.append(",0");
                sb3.append(",0");
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HV1", sb1.toString());
            values.put("HV2", sb2.toString());
            values.put("HV3", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static int toInteger(byte[] data, int index) {
        return DMX3DPX3EMS.decodeInteger(data, index, 2, false).intValue();
    }

    private static String toIntegerString(Integer val, int digits, int decimals, boolean signed) {
        if (val == null) {
            return "";
        }
        if (signed && val == Integer.MIN_VALUE) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val.intValue() / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val.intValue() / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                if ((d2[0] & 0xFFFFFF80) != 0) {
                    d2[0] = (byte)(d2[0] & 0x7F);
                    return new BigInteger(-1, d2);
                }
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static void putInteger(Hashtable<String, Integer> values, String name, byte[] data, int index) {
        DMX3DPX3EMS.putInteger(values, name, data, index, 1);
    }

    private static void putInteger(Hashtable<String, Integer> values, String name, byte[] data, int index, int multi) {
        if (data[index] != -128 || data[index + 1] != 0) {
            values.put(name, DMX3DPX3EMS.decodeInteger(data, index, 2, true).intValue() * multi);
        }
    }

    private static void putInteger(Hashtable<String, Integer> values, String name, byte[] data, int index, int multi, int div) {
        if (data[index] != -128 || data[index + 1] != 0) {
            values.put(name, DMX3DPX3EMS.decodeInteger(data, index, 2, true).intValue() * multi / div);
        }
    }

    private static int toLongSigned(byte[] data, int index) {
        return DMX3DPX3EMS.decodeInteger(data, index, 4, true).intValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValid(byte[] data, int offset, int length) {
        try {
            if (data[offset] != -128) {
                return true;
            }
            int i2 = offset + 1;
            while (true) {
                if (i2 >= offset + length) {
                    return false;
                }
                if (data[i2] != 0) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }
}

