/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.SFTPv3FileAttributes;
import com.hsyco.SSHutil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connector {
    private static Integer schedulerDay = null;
    private static Integer schedulerHour = null;
    private static File[] sourcePaths = null;
    private static String destinationHost = null;
    private static int destinationPort = 22;
    private static String destinationPassword = null;
    private static String destinationPath = null;
    private static String destinationUser = null;
    private static int transferMode = 0;
    private static String[] logRing = new String[200];
    private static int logRingPointer = 0;
    private static Boolean runSemaphore = false;
    static FileFilter directoryFilefilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    private static String getDay() {
        if (schedulerDay == null) {
            return "";
        }
        switch (schedulerDay) {
            case 0: {
                return "*";
            }
            case -2: {
                return "mon";
            }
            case -3: {
                return "tue";
            }
            case -4: {
                return "wed";
            }
            case -5: {
                return "thu";
            }
            case -6: {
                return "fri";
            }
            case -7: {
                return "sat";
            }
            case -1: {
                return "sun";
            }
        }
        return schedulerDay.toString();
    }

    static void setDay(String day) {
        try {
            if (day == null) {
                schedulerDay = null;
            } else {
                String d2 = day.trim().toLowerCase();
                if (d2.equals("*")) {
                    schedulerDay = 0;
                } else if (d2.equals("mon")) {
                    schedulerDay = -2;
                } else if (d2.equals("tue")) {
                    schedulerDay = -3;
                } else if (d2.equals("wed")) {
                    schedulerDay = -4;
                } else if (d2.equals("thu")) {
                    schedulerDay = -5;
                } else if (d2.equals("fri")) {
                    schedulerDay = -6;
                } else if (d2.equals("sat")) {
                    schedulerDay = -7;
                } else if (d2.equals("sun")) {
                    schedulerDay = -1;
                } else {
                    schedulerDay = Integer.parseInt(d2);
                    if (schedulerDay < 0 || schedulerDay > 31) {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        catch (Exception e2) {
            schedulerDay = null;
            Connector.log("transfer day error: " + day);
        }
    }

    private static String getHour() {
        if (schedulerHour == null) {
            return "";
        }
        switch (schedulerHour) {
            case -1: {
                return "*";
            }
        }
        return schedulerHour.toString();
    }

    static void setHour(String hour) {
        try {
            if (hour == null) {
                schedulerHour = null;
            } else {
                String h2 = hour.trim();
                if (h2.equals("*")) {
                    schedulerHour = -1;
                } else {
                    schedulerHour = Integer.parseInt(h2);
                    if (schedulerHour < 0 || schedulerHour > 23) {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        catch (Exception e2) {
            schedulerHour = null;
            Connector.log("transfer hour error: " + hour);
        }
    }

    static void setSourcePaths(String paths) {
        Vector<File> v = new Vector<File>();
        try {
            if (paths == null) {
                sourcePaths = null;
            } else {
                if (paths.contains("..")) {
                    sourcePaths = null;
                    Connector.log("source paths error: contains \"..\"");
                    throw new IllegalArgumentException();
                }
                String[] a2 = paths.split(",");
                int i2 = 0;
                while (i2 < a2.length) {
                    File f2 = new File("userdata", a2[i2].trim());
                    if (!v.contains(f2)) {
                        v.add(f2);
                    }
                    ++i2;
                }
                sourcePaths = new File[0];
                sourcePaths = v.toArray(sourcePaths);
            }
        }
        catch (Exception e2) {
            sourcePaths = null;
            Connector.log("source paths error: " + paths);
        }
    }

    static void setDestinationHost(String host) {
        try {
            if (host == null) {
                destinationHost = null;
            } else {
                if (host.trim().length() == 0) {
                    destinationHost = null;
                    Connector.log("destination host error");
                    throw new IllegalArgumentException();
                }
                destinationHost = host.trim();
            }
        }
        catch (Exception e2) {
            destinationHost = null;
            Connector.log("destination host error: " + host);
        }
    }

    static void setDestinationPort(String port) {
        try {
            if (port == null || port.trim().length() == 0) {
                destinationPort = 22;
            } else {
                destinationPort = Integer.parseInt(port);
                if (destinationPort <= 0 || destinationPort > 65534) {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (Exception e2) {
            destinationPort = 22;
            Connector.log("destination host error: " + port);
        }
    }

    static void setDestinationPassword(String password) {
        try {
            if (password == null) {
                destinationPassword = null;
            } else {
                if (password.trim().length() == 0) {
                    destinationPassword = null;
                    Connector.log("destination password error");
                    throw new IllegalArgumentException();
                }
                destinationPassword = password.trim();
            }
        }
        catch (Exception e2) {
            destinationPassword = null;
            Connector.log("destination password error");
        }
    }

    static void setDestinationPath(String path) {
        destinationPath = path;
    }

    static void setDestinationUser(String user2) {
        try {
            if (user2 == null) {
                destinationUser = null;
            } else {
                if (user2 == null || user2.trim().length() == 0) {
                    destinationUser = null;
                    Connector.log("destination user error");
                    throw new IllegalArgumentException();
                }
                destinationUser = user2.trim();
            }
        }
        catch (Exception e2) {
            destinationUser = null;
            Connector.log("destination user error: " + user2);
        }
    }

    static void setTransferMode(String mode) {
        try {
            if (mode == null) {
                transferMode = 0;
            } else {
                int m2 = Integer.parseInt(mode.trim());
                if (m2 < 0 || m2 > 2) {
                    throw new IllegalArgumentException();
                }
                transferMode = m2;
            }
        }
        catch (Exception e2) {
            transferMode = 0;
            Connector.log("transfer mode error: " + mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void trigger(boolean now) {
        Connector.readConfig();
        if (now || Connector.triggerTimeAndConfigurationCheck()) {
            Boolean bl = runSemaphore;
            synchronized (bl) {
                if (runSemaphore.booleanValue()) {
                    Connector.log("skip");
                    return;
                }
                runSemaphore = true;
            }
            switch (transferMode) {
                case 1: {
                    Connector.scpPipe();
                    break;
                }
                case 2: {
                    Connector.sftpPipe();
                }
            }
            runSemaphore = false;
        }
    }

    static void init() {
        Connector.readConfig();
        Connector.displayConfig();
        user.uiSet("xconnector.ciphers", "value", Connector.getAvailableCiphers().replaceAll(",", "\n"));
        user.uiSet("xconnector.macs", "value", Connector.getAvailableMACs().replaceAll(",", "\n"));
    }

    static void userSubmit(String session, String uid, HashMap<String, String> fields) {
        String s = fields.get("xconnector.host");
        if (s != null) {
            Connector.setDestinationHost(s);
        }
        if ((s = fields.get("xconnector.port")) != null) {
            Connector.setDestinationPort(s);
        }
        if ((s = fields.get("xconnector.user")) != null) {
            Connector.setDestinationUser(s);
        }
        if ((s = fields.get("xconnector.password")) != null) {
            boolean isPasswordPlaceholder = true;
            int i2 = 0;
            while (i2 < s.length()) {
                if (s.charAt(i2) != '*') {
                    isPasswordPlaceholder = false;
                    break;
                }
                ++i2;
            }
            if (!isPasswordPlaceholder) {
                Connector.setDestinationPassword(s);
            }
        }
        if ((s = fields.get("xconnector.mode")) != null) {
            Connector.setTransferMode(s);
        }
        if ((s = fields.get("xconnector.source.paths")) != null) {
            Connector.setSourcePaths(s);
        }
        if ((s = fields.get("xconnector.destination")) != null) {
            Connector.setDestinationPath(s);
        }
        if ((s = fields.get("xconnector.day")) != null) {
            Connector.setDay(s);
        }
        if ((s = fields.get("xconnector.hour")) != null) {
            Connector.setHour(s);
        }
        Connector.writeConfig();
        Connector.displayConfig();
    }

    private static void displayConfig() {
        user.uiSet("xconnector.day", "value", Connector.getDay());
        user.uiSet("xconnector.hour", "value", Connector.getHour());
        if (sourcePaths != null) {
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < sourcePaths.length) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(Paths.get("userdata", new String[0]).relativize(Paths.get(sourcePaths[i2].getPath(), new String[0])).toString());
                ++i2;
            }
            user.uiSet("xconnector.source.paths", "value", sb.toString());
        } else {
            user.uiSet("xconnector.source.paths", "value", "");
        }
        user.uiSet("xconnector.host", "value", destinationHost == null ? "" : destinationHost);
        user.uiSet("xconnector.port", "value", Integer.toString(destinationPort));
        user.uiSet("xconnector.password", "value", destinationPassword == null ? "" : destinationPassword.replaceAll(".", "*"));
        user.uiSet("xconnector.destination", "value", destinationPath == null ? "" : destinationPath);
        user.uiSet("xconnector.user", "value", destinationUser == null ? "" : destinationUser);
        user.uiSet("xconnector.mode", "value", Integer.toString(transferMode));
    }

    private static void readConfig() {
        Connector.setDay(user.varGet("connectorday!"));
        Connector.setHour(user.varGet("connectorhour!"));
        Connector.setSourcePaths(user.varGet("connectorsourcepaths!"));
        Connector.setDestinationHost(user.varGet("connectorhost!"));
        Connector.setDestinationPort(user.varGet("connectorport!"));
        Connector.setDestinationPassword(user.varGet("connectorpassword!"));
        Connector.setDestinationPath(user.varGet("connectordestinationpath!"));
        Connector.setDestinationUser(user.varGet("connectoruser!"));
        Connector.setTransferMode(user.varGet("connectormode!"));
    }

    private static void writeConfig() {
        user.varSet("connectorday!", Connector.getDay());
        user.varSet("connectorhour!", Connector.getHour());
        if (sourcePaths != null) {
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < sourcePaths.length) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(Paths.get("userdata", new String[0]).relativize(Paths.get(sourcePaths[i2].getPath(), new String[0])).toString());
                ++i2;
            }
            user.varSet("connectorsourcepaths!", sb.toString());
        } else {
            user.varSet("connectorsourcepaths!", "");
        }
        user.varSet("connectorhost!", destinationHost == null ? "" : destinationHost);
        user.varSet("connectorport!", Integer.toString(destinationPort));
        user.varSet("connectorpassword!", destinationPassword == null ? "" : destinationPassword);
        user.varSet("connectordestinationpath!", destinationPath == null ? "" : destinationPath);
        user.varSet("connectoruser!", destinationUser == null ? "" : destinationUser);
        user.varSet("connectormode!", Integer.toString(transferMode));
    }

    private static String getAvailableCiphers() {
        StringBuffer sb = new StringBuffer();
        try {
            String[] a2 = Connection.getAvailableCiphers();
            int i2 = 0;
            while (i2 < a2.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                sb.append(a2[i2]);
                ++i2;
            }
            return sb.toString().toUpperCase();
        }
        catch (Exception e2) {
            return "";
        }
    }

    private static String getAvailableMACs() {
        StringBuffer sb = new StringBuffer();
        try {
            String[] a2 = Connection.getAvailableMACs();
            int i2 = 0;
            while (i2 < a2.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                sb.append(a2[i2]);
                ++i2;
            }
            return sb.toString().toUpperCase();
        }
        catch (Exception e2) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String text) {
        long now = Calendar.getInstance().getTimeInMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String message = String.valueOf(df.format(now)) + " " + text + "\r\n";
        StringBuffer sb = new StringBuffer();
        user.messageLog("CONNECTOR: " + text);
        String[] stringArray = logRing;
        synchronized (logRing) {
            Connector.logRing[Connector.logRingPointer] = message;
            int i2 = 0;
            while (i2 < logRing.length && logRing[i2] != null) {
                sb.append(logRing[logRingPointer - i2 >= 0 ? logRingPointer - i2 : logRing.length + logRingPointer - i2]);
                ++i2;
            }
            logRingPointer = logRingPointer == logRing.length - 1 ? 0 : logRingPointer + 1;
            user.uiSet("xconnector.log", "value", sb.toString());
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    private static boolean triggerTimeAndConfigurationCheck() {
        block12: {
            Calendar now;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            try {
                                now = Calendar.getInstance();
                                if (schedulerDay != null) break block8;
                                return false;
                            }
                            catch (Exception e2) {
                                return false;
                            }
                        }
                        if (schedulerDay >= 0) break block9;
                        if (-schedulerDay.intValue() != now.get(7)) {
                            return false;
                        }
                        break block10;
                    }
                    if (schedulerDay <= 0 || schedulerDay.intValue() == now.get(5)) break block10;
                    return false;
                }
                if (schedulerHour != null) break block11;
                return false;
            }
            if (schedulerHour < 0 || schedulerHour.intValue() == now.get(11)) break block12;
            return false;
        }
        return sourcePaths != null && destinationHost != null && destinationPassword != null && destinationPath != null && destinationUser != null && transferMode != 0;
    }

    private static void sftpPipe() {
        long now = System.currentTimeMillis();
        SSHutil ssh = null;
        Connection conn = null;
        SFTPv3Client client = null;
        SFTPv3FileAttributes attr = null;
        Connector.log("synchronization starting (sftp)");
        try {
            SimpleDateFormat df;
            String dest = new String(destinationPath);
            if (dest.contains("%date")) {
                df = new SimpleDateFormat("yyyyMMddHHmm");
                dest = dest.replace("%date", df.format(now));
            }
            if (dest.contains("%day")) {
                df = new SimpleDateFormat("dd");
                dest = dest.replace("%day", df.format(now));
            }
            if (dest.contains("%dow")) {
                df = new SimpleDateFormat("E");
                dest = dest.replace("%dow", df.format(now).toLowerCase());
            }
            if (dest.contains("%hour")) {
                df = new SimpleDateFormat("HH");
                dest = dest.replace("%hour", df.format(now));
            }
            ssh = new SSHutil();
            conn = ssh.connect(destinationHost, destinationPort, destinationUser, destinationPassword);
            client = new SFTPv3Client(conn);
            try {
                attr = client.stat(dest);
            }
            catch (Exception e2) {
                client.mkdir(dest, 493);
                attr = client.stat(dest);
            }
            if (attr == null || !attr.isDirectory()) {
                Connector.log("failed to write (sftp) to server: " + destinationHost + ". Destination (" + dest + ") is not a directory");
                return;
            }
            try {
                Connector.sftpCreateAllDirectoriesFromSource(sourcePaths, dest, client);
                Connector.sftpCreateAllFilesFromSource(sourcePaths, dest, client);
                Connector.log("synchronization completed (sftp)");
            }
            catch (Exception e3) {
                Connector.log("generic (sftp) exception: " + e3.getLocalizedMessage());
            }
        }
        finally {
            try {
                client.close();
            }
            catch (Exception exception) {}
            try {
                ssh.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    private static void sftpCreateAllDirectoriesFromSource(File[] dirs, String destinationRoot, SFTPv3Client client) throws Exception {
        SFTPv3FileAttributes attr = null;
        int i2 = 0;
        while (i2 < dirs.length) {
            String localDir = Paths.get("userdata", new String[0]).relativize(Paths.get(dirs[i2].getPath(), new String[0])).toString();
            String remoteDir = new File(destinationRoot, localDir).toString();
            if (remoteDir.length() > 0) {
                try {
                    attr = client.stat(remoteDir);
                }
                catch (Exception e2) {
                    client.mkdir(remoteDir, 493);
                    attr = client.stat(remoteDir);
                }
                if (attr == null || !attr.isDirectory()) {
                    Connector.log("failed to write (sftp) to server: " + destinationHost + ". Destination (" + destinationPath + ") is not a directory");
                    return;
                }
            }
            Connector.sftpCreateAllDirectoriesFromSource(new File("userdata", localDir).listFiles(directoryFilefilter), destinationRoot, client);
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sftpCreateAllFilesFromSource(File[] sources, String destinationRoot, SFTPv3Client client) throws Exception {
        FILEBUFFER = 2048;
        data = new byte[2048];
        remoteFile = null;
        is = null;
        i = 0;
        while (i < sources.length) {
            source = sources[i];
            if (source.isFile()) {
                if (!source.getName().startsWith(".")) {
                    try {
                        localFilePathname = Paths.get("userdata", new String[0]).relativize(Paths.get(source.getPath(), new String[0])).toString();
                        remoteFilePathname = new File(destinationRoot, localFilePathname).toString();
                        localFile = new File("userdata", localFilePathname);
                        try {
                            remoteFileAttr = client.stat(remoteFilePathname);
                            write = (long)remoteFileAttr.mtime.intValue() < localFile.lastModified() / 1000L || remoteFileAttr.size.longValue() != localFile.length();
                        }
                        catch (IOException e) {
                            write = true;
                        }
                        if (!write) ** GOTO lbl43
                        client.createFileTruncate(remoteFilePathname);
                        remoteFile = client.openFileRW(remoteFilePathname);
                        is = new BufferedInputStream(new FileInputStream(localFile), 2048);
                        counter = 0;
                        while ((len = is.read(data, 0, 2048)) != -1) {
                            client.write(remoteFile, counter, data, 0, len);
                            counter += len;
                        }
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception var16_20) {}
                        try {
                            client.closeFile(remoteFile);
                        }
                        catch (Exception var16_21) {}
                    }
                }
            } else {
                Connector.sftpCreateAllFilesFromSource(source.listFiles(), destinationRoot, client);
            }
lbl43:
            // 4 sources

            ++i;
        }
    }

    private static void scpPipe() {
        File TMPDIR = new File(".tmp");
        long now = System.currentTimeMillis();
        File data = null;
        FileOutputStream fos = null;
        ZipOutputStream zout = null;
        Connector.log("transfer starting (scp)");
        if (!TMPDIR.isDirectory()) {
            TMPDIR.mkdir();
            TMPDIR.setWritable(true, false);
        }
        try {
            SimpleDateFormat df;
            data = new File(TMPDIR, "userdata.zip");
            fos = new FileOutputStream(data);
            zout = new ZipOutputStream(new BufferedOutputStream(fos));
            int i2 = 0;
            while (i2 < sourcePaths.length) {
                try {
                    Connector.zip(zout, sourcePaths[i2], sourcePaths[i2].getParentFile(), null);
                }
                catch (Exception e2) {
                    Connector.log("error while processing [" + sourcePaths[i2] + "]: " + e2.getLocalizedMessage());
                }
                ++i2;
            }
            zout.close();
            String dest = new String(destinationPath);
            if (dest.contains("%date")) {
                df = new SimpleDateFormat("yyyyMMddHHmm");
                dest = dest.replace("%date", df.format(now));
            }
            if (dest.contains("%day")) {
                df = new SimpleDateFormat("dd");
                dest = dest.replace("%day", df.format(now));
            }
            if (dest.contains("%dow")) {
                df = new SimpleDateFormat("E");
                dest = dest.replace("%dow", df.format(now).toLowerCase());
            }
            if (dest.contains("%hour")) {
                df = new SimpleDateFormat("HH");
                dest = dest.replace("%hour", df.format(now));
            }
            if (!dest.toLowerCase().endsWith(".zip")) {
                dest = String.valueOf(dest) + ".zip";
            }
            SSHutil ssh = new SSHutil();
            ssh.connect(destinationHost, destinationPort, destinationUser, destinationPassword);
            boolean put_ok = ssh.put(data.getAbsolutePath(), dest);
            ssh.disconnect();
            if (put_ok) {
                Connector.log("transfer completed (scp)");
            } else {
                Connector.log("failed to write (scp) remote file to : " + dest + " on server: " + destinationHost);
            }
        }
        catch (Exception e3) {
            Connector.log("generic (scp) exception: " + e3.getLocalizedMessage());
        }
    }

    static void zip(ZipOutputStream out, File path, File basepath, String[] exclude) throws Exception {
        String basename;
        int FILEBUFFER = 2048;
        String canonical = null;
        String string = basename = basepath != null ? basepath.getPath() : "";
        if (!(!path.isDirectory() || path.getName().equals("lost+found") || path.getName().startsWith(".") && !path.getName().equals(".") || path.getName().startsWith("~"))) {
            canonical = path.getCanonicalPath();
            if (canonical != null && exclude != null) {
                int i2 = 0;
                while (i2 < exclude.length) {
                    if (canonical.equals(new File(exclude[i2]).getCanonicalPath())) {
                        return;
                    }
                    ++i2;
                }
            }
            File[] fa = path.listFiles();
            byte[] data = new byte[2048];
            int i3 = 0;
            while (i3 < fa.length) {
                if (!(!fa[i3].isFile() || fa[i3].getName().startsWith(".") || fa[i3].getName().startsWith("~") || fa[i3].getPath().equals("./hsyco.jar") || fa[i3].getPath().startsWith("./hs_err_pid"))) {
                    int counter = 0;
                    BufferedInputStream source = new BufferedInputStream(new FileInputStream(fa[i3]), 2048);
                    String entryname = fa[i3].getPath();
                    if (basename.length() > 0 && entryname.startsWith(basename)) {
                        entryname = entryname.substring(basename.length() + 1);
                    }
                    out.putNextEntry(new ZipEntry(entryname));
                    while ((counter = source.read(data, 0, 2048)) != -1) {
                        out.write(data, 0, counter);
                    }
                    source.close();
                } else {
                    Connector.zip(out, fa[i3], basepath, exclude);
                }
                ++i3;
            }
        }
    }
}

