/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import com.hsyco.HsycoFile;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import plugins.wsmeasure.ALPTEC;
import plugins.wsmeasure.DMX3;
import plugins.wsmeasure.DPX3;
import plugins.wsmeasure.EMS;
import plugins.wsmeasure.EMSInterface;
import plugins.wsmeasure.Polling;
import plugins.wsmeasure.Reports;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.user;

public class Alarms {
    private static Properties ptxt = null;
    private static boolean initialized = false;
    private static Hashtable<String, String> emsInterfaceHeader = new Hashtable();
    private static Hashtable<String, Boolean> alarmsCache = new Hashtable();
    private static PreparedStatement alarmsselectstmt;
    private static PreparedStatement alarmsinsertstmt;
    private static PreparedStatement alarmsupdatestmt;
    private static PreparedStatement alarmsdeletestmt;

    public static void init() {
        try {
            String telegramToken;
            String language = user.localeToId();
            ptxt = new Properties();
            HsycoFile f2 = new HsycoFile("plugins/wsmeasure/resources/alarms/", "text_" + language + ".txt");
            ByteArrayInputStream bis = new ByteArrayInputStream(f2.getBytes());
            ptxt.load(bis);
            bis.close();
            String telegramPassword = user.varGet("telegrampassword!");
            if (telegramPassword != null && telegramPassword.length() > 0) {
                user.ioSet("telegram.password", telegramPassword);
            }
            if ((telegramToken = user.varGet("telegramtoken!")) != null && telegramToken.length() > 0) {
                user.ioSet("telegram.token", telegramToken);
            }
            if (!initialized) {
                initialized = true;
                alarmsselectstmt = user.databaseConnection.prepareStatement("select ts, data, acknowledged from alarms order by data desc limit 200");
                alarmsinsertstmt = user.databaseConnection.prepareStatement("insert into alarms (ts, data, acknowledged) values (?, ?, ?)");
                alarmsupdatestmt = user.databaseConnection.prepareStatement("update alarms set acknowledged = ? where ts = ?");
                alarmsdeletestmt = user.databaseConnection.prepareStatement("delete from alarms where ts < ?");
                Alarms.consolidate();
                user.schedulerRegister("alarms", "polling", 10000);
            }
        }
        catch (Exception e2) {
            ptxt = null;
        }
    }

    public static void polling() {
        Hashtable<String, EMSInterface> emsInterfaceList = new Hashtable<String, EMSInterface>();
        long now = System.currentTimeMillis();
        String stage = "init";
        try {
            Object k2;
            Enumeration<Integer> e2 = Polling.sensorCache.keys();
            while (e2.hasMoreElements()) {
                Hashtable<String, Boolean> alarms;
                String encodedAlarm;
                Boolean av;
                Boolean cav;
                String cak;
                k2 = e2.nextElement();
                SensorCache sensor = Polling.sensorCache.get(k2);
                if (!sensor.enabled) continue;
                stage = "fetch sensor data: " + sensor.sensorid;
                if (sensor.modelid == 62 || sensor.modelid == 190) {
                    if (!Polling.gatewayCache.get((Object)Integer.valueOf((int)sensor.gatewayid)).enabled) continue;
                    int interfaceAddress = EMS.getInterfaceAddress(sensor);
                    String interfaceId = String.valueOf(sensor.gatewayaddress) + ":" + interfaceAddress;
                    if (emsInterfaceList.containsKey(interfaceId)) continue;
                    emsInterfaceList.put(interfaceId, new EMSInterface(interfaceAddress, sensor.gatewayname, sensor.gatewayaddress));
                    continue;
                }
                if (sensor.modelid == 20) {
                    Integer v = DMX3.readBreakerState(sensor.gatewayaddress, sensor.address);
                    if (v == null) continue;
                    cak = String.valueOf(sensor.sensorid) + ".tripped";
                    cav = alarmsCache.get(cak);
                    av = v == -1;
                    alarmsCache.put(cak, av);
                    if (cav == null || !av.booleanValue() || cav.booleanValue()) continue;
                    encodedAlarm = Alarms.alarmsEncoder(sensor, "breaker_tripped", "statechanges", ++now);
                    alarmsinsertstmt.setLong(1, now);
                    alarmsinsertstmt.setString(2, encodedAlarm);
                    alarmsinsertstmt.setBoolean(3, false);
                    try {
                        alarmsinsertstmt.execute();
                        Alarms.alert(encodedAlarm);
                        user.varSet("$alarm", encodedAlarm);
                    }
                    catch (SQLException sQLException) {}
                    continue;
                }
                if (sensor.modelid == 21) {
                    Integer v = DPX3.readBreakerState(sensor.gatewayaddress, sensor.address);
                    if (v == null) continue;
                    cak = String.valueOf(sensor.sensorid) + ".tripped";
                    cav = alarmsCache.get(cak);
                    av = v == -1;
                    alarmsCache.put(cak, av);
                    if (cav == null || !av.booleanValue() || cav.booleanValue()) continue;
                    encodedAlarm = Alarms.alarmsEncoder(sensor, "breaker_tripped", "statechanges", ++now);
                    alarmsinsertstmt.setLong(1, now);
                    alarmsinsertstmt.setString(2, encodedAlarm);
                    alarmsinsertstmt.setBoolean(3, false);
                    try {
                        alarmsinsertstmt.execute();
                        Alarms.alert(encodedAlarm);
                        user.varSet("$alarm", encodedAlarm);
                    }
                    catch (SQLException sQLException) {}
                    continue;
                }
                if (!user.isPFCModel(sensor.modelid)) continue;
                Hashtable<String, Boolean> hashtable = alarms = sensor.modelid == 127 ? ALPTEC.readAlarms8(sensor.gatewayaddress, sensor.address) : ALPTEC.readAlarmsX2(sensor.gatewayaddress, sensor.address);
                if (alarms == null) continue;
                Enumeration<String> ae = alarms.keys();
                while (ae.hasMoreElements()) {
                    String aek = ae.nextElement();
                    String cak2 = String.valueOf(sensor.sensorid) + "." + aek;
                    Boolean cav2 = alarmsCache.get(cak2);
                    Boolean av2 = alarms.get(aek);
                    alarmsCache.put(cak2, av2);
                    if (cav2 == null || !av2.booleanValue() || cav2.booleanValue()) continue;
                    String encodedAlarm2 = Alarms.alarmsEncoder(sensor, aek, "pfc", ++now);
                    alarmsinsertstmt.setLong(1, now);
                    alarmsinsertstmt.setString(2, encodedAlarm2);
                    alarmsinsertstmt.setBoolean(3, false);
                    try {
                        alarmsinsertstmt.execute();
                        Alarms.alert(encodedAlarm2);
                        user.varSet("$alarm", encodedAlarm2);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            stage = "init interfaces polling";
            e2 = emsInterfaceList.keys();
            while (e2.hasMoreElements()) {
                k2 = (String)((Object)e2.nextElement());
                stage = "polling interface alarms: " + (String)k2;
                EMSInterface iface = (EMSInterface)emsInterfaceList.get(k2);
                byte[] data = user.modbusReadInputRegisters(iface.gatewayaddress, iface.address, 9472, 5);
                if (data == null || data.length != 12) continue;
                String top = Alarms.alarmsEncoderEMS(iface.gatewayaddress, data, 2);
                String topcache = emsInterfaceHeader.get(k2);
                if (top == null || top.equals(topcache) || (data = user.modbusReadInputRegisters(iface.gatewayaddress, iface.address, 9472, 100)) == null || data.length != 202) continue;
                int i2 = 0;
                while (i2 < 20) {
                    String encodedAlarm = Alarms.alarmsEncoderEMS(iface.gatewayaddress, data, 2 + i2 * 10);
                    if (encodedAlarm != null) {
                        if (i2 == 0) {
                            emsInterfaceHeader.put((String)k2, encodedAlarm);
                        }
                        alarmsinsertstmt.setLong(1, now++);
                        alarmsinsertstmt.setString(2, encodedAlarm);
                        alarmsinsertstmt.setBoolean(3, false);
                        try {
                            alarmsinsertstmt.execute();
                            if (topcache != null) {
                                Alarms.alert(encodedAlarm);
                                user.varSet("$alarm", encodedAlarm);
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e3) {
            user.errorLog("ALARMS: SENSORS POLLING EXCEPTION [" + stage + "]: " + e3.getMessage());
        }
    }

    private static void alert(String encodedAlarm) {
        StringBuffer sb = new StringBuffer();
        try {
            String[] alarm = encodedAlarm.split(" ");
            SensorCache sensor = Polling.searchSensorCache(alarm[6], Integer.parseInt(alarm[4]));
            if (!sensor.noalerts && Boolean.parseBoolean(user.varGet("alerts" + alarm[7] + "!"))) {
                sb.append(ptxt.getProperty("alertsdevicelabel"));
                sb.append(": ");
                sb.append(URLDecoder.decode(alarm[3], "UTF-8"));
                sb.append(" (");
                sb.append(URLDecoder.decode(alarm[5], "UTF-8"));
                sb.append(" : ");
                sb.append(alarm[4]);
                sb.append(")\r\n");
                sb.append(ptxt.getProperty("alertsalarmlabel"));
                sb.append(": ");
                sb.append(URLDecoder.decode(alarm[8], "UTF-8"));
                sb.append("\r\n");
                sb.append(ptxt.getProperty("alertstimelabel"));
                sb.append(": ");
                sb.append(alarm[0]);
                sb.append(" ");
                sb.append(alarm[1]);
                String message = sb.toString();
                if (Boolean.parseBoolean(user.varGet("alertstelegramalert!"))) {
                    Reports.sendTelegram(message);
                }
                if (Boolean.parseBoolean(user.varGet("alertsemailalert!"))) {
                    String to = user.varGet("alertsemailaddress!");
                    String subject = user.varGet("alertsemailsubject!");
                    Reports.sendMail(to, subject.length() > 0 ? subject : ptxt.getProperty("alertsemailsubject"), message);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolidate() {
        long T2 = (user.smallDisk ? 30L : 366L) * 86400000L;
        PreparedStatement preparedStatement = alarmsdeletestmt;
        synchronized (preparedStatement) {
            try {
                alarmsdeletestmt.setLong(1, System.currentTimeMillis() - T2);
                alarmsdeletestmt.execute();
            }
            catch (SQLException e2) {
                System.out.println(e2);
            }
        }
    }

    public static String selectAllAlarms() {
        StringBuffer sb = new StringBuffer();
        try {
            ResultSet rs = alarmsselectstmt.executeQuery();
            while (rs.next()) {
                String[] data = rs.getString(2).split(" ");
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("[\"");
                sb.append(rs.getLong(1));
                sb.append("\",\"");
                sb.append(rs.getBoolean(3) ? "off" : "on");
                sb.append("\",\"");
                sb.append(Alarms.dateFormat(data[0]));
                sb.append(" ");
                sb.append(data[1]);
                sb.append("\",\"");
                sb.append(data[3].replace('+', ' '));
                sb.append("\",\"");
                sb.append(data[5].replace('+', ' '));
                sb.append(" : ");
                sb.append(data[4]);
                sb.append("\",\"");
                sb.append(data[8].replace('+', ' '));
                sb.append("\"]");
            }
            rs.close();
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setAlarm(String alarmid, boolean acknowledged) {
        PreparedStatement preparedStatement = alarmsupdatestmt;
        synchronized (preparedStatement) {
            try {
                alarmsupdatestmt.setBoolean(1, acknowledged);
                alarmsupdatestmt.setLong(2, Long.parseLong(alarmid));
                alarmsupdatestmt.execute();
                return true;
            }
            catch (SQLException e2) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String alarmsEncoderEMS(String gateway, byte[] data, int index) {
        StringBuffer sb = new StringBuffer();
        try {
            int address = data[index + 6] & 0xFF;
            SensorCache sensor = Polling.searchSensorCache(gateway, address);
            sb.append(String.format("20%02d-%02d-%02d %02d:%02d:%02d", data[index], data[index + 1], data[index + 2], data[index + 3], data[index + 4], data[index + 5]));
            sb.append(' ');
            sb.append(sensor.sensorid);
            sb.append(' ');
            sb.append(URLEncoder.encode(sensor.name, "UTF-8"));
            sb.append(' ');
            sb.append(address);
            sb.append(' ');
            sb.append(URLEncoder.encode(sensor.gatewayname, "UTF-8"));
            sb.append(' ');
            sb.append(URLEncoder.encode(sensor.gatewayaddress, "UTF-8"));
            sb.append(' ');
            switch (data[index + 7]) {
                case 1: {
                    switch (Alarms.toInteger(data, index + 8)) {
                        case 4096: {
                            sb.append("statechanges ");
                            String name = user.varGet("$alarm.s." + sensor.sensorid + ".i1.name");
                            sb.append(URLEncoder.encode(String.valueOf(ptxt.getProperty("generic_input")) + (name == null ? " 1" : " 1 (" + name + ")"), "UTF-8"));
                            return sb.toString();
                        }
                        case 4097: {
                            sb.append("statechanges ");
                            String name = user.varGet("$alarm.s." + sensor.sensorid + ".i2.name");
                            sb.append(URLEncoder.encode(String.valueOf(ptxt.getProperty("generic_input")) + (name == null ? " 2" : " 2 (" + name + ")"), "UTF-8"));
                            return sb.toString();
                        }
                        case 4098: {
                            sb.append("statechanges ");
                            String name = user.varGet("$alarm.s." + sensor.sensorid + ".i3.name");
                            sb.append(URLEncoder.encode(String.valueOf(ptxt.getProperty("generic_input")) + (name == null ? " 3" : " 3 (" + name + ")"), "UTF-8"));
                            return sb.toString();
                        }
                        case 16384: {
                            sb.append("statechanges ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("breaker_open"), "UTF-8"));
                            return sb.toString();
                        }
                        case 16385: {
                            sb.append("statechanges ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("breaker_closed"), "UTF-8"));
                            return sb.toString();
                        }
                        case 16386: {
                            sb.append("statechanges ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("breaker_tripped"), "UTF-8"));
                            return sb.toString();
                        }
                        case 20480: {
                            sb.append("threshold ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("measure_threshold"), "UTF-8"));
                            return sb.toString();
                        }
                        case 20490: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("voltage_sequence_error"), "UTF-8"));
                            return sb.toString();
                        }
                        case 28672: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("earth_leakage_prealarm"), "UTF-8"));
                            return sb.toString();
                        }
                        case 28673: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("earth_leakage_alarm_three_phase_map"), "UTF-8"));
                            return sb.toString();
                        }
                        case 29184: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("overload_prealarm"), "UTF-8"));
                            return sb.toString();
                        }
                        case 29185: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("overload_alarm"), "UTF-8"));
                            return sb.toString();
                        }
                        case 29188: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("overtemperature_alarm"), "UTF-8"));
                            return sb.toString();
                        }
                    }
                    sb.append("statechanges ");
                    sb.append(URLEncoder.encode(String.valueOf(ptxt.getProperty("undefined")) + " (1." + Alarms.toInteger(data, index + 8) + ")", "UTF-8"));
                    return sb.toString();
                }
                case 4: {
                    switch (Alarms.toLong(user.modbusReadHoldingRegisters(gateway, address, Alarms.toInteger(data, index + 8), 2), 2)) {
                        case 20522: {
                            int limit = Alarms.toInteger(user.modbusReadHoldingRegisters(gateway, address, 20494, 1), 2) / Alarms.toInteger(user.modbusReadHoldingRegisters(gateway, address, 20488, 1), 2);
                            sb.append("threshold ");
                            sb.append(URLEncoder.encode(String.valueOf(ptxt.getProperty("active_power_limit_exceeeded")) + ": " + limit, "UTF-8"));
                            return sb.toString();
                        }
                    }
                    sb.append("threshold ");
                    sb.append(URLEncoder.encode(String.valueOf(ptxt.getProperty("undefined")) + " (4." + Alarms.toInteger(data, index + 8) + ")", "UTF-8"));
                    return sb.toString();
                }
                case 5: {
                    switch (Alarms.toInteger(data, index + 8)) {
                        case 1: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("configuration_error_1"), "UTF-8"));
                            return sb.toString();
                        }
                        case 2: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("configuration_error_2"), "UTF-8"));
                            return sb.toString();
                        }
                        case 3: {
                            sb.append("comerrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("communication_error"), "UTF-8"));
                            return sb.toString();
                        }
                        case 4: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("duplicate_function"), "UTF-8"));
                            return sb.toString();
                        }
                        case 5: {
                            sb.append("conferrors ");
                            sb.append(URLEncoder.encode(ptxt.getProperty("device_limit_exceeeded"), "UTF-8"));
                            return sb.toString();
                        }
                    }
                    sb.append("conferrors ");
                    sb.append(URLEncoder.encode(String.valueOf(ptxt.getProperty("undefined")) + " (5." + Alarms.toInteger(data, index + 8) + ")", "UTF-8"));
                    return sb.toString();
                }
            }
            user.errorLog("ALARMS: ALARMSENCODEREMS ERROR [" + gateway + "]: unknown group: " + data[index + 7]);
            return null;
        }
        catch (Exception e2) {
            user.errorLog("ALARMS: ALARMSENCODEREMS EXCEPTION [" + gateway + "]: " + e2.getMessage());
            return null;
        }
    }

    private static String alarmsEncoder(SensorCache sensor, String alarmKey, String type, long timestamp) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timestamp));
            sb.append(' ');
            sb.append(sensor.sensorid);
            sb.append(' ');
            sb.append(URLEncoder.encode(sensor.name, "UTF-8"));
            sb.append(' ');
            sb.append(sensor.address);
            sb.append(' ');
            sb.append(URLEncoder.encode(sensor.gatewayname, "UTF-8"));
            sb.append(' ');
            sb.append(URLEncoder.encode(sensor.gatewayaddress, "UTF-8"));
            sb.append(' ');
            sb.append(type);
            sb.append(' ');
            switch (sensor.modelid) {
                case 20: 
                case 21: {
                    sb.append(URLEncoder.encode(ptxt.getProperty(alarmKey), "UTF-8"));
                    break;
                }
                case 124: 
                case 125: 
                case 126: {
                    sb.append(URLEncoder.encode(ptxt.getProperty("alptecx2_" + alarmKey), "UTF-8"));
                    break;
                }
                case 127: {
                    sb.append(URLEncoder.encode(ptxt.getProperty("alptec8_" + alarmKey), "UTF-8"));
                    break;
                }
                default: {
                    sb.append("---");
                }
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void cacheReset(String gatewayAddress, int sensorAddress) {
        try {
            SensorCache sensor = Polling.searchSensorCache(gatewayAddress, sensorAddress);
            switch (sensor.modelid) {
                case 124: 
                case 125: 
                case 126: {
                    int i2 = 0;
                    while (i2 <= 12) {
                        alarmsCache.put(String.valueOf(sensor.sensorid) + ".a" + i2, false);
                        ++i2;
                    }
                    break;
                }
                case 127: {
                    int i3 = 0;
                    while (i3 <= 29) {
                        alarmsCache.put(String.valueOf(sensor.sensorid) + ".a" + i3, false);
                        ++i3;
                    }
                    break block1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int toLong(byte[] data, int index) {
        return Alarms.decodeInteger(data, index, 4, false).intValue();
    }

    private static int toInteger(byte[] data, int index) {
        return Alarms.decodeInteger(data, index, 2, false).intValue();
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                if ((d2[0] & 0xFFFFFF80) != 0) {
                    d2[0] = (byte)(d2[0] & 0x7F);
                    return new BigInteger(-1, d2);
                }
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String dateFormat(String date) {
        String languageId = user.localeToId();
        StringBuffer sb = new StringBuffer();
        try {
            String d2;
            String m2;
            String y;
            if (date.length() == 10 && date.charAt(2) == '-' && date.charAt(5) == '-') {
                y = date.substring(6, 10);
                m2 = date.substring(3, 5);
                d2 = date.substring(0, 2);
            } else if (date.length() == 10 && date.charAt(4) == '-' && date.charAt(7) == '-') {
                y = date.substring(0, 4);
                m2 = date.substring(5, 7);
                d2 = date.substring(8, 10);
            } else {
                return date;
            }
            if (languageId.equals("it") || languageId.equals("fr")) {
                sb.append(d2);
                sb.append('-');
                sb.append(m2);
                sb.append('-');
                sb.append(y);
            } else {
                sb.append(y);
                sb.append('-');
                sb.append(m2);
                sb.append('-');
                sb.append(d2);
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return date;
        }
    }
}

