/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import com.hsyco.Modbus;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import plugins.wsmeasure.PARAMS;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALPTEC {
    private static final int PARAMS_CACHE_TIMETOLIVE_MILLIS = 600000;
    private static Hashtable<String, PARAMS> paramsCache = new Hashtable();

    public static byte[] readVITX2(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(15);
        PARAMS p = ALPTEC.getParamX2(gateway, unitid);
        if (p != null) {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 3, 4);
            bb.put((byte)p.voltage);
            bb.put(data, 2, 4);
            bb.put((byte)p.current);
            bb.put(data, 6, 4);
            data = user.modbusReadInputRegisters(gateway, unitid, 13, 2);
            bb.put((byte)p.temperature);
            bb.put(data, 2, 4);
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeVITX2(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[0]) {
                case 0: {
                    values.put("U12", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 1: {
                    values.put("U23", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 2: {
                    values.put("U31", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 3: {
                    values.put("V1", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 4: {
                    values.put("V2", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 5: {
                    values.put("V3", ALPTEC.toLong(data, 1, false));
                }
            }
            switch (data[5]) {
                case 0: {
                    values.put("I1", ALPTEC.toLong(data, 6, false));
                    break;
                }
                case 1: {
                    values.put("I2", ALPTEC.toLong(data, 6, false));
                    break;
                }
                case 2: {
                    values.put("I3", ALPTEC.toLong(data, 6, false));
                }
            }
            values.put("TU", Integer.valueOf(data[10]));
            values.put("T", ALPTEC.toLong(data, 11, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVITX2(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodeVITX2(data);
            Enumeration<String> e2 = decoded.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                if (k2.equals("TU")) {
                    values.put("TU", decoded.get(k2) == 1 ? "F" : "C");
                    continue;
                }
                if (k2.equals("T")) {
                    values.put("T", ALPTEC.toLongString(decoded.get(k2), 4, 0, true));
                    continue;
                }
                if (k2.startsWith("I")) {
                    values.put(k2, ALPTEC.toLongString(decoded.get(k2), 4, 3, false));
                    continue;
                }
                values.put(k2, ALPTEC.toLongString(decoded.get(k2), 4, 0, false));
            }
            return values;
        }
        catch (Exception e3) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readVIT8(String gateway, int unitid) throws Exception {
        PARAMS p = ALPTEC.getParam8(gateway, unitid);
        if (p != null) {
            byte[] data;
            ByteBuffer bb = ByteBuffer.allocate(1 + (p.voltage < 6 ? 4 : 12) + 1 + (p.current < 3 ? 4 : 12) + 3);
            bb.put((byte)p.voltage);
            switch (p.voltage) {
                case 6: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 75, 6);
                    bb.put(data, 2, 12);
                    break;
                }
                case 7: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 63, 6);
                    bb.put(data, 2, 12);
                    break;
                }
                default: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 5, 2);
                    bb.put(data, 2, 4);
                }
            }
            bb.put((byte)p.current);
            switch (p.current) {
                case 3: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 69, 6);
                    bb.put(data, 2, 12);
                    break;
                }
                default: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 7, 2);
                    bb.put(data, 2, 4);
                }
            }
            data = user.modbusReadInputRegisters(gateway, unitid, 8233, 1);
            bb.put((byte)p.temperature);
            bb.put(data, 2, 2);
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeVIT8(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[0]) {
                case 0: {
                    values.put("U12", ALPTEC.toLong(data, 1, true));
                    break;
                }
                case 1: {
                    values.put("U23", ALPTEC.toLong(data, 1, true));
                    break;
                }
                case 2: {
                    values.put("U31", ALPTEC.toLong(data, 1, true));
                    break;
                }
                case 3: {
                    values.put("V1", ALPTEC.toLong(data, 1, true));
                    break;
                }
                case 4: {
                    values.put("V2", ALPTEC.toLong(data, 1, true));
                    break;
                }
                case 5: {
                    values.put("V3", ALPTEC.toLong(data, 1, true));
                    break;
                }
                case 6: {
                    values.put("U12", ALPTEC.toLong(data, 1, true));
                    values.put("U23", ALPTEC.toLong(data, 5, true));
                    values.put("U31", ALPTEC.toLong(data, 9, true));
                    break;
                }
                case 7: {
                    values.put("V1", ALPTEC.toLong(data, 1, true));
                    values.put("V2", ALPTEC.toLong(data, 5, true));
                    values.put("V3", ALPTEC.toLong(data, 9, true));
                }
            }
            int dataindex = data[0] < 6 ? 6 : 14;
            switch (data[dataindex - 1]) {
                case 0: {
                    values.put("I1", ALPTEC.toLong(data, dataindex, true));
                    break;
                }
                case 1: {
                    values.put("I2", ALPTEC.toLong(data, dataindex, true));
                    break;
                }
                case 2: {
                    values.put("I3", ALPTEC.toLong(data, dataindex, true));
                    break;
                }
                case 3: {
                    values.put("I1", ALPTEC.toLong(data, dataindex, true));
                    values.put("I2", ALPTEC.toLong(data, dataindex + 4, true));
                    values.put("I3", ALPTEC.toLong(data, dataindex + 8, true));
                }
            }
            values.put("TU", Integer.valueOf(data[dataindex += data[dataindex - 1] < 3 ? 4 : 12]));
            values.put("T", ALPTEC.toInteger(data, dataindex + 1, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIT8(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodeVIT8(data);
            Enumeration<String> e2 = decoded.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                if (k2.equals("TU")) {
                    values.put("TU", decoded.get(k2) == 1 ? "F" : "C");
                    continue;
                }
                if (k2.equals("T")) {
                    values.put("T", ALPTEC.toIntegerString(decoded.get(k2), 4, 1, true));
                    continue;
                }
                if (k2.startsWith("I")) {
                    values.put(k2, ALPTEC.toLongString(decoded.get(k2), 4, 3, false));
                    continue;
                }
                values.put(k2, ALPTEC.toLongString(decoded.get(k2), 4, 1, false));
            }
            return values;
        }
        catch (Exception e3) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPowerX2(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(24);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 49, 6);
        bb.put(data, 2, 12);
        data = user.modbusReadInputRegisters(gateway, unitid, 1, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 9, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 19, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePowerX2(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            boolean cap = (data[12] & 0x40) > 0;
            data[12] = (byte)(data[12] & 0xFFFFFFBF);
            values.put("P", ALPTEC.toLong(data, 0, true));
            values.put("Q", ALPTEC.toLong(data, 4, true));
            values.put("S", ALPTEC.toLong(data, 8, true));
            values.put("COSFICAP", cap ? 1 : 0);
            values.put("COSFI", ALPTEC.toLong(data, 12, true));
            values.put("avgPF", ALPTEC.toLong(data, 16, false));
            values.put("PF", ALPTEC.toLong(data, 20, true) * 2);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPowerX2(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodePowerX2(data);
            values.put("P", ALPTEC.toLongString(decoded.get("P"), 4, 3, true));
            values.put("Q", ALPTEC.toLongString(decoded.get("Q"), 4, 3, true));
            values.put("S", ALPTEC.toLongString(decoded.get("S"), 4, 3, true));
            values.put("COSFI", String.valueOf(ALPTEC.toLongString(decoded.get("COSFI"), 4, 2, true)) + (decoded.get("COSFICAP") == 1 ? " CAP" : " IND"));
            values.put("avgPF", ALPTEC.toLongString(decoded.get("avgPF"), 6, 2, true));
            values.put("PF", ALPTEC.toLongString(decoded.get("PF"), 6, 4, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower8(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(75);
        PARAMS p = ALPTEC.getParam8(gateway, unitid);
        if (p != null) {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 5375, 16);
            bb.put(data, 2, 32);
            data = user.modbusReadInputRegisters(gateway, unitid, 9, 8);
            bb.put(data, 2, 16);
            data = user.modbusReadInputRegisters(gateway, unitid, 8196, 1);
            bb.put(data, 2, 2);
            bb.put((byte)p.tanfi);
            data = user.modbusReadInputRegisters(gateway, unitid, p.tanfi == 1 ? 3 : 4095, 2);
            bb.put(data, 2, 4);
            data = user.modbusReadInputRegisters(gateway, unitid, p.tanfi == 1 ? 93 : 81, 6);
            bb.put(data, 2, 12);
            data = user.modbusReadInputRegisters(gateway, unitid, 8192, 4);
            bb.put(data, 2, 8);
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodePower8(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int p = ALPTEC.toLong(data, 0, true);
            values.put("P", p);
            values.put("P1", ALPTEC.toLong(data, 4, true));
            values.put("P2", ALPTEC.toLong(data, 8, true));
            values.put("P3", ALPTEC.toLong(data, 12, true));
            int s = ALPTEC.toLong(data, 16, true);
            values.put("S", s);
            values.put("S1", ALPTEC.toLong(data, 20, true));
            values.put("S2", ALPTEC.toLong(data, 24, true));
            values.put("S3", ALPTEC.toLong(data, 28, true));
            values.put("Q", ALPTEC.toLong(data, 32, true));
            values.put("Q1", ALPTEC.toLong(data, 36, true));
            values.put("Q2", ALPTEC.toLong(data, 40, true));
            values.put("Q3", ALPTEC.toLong(data, 44, true));
            values.put("PF", 1000 * p / s);
            values.put("avgPF", ALPTEC.toInteger(data, 48, false));
            String fiprefix = data[50] == 1 ? "TAN" : "COS";
            values.put(String.valueOf(fiprefix) + "FI", ALPTEC.toLong(data, 51, true));
            values.put(String.valueOf(fiprefix) + "FI1", ALPTEC.toLong(data, 55, true));
            values.put(String.valueOf(fiprefix) + "FI2", ALPTEC.toLong(data, 59, true));
            values.put(String.valueOf(fiprefix) + "FI3", ALPTEC.toLong(data, 63, true));
            values.put(String.valueOf(fiprefix) + "FICAP", data[68] == 0 ? 1 : 0);
            values.put(String.valueOf(fiprefix) + "FI1CAP", data[70] == 0 ? 1 : 0);
            values.put(String.valueOf(fiprefix) + "FI2CAP", data[72] == 0 ? 1 : 0);
            values.put(String.valueOf(fiprefix) + "FI3CAP", data[74] == 0 ? 1 : 0);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower8(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodePower8(data);
            Enumeration<String> e2 = decoded.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                if (k2.equals("PF") || k2.equals("avgPF")) {
                    values.put(k2, ALPTEC.toIntegerString(decoded.get(k2), 4, 3, true));
                    continue;
                }
                if (k2.endsWith("FI") || k2.endsWith("FI1") || k2.endsWith("FI2") || k2.endsWith("FI3")) {
                    values.put(k2, String.valueOf(ALPTEC.toIntegerString(decoded.get(k2), 4, 3, true)) + (decoded.get(String.valueOf(k2) + "CAP") == 1 ? " CAP" : " IND"));
                    continue;
                }
                if (k2.endsWith("CAP")) continue;
                values.put(k2, ALPTEC.toLongString(decoded.get(k2), 4, 3, true));
            }
            return values;
        }
        catch (Exception e3) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBaseX2(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(5);
        PARAMS p = ALPTEC.getParamX2(gateway, unitid);
        if (p != null) {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 25, 2);
            bb.put((byte)p.current);
            bb.put(data, 2, 4);
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeMaxBaseX2(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[0]) {
                case 0: {
                    values.put("maxI1", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 1: {
                    values.put("maxI2", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 2: {
                    values.put("maxI3", ALPTEC.toLong(data, 1, false));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBaseX2(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodeMaxBaseX2(data);
            Enumeration<String> e2 = decoded.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                values.put(k2, ALPTEC.toLongString(decoded.get(k2), 4, 2, false));
            }
            return values;
        }
        catch (Exception e3) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxExtX2(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(10);
        PARAMS p = ALPTEC.getParamX2(gateway, unitid);
        if (p != null) {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 23, 2);
            bb.put((byte)p.voltage);
            bb.put(data, 2, 4);
            data = user.modbusReadInputRegisters(gateway, unitid, 29, 2);
            bb.put((byte)p.temperature);
            bb.put(data, 2, 4);
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeMaxExtX2(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[0]) {
                case 0: {
                    values.put("maxU12", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 1: {
                    values.put("maxU23", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 2: {
                    values.put("maxU31", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 3: {
                    values.put("maxV1", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 4: {
                    values.put("maxV2", ALPTEC.toLong(data, 1, false));
                    break;
                }
                case 5: {
                    values.put("maxV3", ALPTEC.toLong(data, 1, false));
                }
            }
            values.put("TU", Integer.valueOf(data[5]));
            values.put("maxT", ALPTEC.toLong(data, 6, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxExtX2(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodeMaxExtX2(data);
            Enumeration<String> e2 = decoded.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                if (k2.equals("TU")) continue;
                values.put(k2, ALPTEC.toLongString(decoded.get(k2), 4, 0, false));
            }
            return values;
        }
        catch (Exception e3) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxExt8(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(3);
        PARAMS p = ALPTEC.getParam8(gateway, unitid);
        if (p != null) {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 8234, 1);
            bb.put((byte)p.temperature);
            bb.put(data, 2, 2);
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeMaxExt8(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("TU", Integer.valueOf(data[0]));
            values.put("maxT", ALPTEC.toInteger(data, 1, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxExt8(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodeMaxExt8(data);
            Enumeration<String> e2 = decoded.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                if (k2.equals("TU")) continue;
                values.put(k2, ALPTEC.toIntegerString(decoded.get(k2), 4, 1, true));
            }
            return values;
        }
        catch (Exception e3) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHDX2(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(6);
        PARAMS p = ALPTEC.getParamX2(gateway, unitid);
        if (p != null) {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 8199, 1);
            bb.put((byte)p.voltage);
            bb.put(data, 2, 2);
            bb.put((byte)p.current);
            data = user.modbusReadInputRegisters(gateway, unitid, 8200, 1);
            bb.put(data, 2, 2);
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeTHDX2(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[0]) {
                case 0: {
                    values.put("THDU12", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 1: {
                    values.put("THDU23", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 2: {
                    values.put("THDU31", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 3: {
                    values.put("THDV1", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 4: {
                    values.put("THDV2", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 5: {
                    values.put("THDV3", ALPTEC.toInteger(data, 1, false));
                }
            }
            switch (data[3]) {
                case 0: {
                    values.put("THDI1", ALPTEC.toInteger(data, 4, false));
                    break;
                }
                case 1: {
                    values.put("THDI2", ALPTEC.toInteger(data, 4, false));
                    break;
                }
                case 2: {
                    values.put("THDI3", ALPTEC.toInteger(data, 4, false));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHDX2(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodeTHDX2(data);
            Enumeration<String> e2 = decoded.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                values.put(k2, ALPTEC.toIntegerString(decoded.get(k2), 4, 1, false));
            }
            return values;
        }
        catch (Exception e3) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHD8(String gateway, int unitid) throws Exception {
        PARAMS p = ALPTEC.getParam8(gateway, unitid);
        if (p != null) {
            ByteBuffer bb = ByteBuffer.allocate(1 + (p.voltage < 6 ? 2 : 6) + 1 + (p.current < 3 ? 2 : 6));
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 8199, 1);
            bb.put((byte)p.voltage);
            switch (p.voltage) {
                case 0: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11583, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 1: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11631, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 2: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11679, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 3: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11295, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 4: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11343, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 5: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11391, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 6: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11583, 1);
                    bb.put(data, 2, 2);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11631, 1);
                    bb.put(data, 2, 2);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11679, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 7: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11295, 1);
                    bb.put(data, 2, 2);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11343, 1);
                    bb.put(data, 2, 2);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11391, 1);
                    bb.put(data, 2, 2);
                }
            }
            bb.put((byte)p.current);
            switch (p.current) {
                case 0: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11439, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 1: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11487, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 2: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11535, 1);
                    bb.put(data, 2, 2);
                    break;
                }
                case 3: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11439, 1);
                    bb.put(data, 2, 2);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11487, 1);
                    bb.put(data, 2, 2);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11535, 1);
                    bb.put(data, 2, 2);
                }
            }
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeTHD8(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[0]) {
                case 0: {
                    values.put("THDU12", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 1: {
                    values.put("THDU23", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 2: {
                    values.put("THDU31", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 3: {
                    values.put("THDV1", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 4: {
                    values.put("THDV2", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 5: {
                    values.put("THDV3", ALPTEC.toInteger(data, 1, false));
                    break;
                }
                case 6: {
                    values.put("THDU12", ALPTEC.toInteger(data, 1, false));
                    values.put("THDU23", ALPTEC.toInteger(data, 3, false));
                    values.put("THDU31", ALPTEC.toInteger(data, 5, false));
                    break;
                }
                case 7: {
                    values.put("THDV1", ALPTEC.toInteger(data, 1, false));
                    values.put("THDV2", ALPTEC.toInteger(data, 3, false));
                    values.put("THDV3", ALPTEC.toInteger(data, 5, false));
                }
            }
            int dataindex = data[0] < 6 ? 4 : 8;
            switch (data[dataindex - 1]) {
                case 0: {
                    values.put("THDI1", ALPTEC.toInteger(data, dataindex, false));
                    break;
                }
                case 1: {
                    values.put("THDI2", ALPTEC.toInteger(data, dataindex, false));
                    break;
                }
                case 2: {
                    values.put("THDI3", ALPTEC.toInteger(data, dataindex, false));
                    break;
                }
                case 3: {
                    values.put("THDI1", ALPTEC.toInteger(data, dataindex, false));
                    values.put("THDI2", ALPTEC.toInteger(data, dataindex + 2, false));
                    values.put("THDI3", ALPTEC.toInteger(data, dataindex + 4, false));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHD8(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodeTHD8(data);
            Enumeration<String> e2 = decoded.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                values.put(k2, ALPTEC.toIntegerString(decoded.get(k2), 4, 1, false));
            }
            return values;
        }
        catch (Exception e3) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicX2(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(58);
        PARAMS p = ALPTEC.getParamX2(gateway, unitid);
        if (p != null) {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 8319, 14);
            bb.put((byte)p.voltage);
            bb.put(data, 2, 28);
            bb.put((byte)p.current);
            data = user.modbusReadInputRegisters(gateway, unitid, 8351, 14);
            bb.put(data, 2, 28);
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeHarmonicX2(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            String currentHarmonicPrefix;
            String voltageHarmonicPrefix;
            switch (data[0]) {
                case 0: {
                    voltageHarmonicPrefix = "U12";
                    break;
                }
                case 1: {
                    voltageHarmonicPrefix = "U23";
                    break;
                }
                case 2: {
                    voltageHarmonicPrefix = "U31";
                    break;
                }
                case 3: {
                    voltageHarmonicPrefix = "V1";
                    break;
                }
                case 4: {
                    voltageHarmonicPrefix = "V2";
                    break;
                }
                case 5: {
                    voltageHarmonicPrefix = "V3";
                    break;
                }
                default: {
                    voltageHarmonicPrefix = null;
                }
            }
            switch (data[29]) {
                case 0: {
                    currentHarmonicPrefix = "I1";
                    break;
                }
                case 1: {
                    currentHarmonicPrefix = "I2";
                    break;
                }
                case 2: {
                    currentHarmonicPrefix = "I3";
                    break;
                }
                default: {
                    currentHarmonicPrefix = null;
                }
            }
            if (voltageHarmonicPrefix != null && currentHarmonicPrefix != null) {
                int i2 = 0;
                while (i2 < 14) {
                    values.put("H" + (i2 + 2) + voltageHarmonicPrefix, ALPTEC.toInteger(data, 1 + 2 * i2, false));
                    values.put("H" + (i2 + 2) + currentHarmonicPrefix, ALPTEC.toInteger(data, 30 + 2 * i2, false));
                    ++i2;
                }
            }
            return values;
        }
        catch (Exception exception) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicX2(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sbv = new StringBuffer("[");
        StringBuffer sbi = new StringBuffer("[");
        try {
            String currentHarmonicPrefix;
            String voltageHarmonicPrefix;
            switch (data[0]) {
                case 0: {
                    voltageHarmonicPrefix = "U12";
                    break;
                }
                case 1: {
                    voltageHarmonicPrefix = "U23";
                    break;
                }
                case 2: {
                    voltageHarmonicPrefix = "U31";
                    break;
                }
                case 3: {
                    voltageHarmonicPrefix = "V1";
                    break;
                }
                case 4: {
                    voltageHarmonicPrefix = "V2";
                    break;
                }
                case 5: {
                    voltageHarmonicPrefix = "V3";
                    break;
                }
                default: {
                    voltageHarmonicPrefix = null;
                }
            }
            switch (data[29]) {
                case 0: {
                    currentHarmonicPrefix = "I1";
                    break;
                }
                case 1: {
                    currentHarmonicPrefix = "I2";
                    break;
                }
                case 2: {
                    currentHarmonicPrefix = "I3";
                    break;
                }
                default: {
                    currentHarmonicPrefix = null;
                }
            }
            if (voltageHarmonicPrefix != null && currentHarmonicPrefix != null) {
                int i2 = 0;
                while (i2 < 14) {
                    if (i2 > 0) {
                        sbv.append(',');
                        sbi.append(',');
                    }
                    sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                    sbi.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 30 + 2 * i2, 2, false).intValue(), 3, 1, false));
                    ++i2;
                }
                sbv.append(']');
                sbi.append(']');
                values.put("H" + voltageHarmonicPrefix, sbv.toString());
                values.put("H" + currentHarmonicPrefix, sbi.toString());
                return values;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Hashtable<String, String>();
    }

    public static byte[] readHarmonic8(String gateway, int unitid) throws Exception {
        PARAMS p = ALPTEC.getParam8(gateway, unitid);
        if (p != null) {
            byte[] data;
            ByteBuffer bb = ByteBuffer.allocate(1 + (p.voltage < 6 ? 28 : 84) + 1 + (p.current < 3 ? 28 : 12) + 84);
            bb.put((byte)p.voltage);
            switch (p.voltage) {
                case 0: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11551, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 1: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11599, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 2: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11647, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 3: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11263, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 4: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11311, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 5: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11359, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 6: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11551, 14);
                    bb.put(data, 2, 28);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11599, 14);
                    bb.put(data, 2, 28);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11647, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 7: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11263, 14);
                    bb.put(data, 2, 28);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11311, 14);
                    bb.put(data, 2, 28);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11359, 14);
                    bb.put(data, 2, 28);
                }
            }
            bb.put((byte)p.current);
            switch (p.current) {
                case 0: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11407, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 1: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11455, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 2: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11518, 14);
                    bb.put(data, 2, 28);
                    break;
                }
                case 3: {
                    data = user.modbusReadInputRegisters(gateway, unitid, 11407, 14);
                    bb.put(data, 2, 28);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11455, 14);
                    bb.put(data, 2, 28);
                    data = user.modbusReadInputRegisters(gateway, unitid, 11518, 14);
                    bb.put(data, 2, 28);
                }
            }
            return bb.array();
        }
        return new byte[0];
    }

    public static Hashtable<String, Integer> decodeHarmonic8(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data[0]) {
                case 0: {
                    int i2 = 0;
                    while (i2 < 14) {
                        values.put("H" + (i2 + 2) + "U12", ALPTEC.toInteger(data, 1 + 2 * i2, false));
                        ++i2;
                    }
                    break;
                }
                case 1: {
                    int i2 = 0;
                    while (i2 < 14) {
                        values.put("H" + (i2 + 2) + "U23", ALPTEC.toInteger(data, 1 + 2 * i2, false));
                        ++i2;
                    }
                    break;
                }
                case 2: {
                    int i2 = 0;
                    while (i2 < 14) {
                        values.put("H" + (i2 + 2) + "U31", ALPTEC.toInteger(data, 1 + 2 * i2, false));
                        ++i2;
                    }
                    break;
                }
                case 3: {
                    int i2 = 0;
                    while (i2 < 14) {
                        values.put("H" + (i2 + 2) + "V1", ALPTEC.toInteger(data, 1 + 2 * i2, false));
                        ++i2;
                    }
                    break;
                }
                case 4: {
                    int i2 = 0;
                    while (i2 < 14) {
                        values.put("H" + (i2 + 2) + "V2", ALPTEC.toInteger(data, 1 + 2 * i2, false));
                        ++i2;
                    }
                    break;
                }
                case 5: {
                    int i2 = 0;
                    while (i2 < 14) {
                        values.put("H" + (i2 + 2) + "V3", ALPTEC.toInteger(data, 1 + 2 * i2, false));
                        ++i2;
                    }
                    break;
                }
                case 6: {
                    int i2 = 0;
                    while (i2 < 14) {
                        values.put("H" + (i2 + 2) + "U12", ALPTEC.toInteger(data, 1 + 2 * i2, false));
                        values.put("H" + (i2 + 2) + "U23", ALPTEC.toInteger(data, 1 + 2 * i2 + 28, false));
                        values.put("H" + (i2 + 2) + "U31", ALPTEC.toInteger(data, 1 + 2 * i2 + 56, false));
                        ++i2;
                    }
                    break;
                }
                case 7: {
                    int i2 = 0;
                    while (i2 < 14) {
                        values.put("H" + (i2 + 2) + "V1", ALPTEC.toInteger(data, 1 + 2 * i2, false));
                        values.put("H" + (i2 + 2) + "V2", ALPTEC.toInteger(data, 1 + 2 * i2 + 28, false));
                        values.put("H" + (i2 + 2) + "V3", ALPTEC.toInteger(data, 1 + 2 * i2 + 56, false));
                        ++i2;
                    }
                    break;
                }
            }
            int dataindex = data[0] < 6 ? 30 : 86;
            switch (data[dataindex - 1]) {
                case 0: {
                    int i3 = 0;
                    while (i3 < 14) {
                        values.put("H" + (i3 + 2) + "I1", ALPTEC.toInteger(data, dataindex + 2 * i3, false));
                        ++i3;
                    }
                    break;
                }
                case 1: {
                    int i4 = 0;
                    while (i4 < 14) {
                        values.put("H" + (i4 + 2) + "I2", ALPTEC.toInteger(data, dataindex + 2 * i4, false));
                        ++i4;
                    }
                    break;
                }
                case 2: {
                    int i5 = 0;
                    while (i5 < 14) {
                        values.put("H" + (i5 + 2) + "I3", ALPTEC.toInteger(data, dataindex + 2 * i5, false));
                        ++i5;
                    }
                    break;
                }
                case 3: {
                    int i6 = 0;
                    while (i6 < 14) {
                        values.put("H" + (i6 + 2) + "I1", ALPTEC.toInteger(data, dataindex + 2 * i6, false));
                        values.put("H" + (i6 + 2) + "I2", ALPTEC.toInteger(data, dataindex + 2 * i6 + 28, false));
                        values.put("H" + (i6 + 2) + "I3", ALPTEC.toInteger(data, dataindex + 2 * i6 + 56, false));
                        ++i6;
                    }
                    break;
                }
            }
            return values;
        }
        catch (Exception exception) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonic8(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sbv = new StringBuffer("[");
        StringBuffer sbi = new StringBuffer("[");
        try {
            switch (data[0]) {
                case 0: {
                    int i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HU12", sbv.toString());
                    break;
                }
                case 1: {
                    int i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HU23", sbv.toString());
                    break;
                }
                case 2: {
                    int i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HU31", sbv.toString());
                    break;
                }
                case 3: {
                    int i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HV1", sbv.toString());
                    break;
                }
                case 4: {
                    int i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HV2", sbv.toString());
                    break;
                }
                case 5: {
                    int i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HV3", sbv.toString());
                    break;
                }
                case 6: {
                    int i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HU12", sbv.toString());
                    sbv = new StringBuffer("[");
                    i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2 + 28, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HU23", sbv.toString());
                    sbv = new StringBuffer("[");
                    i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2 + 56, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HU31", sbv.toString());
                    break;
                }
                case 7: {
                    int i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HV1", sbv.toString());
                    sbv = new StringBuffer("[");
                    i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2 + 28, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HV2", sbv.toString());
                    sbv = new StringBuffer("[");
                    i2 = 0;
                    while (i2 < 14) {
                        if (i2 > 0) {
                            sbv.append(',');
                        }
                        sbv.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, 1 + 2 * i2 + 56, 2, false).intValue(), 3, 1, false));
                        ++i2;
                    }
                    sbv.append(']');
                    values.put("HV3", sbv.toString());
                }
            }
            int dataindex = data[0] < 6 ? 30 : 86;
            switch (data[dataindex - 1]) {
                case 0: {
                    int i3 = 0;
                    while (i3 < 14) {
                        if (i3 > 0) {
                            sbi.append(',');
                        }
                        sbi.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, dataindex + 2 * i3, 2, false).intValue(), 3, 1, false));
                        ++i3;
                    }
                    sbi.append(']');
                    values.put("HI1", sbi.toString());
                    break;
                }
                case 1: {
                    int i4 = 0;
                    while (i4 < 14) {
                        if (i4 > 0) {
                            sbi.append(',');
                        }
                        sbi.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, dataindex + 2 * i4, 2, false).intValue(), 3, 1, false));
                        ++i4;
                    }
                    sbi.append(']');
                    values.put("HI2", sbi.toString());
                    break;
                }
                case 2: {
                    int i5 = 0;
                    while (i5 < 14) {
                        if (i5 > 0) {
                            sbi.append(',');
                        }
                        sbi.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, dataindex + 2 * i5, 2, false).intValue(), 3, 1, false));
                        ++i5;
                    }
                    sbi.append(']');
                    values.put("HI3", sbi.toString());
                    break;
                }
                case 3: {
                    int i6 = 0;
                    while (i6 < 14) {
                        if (i6 > 0) {
                            sbi.append(',');
                        }
                        sbi.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, dataindex + 2 * i6, 2, false).intValue(), 3, 1, false));
                        ++i6;
                    }
                    sbi.append(']');
                    values.put("HI1", sbi.toString());
                    sbi = new StringBuffer("[");
                    i6 = 0;
                    while (i6 < 14) {
                        if (i6 > 0) {
                            sbi.append(',');
                        }
                        sbi.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, dataindex + 2 * i6 + 28, 2, false).intValue(), 3, 1, false));
                        ++i6;
                    }
                    sbi.append(']');
                    values.put("HI2", sbi.toString());
                    sbi = new StringBuffer("[");
                    i6 = 0;
                    while (i6 < 14) {
                        if (i6 > 0) {
                            sbi.append(',');
                        }
                        sbi.append(ALPTEC.toIntegerString(ALPTEC.decodeInteger(data, dataindex + 2 * i6 + 56, 2, false).intValue(), 3, 1, false));
                        ++i6;
                    }
                    sbi.append(']');
                    values.put("HI3", sbi.toString());
                }
            }
            return values;
        }
        catch (Exception exception) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readSteps3252(String gateway, int unitid, int steps) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(steps * 8);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 511, steps * 2);
        bb.put(data, 2, steps * 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 8223, steps);
        bb.put(data, 2, steps * 2);
        data = user.modbusReadInputRegisters(gateway, unitid, 8255, steps);
        bb.put(data, 2, steps * 2);
        return bb.array();
    }

    public static Hashtable<String, Integer[]> decodeSteps3252(byte[] data) {
        Hashtable<String, Integer[]> values = new Hashtable<String, Integer[]>();
        try {
            int numberOfSteps = data.length / 8;
            Integer[] buffer = new Integer[numberOfSteps];
            int i2 = 0;
            while (i2 < numberOfSteps) {
                buffer[i2] = ALPTEC.toLong(data, 4 * i2, false);
                ++i2;
            }
            values.put("ST", buffer);
            buffer = new Integer[numberOfSteps];
            i2 = 0;
            while (i2 < numberOfSteps) {
                buffer[i2] = ALPTEC.toInteger(data, 4 * numberOfSteps + 2 * i2, false);
                ++i2;
            }
            values.put("SN", buffer);
            buffer = new Integer[numberOfSteps];
            i2 = 0;
            while (i2 < numberOfSteps) {
                buffer[i2] = ALPTEC.toInteger(data, 6 * numberOfSteps + 2 * i2, false);
                ++i2;
            }
            values.put("SR", buffer);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer[]>();
        }
    }

    public static Hashtable<String, String> displaySteps3252(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sbt = new StringBuffer("[");
        StringBuffer sbn = new StringBuffer("[");
        StringBuffer sbr = new StringBuffer("[");
        try {
            Hashtable<String, Integer[]> decoded = ALPTEC.decodeSteps3252(data);
            Integer[] stepst = decoded.get("ST");
            Integer[] stepsn = decoded.get("SN");
            Integer[] stepsr = decoded.get("SR");
            int i2 = 0;
            while (i2 < stepst.length) {
                if (i2 > 0) {
                    sbt.append(',');
                    sbn.append(',');
                    sbr.append(',');
                }
                sbt.append(stepst[i2]);
                sbn.append(stepsn[i2]);
                sbr.append(stepsr[i2]);
                ++i2;
            }
            sbt.append(']');
            sbn.append(']');
            sbr.append(']');
            values.put("ST", sbt.toString());
            values.put("SN", sbn.toString());
            values.put("SR", sbr.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readSteps82(String gateway, int unitid) throws Exception {
        int steps = 14;
        ByteBuffer bb = ByteBuffer.allocate(112);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 511, 28);
        bb.put(data, 2, 56);
        data = user.modbusReadInputRegisters(gateway, unitid, 8223, 14);
        bb.put(data, 2, 28);
        data = user.modbusReadInputRegisters(gateway, unitid, 8255, 14);
        bb.put(data, 2, 28);
        return bb.array();
    }

    public static Hashtable<String, Integer[]> decodeSteps82(byte[] data) {
        Hashtable<String, Integer[]> values = new Hashtable<String, Integer[]>();
        try {
            Integer[] buffer = new Integer[11];
            int i2 = 0;
            while (i2 < 8) {
                buffer[i2] = ALPTEC.toLong(data, 4 * i2, false);
                ++i2;
            }
            i2 = 8;
            while (i2 < 11) {
                buffer[i2] = ALPTEC.toLong(data, 4 * i2, false) + ALPTEC.toLong(data, 12 + 4 * i2, false);
                ++i2;
            }
            values.put("ST", buffer);
            buffer = new Integer[11];
            i2 = 0;
            while (i2 < 8) {
                buffer[i2] = ALPTEC.toInteger(data, 56 + 2 * i2, false);
                ++i2;
            }
            i2 = 8;
            while (i2 < 11) {
                buffer[i2] = ALPTEC.toInteger(data, 56 + 2 * i2, false) + ALPTEC.toInteger(data, 62 + 2 * i2, false);
                ++i2;
            }
            values.put("SN", buffer);
            buffer = new Integer[11];
            i2 = 0;
            while (i2 < 8) {
                buffer[i2] = ALPTEC.toInteger(data, 84 + 2 * i2, false);
                ++i2;
            }
            i2 = 8;
            while (i2 < 11) {
                buffer[i2] = ALPTEC.toInteger(data, 84 + 2 * i2, false) + ALPTEC.toInteger(data, 90 + 2 * i2, false);
                ++i2;
            }
            values.put("SR", buffer);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer[]>();
        }
    }

    public static Hashtable<String, String> displaySteps82(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sbt = new StringBuffer("[");
        StringBuffer sbn = new StringBuffer("[");
        StringBuffer sbr = new StringBuffer("[");
        try {
            Hashtable<String, Integer[]> decoded = ALPTEC.decodeSteps82(data);
            Integer[] stepst = decoded.get("ST");
            Integer[] stepsn = decoded.get("SN");
            Integer[] stepsr = decoded.get("SR");
            int i2 = 0;
            while (i2 < stepst.length) {
                if (i2 > 0) {
                    sbt.append(',');
                    sbn.append(',');
                    sbr.append(',');
                }
                sbt.append(stepst[i2]);
                sbn.append(stepsn[i2]);
                sbr.append(stepsr[i2]);
                ++i2;
            }
            sbt.append(']');
            sbn.append(']');
            sbr.append(']');
            values.put("ST", sbt.toString());
            values.put("SN", sbn.toString());
            values.put("SR", sbr.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readSteps8(String gateway, int unitid) throws Exception {
        int steps = 20;
        ByteBuffer bb = ByteBuffer.allocate(240);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 4607, 40);
        bb.put(data, 2, 80);
        data = user.modbusReadInputRegisters(gateway, unitid, 4351, 40);
        bb.put(data, 2, 80);
        data = user.modbusReadInputRegisters(gateway, unitid, 4863, 40);
        bb.put(data, 2, 80);
        return bb.array();
    }

    public static Hashtable<String, Integer[]> decodeSteps8(byte[] data) {
        int steps = 20;
        Hashtable<String, Integer[]> values = new Hashtable<String, Integer[]>();
        try {
            Integer[] buffer = new Integer[20];
            int i2 = 0;
            while (i2 < 20) {
                buffer[i2] = ALPTEC.toLong(data, 4 * i2, false) / 60;
                ++i2;
            }
            values.put("ST", buffer);
            buffer = new Integer[20];
            i2 = 0;
            while (i2 < 20) {
                buffer[i2] = ALPTEC.toLong(data, 80 + 4 * i2, false);
                ++i2;
            }
            values.put("SN", buffer);
            buffer = new Integer[20];
            i2 = 0;
            while (i2 < 20) {
                buffer[i2] = ALPTEC.toLong(data, 160 + 4 * i2, false);
                ++i2;
            }
            values.put("SR", buffer);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer[]>();
        }
    }

    public static Hashtable<String, String> displaySteps8(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sbt = new StringBuffer("[");
        StringBuffer sbn = new StringBuffer("[");
        StringBuffer sbr = new StringBuffer("[");
        try {
            Hashtable<String, Integer[]> decoded = ALPTEC.decodeSteps8(data);
            Integer[] stepst = decoded.get("ST");
            Integer[] stepsn = decoded.get("SN");
            Integer[] stepsr = decoded.get("SR");
            int i2 = 0;
            while (i2 < stepst.length) {
                if (i2 > 0) {
                    sbt.append(',');
                    sbn.append(',');
                    sbr.append(',');
                }
                sbt.append(stepst[i2]);
                sbn.append(stepsn[i2]);
                sbr.append(ALPTEC.toLongString(stepsr[i2], 4, 2, false));
                ++i2;
            }
            sbt.append(']');
            sbn.append(']');
            sbr.append(']');
            values.put("ST", sbt.toString());
            values.put("SN", sbn.toString());
            values.put("SR", sbr.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readCapacitorOverloadX2(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(6);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 8196, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadInputRegisters(gateway, unitid, 27, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeCapacitorOverloadX2(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("COV", ALPTEC.toInteger(data, 0, false));
            values.put("maxCOV", ALPTEC.toLong(data, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayCapacitorOverloadX2(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = ALPTEC.decodeCapacitorOverloadX2(data);
            values.put("COV", Integer.toString(decoded.get("COV")));
            values.put("maxCOV", Integer.toString(decoded.get("maxCOV")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static Hashtable<String, String> readMaintenanceHoursX2(String gateway, int unitid) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 8198, 1);
            if (data[0] == 4) {
                values.put("mhours", Integer.toString(ALPTEC.toInteger(data, 2, false)));
                return values;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean writeResetMaintenanceHoursX2(String gateway, int unitid) {
        byte[] data = new byte[2];
        try {
            data = user.modbusWriteSingleRegister(gateway, unitid, 12271, data);
            return data[0] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean writeResetMaintenanceHours8(String gateway, int unitid, int interval) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(15 + interval);
        byte[] data = byArray;
        try {
            data = user.modbusWriteSingleRegister(gateway, unitid, 12271, data);
            return data[0] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static Hashtable<String, String> readStepsModeX2(String gateway, int unitid, int steps) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb = new StringBuffer("[");
        try {
            byte[] data = Modbus.readExceptionStatus(gateway, unitid, 0);
            if (data[0] == 7) {
                values.put("mode", (data[1] & 1) > 0 ? "man" : "auto");
                data = user.modbusReadInputRegisters(gateway, unitid, 15, 2);
                if (data[0] == 4) {
                    int i2 = 0;
                    while (i2 < steps) {
                        if (i2 > 0) {
                            sb.append(',');
                        }
                        if (steps == 3 && i2 == 2) {
                            sb.append((data[5] & 0x10) > 0 ? 1 : 0);
                        } else if (i2 < 8) {
                            sb.append((data[5] & 1 << i2) > 0 ? 1 : 0);
                        } else {
                            sb.append((data[4] & (1 << i2 - 8 | 1 << 3 + i2 - 8)) > 0 ? 1 : 0);
                        }
                        ++i2;
                    }
                    sb.append(']');
                    values.put("steps", sb.toString());
                    data = user.modbusReadInputRegisters(gateway, unitid, 21, 2);
                    if (data[0] == 4) {
                        values.put("stepfault", (data[4] & 0x10) > 0 ? "1" : "0");
                        return values;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Hashtable<String, String> readStepsMode8(String gateway, int unitid) {
        int steps = 20;
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb = new StringBuffer("[");
        try {
            byte[] data = Modbus.readExceptionStatus(gateway, unitid, 0);
            if (data[0] == 7) {
                values.put("mode", (data[1] & 2) > 0 ? "man" : "auto");
                data = user.modbusReadInputRegisters(gateway, unitid, 8463, 20);
                if (data[0] == 4 && data[1] == 40) {
                    int i2 = 0;
                    while (i2 < 20) {
                        if (i2 > 0) {
                            sb.append(',');
                        }
                        switch (data[3 + 2 * i2]) {
                            case 0: {
                                sb.append(0);
                                break;
                            }
                            case 1: {
                                sb.append(1);
                            }
                        }
                        ++i2;
                    }
                    sb.append(']');
                    values.put("steps", sb.toString());
                    data = user.modbusReadInputRegisters(gateway, unitid, 5119, 2);
                    if (data[0] == 4) {
                        values.put("stepfault", (data[4] & 2) > 0 ? "1" : "0");
                    }
                    return values;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Hashtable<String, Boolean> readAlarmsX2(String gateway, int unitid) {
        Hashtable<String, Boolean> values = new Hashtable<String, Boolean>();
        try {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 21, 2);
            if (data[0] == 4) {
                int i2 = 0;
                while (i2 < 13) {
                    boolean a2 = i2 < 8 ? (data[5] & 1 << i2) > 0 : (data[4] & 1 << i2 - 8) > 0;
                    values.put("a" + i2, a2);
                    ++i2;
                }
                return values;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Hashtable<String, Boolean> readAlarms8(String gateway, int unitid) {
        Hashtable<String, Boolean> values = new Hashtable<String, Boolean>();
        try {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 5119, 2);
            if (data[0] == 4) {
                int i2 = 0;
                while (i2 < 30) {
                    boolean a2 = i2 < 8 ? (data[5] & 1 << i2) > 0 : (i2 < 16 ? (data[4] & 1 << i2 - 8) > 0 : (i2 < 24 ? (data[3] & 1 << i2 - 16) > 0 : (data[2] & 1 << i2 - 24) > 0));
                    values.put("a" + i2, a2);
                    ++i2;
                }
                return values;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readModel(String gateway, int unitid) {
        try {
            byte[] data = Modbus.reportSlaveID(gateway, unitid, 0);
            if (data[0] != 17) return null;
            if (data[1] != 8) {
                if (data[2] != 72) return null;
                return "8";
            }
            switch (data[2]) {
                case 67: {
                    return "3.2";
                }
                case 69: {
                    return "5.2";
                }
                case 73: {
                    return "8.2";
                }
            }
            return null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean writeModeX2(String gateway, int unitid, boolean auto) {
        byte[] data = new byte[2];
        try {
            data[1] = (byte)(auto ? 2 : 1);
            data = user.modbusWriteSingleRegister(gateway, unitid, 12287, data);
            return data[0] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean writeMode8(String gateway, int unitid, boolean auto) {
        byte[] data = new byte[2];
        try {
            data[1] = (byte)(auto ? 2 : 1);
            data = user.modbusWriteSingleRegister(gateway, unitid, 12031, data);
            return data[0] == 6;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean writeStepsModeX2(String gateway, int unitid, int step, boolean on) {
        byte[] data = new byte[2];
        try {
            if (step >= 1 && step <= 11) {
                data[1] = (byte)(step - 1);
                data = user.modbusWriteSingleRegister(gateway, unitid, on ? 12292 : 12293, data);
                return data[0] == 6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PARAMS getParamX2(String gateway, int unitid) throws Exception {
        String cacheId = String.valueOf(gateway) + ":" + unitid;
        long now = System.currentTimeMillis();
        boolean error = true;
        Hashtable<String, PARAMS> hashtable = paramsCache;
        synchronized (hashtable) {
            PARAMS params = paramsCache.get(cacheId);
            if (params == null || params.timestamp < now - 600000L) {
                int i2 = 0;
                while (i2 < 4 && error) {
                    byte[] wdata = new byte[2];
                    int voltage = -1;
                    int current = -1;
                    int temperature = -1;
                    error = false;
                    wdata[0] = 0;
                    wdata[1] = 5;
                    byte[] data = user.modbusWriteSingleRegister(gateway, unitid, 20481, wdata);
                    if (data[0] == 6) {
                        data = user.modbusReadInputRegisters(gateway, unitid, 20482, 2);
                        if (data[0] == 4 && data[5] >= 0 && data[5] <= 5) {
                            voltage = data[5];
                        } else {
                            error = true;
                        }
                    } else {
                        error = true;
                    }
                    if (!error) {
                        wdata[0] = 0;
                        wdata[1] = 3;
                        data = user.modbusWriteSingleRegister(gateway, unitid, 20481, wdata);
                        if (data[0] == 6) {
                            data = user.modbusReadInputRegisters(gateway, unitid, 20482, 2);
                            if (data[0] == 4 && data[5] >= 0 && data[5] <= 2) {
                                current = data[5];
                            } else {
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                    }
                    if (!error) {
                        wdata[0] = 0;
                        wdata[1] = 36;
                        data = user.modbusWriteSingleRegister(gateway, unitid, 20481, wdata);
                        if (data[0] == 6) {
                            data = user.modbusReadInputRegisters(gateway, unitid, 20482, 2);
                            if (data[0] == 4 && data[5] >= 0 && data[5] <= 1) {
                                temperature = data[5];
                            } else {
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                    }
                    if (!error) {
                        params = new PARAMS(voltage, current, temperature, -1);
                        paramsCache.put(cacheId, params);
                    }
                    ++i2;
                }
            }
            if (params != null) {
                return params;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PARAMS getParam8(String gateway, int unitid) throws Exception {
        String cacheId = String.valueOf(gateway) + ":" + unitid;
        long now = System.currentTimeMillis();
        boolean error = true;
        Hashtable<String, PARAMS> hashtable = paramsCache;
        synchronized (hashtable) {
            PARAMS params = paramsCache.get(cacheId);
            if (params == null || params.timestamp < now - 600000L) {
                int i2 = 0;
                while (i2 < 4 && error) {
                    byte[] wdata = new byte[2];
                    int voltage = -1;
                    int current = -1;
                    int temperature = -1;
                    int tanfi = -1;
                    error = false;
                    wdata[0] = 0;
                    wdata[1] = 2;
                    byte[] data = user.modbusWriteSingleRegister(gateway, unitid, 20479, wdata);
                    if (data[0] == 6) {
                        wdata[0] = 0;
                        wdata[1] = 6;
                        data = user.modbusWriteSingleRegister(gateway, unitid, 20481, wdata);
                        if (data[0] == 6) {
                            data = user.modbusReadInputRegisters(gateway, unitid, 20483, 1);
                            if (data[0] == 4 && data[2] == 0 && data[3] >= 0 && data[3] <= 7) {
                                voltage = data[3];
                            } else {
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                    } else {
                        error = true;
                    }
                    if (!error) {
                        wdata[0] = 0;
                        wdata[1] = 2;
                        data = user.modbusWriteSingleRegister(gateway, unitid, 20479, wdata);
                        if (data[0] == 6) {
                            wdata[0] = 0;
                            wdata[1] = 4;
                            data = user.modbusWriteSingleRegister(gateway, unitid, 20481, wdata);
                            if (data[0] == 6) {
                                data = user.modbusReadInputRegisters(gateway, unitid, 20483, 1);
                                if (data[0] == 4 && data[2] == 0 && data[3] >= 0 && data[3] <= 3) {
                                    current = data[3];
                                } else {
                                    error = true;
                                }
                            } else {
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                    }
                    if (!error) {
                        wdata[0] = 0;
                        wdata[1] = 17;
                        data = user.modbusWriteSingleRegister(gateway, unitid, 20479, wdata);
                        if (data[0] == 6) {
                            wdata[0] = 0;
                            wdata[1] = 1;
                            data = user.modbusWriteSingleRegister(gateway, unitid, 20481, wdata);
                            if (data[0] == 6) {
                                data = user.modbusReadInputRegisters(gateway, unitid, 20483, 1);
                                if (data[0] == 4 && data[2] == 0 && data[3] >= 0 && data[3] <= 1) {
                                    temperature = data[3];
                                } else {
                                    error = true;
                                }
                            } else {
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                    }
                    if (!error) {
                        wdata[0] = 0;
                        wdata[1] = 2;
                        data = user.modbusWriteSingleRegister(gateway, unitid, 20479, wdata);
                        if (data[0] == 6) {
                            wdata[0] = 0;
                            wdata[1] = 30;
                            data = user.modbusWriteSingleRegister(gateway, unitid, 20481, wdata);
                            if (data[0] == 6) {
                                data = user.modbusReadInputRegisters(gateway, unitid, 20483, 1);
                                if (data[0] == 4 && data[2] == 0 && data[3] >= 0 && data[3] <= 1) {
                                    tanfi = data[3];
                                } else {
                                    error = true;
                                }
                            } else {
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                    }
                    if (!error) {
                        params = new PARAMS(voltage, current, temperature, tanfi);
                        paramsCache.put(cacheId, params);
                    }
                    ++i2;
                }
            }
            if (params != null) {
                return params;
            }
            return null;
        }
    }

    public static int getNumberOfStepsByModel(int modelid) {
        switch (modelid) {
            case 124: {
                return 3;
            }
            case 125: {
                return 5;
            }
            case 126: {
                return 11;
            }
            case 127: {
                return 20;
            }
        }
        return 0;
    }

    public static int toInteger(byte[] data, int index, boolean signed) {
        return ALPTEC.decodeInteger(data, index, 2, signed).intValue();
    }

    public static String toIntegerString(int val, int digits, int decimals, boolean signed) {
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    public static int toLong(byte[] data, int index, boolean signed) {
        return ALPTEC.decodeInteger(data, index, 4, signed).intValue();
    }

    public static String toLongString(byte[] data, int index, boolean signed) {
        long val = ALPTEC.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "";
        }
        return Long.toString(val);
    }

    public static String toLongString(int val, int digits, int decimals, boolean signed) {
        if (signed && val == Integer.MAX_VALUE || !signed && val == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

