/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.io.Serializable;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.InputGroup;
import plugins.wiringeditor.Listable;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.OutputGroup;
import plugins.wiringeditor.UIText;
import plugins.wiringeditor.WiringBlind;
import plugins.wiringeditor.WiringDimmer;
import plugins.wiringeditor.WiringEditor;
import plugins.wiringeditor.WiringOnOff;
import plugins.wiringeditor.WiringScenario;

public abstract class Wiring
implements Listable {
    private static final long serialVersionUID = 2533396263973767591L;
    static int wirings_count;
    final String id;
    String name;
    protected final Function function;
    protected Input[] inputs;
    protected Output output;
    boolean ready = true;

    protected Wiring(String id, String name, Function function) {
        this.id = id;
        this.name = name;
        this.function = function;
        this.inputs = new Input[this.function.inputLabels.length];
    }

    public Wiring(String name, Function function, Output output, String[] ins, Wiring edited) throws Exception {
        if (edited == null) {
            this.id = Integer.toString(wirings_count++);
            Database.save("wirings_count", wirings_count);
        } else {
            this.id = edited.id;
        }
        this.name = name;
        this.output = output;
        this.function = function;
        this.inputs = new Input[this.function.inputLabels.length];
        int j2 = 0;
        while (j2 < this.inputs.length) {
            if (ins[j2].equals("")) {
                throw new WiringEditor.UserException(UIText.SELECT_AN_INPUT);
            }
            Input i2 = WiringEditor.inputs.get(ins[j2]);
            if (i2 == null) {
                throw new Exception("input not found");
            }
            this.inputs[j2] = i2;
            ++j2;
        }
    }

    public static Wiring getInstance(String name, String typeOut, String function, String out, String[] ins, String value, String manned, String delay, String hold, String ratio, String schedulerVal, Wiring edited) throws Exception {
        Output o2 = WiringEditor.outputs.get(out);
        if (o2 == null) {
            throw new Exception("output not found");
        }
        if (typeOut.equals("onoff")) {
            return new WiringOnOff(name, function, o2, ins, value, delay, hold, edited);
        }
        if (typeOut.equals("dimmer")) {
            return new WiringDimmer(name, function, o2, ins, ratio, edited);
        }
        if (typeOut.equals("blind")) {
            return new WiringBlind(name, function, o2, ins, manned, edited);
        }
        if (typeOut.equals("scenario")) {
            return new WiringScenario(name, o2, ins, schedulerVal, edited);
        }
        throw new Exception("unknown output type: " + typeOut);
    }

    @Override
    public String getRow(String list, Object filter) {
        String row = null;
        if (filter == null || filter instanceof String || filter instanceof Input && this.hasInput((Input)filter) || filter instanceof Output && this.hasOutput((Output)filter) || filter instanceof Wiring && filter == this) {
            row = "<table class=\"listtable\">";
            row = String.valueOf(row) + "<colgroup><col class=\"id\"></colgroup>";
            row = String.valueOf(row) + "<tr><td colspan=\"2\" class=\"name\">" + (this.ready ? this.name : "<del>" + this.name + "</del>") + "</td></tr>";
            row = String.valueOf(row) + "<tr>";
            row = String.valueOf(row) + "<td class=\"id\">" + this.getOutputTypeName() + "</td>";
            row = String.valueOf(row) + "<td class=\"type\">" + this.function.label + "</td>";
            row = String.valueOf(row) + "</tr></table>";
        }
        return row;
    }

    protected abstract String getOutputTypeName();

    @Override
    public String select(String list, boolean repeat, boolean up, String session) throws Exception {
        if (repeat) {
            WiringEditor.uiSet("wiring.id", "text", this.id, session);
            WiringEditor.uiSet("wiring.name", "text", this.name, session);
            WiringEditor.uiSet("wiring.new", "visible", "false", session);
            WiringEditor.uiSet("wiring.edit", "visible", "true", session);
            WiringEditor.uiSet("wiring.delete", "visible", "true", session);
            WiringEditor.uiSet("wiring.function", "enabled", "true", session);
            WiringEditor.uiSet("wiring.scenario.rec", "visible", "false", session);
            WiringEditor.uiSet("wiring.scenario.info", "visible", "false", session);
            WiringEditor.uiSet("wiring.scheduler.option", "visible", "false", session);
            this.uiSet(session);
            WiringEditor.uiSet("wiring.output.list", "value", this.output.id, session);
            int i2 = 0;
            while (i2 < this.inputs.length) {
                WiringEditor.uiSet("wiring.input." + i2 + ".list", "value", this.inputs[i2].id, session);
                ++i2;
            }
            return "!page:wiring.add";
        }
        if (up) {
            String nowSelected = WiringEditor.uiGet("wiring.list", "value", session);
            if (nowSelected == null || !nowSelected.equals(this.id)) {
                WiringEditor.uiSet("input.list", "value", "", session);
                WiringEditor.uiSet("output.list", "value", "", session);
                WiringEditor.uiSet("wiring.list", "value", this.id, session);
                WiringEditor.inputs.update(this, session);
                WiringEditor.outputs.update(this, session);
                WiringEditor.wirings.update(this, session);
            } else {
                WiringEditor.uiClear(session);
                WiringEditor.uiSet("input.list", "value", "", session);
                WiringEditor.uiSet("output.list", "value", "", session);
                WiringEditor.uiSet("wiring.list", "value", "", session);
                WiringEditor.inputs.update(null);
                WiringEditor.outputs.update(null);
                WiringEditor.wirings.update(null);
            }
        }
        return "!";
    }

    protected abstract void uiSet(String var1) throws Exception;

    @Override
    public int compare(Listable anotherListable) {
        if (anotherListable instanceof Wiring) {
            Wiring w = (Wiring)anotherListable;
            return this.name.toLowerCase().compareTo(w.name.toLowerCase());
        }
        return 0;
    }

    public void setName(String name) throws Exception {
        this.name = name;
        WiringEditor.wirings.save(null);
    }

    public void event(Input i2, String value) throws Exception {
        if (this.ready) {
            Input[] inputArray = this.inputs;
            int n2 = this.inputs.length;
            int n3 = 0;
            while (n3 < n2) {
                Input in = inputArray[n3];
                if (in.matches(i2)) {
                    this.execute(i2, value);
                    return;
                }
                ++n3;
            }
        }
    }

    boolean hasInput(Input i2) {
        Input[] inputArray = this.inputs;
        int n2 = this.inputs.length;
        int n3 = 0;
        while (n3 < n2) {
            Input in = inputArray[n3];
            if (in == i2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    boolean hasOutput(Output o2) {
        return this.output == o2;
    }

    protected abstract void execute(Input var1, String var2) throws Exception;

    public void check() {
        this.ready = true;
        Output o2 = WiringEditor.outputs.get(this.output.id);
        if (o2 == null) {
            this.ready = false;
            return;
        }
        if (o2 instanceof OutputGroup && !((OutputGroup)o2).ready) {
            this.ready = false;
            return;
        }
        this.output = o2;
        int x = 0;
        while (x < this.inputs.length) {
            Input i2 = WiringEditor.inputs.get(this.inputs[x].id);
            if (i2 == null) {
                this.ready = false;
            } else {
                if (i2 instanceof InputGroup && !((InputGroup)i2).ready) {
                    this.ready = false;
                }
                this.inputs[x] = i2;
            }
            ++x;
        }
    }

    @Override
    public void onRemove() {
    }

    static class Function
    implements Serializable {
        private static final long serialVersionUID = -6452663607565155150L;
        static final String[] options = new String[]{"value", "manned", "timers", "ratio"};
        final int id;
        final String label;
        final String[] inputLabels;
        final String option;

        public Function(int id, String label, String[] inputLabels, String option) {
            this.id = id;
            this.label = label;
            this.inputLabels = inputLabels;
            this.option = option;
        }

        public void uiSet(String session) {
            WiringEditor.uiSet("wiring.function", "value", "" + this.id, session);
            int i2 = 0;
            while (i2 < this.inputLabels.length) {
                WiringEditor.uiSet("wiring.input." + i2 + ".cont", "visible", "true", session);
                WiringEditor.uiSet("wiring.input." + i2 + ".label", "text", this.inputLabels[i2], session);
                WiringEditor.uiSet("wiring.input." + i2 + ".list", "value", "", session);
                ++i2;
            }
            while (i2 < 3) {
                WiringEditor.uiSet("wiring.input." + i2 + ".cont", "visible", "false", session);
                ++i2;
            }
            String[] stringArray = options;
            int n2 = options.length;
            int n3 = 0;
            while (n3 < n2) {
                String opt = stringArray[n3];
                WiringEditor.uiSet("wiring.function.option." + opt, "visible", "false", session);
                ++n3;
            }
            if (this.option != null) {
                WiringEditor.uiSet("wiring.function.option." + this.option, "visible", "true", session);
            }
        }
    }
}

