/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.util.Map;
import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringEditor;
import plugins.wiringeditor.WiringScenario;

public class OutputUser
extends Output {
    private static final long serialVersionUID = 8876295685871603476L;
    private String value;

    public OutputUser(String dbString) {
        this(Database.split(dbString, ','));
    }

    private OutputUser(Vector<String> params) {
        super(params.get(0), "User", params.get(1), Integer.parseInt(params.get(2)));
        int i2 = 3;
        while (i2 < params.size()) {
            Wiring s = WiringEditor.wirings.get(params.get(i2));
            if (s != null && s instanceof WiringScenario) {
                this.scenarios.put((WiringScenario)s, params.get(i2 + 1));
            }
            i2 += 2;
        }
    }

    public OutputUser(String id, String name, int valueType) throws Exception {
        super(id, "User", name, valueType);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    @Override
    public void saveScenarios() {
    }

    @Override
    public void onRemove() {
    }

    @Override
    public void setValue(String value) {
        WiringEditor.user(this.id, value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void updateValue(String value) {
        this.value = value;
    }

    @Override
    public String toDBString() {
        StringBuilder dbString = new StringBuilder();
        dbString.append(this.id.replace(",", ",,")).append(",");
        dbString.append(this.name.replace(",", ",,")).append(",");
        dbString.append(this.valueType);
        for (Map.Entry s : this.scenarios.entrySet()) {
            dbString.append(",").append(((WiringScenario)s.getKey()).id);
            dbString.append(",").append((String)s.getValue());
        }
        return dbString.toString();
    }
}

