/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.Listable;
import plugins.wiringeditor.OutputGroup;
import plugins.wiringeditor.UIText;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringEditor;
import plugins.wiringeditor.WiringScenario;

public class Output
implements Listable {
    private static final long serialVersionUID = -3239872806598758215L;
    static final int VALUE_TYPE_UNKNOWN = -1;
    static final int VALUE_TYPE_ONOFF = 0;
    static final int VALUE_TYPE_DIMMER = 1;
    static final int VALUE_TYPE_BLIND = 2;
    final String id;
    String name;
    String typeName;
    int valueType;
    protected HashMap<WiringScenario, String> scenarios;

    protected Output(String id) {
        this.id = id;
    }

    protected Output(String id, String typeName, String name, int valueType) {
        this.id = id;
        this.name = name;
        this.typeName = typeName;
        this.valueType = valueType;
        this.scenarios = new HashMap();
    }

    public Output(String id, String typeName) throws Exception {
        this(id, typeName, Output.loadName(id), Output.loadValueType(id));
        this.loadScenarios();
    }

    private static String loadName(String id) {
        try {
            return Database.loadString(String.valueOf(id) + ".name");
        }
        catch (Exception e2) {
            return id;
        }
    }

    private static int loadValueType(String id) {
        try {
            return Database.loadInt(String.valueOf(id) + ".valuetype");
        }
        catch (Exception e2) {
            return -1;
        }
    }

    private void loadScenarios() throws Exception {
        try {
            String scenString = Database.loadString(String.valueOf(this.id) + ".scenarios");
            Vector<String> scens = Database.split(scenString, ',');
            int i2 = 0;
            while (i2 < scens.size()) {
                Wiring s = WiringEditor.wirings.get(scens.get(i2));
                if (s != null && s instanceof WiringScenario) {
                    this.scenarios.put((WiringScenario)s, scens.get(i2 + 1));
                } else {
                    WiringEditor.log(0, "error loading scenario '" + scens.get(i2) + "' for output '" + this.id + "'");
                }
                i2 += 2;
            }
        }
        catch (IOException e2) {
            this.scenarios = new HashMap();
        }
    }

    @Override
    public String getRow(String list, Object filter) {
        if (list.startsWith("output.group.")) {
            return this.name;
        }
        if (list.startsWith("wiring.")) {
            if (filter != null && filter instanceof String) {
                if (filter.equals("onoff")) {
                    if (this.valueType == 0 || this.valueType == -1) {
                        return this.name;
                    }
                    return null;
                }
                if (filter.equals("dimmer")) {
                    if (this.valueType == 1 || this.valueType == -1) {
                        return this.name;
                    }
                    return null;
                }
                if (filter.equals("blind")) {
                    if (this.valueType == 2 || this.valueType == -1) {
                        return this.name;
                    }
                    return null;
                }
            }
            return this.name;
        }
        if (list.startsWith("output.")) {
            if (filter == null || filter instanceof String || filter instanceof Wiring && ((Wiring)filter).hasOutput(this) || filter instanceof Input && this.isWiredTo((Input)filter) || filter instanceof Output && (filter == this || this instanceof OutputGroup && ((OutputGroup)this).hasOutput((Output)filter))) {
                return this.getOutputRow();
            }
            return null;
        }
        return null;
    }

    protected String getOutputRow() {
        String row = "<table class=\"listtable\">";
        row = String.valueOf(row) + "<colgroup><col class=\"id\"></colgroup>";
        row = String.valueOf(row) + "<tr><td colspan=\"2\" class=\"name\">" + this.name + "</td></tr>";
        row = String.valueOf(row) + "<tr>";
        row = String.valueOf(row) + "<td class=\"id\">" + this.id + "</td>";
        row = String.valueOf(row) + "<td class=\"type\">" + (this.typeName == null ? "IO Datapoint" : this.typeName) + "</td>";
        row = String.valueOf(row) + "</tr></table>";
        return row;
    }

    protected boolean isWiredTo(Input i2) {
        for (Wiring w : WiringEditor.wirings.values()) {
            if (!w.hasOutput(this) || !w.hasInput(i2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String select(String list, boolean repeat, boolean up, String session) throws Exception {
        if (repeat) {
            if (!WiringEditor.expertMode) {
                return "!";
            }
            WiringEditor.uiSet("output.id", "text", this.id, session);
            WiringEditor.uiSet("output.name", "text", this.name, session);
            WiringEditor.uiSet("output.valtype", "visible", "true", session);
            if (this.valueType == 0) {
                WiringEditor.uiSet("output.valtype", "value", "onoff", session);
            } else if (this.valueType == 1) {
                WiringEditor.uiSet("output.valtype", "value", "dimmer", session);
            } else if (this.valueType == 2) {
                WiringEditor.uiSet("output.valtype", "value", "blind", session);
            } else {
                WiringEditor.uiSet("output.valtype", "value", "", session);
            }
            return "!page:output.edit";
        }
        if (up) {
            String nowSelected = WiringEditor.uiGet("output.list", "value", session);
            if (nowSelected == null || !nowSelected.equals(this.id)) {
                WiringEditor.uiSet("input.list", "value", "", session);
                WiringEditor.uiSet("output.list", "value", this.id, session);
                WiringEditor.uiSet("wiring.list", "value", "", session);
                WiringEditor.inputs.update(this, session);
                WiringEditor.outputs.update(this, session);
                WiringEditor.wirings.update(this, session);
            } else {
                WiringEditor.uiClear(session);
                WiringEditor.uiSet("input.list", "value", "", session);
                WiringEditor.uiSet("output.list", "value", "", session);
                WiringEditor.uiSet("wiring.list", "value", "", session);
                WiringEditor.inputs.update(null);
                WiringEditor.outputs.update(null);
                WiringEditor.wirings.update(null);
            }
        }
        return "!";
    }

    @Override
    public int compare(Listable anotherListable) {
        if (anotherListable instanceof Output) {
            Output o2 = (Output)anotherListable;
            return this.name.toLowerCase().compareTo(o2.name.toLowerCase());
        }
        return 0;
    }

    public void setName(String name) throws Exception {
        this.name = name;
        Database.save(String.valueOf(this.id) + ".name", name);
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setValue(String value) {
        WiringEditor.ioSet(this.id, value);
    }

    public String getValue() {
        return WiringEditor.ioGet(this.id);
    }

    public void recordScenario(WiringScenario scenario) throws Exception {
        String val = this.getValue();
        if (val == null || val.equals("unknown")) {
            throw new WiringEditor.UserException(String.valueOf(UIText.THE_VALUE_OF_THE_OUTPUT_IS_UNKNOWN) + ": " + this.name);
        }
        if (val.equals("offdown")) {
            val = "down";
        } else if (val.equals("offup")) {
            val = "up";
        }
        this.scenarios.put(scenario, val);
        this.saveScenarios();
    }

    public void recallScenario(WiringScenario scenario) throws Exception {
        String val = this.scenarios.get(scenario);
        if (val == null) {
            throw new Exception("Scenario '" + scenario.name + "' not found for output '" + this.name + "'");
        }
        this.setValue(val);
    }

    public void removeScenario(WiringScenario scenario) {
        if (this.scenarios.remove(scenario) != null) {
            try {
                this.saveScenarios();
            }
            catch (Exception e2) {
                WiringEditor.log(0, "error saving scenarios on output '" + this.name + "' - " + e2.getLocalizedMessage());
            }
        }
    }

    public void switchScenario(WiringScenario from, WiringScenario to) throws Exception {
        String val = this.scenarios.remove(from);
        if (val != null) {
            this.scenarios.put(to, val);
            this.saveScenarios();
        } else {
            this.recordScenario(to);
        }
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
        Database.save(String.valueOf(this.id) + ".valuetype", valueType);
    }

    @Override
    public void onRemove() {
        Database.delete(String.valueOf(this.id) + ".name");
        Database.delete(String.valueOf(this.id) + ".valuetype");
        Database.delete(String.valueOf(this.id) + ".scenarios");
    }

    public void checkScenarios() {
        HashMap<WiringScenario, String> newScenarios = new HashMap<WiringScenario, String>(this.scenarios.size());
        for (Map.Entry<WiringScenario, String> e2 : this.scenarios.entrySet()) {
            Wiring s = WiringEditor.wirings.get(e2.getKey().id);
            if (s == null || !(s instanceof WiringScenario)) continue;
            newScenarios.put((WiringScenario)s, e2.getValue());
        }
        this.scenarios = newScenarios;
    }

    public void saveScenarios() throws Exception {
        StringBuilder scenString = new StringBuilder();
        for (Map.Entry<WiringScenario, String> s : this.scenarios.entrySet()) {
            scenString.append(",").append(s.getKey().id);
            scenString.append(",").append(s.getValue());
        }
        if (scenString.length() == 0) {
            Database.delete(String.valueOf(this.id) + ".scenarios");
        } else {
            Database.save(String.valueOf(this.id) + ".scenarios", scenString.substring(1));
        }
    }

    @Override
    public String toDBString() {
        return null;
    }

    public String getScenarioString(WiringScenario scenario) {
        return String.valueOf(this.name) + " = " + this.scenarios.get(scenario);
    }
}

