/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.UIText;
import plugins.wiringeditor.WiringEditor;

public class InputGroup
extends Input {
    private static final long serialVersionUID = -7186055322264801949L;
    static int in_groups_count;
    Vector<Input> members = null;
    boolean ready = true;

    public InputGroup(String dbString) {
        this(Database.split(dbString, ','));
    }

    private InputGroup(Vector<String> params) {
        super(params.get(0), "Group", params.get(1), Integer.parseInt(params.get(2)));
        this.members = new Vector(params.size() - 3);
        int i2 = 3;
        while (i2 < params.size()) {
            this.members.add(new Input(params.get(i2)));
            ++i2;
        }
    }

    public InputGroup(String name, String membersList) throws WiringEditor.UserException {
        super(InputGroup.generateID(), "Group", name, -1);
        this.setMembers(membersList);
    }

    private static String generateID() {
        String id = "_in_group_" + Integer.toString(in_groups_count++);
        Database.save("in_groups_count", in_groups_count);
        return id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    @Override
    public void onRemove() {
    }

    void setMembers(String membersList) throws WiringEditor.UserException {
        String[] ms = membersList.split(",");
        if (ms.length < 2) {
            throw new WiringEditor.UserException(UIText.SELECT_AT_LEAST_TWO_MEMBERS);
        }
        this.valueType = -1;
        Vector<Input> newMembers = new Vector<Input>(ms.length);
        String[] stringArray = ms;
        int n2 = ms.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            Input i2 = WiringEditor.inputs.get(string);
            if (this.valueType == -1 && i2.valueType != -1) {
                this.valueType = i2.valueType;
            } else if (i2.valueType != -1 && i2.valueType != this.valueType) {
                throw new WiringEditor.UserException(UIText.THE_SELECTED_INPUTS_HAVE_DIFFERENT_VALUE_TYPES);
            }
            newMembers.add(i2);
            ++n3;
        }
        for (Input input : newMembers) {
            if (!input.matches(this)) continue;
            throw new WiringEditor.UserException(String.valueOf(UIText.THE_MEMBER) + " '" + input.name + "' " + UIText.CREATES_A_RECURSION);
        }
        this.members = newMembers;
    }

    @Override
    public String select(String list, boolean repeat, boolean up, String session) throws Exception {
        if (repeat) {
            WiringEditor.uiSet("input.id", "text", this.id, session);
            WiringEditor.uiSet("input.name", "text", this.name, session);
            String mems = "";
            for (Input i2 : this.members) {
                mems = String.valueOf(mems) + "," + i2.id;
            }
            WiringEditor.uiSet("input.group.members.list", "value", mems.substring(1), session);
            WiringEditor.uiSet("input.group.members.list", "visible", "true", session);
            return "page:group.input.edit";
        }
        return super.select(list, repeat, up, session);
    }

    @Override
    protected String getInputRow() {
        String row = "<table class=\"listtable\">";
        row = String.valueOf(row) + "<colgroup><col class=\"id\"></colgroup>";
        row = String.valueOf(row) + "<tr><td colspan=\"2\" class=\"name\">" + (this.ready ? this.name : "<del>" + this.name + "</del>") + "</td></tr>";
        row = String.valueOf(row) + "<tr>";
        String ms = "";
        for (Input i2 : this.members) {
            ms = String.valueOf(ms) + " - " + i2.name;
        }
        row = String.valueOf(row) + "<td class=\"id\">" + ms.substring(3) + "</td>";
        row = String.valueOf(row) + "<td class=\"type\">" + this.typeName + "</td>";
        row = String.valueOf(row) + "</tr></table>";
        return row;
    }

    public void check() {
        this.ready = true;
        int x = 0;
        while (x < this.members.size()) {
            Input i2 = WiringEditor.inputs.get(this.members.get((int)x).id);
            if (i2 == null) {
                this.ready = false;
            } else {
                this.members.set(x, i2);
            }
            ++x;
        }
    }

    public boolean hasInput(Input i2) {
        for (Input m2 : this.members) {
            if (i2 != m2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Input anotherInput) {
        if (this == anotherInput) {
            return true;
        }
        for (Input m2 : this.members) {
            if (!m2.matches(anotherInput)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toDBString() {
        StringBuilder dbString = new StringBuilder();
        dbString.append(this.id.replace(",", ",,")).append(",");
        dbString.append(this.name.replace(",", ",,")).append(",");
        dbString.append(this.valueType);
        for (Input i2 : this.members) {
            dbString.append(',').append(i2.id.replace(",", ",,"));
        }
        return dbString.toString();
    }
}

