/*
 * Decompiled with CFR 0.152.
 */
package plugins.sigfoxutil;

import com.hsyco.Configuration;
import com.hsyco.userBase;
import drivers.sigfox.Device;
import drivers.sigfox.Driver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import plugins.sigfoxutil.WarningException;

public class SigfoxUtility
extends userBase {
    private static final String VERSION = "1.0.1";
    static final String PREFIX = "__sgfx__.";
    static final String PROJECTNAME = "sigfoxutility";
    private static boolean initialized;
    private static String listValues;
    private static String listLabels;
    private static String listFilter;
    private static String ioServerPrefix;
    private static Driver DRIVER;

    static {
        listFilter = "";
    }

    public static void StartupEvent() {
        try {
            initialized = false;
            String vals = "";
            for (String io : Configuration.ioServers) {
                if (!"sigfox".equalsIgnoreCase(Configuration.ioServersGetTypeByName(io))) continue;
                vals = String.valueOf(vals) + "," + io;
            }
            String newVals = vals.length() == 0 ? "" : vals.substring(1);
            SigfoxUtility.uiSet("__sgfx__.driver.select", "values", newVals);
            SigfoxUtility.uiSet("__sgfx__.driver.select", "labels", newVals);
            if (newVals.isEmpty()) {
                SigfoxUtility.uiSet(PROJECTNAME, "lock", "noioserver");
                return;
            }
            ioServerPrefix = String.valueOf(newVals.split(",")[0]) + ".";
            String newPrefix = ioServerPrefix.substring(0, ioServerPrefix.length() - 1);
            SigfoxUtility.uiSet("__sgfx__.driver.select", "value", newPrefix);
            SigfoxUtility.uiSet("__sgfx__.search", "value", "");
            SigfoxUtility.uiSet("__sgfx__.search", "helptext", "search");
            SigfoxUtility.uiSet("__sgfx__.device.edit.delete", "confirm", "true");
            SigfoxUtility.uiSet(PROJECTNAME, "lock", "loading");
            SigfoxUtility.messageLog("sigfoxutility - application started");
            SigfoxUtility.uiSet("version", "value", VERSION);
            initialized = true;
            SigfoxUtility.messageLog("sigfoxutility - initialization complete");
        }
        catch (Exception e2) {
            SigfoxUtility.errorLog("sigfoxutility - initialization error - " + e2.getMessage());
        }
    }

    public static void pageEvent(String address, String session, String userid, String project, String page) {
        if (project.equals(PROJECTNAME) && page.equals("menu")) {
            SigfoxUtility.uiSet("__sgfx__.search", "helptext", "search");
            if (DRIVER != null) {
                SigfoxUtility.guiUpdateDeviceList(false);
            }
        }
    }

    public static void IOEvent(String id, String value) {
        if (ioServerPrefix == null || !id.startsWith(ioServerPrefix)) {
            return;
        }
        if ("connection".equals(id = id.substring(ioServerPrefix.length()))) {
            boolean online = "online".equals(value);
            SigfoxUtility.uiSet(PROJECTNAME, "lock", online ? "" : "loading");
            if (online) {
                DRIVER = Driver.driversList.get(ioServerPrefix);
                SigfoxUtility.uiSet("__sgfx__.devices.discovery", "value", "" + SigfoxUtility.DRIVER.acceptunknown);
                SigfoxUtility.uiSet(PROJECTNAME, "page", "menu");
                SigfoxUtility.guiUpdateDeviceList(true);
            }
        } else if (id.endsWith(".lastseen")) {
            SigfoxUtility.guiUpdateDeviceList(true);
        }
    }

    public static void guiUpdateDeviceList(boolean filter) {
        if (DRIVER == null) {
            return;
        }
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        Collection<Device> devs = SigfoxUtility.DRIVER.devices.values();
        for (Device dev : devs) {
            String id = dev.getId().replace(",", "&#44;").replace("|", "&#10072");
            String name = dev.getName() == null ? "" : dev.getName().replace(",", "&#44;").replace("|", "&#10072");
            String model = dev.getModel() == null ? "" : dev.getModel();
            String lastseen = userBase.ioGet(String.valueOf(ioServerPrefix) + "device." + id.toLowerCase() + ".lastseen");
            if (lastseen != null) {
                Timestamp ts = new Timestamp(Long.parseLong(lastseen));
                Date date = new Date(ts.getTime());
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                lastseen = simpleDateFormat.format(date);
            } else {
                lastseen = "";
            }
            values.append(",").append(id);
            labels.append(",").append(String.valueOf(id) + "|" + name + "|" + model + "|" + lastseen);
        }
        listLabels = labels.length() == 0 ? "" : labels.substring(1);
        String string = listValues = values.length() == 0 ? "" : values.substring(1);
        if (!filter || listFilter.isEmpty()) {
            SigfoxUtility.uiSet("__sgfx__.devicelist", "labels", listLabels);
            SigfoxUtility.uiSet("__sgfx__.devicelist", "values", listValues);
        } else {
            SigfoxUtility.doFilter(listFilter);
        }
    }

    public static String userCommand(String session, String userId, String cmd, String param) {
        return SigfoxUtility.userCommandOrSubmit(session, userId, cmd, param, null);
    }

    public static String userSubmit(String session, String userId, String cmd, HashMap<String, String> fields) {
        return SigfoxUtility.userCommandOrSubmit(session, userId, cmd, null, fields);
    }

    public static String userCommandOrSubmit(String session, String userId, String cmd, String param, HashMap<String, String> fields) {
        block32: {
            block33: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    String oldId;
                                    String id;
                                    block27: {
                                        block25: {
                                            block24: {
                                                String lf;
                                                block23: {
                                                    block22: {
                                                        block21: {
                                                            if (cmd.startsWith(PREFIX)) break block21;
                                                            return null;
                                                        }
                                                        if (initialized) break block22;
                                                        return null;
                                                    }
                                                    if (param == null || !param.endsWith("/close")) break block23;
                                                    return "!";
                                                }
                                                if (!cmd.equals("__sgfx__.search")) break block24;
                                                listFilter = lf = param.trim();
                                                if (!lf.isEmpty()) {
                                                    SigfoxUtility.doFilter(lf);
                                                } else {
                                                    SigfoxUtility.uiSet("__sgfx__.devicelist", "values", listValues.toString());
                                                    SigfoxUtility.uiSet("__sgfx__.devicelist", "labels", listLabels.toString());
                                                }
                                                return "";
                                            }
                                            if (!cmd.equals("__sgfx__.devicelist")) break block25;
                                            String id2 = param.replace("&#44;", ",");
                                            Device dev = SigfoxUtility.DRIVER.devices.get(id2);
                                            id2 = dev.getId();
                                            SigfoxUtility.uiSet("__sgfx__.device.edit.id", "internal", id2);
                                            String name = dev.getName() == null ? "" : dev.getName();
                                            String model = dev.getModel() == null ? "" : dev.getModel();
                                            SigfoxUtility.uiSet("__sgfx__.device.edit.id", "value", id2);
                                            SigfoxUtility.uiSet("__sgfx__.device.edit.name", "value", name);
                                            SigfoxUtility.uiSet("__sgfx__.device.edit.model", "value", model);
                                            SigfoxUtility.uiSet("__sgfx__.edit.error", "text", "");
                                            return "!page:edit";
                                        }
                                        if (!cmd.equals("__sgfx__.device.edit.save")) break block26;
                                        id = fields.get("__sgfx__.device.edit.id");
                                        oldId = SigfoxUtility.uiGet("__sgfx__.device.edit.id", "internal");
                                        if (!id.isEmpty()) break block27;
                                        SigfoxUtility.uiSet("__sgfx__.device.edit.id", "error", "true");
                                        return "!error";
                                    }
                                    id = id.replace("&#44;", ",");
                                    for (Device dev : SigfoxUtility.DRIVER.devices.values()) {
                                        if (oldId.equalsIgnoreCase(id) || !id.equalsIgnoreCase(dev.getId())) continue;
                                        throw new WarningException("ID already used", "close");
                                    }
                                    String name = fields.get("__sgfx__.device.edit.name");
                                    Object model = fields.get("__sgfx__.device.edit.model");
                                    name = name.isEmpty() ? null : name.replace("&#44;", ",");
                                    if (((String)model).isEmpty()) {
                                        model = null;
                                    }
                                    DRIVER.updateDeviceNameAndModel(oldId, id, name, (String)model);
                                    SigfoxUtility.guiUpdateDeviceList(true);
                                    SigfoxUtility.writeConfigurationFile();
                                    return "!page:close";
                                }
                                if (!cmd.equals("__sgfx__.commit.yes")) break block28;
                                SigfoxUtility.writeConfigurationFile();
                                return "!page:close";
                            }
                            if (cmd.equals("__sgfx__.warning.close")) {
                                return "!page:" + param;
                            }
                            if (!cmd.equals("__sgfx__.device.new")) break block29;
                            SigfoxUtility.uiSet("__sgfx__.device.edit.id", "internal", "");
                            SigfoxUtility.uiSet("__sgfx__.device.edit.id", "value", "");
                            SigfoxUtility.uiSet("__sgfx__.device.edit.name", "value", "");
                            SigfoxUtility.uiSet("__sgfx__.device.edit.model", "value", "");
                            return "!page:edit";
                        }
                        if (!cmd.equals("__sgfx__.device.edit.delete")) break block30;
                        String id = SigfoxUtility.uiGet("__sgfx__.device.edit.id", "value");
                        SigfoxUtility.DRIVER.devices.remove(id);
                        SigfoxUtility.guiUpdateDeviceList(true);
                        return "!page:close";
                    }
                    if (!cmd.equals("__sgfx__.devices.discovery")) break block31;
                    SigfoxUtility.DRIVER.acceptunknown = Boolean.parseBoolean(param);
                    if (param.equals("true") && SigfoxUtility.DRIVER.username != null && SigfoxUtility.DRIVER.password != null) {
                        DRIVER.updateAllStatuses();
                        SigfoxUtility.guiUpdateDeviceList(true);
                    }
                    return "!";
                }
                if (!cmd.equals("__sgfx__.driver.select")) break block32;
                if (!param.isEmpty()) break block33;
                return "!";
            }
            try {
                ioServerPrefix = String.valueOf(param) + ".";
                DRIVER = Driver.driversList.get(ioServerPrefix);
                SigfoxUtility.uiSet("__sgfx__.driver.select", "value", param);
                SigfoxUtility.uiSet("__sgfx__.devices.discovery", "value", "" + SigfoxUtility.DRIVER.acceptunknown);
                SigfoxUtility.guiUpdateDeviceList(true);
                String conn = userBase.ioGet(String.valueOf(ioServerPrefix) + "connection");
                boolean online = conn != null && !conn.equals("offline");
                SigfoxUtility.uiSet(PROJECTNAME, "lock", online ? "" : "loading");
                return "!";
            }
            catch (WarningException e2) {
                return "!page:warning";
            }
            catch (Exception e3) {
                SigfoxUtility.errorLog("error processing command: " + cmd + " - " + e3.getLocalizedMessage());
                return "!error";
            }
        }
        return null;
    }

    public static void writeConfigurationFile() throws Exception {
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("sigfox-devices_" + ioServerPrefix + "ini.tmp"), Charset.forName("UTF-8")));
                Collection<Device> devs = Driver.driversList.get((Object)SigfoxUtility.ioServerPrefix).devices.values();
                for (Device dev : devs) {
                    String id = dev.getId().replace("\\", "\\\\").replace(":", "\\:").replace("=", "\\=").replace(",", "\\,");
                    String model = dev.getModel() == null ? "" : dev.getModel();
                    model = model.replace("\\", "\\\\").replace(":", "\\:").replace("=", "\\=").replace(",", "\\,");
                    String name = dev.getName() == null ? "" : dev.getName();
                    name = name.replace("\\", "\\\\").replace(":", "\\:").replace("=", "\\=").replace(",", "\\,");
                    StringBuffer toWrite = new StringBuffer();
                    toWrite.append(String.valueOf(id) + (model.isEmpty() && name.isEmpty() ? "" : ":"));
                    if (!name.isEmpty()) {
                        toWrite.append("name=" + name);
                        if (!model.isEmpty()) {
                            toWrite.append(",");
                        }
                    }
                    if (!model.isEmpty()) {
                        toWrite.append("model=" + model);
                    }
                    bw.write(toWrite.toString());
                    bw.newLine();
                }
                File f2 = new File("sigfox-devices_" + ioServerPrefix + "ini.tmp");
                if (!f2.renameTo(new File("sigfox-devices_" + ioServerPrefix + "ini"))) {
                    throw new Exception("cannot rename sigfox-devices_" + ioServerPrefix + "ini.tmp");
                }
                f2.setWritable(true, false);
                SigfoxUtility.ioServersRestart(ioServerPrefix.substring(0, ioServerPrefix.length() - 1));
            }
            catch (Exception e2) {
                throw new Exception("exception while writing to sigfox-devices_" + ioServerPrefix + ".ini - " + e2.getLocalizedMessage());
            }
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void doFilter(String listFilter) {
        String[] labs;
        String[] vals = listValues.split(",");
        if (vals.length != (labs = listLabels.split(",")).length) {
            return;
        }
        StringBuilder valsF = new StringBuilder();
        StringBuilder labsF = new StringBuilder();
        int i2 = 0;
        while (i2 < labs.length) {
            String ll = labs[i2].toLowerCase();
            if (ll.contains(listFilter.toLowerCase())) {
                valsF.append(",").append(vals[i2]);
                labsF.append(",").append(labs[i2]);
            }
            ++i2;
        }
        SigfoxUtility.uiSet("__sgfx__.devicelist", "values", valsF.length() > 0 ? valsF.substring(1) : "");
        SigfoxUtility.uiSet("__sgfx__.devicelist", "labels", labsF.length() > 0 ? labsF.substring(1) : "");
    }
}

