/*
 * Decompiled with CFR 0.152.
 */
package plugins.modbusutil;

import com.hsyco.Configuration;
import com.hsyco.Modbus;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import plugins.modbusutil.ModbusUtilRequest;

public class ModbusUtil
extends userBase {
    private static final String SCHEDULER_PREFIX = "__HSYCO_MODBUS_UTIL__";
    private static final int SCHEDULER_PREFIX_LENGTH = "__HSYCO_MODBUS_UTIL__".length();
    private static final int SCHEDULER_FILE_CHECK_INTERVAL_MILLIS = 5000;
    private static final int SCHEDULER_DISPLAY_REFRESH_INTERVAL_MILLIS = 5000;
    private static final int SCHEDULER_DISPLAY_REFRESH_INACTIVITY_TIMEOUT_MILLIS = 60000;
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("0.0##");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Hashtable<String, ModbusUtilRequest> scheduleCache = new Hashtable();
    private static List<ModbusUtilRequest> scheduleFileLines = new Vector<ModbusUtilRequest>();
    private static File scheduleFile = new File("modbus-scheduler.ini");
    private static long scheduleFileLastModified = 0L;
    private static boolean enabled = false;
    private static boolean active = false;
    private static long uiActivityLastTimeMillis = 0L;
    private static Boolean displayRequestsSemaphore = false;
    private static String nameDisplayFilter = "";
    private static int statusDisplayFilter = -1;
    static final Comparator<ModbusUtilRequest> REQUESTS_COMPARE = new Comparator<ModbusUtilRequest>(){

        @Override
        public int compare(ModbusUtilRequest r1, ModbusUtilRequest r2) {
            try {
                String[] a1 = r1.datapointName.split("[.]");
                String[] a2 = r2.datapointName.split("[.]");
                if (a1[0].equals(a2[0])) {
                    int i2;
                    int i1 = Integer.parseInt(a1[1]);
                    if (i1 == (i2 = Integer.parseInt(a2[1]))) {
                        i1 = Integer.parseInt(a1[2]);
                        i2 = Integer.parseInt(a2[2]);
                    }
                    return i1 - i2;
                }
                return a1[0].compareTo(a2[0]);
            }
            catch (Exception e2) {
                return 0;
            }
        }
    };

    public static void StartupEvent() throws Exception {
        int i2 = 0;
        while (i2 < Configuration.ioServersType.size()) {
            if (Configuration.ioServersType.get(i2) == 3) {
                enabled = true;
            }
            ++i2;
        }
        if (enabled) {
            ModbusUtil.schedulerRegister(SCHEDULER_PREFIX, "_FC_", 5000);
            ModbusUtil.schedulerRegister(SCHEDULER_PREFIX, "_DISPLAY_", 5000);
            ModbusUtil.uiSet("__hsyco__modbusutil.scope", "__hsyco__modbusutil.filter.status", "value", Integer.toString(statusDisplayFilter));
            ModbusUtil.uiSet("__hsyco__modbusutil.scope", "__hsyco__modbusutil.filter.name", "value", nameDisplayFilter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void SchedulerEvent(String groupname, String schedulename) {
        boolean err;
        boolean tolerateErrors;
        if (!enabled) return;
        if (!groupname.startsWith(SCHEDULER_PREFIX)) return;
        if (schedulename.equals("_FC_")) {
            ModbusUtil.scheduleFileCheckLoad();
            return;
        }
        if (schedulename.equals("_DISPLAY_")) {
            if (!active) return;
            if (System.currentTimeMillis() >= uiActivityLastTimeMillis + 60000L) return;
            ModbusUtil.displayRequests();
            return;
        }
        if (!active) return;
        String[] a2 = schedulename.split("=");
        String serverId = groupname.substring(SCHEDULER_PREFIX_LENGTH);
        String name = a2[0];
        String value = a2[1];
        Hashtable<String, ModbusUtilRequest> hashtable = scheduleCache;
        // MONITORENTER : hashtable
        // MONITOREXIT : hashtable
        ModbusUtilRequest request = scheduleCache.get(String.valueOf(serverId) + "." + name + "=" + value);
        if (request == null) return;
        if (request.variableName != null && !"1".equals(ModbusUtil.varGet(request.variableName))) {
            if (request.variableName == null) return;
            request.skip = true;
            return;
        }
        long now = System.currentTimeMillis();
        boolean bl = tolerateErrors = (long)request.errorsTolerance > request.consecutiveErrorsCounter;
        if (request.error) {
            if (now - request.lastRunTimeMillis <= request.skipIntervalMillisOnError) return;
        }
        if (err = Modbus.set(serverId, name, value, !tolerateErrors)) {
            if (tolerateErrors) {
                request.error = false;
                request.skip = false;
                ++request.consecutiveErrorsCounter;
            } else {
                request.error = true;
                request.skip = request.skipIntervalMillisOnError > 0L;
            }
        } else {
            request.error = false;
            request.skip = false;
            request.consecutiveErrorsCounter = 0L;
        }
        long resptime = System.currentTimeMillis() - now;
        if (request.lastRunTimeMillis > 0L) {
            request.lastMeasuredIntervalMillis = now - request.lastRunTimeMillis;
        }
        request.lastRunTimeMillis = now;
        if (request.minResponseTimeMillis == -1L || request.minResponseTimeMillis > resptime) {
            request.minResponseTimeMillis = resptime;
        }
        if (request.maxResponseTimeMillis != -1L) {
            if (request.maxResponseTimeMillis >= resptime) return;
        }
        request.maxResponseTimeMillis = resptime;
    }

    public static void pageEvent(String address, String session, String userid, String project, String page) {
        if (enabled && project.equals("modbusutil") && page.equals("menu")) {
            uiActivityLastTimeMillis = System.currentTimeMillis();
            ModbusUtil.displayRequests();
        }
    }

    public static String userCommand(String session, String userid, String name, String param) {
        if (enabled) {
            if (name.equals("__hsyco__modbusutil")) {
                uiActivityLastTimeMillis = System.currentTimeMillis();
                if (param.equals("refresh")) {
                    ModbusUtil.resetCounters();
                    return "!";
                }
                if (param.equals("add")) {
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.rowid", "value", "-1");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.name", "value", "");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.function", "value", "");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.format", "value", "");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.format", "enabled", "true");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.number", "value", "");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.description", "value", "");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.interval", "value", "0.0");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.variable", "value", "");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.tolerance", "value", "");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.skipinterval", "value", "");
                    ModbusUtil.uiSet(session, "__hsyco__modbusutil.error", "text", "");
                    ModbusUtil.uiSet(session, "modbusutil", "page", "request_edit");
                    return "!";
                }
            } else {
                if (name.equals("__hsyco__modbusutil.list")) {
                    uiActivityLastTimeMillis = System.currentTimeMillis();
                    try {
                        int i2 = Integer.parseInt(param);
                        ModbusUtilRequest request = scheduleFileLines.get(i2);
                        String[] dpva = request.datapointValue.split("[:]");
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.rowid", "value", Integer.toString(i2));
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.name", "value", request.datapointName);
                        if (dpva[0].equals("readcoils") || dpva[0].equals("readdiscreteinputs")) {
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.function", "value", dpva[0]);
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.format", "value", "");
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.format", "enabled", "false");
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.number", "value", dpva.length == 2 ? dpva[1] : "");
                        } else if (dpva[0].equals("readholdingregisters") || dpva[0].equals("readinputregisters")) {
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.function", "value", dpva[0]);
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.format", "value", dpva[1]);
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.format", "enabled", "true");
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.number", "value", dpva.length == 3 ? dpva[2] : "");
                        } else {
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.function", "value", "");
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.format", "value", "");
                            ModbusUtil.uiSet(session, "__hsyco__modbusutil.value.number", "value", "");
                        }
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.description", "value", request.description == null ? "" : request.description);
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.interval", "value", TIME_FORMAT.format((double)request.intervalMillis / 1000.0));
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.variable", "value", request.variableName == null ? "" : request.variableName);
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.tolerance", "value", request.errorsTolerance == 0 ? "" : Integer.toString(request.errorsTolerance));
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.skipinterval", "value", request.skipIntervalMillisOnError == 0L ? "" : TIME_FORMAT.format((double)request.skipIntervalMillisOnError / 1000.0));
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.error", "text", "");
                        ModbusUtil.uiSet(session, "modbusutil", "page", "request_edit");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return "!";
                }
                if (name.equals("__hsyco__modbusutil.filter.name")) {
                    uiActivityLastTimeMillis = System.currentTimeMillis();
                    nameDisplayFilter = param.trim().toLowerCase();
                    ModbusUtil.uiSet("__hsyco__modbusutil.scope", "__hsyco__modbusutil.filter.name", "value", nameDisplayFilter);
                    ModbusUtil.displayRequests();
                    return "!";
                }
                if (name.equals("__hsyco__modbusutil.filter.status")) {
                    uiActivityLastTimeMillis = System.currentTimeMillis();
                    statusDisplayFilter = Integer.parseInt(param);
                    ModbusUtil.uiSet("__hsyco__modbusutil.scope", "__hsyco__modbusutil.filter.status", "value", param);
                    ModbusUtil.displayRequests();
                    return "!";
                }
            }
        }
        return null;
    }

    public static String userSubmit(String session, String uid, String name, HashMap<String, String> fields) {
        block21: {
            if (enabled) {
                block20: {
                    block19: {
                        if (!name.equals("__hsyco__modbusutil.cancel")) break block19;
                        uiActivityLastTimeMillis = System.currentTimeMillis();
                        ModbusUtil.uiSet(session, "modbusutil", "page", "menu");
                        return "!";
                    }
                    if (!name.equals("__hsyco__modbusutil.del")) break block20;
                    uiActivityLastTimeMillis = System.currentTimeMillis();
                    ModbusUtil.uiSet(session, "modbusutil", "page", "menu");
                    ModbusUtil.scheduleFileDeleteLine(Integer.parseInt(fields.get("__hsyco__modbusutil.rowid")));
                    return "!";
                }
                try {
                    String err;
                    if (!name.equals("__hsyco__modbusutil.save")) break block21;
                    uiActivityLastTimeMillis = System.currentTimeMillis();
                    String value = "";
                    String function = fields.get("__hsyco__modbusutil.value.function").trim().toLowerCase();
                    String format = fields.get("__hsyco__modbusutil.value.format").trim().toLowerCase();
                    String number = fields.get("__hsyco__modbusutil.value.number").trim().toLowerCase();
                    if (function.equals("readcoils") || function.equals("readdiscreteinputs")) {
                        if (number.length() > 0) {
                            try {
                                int n2 = Integer.parseInt(number);
                                if (n2 > 0) {
                                    value = String.valueOf(function) + ":" + number;
                                }
                            }
                            catch (Exception n2) {}
                        }
                    } else if (function.equals("readholdingregisters") || function.equals("readinputregisters")) {
                        if (number.length() > 0) {
                            try {
                                int n3 = Integer.parseInt(number);
                                if (n3 > 0) {
                                    value = String.valueOf(function) + ":" + format + ":" + number;
                                }
                            }
                            catch (Exception n3) {}
                        } else {
                            value = String.valueOf(function) + ":" + format;
                        }
                    }
                    if ((err = ModbusUtil.scheduleFileEditLine(Integer.parseInt(fields.get("__hsyco__modbusutil.rowid")), fields.get("__hsyco__modbusutil.name").trim().toLowerCase(), value, fields.get("__hsyco__modbusutil.description").trim(), fields.get("__hsyco__modbusutil.interval").trim(), fields.get("__hsyco__modbusutil.variable").trim(), fields.get("__hsyco__modbusutil.tolerance").trim(), fields.get("__hsyco__modbusutil.skipinterval").trim())) == null) {
                        ModbusUtil.uiSet(session, "modbusutil", "page", "menu");
                    } else {
                        ModbusUtil.uiSet(session, "__hsyco__modbusutil.error", "text", err);
                    }
                    return "!";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleFileDeleteLine(int index) {
        try {
            Hashtable<String, ModbusUtilRequest> hashtable = scheduleCache;
            synchronized (hashtable) {
                scheduleFileLines.remove(index);
                ModbusUtil.scheduleFileSave();
                ModbusUtil.scheduleFileCheckLoad();
                ModbusUtil.displayRequests();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static String scheduleFileEditLine(int index, String name, String value, String description, String interval, String variable, String tolerance, String skipinterval) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleFileCheckLoad() {
        try {
            Hashtable<String, ModbusUtilRequest> hashtable = scheduleCache;
            synchronized (hashtable) {
                long t = scheduleFile.lastModified();
                if (t == scheduleFileLastModified) {
                    return;
                }
                if (t == 0L) {
                    ModbusUtil.clearAllRequests();
                    hsyco.messageLog("Modbus Utility: " + scheduleFile.getName() + " file not found");
                } else {
                    ModbusUtil.reloadAllRequests();
                    hsyco.messageLog("Modbus Utility: " + scheduleFile.getName() + " file reloaded");
                }
                scheduleFileLastModified = t;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        active = !scheduleCache.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleFileSave() {
        try {
            Hashtable<String, ModbusUtilRequest> hashtable = scheduleCache;
            synchronized (hashtable) {
                BufferedWriter out = new BufferedWriter(new FileWriter(scheduleFile));
                int i2 = 0;
                while (i2 < scheduleFileLines.size()) {
                    ModbusUtilRequest r = scheduleFileLines.get(i2);
                    out.write(r.datapointName);
                    out.write("=");
                    out.write(r.datapointValue);
                    out.write(" ");
                    out.write(TIME_FORMAT.format((double)r.intervalMillis / 1000.0));
                    out.write(" ");
                    out.write(Integer.toString(r.errorsTolerance));
                    out.write(" ");
                    out.write(TIME_FORMAT.format((double)r.skipIntervalMillisOnError / 1000.0));
                    if (r.variableName != null) {
                        out.write(" ");
                        out.write(r.variableName);
                    }
                    if (r.description != null) {
                        out.write(" #");
                        out.write(r.description);
                    }
                    out.write(LINE_SEPARATOR);
                    ++i2;
                }
                out.close();
                ModbusUtil.scheduleFileCheckLoad();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearAllRequests() throws Exception {
        Hashtable<String, ModbusUtilRequest> hashtable = scheduleCache;
        synchronized (hashtable) {
            Enumeration<String> e2 = scheduleCache.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                ModbusUtilRequest r = scheduleCache.get(k2);
                String[] a2 = r.datapointName.split("[.]", 2);
                ModbusUtil.schedulerRemove(SCHEDULER_PREFIX + a2[0].trim(), String.valueOf(a2[1].trim()) + "=" + r.datapointValue);
            }
            scheduleCache.clear();
            scheduleFileLines.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadAllRequests() throws Exception {
        int lineCounter = 0;
        Hashtable<String, ModbusUtilRequest> hashtable = scheduleCache;
        synchronized (hashtable) {
            String line;
            ModbusUtil.clearAllRequests();
            BufferedReader in = new BufferedReader(new FileReader(scheduleFile));
            while ((line = in.readLine()) != null) {
                ++lineCounter;
                try {
                    String tline = line.trim();
                    if (tline.length() <= 0 || tline.startsWith("#")) continue;
                    String datapointName = null;
                    String datapointValue = null;
                    String variableName = null;
                    long intervalMillis = 0L;
                    String description = null;
                    int errorsTolerance = 0;
                    long skipIntervalMillisOnError = 0L;
                    int i2 = tline.indexOf(35);
                    if (i2 != -1) {
                        description = tline.substring(i2 + 1).trim();
                        tline = tline.substring(0, i2).trim();
                    } else {
                        description = "";
                    }
                    StringBuffer accumulator = new StringBuffer();
                    int state = 0;
                    int j2 = 0;
                    while (j2 <= tline.length()) {
                        char c2 = j2 < tline.length() ? tline.charAt(j2) : (char)'\u0000';
                        switch (state) {
                            case 0: {
                                if (c2 == '\u0000' || c2 == ' ' || c2 == '\t') {
                                    datapointName = accumulator.toString();
                                    accumulator = new StringBuffer();
                                    state = 1;
                                    break;
                                }
                                if (c2 == '=') {
                                    datapointName = accumulator.toString();
                                    accumulator = new StringBuffer();
                                    state = 2;
                                    break;
                                }
                                accumulator.append(c2);
                                break;
                            }
                            case 1: {
                                if (c2 == '=') {
                                    state = 2;
                                    break;
                                }
                                if (c2 == ' ' || c2 == '\t') break;
                                state = 99;
                                break;
                            }
                            case 2: {
                                if (c2 == '\u0000') {
                                    state = 99;
                                    break;
                                }
                                if (c2 == ' ' || c2 == '\t') break;
                                accumulator.append(c2);
                                state = 3;
                                break;
                            }
                            case 3: {
                                if (c2 == '\u0000' || c2 == ' ' || c2 == '\t') {
                                    datapointValue = accumulator.toString();
                                    accumulator = new StringBuffer();
                                    state = 4;
                                    break;
                                }
                                accumulator.append(c2);
                                break;
                            }
                            case 4: {
                                if (c2 == '\u0000') {
                                    state = 99;
                                    break;
                                }
                                if (c2 == ' ' || c2 == '\t') break;
                                accumulator.append(c2);
                                state = 5;
                                break;
                            }
                            case 5: {
                                if (c2 == '\u0000' || c2 == ' ' || c2 == '\t') {
                                    intervalMillis = Math.round(1000.0 * Double.parseDouble(accumulator.toString()));
                                    accumulator = new StringBuffer();
                                    state = c2 == '\u0000' ? -1 : 6;
                                    break;
                                }
                                accumulator.append(c2);
                                break;
                            }
                            case 6: {
                                if (c2 == '\u0000') {
                                    state = -1;
                                    break;
                                }
                                if (c2 == ' ' || c2 == '\t') break;
                                accumulator.append(c2);
                                state = 7;
                                break;
                            }
                            case 7: {
                                if (c2 == '\u0000' || c2 == ' ' || c2 == '\t' || c2 == '#') {
                                    try {
                                        errorsTolerance = Integer.parseInt(accumulator.toString());
                                        state = c2 == '\u0000' ? -1 : 8;
                                    }
                                    catch (Exception e2) {
                                        variableName = accumulator.toString();
                                        state = -1;
                                    }
                                    accumulator = new StringBuffer();
                                    break;
                                }
                                accumulator.append(c2);
                                break;
                            }
                            case 8: {
                                if (c2 == '\u0000') {
                                    state = -1;
                                    break;
                                }
                                if (c2 == ' ' || c2 == '\t') break;
                                accumulator.append(c2);
                                state = 9;
                                break;
                            }
                            case 9: {
                                if (c2 == '\u0000' || c2 == ' ' || c2 == '\t' || c2 == '#') {
                                    try {
                                        skipIntervalMillisOnError = Math.round(1000.0 * Double.parseDouble(accumulator.toString()));
                                        state = c2 == '\u0000' ? -1 : 10;
                                    }
                                    catch (Exception e3) {
                                        variableName = accumulator.toString();
                                        state = -1;
                                    }
                                    accumulator = new StringBuffer();
                                    break;
                                }
                                accumulator.append(c2);
                                break;
                            }
                            case 10: {
                                if (c2 == '\u0000') {
                                    state = -1;
                                    break;
                                }
                                if (c2 == ' ' || c2 == '\t') break;
                                accumulator.append(c2);
                                state = 11;
                                break;
                            }
                            case 11: {
                                if (c2 == '\u0000' || c2 == ' ' || c2 == '\t' || c2 == '#') {
                                    variableName = accumulator.toString();
                                    state = -1;
                                    accumulator = new StringBuffer();
                                    break;
                                }
                                accumulator.append(c2);
                            }
                        }
                        ++j2;
                    }
                    if (state == -1) {
                        if (intervalMillis <= 0L) {
                            hsyco.errorLog("Modbus Utility: " + scheduleFile.getName() + " line " + lineCounter + ": negative interval value. Ignored");
                            continue;
                        }
                        if (errorsTolerance < 0) {
                            hsyco.errorLog("Modbus Utility: " + scheduleFile.getName() + " line " + lineCounter + ": negative errors tolerance value. Ignored");
                            continue;
                        }
                        if (skipIntervalMillisOnError < 0L) {
                            hsyco.errorLog("Modbus Utility: " + scheduleFile.getName() + " line " + lineCounter + ": negative skip interval on errors value. Ignored");
                            continue;
                        }
                        String cacheKey = String.valueOf(datapointName) + "=" + datapointValue;
                        if (scheduleCache.containsKey(cacheKey)) {
                            hsyco.errorLog("Modbus Utility: " + scheduleFile.getName() + " line " + lineCounter + ": duplicate data. Ignored");
                            continue;
                        }
                        String[] c3 = datapointName.split("[.]", 2);
                        ModbusUtilRequest r = new ModbusUtilRequest(datapointName, datapointValue, intervalMillis, variableName, errorsTolerance, skipIntervalMillisOnError, description, lineCounter);
                        ModbusUtil.schedulerRegister(SCHEDULER_PREFIX + c3[0].trim(), String.valueOf(c3[1].trim()) + "=" + datapointValue, (int)intervalMillis);
                        scheduleCache.put(cacheKey, r);
                        scheduleFileLines.add(r);
                        continue;
                    }
                    hsyco.errorLog("Modbus Utility: " + scheduleFile.getName() + " line " + lineCounter + ": format error. Ignored");
                }
                catch (Exception e4) {
                    hsyco.errorLog("Modbus Utility: " + scheduleFile.getName() + " line " + lineCounter + ": format error. Ignored");
                }
            }
            Collections.sort(scheduleFileLines, REQUESTS_COMPARE);
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void displayRequests() {
        StringBuffer labels = new StringBuffer();
        StringBuffer parameters = new StringBuffer();
        Boolean bl = displayRequestsSemaphore;
        synchronized (bl) {
            if (displayRequestsSemaphore.booleanValue()) {
                return;
            }
            displayRequestsSemaphore = true;
        }
        try {
            labels.append(" class=\"header\"|");
            labels.append("#|");
            labels.append("Name|");
            labels.append("Value|");
            labels.append("|");
            labels.append("<center>Status</center>|");
            labels.append("Description|");
            labels.append("Variable|");
            labels.append("Interval|");
            labels.append("Delta|");
            labels.append("Min. Time|");
            labels.append("Max. Time|");
            labels.append("Error Tolerance|");
            labels.append("Error Skip Interval");
            parameters.append('-');
            int i2 = 0;
            while (i2 < scheduleFileLines.size()) {
                ModbusUtilRequest request = scheduleFileLines.get(i2);
                int status = request.skip ? 1 : (request.error ? 3 : ((double)(request.lastMeasuredIntervalMillis - request.intervalMillis) > (double)request.intervalMillis / 2.5 ? 2 : 0));
                if (!(statusDisplayFilter != -1 && statusDisplayFilter != status || nameDisplayFilter.length() != 0 && !request.datapointName.contains(nameDisplayFilter))) {
                    parameters.append(',');
                    labels.append(',');
                    parameters.append(i2);
                    labels.append("|");
                    labels.append(i2 + 1);
                    labels.append("|");
                    labels.append(request.datapointName.replace("|", "&#124;"));
                    labels.append("|");
                    labels.append(request.datapointValue.replace("|", "&#124;"));
                    labels.append("|");
                    switch (status) {
                        case 1: {
                            labels.append(" class=\"skip\"|skip");
                            break;
                        }
                        case 2: {
                            labels.append(" class=\"slow\"|slow");
                            break;
                        }
                        case 3: {
                            labels.append(" class=\"error\"|error");
                            break;
                        }
                        default: {
                            labels.append("|");
                        }
                    }
                    labels.append("|");
                    labels.append(request.description == null ? "" : request.description.replace("|", "&#124;").replace(",", "&#44;"));
                    labels.append("|");
                    labels.append(request.variableName == null ? "" : request.variableName.replace("|", "&#124;").replace(",", "&#44;"));
                    labels.append("|");
                    labels.append(TIME_FORMAT.format((double)request.intervalMillis / 1000.0));
                    labels.append("|");
                    labels.append(request.lastMeasuredIntervalMillis == -1L ? "" : TIME_FORMAT.format((double)(request.lastMeasuredIntervalMillis - request.intervalMillis) / 1000.0));
                    labels.append("|");
                    labels.append(request.minResponseTimeMillis == -1L ? "" : TIME_FORMAT.format((double)request.minResponseTimeMillis / 1000.0));
                    labels.append("|");
                    labels.append(request.maxResponseTimeMillis == -1L ? "" : TIME_FORMAT.format((double)request.maxResponseTimeMillis / 1000.0));
                    labels.append("|");
                    labels.append(request.errorsTolerance == 0 ? "" : Integer.toString(request.errorsTolerance));
                    labels.append("|");
                    labels.append(request.skipIntervalMillisOnError == 0L ? "" : TIME_FORMAT.format((double)request.skipIntervalMillisOnError / 1000.0));
                }
                ++i2;
            }
            ModbusUtil.uiSet("__hsyco__modbusutil.scope", "__hsyco__modbusutil.list", "labels", labels.toString());
            ModbusUtil.uiSet("__hsyco__modbusutil.scope", "__hsyco__modbusutil.list", "parameters", parameters.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        displayRequestsSemaphore = false;
    }

    private static void resetCounters() {
        try {
            int i2 = 0;
            while (i2 < scheduleFileLines.size()) {
                ModbusUtilRequest request = scheduleFileLines.get(i2);
                request.lastMeasuredIntervalMillis = -1L;
                request.minResponseTimeMillis = -1L;
                request.maxResponseTimeMillis = -1L;
                request.consecutiveErrorsCounter = 0L;
                request.error = false;
                ++i2;
            }
            ModbusUtil.displayRequests();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

