/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class Timer
extends Listable {
    private boolean enabled = true;

    Timer(String id, boolean check) throws InputException {
        super(id);
        if (check && !id.matches("[a-z0-9]+")) {
            throw new InputException("Illegal Timer ID: " + id);
        }
        Settings.log(1, "Created Timer '" + this.id + "'");
    }

    @Override
    String getListLabel(String list) {
        if (this.enabled) {
            return this.id;
        }
        return "<div style=\"color:#A0A0A0\">" + this.id + "</div>";
    }

    void show(String session) {
        Settings.uiSet("tmr.list", "value", this.id, session);
        Settings.uiSet("tmr.enabled", "value", Boolean.toString(this.enabled), session);
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

