/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.io.BufferedWriter;
import java.io.IOException;
import plugins.manager_settings.Error;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class IRTrans
extends Listable {
    private String ip;
    private boolean enabled = true;

    IRTrans(String id, boolean check) throws InputException {
        super(id);
        if (check && !id.matches("[a-z0-9]+")) {
            throw new InputException("Illegal CommPort ID: " + id);
        }
        Settings.log(1, "Created IRTrans '" + this.id + "'");
    }

    void setIP(String ip) throws InputException {
        if (ip == null || !ip.matches("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])")) {
            throw new InputException("Illegal IP address for IRTrans '" + this.id + "': " + ip);
        }
        this.ip = ip;
        Settings.log(1, "IRTrans '" + this.id + "' - IP set to: " + this.ip);
    }

    @Override
    String getListLabel(String list) {
        if (list.equals("comm.ir")) {
            if (this.enabled) {
                return this.id;
            }
            return null;
        }
        if (this.enabled) {
            return this.id;
        }
        return "<div style=\"color:#A0A0A0\">" + this.id + "</div>";
    }

    void show(String session) {
        Settings.uiSet("ir.selected", "visible", "true", session);
        Settings.uiSet("ir.list", "value", this.id, session);
        Settings.uiSet("ir.enabled", "value", Boolean.toString(this.enabled), session);
        Settings.uiSet("ir.ip", "value", this.ip == null ? "" : this.ip, session);
    }

    void writeIniDeclaration(BufferedWriter bw) throws IOException {
        if (this.ip == null) {
            new Error("IRTrans '" + this.id + "' - IP address not set", this);
        }
        if (bw != null) {
            bw.write("IRTransIP." + this.id);
            bw.write(" = ");
            bw.write(this.ip);
            bw.write("\n");
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

