/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.io.BufferedWriter;
import java.io.IOException;
import plugins.manager_settings.Error;
import plugins.manager_settings.IOServer;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class CommPort
extends Listable {
    static final String[] TYPES = new String[]{"serial", "io", "irtrans", "server"};
    private final String type;
    private String portId;
    private String baudRate;
    private String dataBits;
    private String stopBits;
    private String parity;
    private String flowControl;
    private String timeout;
    private String serverIP;
    private String serverPort;
    private boolean enabled = true;

    CommPort(String id, String type, boolean check) throws InputException {
        super(id);
        if (check && !id.matches("[a-z0-9]+")) {
            throw new InputException("Illegal CommPort ID: " + id);
        }
        this.type = type;
        Settings.log(1, "Created CommPort '" + this.id + "', type '" + this.type + "'");
    }

    String getType() {
        return this.type;
    }

    void setPortId(String portId) throws InputException {
        if (portId == null || portId.length() == 0) {
            throw new InputException("Illegal port ID for CommPort '" + this.id + "': " + portId);
        }
        if (this.type.equals("io")) {
            IOServer ios = Settings.ioServers.get(portId);
            if (ios == null) {
                throw new InputException("Illegal port ID for CommPort '" + this.id + "': IO server '" + portId + "' not defined");
            }
            if (!ios.getType().isCommPort()) {
                throw new InputException("Illegal port ID for CommPort '" + this.id + "': IO server '" + portId + "' cannot be used as CommPort");
            }
        } else if (this.type.equals("irtrans") && Settings.irTrans.get(portId) == null) {
            throw new InputException("Illegal port ID for CommPort '" + this.id + "': IRTrans '" + portId + "' not defined");
        }
        this.portId = portId;
        Settings.log(1, "CommPort '" + this.id + "' - PortId set to: " + this.portId);
    }

    void setParams(String params) throws InputException {
        if (this.type.equals("server")) {
            this.setTimeout(params);
        } else {
            String[] prms = params.split(",");
            if (prms.length < 5) {
                throw new InputException("Illegal params for CommPort '" + this.id + "': " + params);
            }
            this.setBaudRate(prms[0].trim());
            this.setDataBits(prms[1].trim());
            this.setStopBits(prms[2].trim());
            this.setParity(prms[3].trim());
            this.setFlowControl(prms[4].trim());
            if (prms.length > 5) {
                this.setTimeout(prms[5].trim());
            }
        }
    }

    void setBaudRate(String baudRate) throws InputException {
        try {
            Integer.parseInt(baudRate);
        }
        catch (Exception e2) {
            throw new InputException("Illegal baud rate for CommPort '" + this.id + "': " + baudRate);
        }
        this.baudRate = baudRate;
        Settings.log(1, "CommPort '" + this.id + "' - BaudRate set to: " + this.baudRate);
    }

    void setDataBits(String dataBits) throws InputException {
        if (dataBits == null || !dataBits.equals("8") && !dataBits.equals("7") && !dataBits.equals("6") && !dataBits.equals("5")) {
            throw new InputException("Illegal data bits for CommPort '" + this.id + "': " + dataBits);
        }
        this.dataBits = dataBits;
        Settings.log(1, "CommPort '" + this.id + "' - DataBits set to: " + this.dataBits);
    }

    void setStopBits(String stopBits) throws InputException {
        if (stopBits == null || !stopBits.equals("1") && !stopBits.equals("1.5") && !stopBits.equals("2")) {
            throw new InputException("Illegal stop bits for CommPort '" + this.id + "': " + stopBits);
        }
        this.stopBits = stopBits;
        Settings.log(1, "CommPort '" + this.id + "' - StopBits set to: " + this.stopBits);
    }

    void setParity(String parity) throws InputException {
        if (!(parity != null && (parity.equals("0") || parity.equals("1") || parity.equals("2") || parity.equals("3") || parity.equals("4")))) {
            throw new InputException("Illegal parity for CommPort '" + this.id + "': " + parity);
        }
        this.parity = parity;
        Settings.log(1, "CommPort '" + this.id + "' - Parity set to: " + this.parity);
    }

    void setFlowControl(String flowControl) throws InputException {
        if (flowControl == null || !flowControl.equals("0") && !flowControl.equals("1") && !flowControl.equals("2")) {
            throw new InputException("Illegal flow control for CommPort '" + this.id + "': " + flowControl);
        }
        this.flowControl = flowControl;
        Settings.log(1, "CommPort '" + this.id + "' - FlowControl set to: " + this.flowControl);
    }

    void setTimeout(String timeout) throws InputException {
        if (timeout != null && timeout.length() != 0) {
            try {
                int v = Integer.parseInt(timeout);
                if (v < 0) {
                    throw new Exception();
                }
            }
            catch (Exception e2) {
                throw new InputException("Illegal timeout for CommPort '" + this.id + "': " + timeout);
            }
        }
        if (timeout != null && timeout.length() == 0) {
            timeout = null;
        }
        this.timeout = timeout;
        Settings.log(1, "CommPort '" + this.id + "' - Timeout set to: " + this.timeout);
    }

    void setServerIP(String ip) throws InputException {
        if (ip == null || ip.length() == 0) {
            throw new InputException("Illegal IP address for CommPort '" + this.id + "': " + ip);
        }
        this.serverIP = ip;
        Settings.log(1, "CommPort '" + this.id + "' - ServerIP set to: " + this.serverIP);
    }

    void setServerPort(String port) throws InputException {
        int p;
        try {
            p = Integer.parseInt(port);
        }
        catch (Exception e2) {
            throw new InputException("Illegal port number for CommPort '" + this.id + "': " + port);
        }
        if (p <= 0 || p >= 65535) {
            throw new InputException("Illegal port number for CommPort '" + this.id + "': " + port);
        }
        this.serverPort = port;
        Settings.log(1, "CommPort '" + this.id + "' - ServerPort set to: " + this.serverPort);
    }

    @Override
    String getListLabel(String list) {
        if (list.equals("ios.comm.id.select") || list.equals("ios.comm.fail.id")) {
            return this.id;
        }
        String lbl = String.valueOf(this.type) + " - " + this.id;
        if (this.enabled) {
            return lbl;
        }
        return "<div style=\"color:#A0A0A0\">" + lbl + "</div>";
    }

    void show(String session) {
        Settings.uiSet("comm.list", "value", this.id, session);
        Settings.uiSet("comm.enabled", "value", Boolean.toString(this.enabled), session);
        if (this.type.equals("serial")) {
            Settings.uiSet("comm.type.serial", "visible", "true", session);
            Settings.uiSet("comm.type.server", "visible", "false", session);
            Settings.uiSet("comm.type.io", "visible", "false", session);
            Settings.uiSet("comm.type.irtrans", "visible", "false", session);
            Settings.uiSet("comm.port", "value", this.portId == null ? "" : this.portId, session);
            Settings.uiSet("comm.baud", "value", this.baudRate == null ? "" : this.baudRate, session);
            Settings.uiSet("comm.bits", "value", this.dataBits == null ? "" : this.dataBits, session);
            Settings.uiSet("comm.stop", "value", this.stopBits == null ? "" : this.stopBits, session);
            Settings.uiSet("comm.parity", "value", this.parity == null ? "" : this.parity, session);
            Settings.uiSet("comm.flow", "value", this.flowControl == null ? "" : this.flowControl, session);
            if (this.timeout == null) {
                Settings.uiSet("comm.timeout.use", "value", "false", session);
                Settings.uiSet("comm.timeout", "value", "", session);
                Settings.uiSet("comm.timeout", "enabled", "false", session);
            } else {
                Settings.uiSet("comm.timeout.use", "value", "true", session);
                Settings.uiSet("comm.timeout", "value", this.timeout, session);
                Settings.uiSet("comm.timeout", "enabled", "true", session);
            }
        } else if (this.type.equals("server")) {
            Settings.uiSet("comm.type.serial", "visible", "false", session);
            Settings.uiSet("comm.type.server", "visible", "true", session);
            Settings.uiSet("comm.type.io", "visible", "false", session);
            Settings.uiSet("comm.type.irtrans", "visible", "false", session);
            Settings.uiSet("comm.ip", "value", this.serverIP == null ? "" : this.serverIP, session);
            Settings.uiSet("comm.srvport", "value", this.serverPort == null ? "" : this.serverPort, session);
            if (this.timeout == null) {
                Settings.uiSet("comm.timeout.use", "value", "false", session);
                Settings.uiSet("comm.timeout", "value", "", session);
                Settings.uiSet("comm.timeout", "enabled", "false", session);
            } else {
                Settings.uiSet("comm.timeout.use", "value", "true", session);
                Settings.uiSet("comm.timeout", "value", this.timeout, session);
                Settings.uiSet("comm.timeout", "enabled", "true", session);
            }
        } else if (this.type.equals("io")) {
            Settings.uiSet("comm.type.serial", "visible", "false", session);
            Settings.uiSet("comm.type.server", "visible", "false", session);
            Settings.uiSet("comm.type.io", "visible", "true", session);
            Settings.uiSet("comm.type.irtrans", "visible", "false", session);
            Settings.uiSet("comm.io", "value", this.portId == null ? "" : this.portId, session);
            Settings.uiSet("comm.baud", "value", this.baudRate == null ? "" : this.baudRate, session);
            Settings.uiSet("comm.bits", "value", this.dataBits == null ? "" : this.dataBits, session);
            Settings.uiSet("comm.stop", "value", this.stopBits == null ? "" : this.stopBits, session);
            Settings.uiSet("comm.parity", "value", this.parity == null ? "" : this.parity, session);
            Settings.uiSet("comm.flow", "value", this.flowControl == null ? "" : this.flowControl, session);
        } else if (this.type.equals("irtrans")) {
            Settings.uiSet("comm.type.serial", "visible", "false", session);
            Settings.uiSet("comm.type.server", "visible", "false", session);
            Settings.uiSet("comm.type.io", "visible", "false", session);
            Settings.uiSet("comm.type.irtrans", "visible", "true", session);
            Settings.uiSet("comm.ir", "value", this.portId == null ? "" : this.portId, session);
        }
    }

    void writeIniDeclaration(BufferedWriter bw) throws IOException {
        if (this.type == null) {
            new Error("CommPort '" + this.id + "' - Type not specified. Remove this CommPort", this);
            return;
        }
        boolean ok = false;
        String[] stringArray = TYPES;
        int n2 = TYPES.length;
        int n3 = 0;
        while (n3 < n2) {
            String t = stringArray[n3];
            if (t.equals(this.type)) {
                ok = true;
                break;
            }
            ++n3;
        }
        if (!ok) {
            new Error("CommPort '" + this.id + "' - Type not valid. Remove this CommPort", this);
            return;
        }
        if (bw != null) {
            bw.write("CommPort." + this.id + ".Type");
            bw.write(" = ");
            bw.write(this.type);
            bw.write("\n");
        }
        if (this.type.equals("serial") || this.type.equals("io")) {
            if (this.portId == null) {
                new Error("CommPort '" + this.id + "' - Port ID not set", this);
            }
            if (this.baudRate == null) {
                new Error("CommPort '" + this.id + "' - Baud rate not set", this);
            }
            if (this.dataBits == null) {
                new Error("CommPort '" + this.id + "' - Data bits not set", this);
            }
            if (this.stopBits == null) {
                new Error("CommPort '" + this.id + "' - Stop bits not set", this);
            }
            if (this.parity == null) {
                new Error("CommPort '" + this.id + "' - Parity not set", this);
            }
            if (this.flowControl == null) {
                new Error("CommPort '" + this.id + "' - Flow control not set", this);
            }
            if (bw != null) {
                bw.write("CommPort." + this.id + ".Id");
                bw.write(" = ");
                bw.write(this.portId);
                bw.write("\n");
                bw.write("CommPort." + this.id + ".Params");
                bw.write(" = ");
                bw.write(this.baudRate);
                bw.write(",");
                bw.write(this.dataBits);
                bw.write(",");
                bw.write(this.stopBits);
                bw.write(",");
                bw.write(this.parity);
                bw.write(",");
                bw.write(this.flowControl);
                if (this.timeout != null && this.type.equals("serial")) {
                    bw.write(",");
                    bw.write(this.timeout);
                }
                bw.write("\n");
            }
        } else if (this.type.equals("server")) {
            if (this.serverIP == null) {
                new Error("CommPort '" + this.id + "' - Server IP not set", this);
            }
            if (this.serverPort == null) {
                new Error("CommPort '" + this.id + "' - Server Port not set", this);
            }
            if (bw != null) {
                bw.write("CommPort." + this.id + ".IP");
                bw.write(" = ");
                bw.write(this.serverIP);
                bw.write("\n");
                bw.write("CommPort." + this.id + ".Port");
                bw.write(" = ");
                bw.write(this.serverPort);
                bw.write("\n");
                if (this.timeout != null) {
                    bw.write("CommPort." + this.id + ".Params = ");
                    bw.write(this.timeout);
                    bw.write("\n");
                }
            }
        } else if (this.type.equals("irtrans")) {
            if (this.portId == null) {
                new Error("CommPort '" + this.id + "' - Port ID not set", this);
            }
            if (bw != null) {
                bw.write("CommPort." + this.id + ".Id");
                bw.write(" = ");
                bw.write(this.portId);
                bw.write("\n");
            }
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

