/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import org.jcodec.common.model.Picture;
import org.jcodec.scale.Transform;

public class RgbToYuv420
implements Transform {
    private int upShift;
    private int downShift;
    private int downShiftChr;

    public RgbToYuv420(int upShift, int downShift) {
        this.upShift = upShift;
        this.downShift = downShift;
        this.downShiftChr = downShift + 2;
    }

    @Override
    public void transform(Picture img, Picture dst) {
        int[] y = img.getData()[0];
        int[][] dstData = dst.getData();
        int offChr = 0;
        int offLuma = 0;
        int offSrc = 0;
        int strideSrc = img.getWidth() * 3;
        int strideDst = dst.getWidth();
        for (int i2 = 0; i2 < img.getHeight() >> 1; ++i2) {
            for (int j2 = 0; j2 < img.getWidth() >> 1; ++j2) {
                dstData[1][offChr] = 0;
                dstData[2][offChr] = 0;
                RgbToYuv420.rgb2yuv(y[offSrc], y[offSrc + 1], y[offSrc + 2], dstData[0], offLuma, dstData[1], offChr, dstData[2], offChr);
                dstData[0][offLuma] = dstData[0][offLuma] << this.upShift >> this.downShift;
                RgbToYuv420.rgb2yuv(y[offSrc + strideSrc], y[offSrc + strideSrc + 1], y[offSrc + strideSrc + 2], dstData[0], offLuma + strideDst, dstData[1], offChr, dstData[2], offChr);
                dstData[0][offLuma + strideDst] = dstData[0][offLuma + strideDst] << this.upShift >> this.downShift;
                RgbToYuv420.rgb2yuv(y[offSrc + 3], y[offSrc + 4], y[offSrc + 5], dstData[0], ++offLuma, dstData[1], offChr, dstData[2], offChr);
                dstData[0][offLuma] = dstData[0][offLuma] << this.upShift >> this.downShift;
                RgbToYuv420.rgb2yuv(y[offSrc + strideSrc + 3], y[offSrc + strideSrc + 4], y[offSrc + strideSrc + 5], dstData[0], offLuma + strideDst, dstData[1], offChr, dstData[2], offChr);
                dstData[0][offLuma + strideDst] = dstData[0][offLuma + strideDst] << this.upShift >> this.downShift;
                ++offLuma;
                dstData[1][offChr] = dstData[1][offChr] << this.upShift >> this.downShiftChr;
                dstData[2][offChr] = dstData[2][offChr] << this.upShift >> this.downShiftChr;
                ++offChr;
                offSrc += 6;
            }
            offLuma += strideDst;
            offSrc += strideSrc;
        }
    }

    public static final void rgb2yuv(int r, int g2, int b2, int[] Y, int offY, int[] U, int offU, int[] V, int offV) {
        int y = 66 * r + 129 * g2 + 25 * b2;
        int u = -38 * r - 74 * g2 + 112 * b2;
        int v = 112 * r - 94 * g2 - 18 * b2;
        y = y + 128 >> 8;
        u = u + 128 >> 8;
        v = v + 128 >> 8;
        Y[offY] = RgbToYuv420.clip(y + 16);
        int n2 = offU;
        U[n2] = U[n2] + RgbToYuv420.clip(u + 128);
        int n3 = offV;
        V[n3] = V[n3] + RgbToYuv420.clip(v + 128);
    }

    private static final int clip(int val) {
        return val < 0 ? 0 : (val > 255 ? 255 : val);
    }
}

