/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.encode.ConstantRateControl;
import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.codecs.prores.ProresEncoder;
import org.jcodec.codecs.prores.ProresToThumb2x2;
import org.jcodec.codecs.prores.ProresToThumb4x4;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Rect;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;
import org.jcodec.scale.Yuv422pToYuv420p;

public class Prores2AVCTrack
implements VirtualTrack {
    private static final int TARGET_RATE = 1024;
    private int frameSize;
    private VirtualTrack proresTrack;
    private SampleEntry se;
    private ThreadLocal<Transcoder> transcoders = new ThreadLocal();
    private int mbW;
    private int mbH;
    private int scaleFactor;
    private int thumbWidth;
    private int thumbHeight;

    public Prores2AVCTrack(VirtualTrack proresTrack, Size frameDim) {
        this.checkFourCC(proresTrack);
        this.proresTrack = proresTrack;
        ConstantRateControl rc = new ConstantRateControl(1024);
        H264Encoder encoder = new H264Encoder(rc);
        this.scaleFactor = frameDim.getWidth() >= 960 ? 2 : 1;
        this.thumbWidth = frameDim.getWidth() >> this.scaleFactor;
        this.thumbHeight = frameDim.getHeight() >> this.scaleFactor & 0xFFFFFFFE;
        this.mbW = this.thumbWidth + 15 >> 4;
        this.mbH = this.thumbHeight + 15 >> 4;
        this.se = H264Utils.createMOVSampleEntry(encoder.initSPS(new Size(this.thumbWidth, this.thumbHeight)), encoder.initPPS());
        PixelAspectExt pasp = Box.findFirst((NodeBox)proresTrack.getSampleEntry(), PixelAspectExt.class, "pasp");
        if (pasp != null) {
            this.se.add(pasp);
        }
        this.frameSize = rc.calcFrameSize(this.mbW * this.mbH);
        this.frameSize += this.frameSize >> 4;
    }

    private void checkFourCC(VirtualTrack proresTrack) {
        String fourcc = proresTrack.getSampleEntry().getFourcc();
        if ("ap4h".equals(fourcc)) {
            return;
        }
        for (ProresEncoder.Profile profile : EnumSet.allOf(ProresEncoder.Profile.class)) {
            if (!profile.fourcc.equals(fourcc)) continue;
            return;
        }
        throw new IllegalArgumentException("Input track is not ProRes");
    }

    @Override
    public SampleEntry getSampleEntry() {
        return this.se;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket nextPacket = this.proresTrack.nextPacket();
        if (nextPacket == null) {
            return null;
        }
        return new TranscodePacket(nextPacket);
    }

    @Override
    public void close() {
        this.proresTrack.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return this.proresTrack.getEdits();
    }

    @Override
    public int getPreferredTimescale() {
        return this.proresTrack.getPreferredTimescale();
    }

    class Transcoder {
        private ProresDecoder decoder;
        private H264Encoder encoder;
        private Picture pic0;
        private Picture pic1;
        private Yuv422pToYuv420p transform;
        private ConstantRateControl rc = new ConstantRateControl(1024);

        public Transcoder() {
            this.decoder = Prores2AVCTrack.this.scaleFactor == 2 ? new ProresToThumb2x2() : new ProresToThumb4x4();
            this.encoder = new H264Encoder(this.rc);
            this.pic0 = Picture.create(Prores2AVCTrack.this.mbW << 4, Prores2AVCTrack.this.mbH << 4, ColorSpace.YUV422_10);
            this.transform = new Yuv422pToYuv420p(0, 2);
        }

        public ByteBuffer transcodeFrame(ByteBuffer src, ByteBuffer dst) throws IOException {
            Picture decoded = this.decoder.decodeFrame(src, this.pic0.getData());
            if (this.pic1 == null) {
                this.pic1 = Picture.create(decoded.getWidth(), decoded.getHeight(), ColorSpace.YUV420);
            }
            this.transform.transform(decoded, this.pic1);
            this.pic1.setCrop(new Rect(0, 0, Prores2AVCTrack.this.thumbWidth, Prores2AVCTrack.this.thumbHeight));
            int rate = 1024;
            while (true) {
                try {
                    this.encoder.encodeFrame(dst, this.pic1);
                }
                catch (BufferOverflowException ex) {
                    System.out.println("Abandon frame!!!");
                    this.rc.setRate(rate -= 10);
                    if (rate > 10) continue;
                }
                break;
            }
            this.rc.setRate(1024);
            H264Utils.encodeMOVPacket(dst, null, null);
            return dst;
        }
    }

    private class TranscodePacket
    extends VirtualPacketWrapper {
        public TranscodePacket(VirtualPacket nextPacket) {
            super(nextPacket);
        }

        @Override
        public int getDataLen() {
            return Prores2AVCTrack.this.frameSize;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            Transcoder t = (Transcoder)Prores2AVCTrack.this.transcoders.get();
            if (t == null) {
                t = new Transcoder();
                Prores2AVCTrack.this.transcoders.set(t);
            }
            ByteBuffer buf = ByteBuffer.allocate(Prores2AVCTrack.this.frameSize);
            ByteBuffer data = this.src.getData();
            return t.transcodeFrame(data, buf);
        }
    }
}

