/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jcodec.movtool.streaming.MovieHelper;
import org.jcodec.movtool.streaming.MovieSegment;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public class VirtualMovie {
    private PacketChunk[] chunks;
    private MovieSegment headerChunk;
    private long size;
    private VirtualTrack[] tracks;

    public VirtualMovie(VirtualTrack ... tracks) throws IOException {
        this.tracks = tracks;
        this.muxTracks();
    }

    private void muxTracks() throws IOException {
        ArrayList<PacketChunk> chch = new ArrayList<PacketChunk>();
        VirtualPacket[] heads = new VirtualPacket[this.tracks.length];
        VirtualPacket[] tails = new VirtualPacket[this.tracks.length];
        int curChunk = 1;
        while (true) {
            int min = -1;
            for (int i2 = 0; i2 < heads.length; ++i2) {
                if (heads[i2] == null) {
                    heads[i2] = this.tracks[i2].nextPacket();
                    if (heads[i2] == null) continue;
                }
                min = min == -1 || heads[i2].getPts() < heads[min].getPts() ? i2 : min;
            }
            if (min == -1) break;
            chch.add(new PacketChunk(heads[min], min, curChunk, this.size));
            this.size += (long)heads[min].getDataLen();
            tails[min] = heads[min];
            heads[min] = this.tracks[min].nextPacket();
            ++curChunk;
        }
        this.chunks = chch.toArray(new PacketChunk[0]);
        long dataSize = this.size;
        int headerSize = MovieHelper.produceHeader(this.chunks, this.tracks, dataSize).remaining();
        this.size += (long)headerSize;
        for (PacketChunk ch : chch) {
            ch.offset(headerSize);
        }
        this.headerChunk = this.headerChunk(MovieHelper.produceHeader(this.chunks, this.tracks, dataSize));
        this.chunks = chch.toArray(new PacketChunk[0]);
    }

    private MovieSegment headerChunk(final ByteBuffer header) {
        return new MovieSegment(){

            @Override
            public ByteBuffer getData() {
                return header.duplicate();
            }

            @Override
            public int getNo() {
                return 0;
            }

            @Override
            public long getPos() {
                return 0L;
            }

            @Override
            public int getDataLen() {
                return header.remaining();
            }
        };
    }

    public void close() {
        for (VirtualTrack virtualTrack : this.tracks) {
            virtualTrack.close();
        }
    }

    public MovieSegment getPacketAt(long position) {
        if (position >= 0L && position < (long)this.headerChunk.getDataLen()) {
            return this.headerChunk;
        }
        for (int i2 = 0; i2 < this.chunks.length - 1; ++i2) {
            if (this.chunks[i2 + 1].getPos() <= position) continue;
            return this.chunks[i2];
        }
        if (position < this.size) {
            return this.chunks[this.chunks.length - 1];
        }
        return null;
    }

    public MovieSegment getPacketByNo(int no) {
        if (no > this.chunks.length) {
            return null;
        }
        if (no == 0) {
            return this.headerChunk;
        }
        return this.chunks[no - 1];
    }

    public long size() {
        return this.size;
    }

    public class PacketChunk
    implements MovieSegment {
        private VirtualPacket packet;
        private int track;
        private int no;
        private long pos;

        public PacketChunk(VirtualPacket packet, int track, int no, long pos) {
            this.packet = packet;
            this.track = track;
            this.no = no;
            this.pos = pos;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            return this.packet.getData().duplicate();
        }

        @Override
        public int getNo() {
            return this.no;
        }

        @Override
        public long getPos() {
            return this.pos;
        }

        public void offset(int off) {
            this.pos += (long)off;
        }

        @Override
        public int getDataLen() {
            return this.packet.getDataLen();
        }

        public VirtualPacket getPacket() {
            return this.packet;
        }

        public int getTrack() {
            return this.track;
        }
    }
}

