/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.jcodec.common.ArrayUtil;
import org.jcodec.common.model.Rational;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import org.jcodec.containers.mp4.boxes.ChunkOffsetsBox;
import org.jcodec.containers.mp4.boxes.DataRefBox;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleDescriptionBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import org.jcodec.containers.mp4.boxes.TrakBox;

public class Util {
    public static Pair<List<Edit>> split(List<Edit> edits, Rational trackByMv, long tvMv) {
        long total = 0L;
        ArrayList<Edit> l2 = new ArrayList<Edit>();
        ArrayList<Edit> r = new ArrayList<Edit>();
        ListIterator<Edit> lit = edits.listIterator();
        while (lit.hasNext()) {
            Edit edit = lit.next();
            if (total + edit.getDuration() > tvMv) {
                int leftDurMV = (int)(tvMv - total);
                int leftDurMedia = trackByMv.multiplyS(leftDurMV);
                Edit left = new Edit(leftDurMV, edit.getMediaTime(), 1.0f);
                Edit right = new Edit(edit.getDuration() - (long)leftDurMV, (long)leftDurMedia + edit.getMediaTime(), 1.0f);
                lit.remove();
                if (left.getDuration() > 0L) {
                    lit.add(left);
                    l2.add(left);
                }
                if (right.getDuration() <= 0L) break;
                lit.add(right);
                r.add(right);
                break;
            }
            l2.add(edit);
            total += edit.getDuration();
        }
        while (lit.hasNext()) {
            r.add(lit.next());
        }
        return new Pair<List<Edit>>(l2, r);
    }

    public static Pair<List<Edit>> split(MovieBox movie, TrakBox track, long tvMv) {
        return Util.split(track.getEdits(), new Rational(track.getTimescale(), movie.getTimescale()), tvMv);
    }

    public static void spread(MovieBox movie, TrakBox track, long tvMv, long durationMv) {
        Pair<List<Edit>> split = Util.split(movie, track, tvMv);
        track.getEdits().add(split.getA().size(), new Edit(durationMv, -1L, 1.0f));
    }

    public static void shift(MovieBox movie, TrakBox track, long tvMv) {
        track.getEdits().add(0, new Edit(tvMv, -1L, 1.0f));
    }

    public static long[] getTimevalues(TrakBox track) {
        TimeToSampleBox stts = Box.findFirst((NodeBox)track, TimeToSampleBox.class, "mdia", "minf", "stbl", "stts");
        int count = 0;
        TimeToSampleBox.TimeToSampleEntry[] tts = stts.getEntries();
        for (int i2 = 0; i2 < tts.length; ++i2) {
            count += tts[i2].getSampleCount();
        }
        long[] tv = new long[count + 1];
        int k2 = 0;
        for (int i3 = 0; i3 < tts.length; ++i3) {
            int j2 = 0;
            while (j2 < tts[i3].getSampleCount()) {
                tv[k2 + 1] = tv[k2] + (long)tts[i3].getSampleDuration();
                ++j2;
                ++k2;
            }
        }
        return tv;
    }

    private static void appendToInternal(MovieBox movie, TrakBox dest, TrakBox src) {
        int off = Util.appendEntries(dest, src);
        Util.appendChunkOffsets(dest, src);
        Util.appendTimeToSamples(dest, src);
        Util.appendSampleToChunk(dest, src, off);
        Util.appendSampleSizes(dest, src);
    }

    private static void updateDuration(TrakBox dest, TrakBox src) {
        MediaHeaderBox mdhd1 = NodeBox.findFirst((NodeBox)dest, MediaHeaderBox.class, "mdia", "mdhd");
        MediaHeaderBox mdhd2 = NodeBox.findFirst((NodeBox)src, MediaHeaderBox.class, "mdia", "mdhd");
        mdhd1.setDuration(mdhd1.getDuration() + mdhd2.getDuration());
    }

    public static void appendTo(MovieBox movie, TrakBox dest, TrakBox src) {
        Util.appendToInternal(movie, dest, src);
        Util.appendEdits(dest, src, dest.getEdits().size());
        Util.updateDuration(dest, src);
    }

    public static void insertTo(MovieBox movie, TrakBox dest, TrakBox src, long tvMv) {
        Util.appendToInternal(movie, dest, src);
        Util.insertEdits(movie, dest, src, tvMv);
        Util.updateDuration(dest, src);
    }

    private static void insertEdits(MovieBox movie, TrakBox dest, TrakBox src, long tvMv) {
        Pair<List<Edit>> split = Util.split(movie, dest, tvMv);
        Util.appendEdits(dest, src, split.getA().size());
    }

    private static void appendEdits(TrakBox dest, TrakBox src, int ind) {
        for (Edit edit : src.getEdits()) {
            edit.shift(dest.getMediaDuration());
        }
        dest.getEdits().addAll(ind, src.getEdits());
        dest.setEdits(dest.getEdits());
    }

    private static void appendSampleSizes(TrakBox trakBox1, TrakBox trakBox2) {
        SampleSizesBox stsz1 = NodeBox.findFirst((NodeBox)trakBox1, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        SampleSizesBox stsz2 = NodeBox.findFirst((NodeBox)trakBox2, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        if (stsz1.getDefaultSize() != stsz2.getDefaultSize()) {
            throw new IllegalArgumentException("Can't append to track that has different default sample size");
        }
        SampleSizesBox stszr = stsz1.getDefaultSize() > 0 ? new SampleSizesBox(stsz1.getDefaultSize(), stsz1.getCount() + stsz2.getCount()) : new SampleSizesBox(ArrayUtil.addAll(stsz1.getSizes(), stsz2.getSizes()));
        NodeBox.findFirst((NodeBox)trakBox1, NodeBox.class, "mdia", "minf", "stbl").replace("stsz", stszr);
    }

    private static void appendSampleToChunk(TrakBox trakBox1, TrakBox trakBox2, int off) {
        SampleToChunkBox stsc1 = NodeBox.findFirst((NodeBox)trakBox1, SampleToChunkBox.class, "mdia", "minf", "stbl", "stsc");
        SampleToChunkBox stsc2 = NodeBox.findFirst((NodeBox)trakBox2, SampleToChunkBox.class, "mdia", "minf", "stbl", "stsc");
        SampleToChunkBox.SampleToChunkEntry[] orig = stsc2.getSampleToChunk();
        Object[] shifted = new SampleToChunkBox.SampleToChunkEntry[orig.length];
        for (int i2 = 0; i2 < orig.length; ++i2) {
            shifted[i2] = new SampleToChunkBox.SampleToChunkEntry(orig[i2].getFirst() + (long)stsc1.getSampleToChunk().length, orig[i2].getCount(), orig[i2].getEntry() + off);
        }
        NodeBox.findFirst((NodeBox)trakBox1, NodeBox.class, "mdia", "minf", "stbl").replace("stsc", new SampleToChunkBox((SampleToChunkBox.SampleToChunkEntry[])ArrayUtil.addAll(stsc1.getSampleToChunk(), shifted)));
    }

    private static int appendEntries(TrakBox trakBox1, TrakBox trakBox2) {
        Util.appendDrefs(trakBox1, trakBox2);
        SampleEntry[] ent1 = NodeBox.findAll((Box)trakBox1, SampleEntry.class, "mdia", "minf", "stbl", "stsd", null);
        SampleEntry[] ent2 = NodeBox.findAll((Box)trakBox2, SampleEntry.class, "mdia", "minf", "stbl", "stsd", null);
        SampleDescriptionBox stsd = new SampleDescriptionBox(ent1);
        for (SampleEntry se : ent2) {
            se.setDrefInd((short)(se.getDrefInd() + ent1.length));
            stsd.add(se);
        }
        NodeBox.findFirst((NodeBox)trakBox1, NodeBox.class, "mdia", "minf", "stbl").replace("stsd", stsd);
        return ent1.length;
    }

    private static void appendDrefs(TrakBox trakBox1, TrakBox trakBox2) {
        DataRefBox dref1 = NodeBox.findFirst((NodeBox)trakBox1, DataRefBox.class, "mdia", "minf", "dinf", "dref");
        DataRefBox dref2 = NodeBox.findFirst((NodeBox)trakBox2, DataRefBox.class, "mdia", "minf", "dinf", "dref");
        dref1.getBoxes().addAll(dref2.getBoxes());
    }

    private static void appendTimeToSamples(TrakBox trakBox1, TrakBox trakBox2) {
        TimeToSampleBox stts1 = NodeBox.findFirst((NodeBox)trakBox1, TimeToSampleBox.class, "mdia", "minf", "stbl", "stts");
        TimeToSampleBox stts2 = NodeBox.findFirst((NodeBox)trakBox2, TimeToSampleBox.class, "mdia", "minf", "stbl", "stts");
        TimeToSampleBox sttsNew = new TimeToSampleBox((TimeToSampleBox.TimeToSampleEntry[])ArrayUtil.addAll(stts1.getEntries(), stts2.getEntries()));
        NodeBox.findFirst((NodeBox)trakBox1, NodeBox.class, "mdia", "minf", "stbl").replace("stts", sttsNew);
    }

    private static void appendChunkOffsets(TrakBox trakBox1, TrakBox trakBox2) {
        ChunkOffsetsBox stco1 = NodeBox.findFirst((NodeBox)trakBox1, ChunkOffsetsBox.class, "mdia", "minf", "stbl", "stco");
        ChunkOffsets64Box co641 = NodeBox.findFirst((NodeBox)trakBox1, ChunkOffsets64Box.class, "mdia", "minf", "stbl", "co64");
        ChunkOffsetsBox stco2 = NodeBox.findFirst((NodeBox)trakBox2, ChunkOffsetsBox.class, "mdia", "minf", "stbl", "stco");
        ChunkOffsets64Box co642 = NodeBox.findFirst((NodeBox)trakBox2, ChunkOffsets64Box.class, "mdia", "minf", "stbl", "co64");
        long[] off1 = stco1 == null ? co641.getChunkOffsets() : stco1.getChunkOffsets();
        long[] off2 = stco2 == null ? co642.getChunkOffsets() : stco2.getChunkOffsets();
        NodeBox stbl1 = NodeBox.findFirst((NodeBox)trakBox1, NodeBox.class, "mdia", "minf", "stbl");
        stbl1.removeChildren("stco", "co64");
        stbl1.add(co641 == null && co642 == null ? new ChunkOffsetsBox(ArrayUtil.addAll(off1, off2)) : new ChunkOffsets64Box(ArrayUtil.addAll(off1, off2)));
    }

    public static void forceEditList(MovieBox movie, TrakBox trakBox) {
        List<Edit> edits = trakBox.getEdits();
        if (edits == null || edits.size() == 0) {
            MovieHeaderBox mvhd = Box.findFirst((NodeBox)movie, MovieHeaderBox.class, "mvhd");
            edits = new ArrayList<Edit>();
            trakBox.setEdits(edits);
            edits.add(new Edit((int)mvhd.getDuration(), 0L, 1.0f));
            trakBox.setEdits(edits);
        }
    }

    public static void forceEditList(MovieBox movie) {
        for (TrakBox trakBox : movie.getTracks()) {
            Util.forceEditList(movie, trakBox);
        }
    }

    public static List<Edit> editsOnEdits(Rational mvByTrack, List<Edit> lower, List<Edit> higher) {
        ArrayList<Edit> result = new ArrayList<Edit>();
        List<Edit> next = new ArrayList<Edit>(lower);
        for (Edit edit : higher) {
            long startMv = mvByTrack.multiply(edit.getMediaTime());
            Pair<List<Edit>> split = Util.split(next, mvByTrack.flip(), startMv);
            Pair<List<Edit>> split2 = Util.split(split.getB(), mvByTrack.flip(), startMv + edit.getDuration());
            result.addAll((Collection<Edit>)split2.getA());
            next = split2.getB();
        }
        return result;
    }

    public static class Pair<T> {
        private T a;
        private T b;

        public Pair(T a2, T b2) {
            this.a = a2;
            this.b = b2;
        }

        public T getA() {
            return this.a;
        }

        public T getB() {
            return this.b;
        }
    }
}

