/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.io.File;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.movtool.InplaceEdit;

public class ChangeTimescale {
    public static void main(String[] args) throws Exception {
        int ts;
        if (args.length < 2) {
            System.out.println("Syntax: chts <movie> <timescale>");
            System.exit(-1);
        }
        if ((ts = Integer.parseInt(args[1])) < 600) {
            System.out.println("Could not set timescale < 600");
            System.exit(-1);
        }
        new InplaceEdit(){

            @Override
            protected void apply(MovieBox mov) {
                TrakBox vt = mov.getVideoTrack();
                MediaHeaderBox mdhd = Box.findFirst((NodeBox)vt, MediaHeaderBox.class, "mdia", "mdhd");
                int oldTs = mdhd.getTimescale();
                if (oldTs > ts) {
                    throw new RuntimeException("Old timescale (" + oldTs + ") is greater then new timescale (" + ts + "), not touching.");
                }
                vt.fixMediaTimescale(ts);
                mov.fixTimescale(ts);
            }
        }.save(new File(args[0]));
    }
}

