/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.common.Assert;
import org.jcodec.common.IntObjectMap;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mps.MPSDemuxer;

public class MTSDemuxer {
    private int guid = -1;
    private MPSDemuxer psDemuxer;

    public MTSDemuxer(final SeekableByteChannel channel) throws IOException {
        this.psDemuxer = new MPSDemuxer(new SeekableByteChannel(){

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                MTSPacket packet = MTSDemuxer.this.getPacket(channel);
                int rem = packet.payload.remaining();
                NIOUtils.write(dst, packet.payload);
                return rem - packet.payload.remaining();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return 0;
            }

            @Override
            public long position() throws IOException {
                return 0L;
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                return null;
            }

            @Override
            public long size() throws IOException {
                return 0L;
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                return null;
            }
        });
    }

    public List<MPSDemuxer.Track> getTracks() {
        return this.psDemuxer.getTracks();
    }

    public List<MPSDemuxer.Track> getVideoTracks() {
        return this.psDemuxer.getVideoTracks();
    }

    public List<MPSDemuxer.Track> getAudioTracks() {
        return this.psDemuxer.getAudioTracks();
    }

    protected MTSPacket getPacket(ReadableByteChannel channel) throws IOException {
        MTSPacket pkt;
        do {
            if ((pkt = MTSDemuxer.readPacket(channel)) != null) continue;
            return null;
        } while (pkt.pid <= 15 || pkt.pid == 8191);
        while (this.guid == -1) {
            ByteBuffer payload = pkt.payload;
            if (payload.get(0) == 0 && payload.get(1) == 0 && payload.get(2) == 1) {
                this.guid = pkt.pid;
                break;
            }
            pkt = MTSDemuxer.readPacket(channel);
            if (pkt != null) continue;
            return null;
        }
        while (pkt.pid != this.guid) {
            pkt = MTSDemuxer.readPacket(channel);
            if (pkt != null) continue;
            return null;
        }
        return pkt;
    }

    public static MTSPacket readPacket(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(188);
        if (NIOUtils.read(channel, buffer) != 188) {
            return null;
        }
        buffer.flip();
        return MTSDemuxer.parsePacket(buffer);
    }

    public static MTSPacket parsePacket(ByteBuffer buffer) {
        int marker = buffer.get() & 0xFF;
        Assert.assertEquals(71, marker);
        short guidFlags = buffer.getShort();
        int guid = guidFlags & 0x1FFF;
        int payloadStart = guidFlags >> 14 & 1;
        int b0 = buffer.get() & 0xFF;
        int counter = b0 & 0xF;
        if ((b0 & 0x20) != 0) {
            int taken = 0;
            taken = (buffer.get() & 0xFF) + 1;
            NIOUtils.skip(buffer, taken - 1);
        }
        return new MTSPacket(guid, payloadStart == 1, (b0 & 0x10) != 0 ? buffer : null);
    }

    public static int probe(ByteBuffer b2) {
        int[] keys;
        IntObjectMap<ArrayList<ByteBuffer>> streams = new IntObjectMap<ArrayList<ByteBuffer>>();
        try {
            ByteBuffer sub;
            while ((sub = NIOUtils.read(b2, 188)).remaining() >= 188) {
                MTSPacket tsPkt = MTSDemuxer.parsePacket(sub);
                ArrayList<ByteBuffer> data = (ArrayList<ByteBuffer>)streams.get(tsPkt.pid);
                if (data == null) {
                    data = new ArrayList<ByteBuffer>();
                    streams.put(tsPkt.pid, data);
                }
                data.add(tsPkt.payload);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        int maxScore = 0;
        for (int i2 : keys = streams.keys()) {
            int score = MPSDemuxer.probe(NIOUtils.combine((Iterable)streams.get(i2)));
            if (score <= maxScore) continue;
            maxScore = score;
        }
        return maxScore;
    }

    public static class MTSPacket {
        public ByteBuffer payload;
        public boolean payloadStart;
        public int pid;

        public MTSPacket(int guid, boolean payloadStart, ByteBuffer payload) {
            this.pid = guid;
            this.payloadStart = payloadStart;
            this.payload = payload;
        }
    }
}

