/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.muxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.TrackType;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.EndianBox;
import org.jcodec.containers.mp4.boxes.FileTypeBox;
import org.jcodec.containers.mp4.boxes.FormatBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.muxer.AbstractMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.FramesMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.PCMMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.TimecodeMP4MuxerTrack;

public class MP4Muxer {
    private List<AbstractMP4MuxerTrack> tracks = new ArrayList<AbstractMP4MuxerTrack>();
    private long mdatOffset;
    private int nextTrackId = 1;
    SeekableByteChannel out;

    public MP4Muxer(SeekableByteChannel output) throws IOException {
        this(output, Brand.MP4);
    }

    public MP4Muxer(SeekableByteChannel output, Brand brand) throws IOException {
        this(output, brand.getFileTypeBox());
    }

    public MP4Muxer(SeekableByteChannel output, FileTypeBox ftyp) throws IOException {
        this.out = output;
        ByteBuffer buf = ByteBuffer.allocate(1024);
        ftyp.write(buf);
        new Header("wide", 8L).write(buf);
        new Header("mdat", 1L).write(buf);
        this.mdatOffset = buf.position();
        buf.putLong(0L);
        buf.flip();
        output.write(buf);
    }

    public FramesMP4MuxerTrack addVideoTrackWithTimecode(String fourcc, Size size, String encoderName, int timescale) {
        TimecodeMP4MuxerTrack timecode = this.addTimecodeTrack(timescale);
        FramesMP4MuxerTrack track = this.addTrackForCompressed(TrackType.VIDEO, timescale);
        track.addSampleEntry(MP4Muxer.videoSampleEntry(fourcc, size, encoderName));
        track.setTimecode(timecode);
        return track;
    }

    public FramesMP4MuxerTrack addVideoTrack(String fourcc, Size size, String encoderName, int timescale) {
        FramesMP4MuxerTrack track = this.addTrackForCompressed(TrackType.VIDEO, timescale);
        track.addSampleEntry(MP4Muxer.videoSampleEntry(fourcc, size, encoderName));
        return track;
    }

    public static VideoSampleEntry videoSampleEntry(String fourcc, Size size, String encoderName) {
        return new VideoSampleEntry(new Header(fourcc), 0, 0, "jcod", 0, 768, (short)size.getWidth(), (short)size.getHeight(), 72L, 72L, 1, encoderName != null ? encoderName : "jcodec", 24, 1, -1);
    }

    public static AudioSampleEntry audioSampleEntry(String fourcc, int drefId, int sampleSize, int channels, int sampleRate, EndianBox.Endian endian) {
        AudioSampleEntry ase = new AudioSampleEntry(new Header(fourcc, 0L), (short)drefId, (short)channels, 16, sampleRate, 0, 0, 65535, 0, 1, sampleSize, channels * sampleSize, sampleSize, 1);
        NodeBox wave = new NodeBox(new Header("wave"));
        ase.add(wave);
        wave.add(new FormatBox(fourcc));
        wave.add(new EndianBox(endian));
        wave.add(MP4Muxer.terminatorAtom());
        return ase;
    }

    public static LeafBox terminatorAtom() {
        return new LeafBox(new Header(new String(new byte[4])), ByteBuffer.allocate(0));
    }

    public TimecodeMP4MuxerTrack addTimecodeTrack(int timescale) {
        TimecodeMP4MuxerTrack track = new TimecodeMP4MuxerTrack(this.out, this.nextTrackId++, timescale);
        this.tracks.add(track);
        return track;
    }

    public FramesMP4MuxerTrack addTrackForCompressed(TrackType type, int timescale) {
        FramesMP4MuxerTrack track = new FramesMP4MuxerTrack(this.out, this.nextTrackId++, type, timescale);
        this.tracks.add(track);
        return track;
    }

    public PCMMP4MuxerTrack addTrackForUncompressed(TrackType type, int timescale, int sampleDuration, int sampleSize, SampleEntry se) {
        PCMMP4MuxerTrack track = new PCMMP4MuxerTrack(this.out, this.nextTrackId++, type, timescale, sampleDuration, sampleSize, se);
        this.tracks.add(track);
        return track;
    }

    public List<AbstractMP4MuxerTrack> getTracks() {
        return this.tracks;
    }

    public void writeHeader() throws IOException {
        MovieBox movie = this.finalizeHeader();
        this.storeHeader(movie);
    }

    public void storeHeader(MovieBox movie) throws IOException {
        long mdatSize = this.out.position() - this.mdatOffset + 8L;
        MP4Util.writeMovie(this.out, movie);
        this.out.position(this.mdatOffset);
        NIOUtils.writeLong(this.out, mdatSize);
    }

    public MovieBox finalizeHeader() throws IOException {
        MovieBox movie = new MovieBox();
        MovieHeaderBox mvhd = this.movieHeader(movie);
        movie.addFirst(mvhd);
        for (AbstractMP4MuxerTrack track : this.tracks) {
            Box trak = track.finish(mvhd);
            if (trak == null) continue;
            movie.add(trak);
        }
        return movie;
    }

    public AbstractMP4MuxerTrack getVideoTrack() {
        for (AbstractMP4MuxerTrack frameMuxer : this.tracks) {
            if (!frameMuxer.isVideo()) continue;
            return frameMuxer;
        }
        return null;
    }

    public AbstractMP4MuxerTrack getTimecodeTrack() {
        for (AbstractMP4MuxerTrack frameMuxer : this.tracks) {
            if (!frameMuxer.isTimecode()) continue;
            return frameMuxer;
        }
        return null;
    }

    public List<AbstractMP4MuxerTrack> getAudioTracks() {
        ArrayList<AbstractMP4MuxerTrack> result = new ArrayList<AbstractMP4MuxerTrack>();
        for (AbstractMP4MuxerTrack frameMuxer : this.tracks) {
            if (!frameMuxer.isAudio()) continue;
            result.add(frameMuxer);
        }
        return result;
    }

    private MovieHeaderBox movieHeader(NodeBox movie) {
        int timescale = this.tracks.get(0).getTimescale();
        long duration = this.tracks.get(0).getTrackTotalDuration();
        AbstractMP4MuxerTrack videoTrack = this.getVideoTrack();
        if (videoTrack != null) {
            timescale = videoTrack.getTimescale();
            duration = videoTrack.getTrackTotalDuration();
        }
        return new MovieHeaderBox(timescale, duration, 1.0f, 1.0f, new Date().getTime(), new Date().getTime(), new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000}, this.nextTrackId);
    }

    public static String lookupFourcc(AudioFormat format) {
        if (format.getSampleSizeInBits() == 16 && !format.isBigEndian()) {
            return "sowt";
        }
        if (format.getSampleSizeInBits() == 24) {
            return "in24";
        }
        throw new IllegalArgumentException("Audio format " + format + " is not supported.");
    }

    public PCMMP4MuxerTrack addUncompressedAudioTrack(AudioFormat format) {
        return this.addTrackForUncompressed(TrackType.SOUND, (int)format.getSampleRate(), 1, (format.getSampleSizeInBits() >> 3) * format.getChannels(), MP4Muxer.audioSampleEntry(MP4Muxer.lookupFourcc(format), 1, format.getSampleSizeInBits() >> 3, format.getChannels(), (int)format.getSampleRate(), format.isBigEndian() ? EndianBox.Endian.BIG_ENDIAN : EndianBox.Endian.LITTLE_ENDIAN));
    }

    public FramesMP4MuxerTrack addCompressedAudioTrack(String fourcc, int timescale, int channels, int sampleRate, int samplesPerPkt, Box ... extra) {
        FramesMP4MuxerTrack track = this.addTrackForCompressed(TrackType.SOUND, timescale);
        AudioSampleEntry ase = new AudioSampleEntry(new Header(fourcc, 0L), 1, (short)channels, 16, sampleRate, 0, 0, 65534, 0, samplesPerPkt, 0, 0, 2, 1);
        NodeBox wave = new NodeBox(new Header("wave"));
        ase.add(wave);
        wave.add(new FormatBox(fourcc));
        for (Box box : extra) {
            wave.add(box);
        }
        wave.add(MP4Muxer.terminatorAtom());
        track.addSampleEntry(ase);
        return track;
    }
}

