/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jcodec.codecs.wav.StringReader;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.NIOUtils;

public class Header {
    private static final long MAX_UNSIGNED_INT = 0x100000000L;
    private String fourcc;
    private long size;
    private boolean lng;

    public Header(String fourcc) {
        this.fourcc = fourcc;
    }

    public Header(String fourcc, long size) {
        this.size = size;
        this.fourcc = fourcc;
    }

    public Header(Header h2) {
        this.fourcc = h2.fourcc;
        this.size = h2.size;
    }

    public Header(String fourcc, long size, boolean lng) {
        this(fourcc, size);
        this.lng = lng;
    }

    public static Header read(ByteBuffer input) {
        long size = 0L;
        while (input.remaining() >= 4 && (size = (long)input.getInt() & 0xFFFFFFFFL) == 0L) {
        }
        if (input.remaining() < 4 || size < 8L && size != 1L) {
            System.out.println("Broken atom of size " + size);
            return null;
        }
        String fourcc = NIOUtils.readString(input, 4);
        boolean lng = false;
        if (size == 1L) {
            if (input.remaining() >= 8) {
                lng = true;
                size = input.getLong();
            } else {
                System.out.println("Broken atom of size " + size);
                return null;
            }
        }
        return new Header(fourcc, size, lng);
    }

    public void print() {
        System.out.println(this.fourcc + "," + this.size);
    }

    public void skip(InputStream di) throws IOException {
        StringReader.sureSkip(di, this.size - this.headerSize());
    }

    public long headerSize() {
        return this.lng || this.size > 0x100000000L ? 16L : 8L;
    }

    public byte[] readContents(InputStream di) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i2 = 0;
        while ((long)i2 < this.size - this.headerSize()) {
            baos.write(di.read());
            ++i2;
        }
        return baos.toByteArray();
    }

    public String getFourcc() {
        return this.fourcc;
    }

    public long getBodySize() {
        return this.size - this.headerSize();
    }

    public void setBodySize(int length) {
        this.size = (long)length + this.headerSize();
    }

    public void write(ByteBuffer out) {
        if (this.size > 0x100000000L) {
            out.putInt(1);
        } else {
            out.putInt((int)this.size);
        }
        out.put(JCodecUtil.asciiString(this.fourcc));
        if (this.size > 0x100000000L) {
            out.putLong(this.size);
        }
    }

    public long getSize() {
        return this.size;
    }
}

