/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.common.Assert;
import org.jcodec.common.NIOUtils;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.NodeBox;

public abstract class Box {
    protected Header header;

    public Box(Header header) {
        this.header = header;
    }

    public Box(Box other) {
        this.header = other.header;
    }

    public Header getHeader() {
        return this.header;
    }

    public abstract void parse(ByteBuffer var1);

    public static Box findFirst(NodeBox box, String ... path) {
        return Box.findFirst(box, Box.class, path);
    }

    public static <T> T findFirst(NodeBox box, Class<T> clazz, String ... path) {
        T[] result = Box.findAll((Box)box, clazz, path);
        return result.length > 0 ? (T)result[0] : null;
    }

    public static Box[] findAll(Box box, String ... path) {
        return Box.findAll(box, Box.class, path);
    }

    private static void findSub(Box box, List<String> path, Collection<Box> result) {
        if (path.size() > 0) {
            String head = path.remove(0);
            if (box instanceof NodeBox) {
                NodeBox nb = (NodeBox)box;
                for (Box candidate : nb.getBoxes()) {
                    if (head != null && !head.equals(candidate.header.getFourcc())) continue;
                    Box.findSub(candidate, path, result);
                }
            }
            path.add(0, head);
        } else {
            result.add(box);
        }
    }

    public static <T> T[] findAll(Box box, Class<T> class1, String ... path) {
        LinkedList<Box> result = new LinkedList<Box>();
        LinkedList<String> tlist = new LinkedList<String>();
        for (String type : path) {
            tlist.add(type);
        }
        Box.findSub(box, tlist, result);
        return result.toArray((Object[])Array.newInstance(class1, 0));
    }

    public void write(ByteBuffer buf) {
        ByteBuffer dup = buf.duplicate();
        NIOUtils.skip(buf, 8);
        this.doWrite(buf);
        this.header.setBodySize(buf.position() - dup.position() - 8);
        Assert.assertEquals(this.header.headerSize(), 8);
        this.header.write(dup);
    }

    protected abstract void doWrite(ByteBuffer var1);

    public String getFourcc() {
        return this.header.getFourcc();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb);
        return sb.toString();
    }

    protected void dump(StringBuilder sb) {
        sb.append("'" + this.header.getFourcc() + "'");
    }

    public static <T extends Box> T as(Class<T> class1, LeafBox box) {
        try {
            Box res = (Box)class1.getConstructor(Header.class).newInstance(box.getHeader());
            res.parse(box.getData());
            return (T)res;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

