/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.util;

public class TLinkedList {
    protected TLinkable _head;
    protected TLinkable _tail;
    protected int _size = 0;

    public boolean isEmpty() {
        return this._size == 0;
    }

    public IteratorImpl first() {
        return this.listIterator();
    }

    public IteratorImpl listIterator() {
        return this.listIterator(0);
    }

    public IteratorImpl listIterator(int index) {
        return new IteratorImpl(index);
    }

    public int size() {
        return this._size;
    }

    public void add(int index, Object linkable) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index:" + index);
        }
        this.insert(index, linkable);
    }

    public boolean add(Object linkable) {
        this.insert(this._size, linkable);
        return true;
    }

    public void addFirst(Object linkable) {
        this.insert(0, linkable);
    }

    public void addLast(Object linkable) {
        this.insert(this.size(), linkable);
    }

    public void clear() {
        if (null != this._head) {
            for (TLinkable link = this._head.getNext(); link != null; link = link.getNext()) {
                TLinkable prev = link.getPrevious();
                prev.setNext(null);
                link.setPrevious(null);
            }
            this._tail = null;
            this._head = null;
        }
        this._size = 0;
    }

    public Object[] toArray() {
        Object[] o2 = new Object[this._size];
        int i2 = 0;
        for (TLinkable link = this._head; link != null; link = link.getNext()) {
            o2[i2++] = link.getValue();
        }
        return o2;
    }

    public Object[] toUnlinkedArray() {
        Object[] o2 = new Object[this._size];
        int i2 = 0;
        TLinkable link = this._head;
        TLinkable tmp = null;
        while (link != null) {
            o2[i2] = link.getValue();
            tmp = link;
            link = link.getNext();
            tmp.setNext(null);
            tmp.setPrevious(null);
            ++i2;
        }
        this._size = 0;
        this._tail = null;
        this._head = null;
        return o2;
    }

    public boolean contains(Object o2) {
        for (TLinkable link = this._head; link != null; link = link.getNext()) {
            if (!o2.equals(link)) continue;
            return true;
        }
        return false;
    }

    public Object getFirst() {
        return this._head != null ? this._head.getValue() : null;
    }

    public Object getLast() {
        return this._tail != null ? this._tail.getValue() : null;
    }

    public Object removeFirst() {
        TLinkable o2 = this._head;
        TLinkable n2 = o2.getNext();
        o2.setNext(null);
        if (null != n2) {
            n2.setPrevious(null);
        }
        this._head = n2;
        if (--this._size == 0) {
            this._tail = null;
        }
        return o2 != null ? o2.getValue() : null;
    }

    public Object removeLast() {
        TLinkable o2 = this._tail;
        TLinkable prev = o2.getPrevious();
        o2.setPrevious(null);
        if (null != prev) {
            prev.setNext(null);
        }
        this._tail = prev;
        if (--this._size == 0) {
            this._head = null;
        }
        return o2 != null ? o2.getValue() : null;
    }

    protected void insert(int index, Object linkable) {
        TLinkable newLink = new TLinkable(linkable);
        if (this._size == 0) {
            this._head = this._tail = newLink;
        } else if (index == 0) {
            newLink.setNext(this._head);
            this._head.setPrevious(newLink);
            this._head = newLink;
        } else if (index == this._size) {
            this._tail.setNext(newLink);
            newLink.setPrevious(this._tail);
            this._tail = newLink;
        } else {
            TLinkable prior = null;
            TLinkable post = null;
            if (index > this._size >> 1) {
                prior = this._tail;
                for (int pos = this._size - 1; pos > index; --pos) {
                    prior = prior.getPrevious();
                }
            } else {
                prior = this._head;
                for (int pos = 0; pos < index; ++pos) {
                    prior = prior.getNext();
                }
            }
            post = prior.getNext();
            newLink.setNext(post);
            newLink.setPrevious(prior);
            post.setPrevious(newLink);
            prior.setNext(newLink);
        }
        ++this._size;
    }

    public boolean remove(Object o2) {
        TLinkable link = null;
        for (link = this._head; link != null && !o2.equals(link); link = link.getNext()) {
        }
        if (link != null) {
            TLinkable p = link.getPrevious();
            TLinkable n2 = link.getNext();
            if (n2 == null && p == null) {
                this._tail = null;
                this._head = null;
            } else if (n2 == null) {
                link.setPrevious(null);
                p.setNext(null);
                this._tail = p;
            } else if (p == null) {
                link.setNext(null);
                n2.setPrevious(null);
                this._head = n2;
            } else {
                p.setNext(n2);
                n2.setPrevious(p);
                link.setNext(null);
                link.setPrevious(null);
            }
            --this._size;
            return true;
        }
        return false;
    }

    public void addBefore(TLinkable current, TLinkable newElement) {
        if (current == this._head) {
            this.addFirst(newElement);
        } else if (current == null) {
            this.addLast(newElement);
        } else {
            TLinkable p = current.getPrevious();
            newElement.setNext(current);
            p.setNext(newElement);
            newElement.setPrevious(p);
            current.setPrevious(newElement);
            ++this._size;
        }
    }

    public class IteratorImpl {
        private int _nextIndex = 0;
        private TLinkable _next;
        private TLinkable _lastReturned;

        IteratorImpl(int position) {
            if (position < 0 || position > TLinkedList.this._size) {
                throw new IndexOutOfBoundsException();
            }
            this._nextIndex = position;
            if (position == 0) {
                this._next = TLinkedList.this._head;
            } else if (position == TLinkedList.this._size) {
                this._next = null;
            } else if (position < TLinkedList.this._size >> 1) {
                this._next = TLinkedList.this._head;
                for (int pos = 0; pos < position; ++pos) {
                    this._next = this._next.getNext();
                }
            } else {
                this._next = TLinkedList.this._tail;
                for (int pos = TLinkedList.this._size - 1; pos > position; --pos) {
                    this._next = this._next.getPrevious();
                }
            }
        }

        public final void add(Object linkable) {
            this._lastReturned = null;
            ++this._nextIndex;
            if (TLinkedList.this._size == 0) {
                TLinkedList.this.add(linkable);
            } else {
                TLinkedList.this.addBefore(this._next, new TLinkable(linkable));
            }
        }

        public final boolean hasNext() {
            return this._nextIndex != TLinkedList.this._size;
        }

        public final boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        public final Object next() {
            if (this._nextIndex == TLinkedList.this._size) {
                throw new IndexOutOfBoundsException("NoSuchElementException");
            }
            this._lastReturned = this._next;
            this._next = this._next.getNext();
            ++this._nextIndex;
            return this._lastReturned != null ? this._lastReturned.getValue() : null;
        }

        public final int nextIndex() {
            return this._nextIndex;
        }

        public final Object previous() {
            if (this._nextIndex == 0) {
                throw new IndexOutOfBoundsException("NoSuchElementException");
            }
            this._lastReturned = this._nextIndex == TLinkedList.this._size ? (this._next = TLinkedList.this._tail) : (this._next = this._next.getPrevious());
            --this._nextIndex;
            return this._lastReturned != null ? this._lastReturned.getValue() : null;
        }

        public final int previousIndex() {
            return this._nextIndex - 1;
        }

        public final void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException("must invoke next or previous before invoking remove");
            }
            if (this._lastReturned != this._next) {
                --this._nextIndex;
            }
            this._next = this._lastReturned.getNext();
            TLinkedList.this.remove(this._lastReturned);
            this._lastReturned = null;
        }

        public final void set(Object linkable) {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            TLinkable l2 = new TLinkable(linkable);
            if (this._lastReturned == TLinkedList.this._head) {
                TLinkedList.this._head = l2;
            }
            if (this._lastReturned == TLinkedList.this._tail) {
                TLinkedList.this._tail = l2;
            }
            this.swap(this._lastReturned, l2);
            this._lastReturned = l2;
        }

        private void swap(TLinkable from, TLinkable to) {
            TLinkable p = from.getPrevious();
            TLinkable n2 = from.getNext();
            if (null != p) {
                to.setPrevious(p);
                p.setNext(to);
            }
            if (null != n2) {
                to.setNext(n2);
                n2.setPrevious(to);
            }
            from.setNext(null);
            from.setPrevious(null);
        }
    }

    class TLinkable {
        protected TLinkable _next;
        protected TLinkable _prev;
        protected Object _value;

        public TLinkable(Object value) {
            this._value = value;
        }

        public TLinkable getNext() {
            return this._next;
        }

        public TLinkable getPrevious() {
            return this._prev;
        }

        public void setNext(TLinkable linkable) {
            this._next = linkable;
        }

        public void setPrevious(TLinkable linkable) {
            this._prev = linkable;
        }

        public void setValue(Object value) {
            this._value = value;
        }

        public Object getValue() {
            return this._value;
        }
    }
}

