/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.elements;

import org.jcodec.containers.mkv.Type;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.MasterElement;
import org.jcodec.containers.mkv.ebml.UnsignedIntegerElement;

public class TrackEntryElement
extends MasterElement {
    private TrackType type;

    public TrackEntryElement(byte[] type) {
        super(type);
    }

    @Override
    public void addChildElement(Element elem) {
        if (elem == null) {
            return;
        }
        if (elem.type.equals((Object)Type.TrackType)) {
            UnsignedIntegerElement trackType = (UnsignedIntegerElement)elem;
            int val = (int)trackType.get();
            switch (val) {
                case 1: {
                    this.type = TrackType.VIDEO;
                    break;
                }
                case 2: {
                    this.type = TrackType.AUDIO;
                    break;
                }
                case 3: {
                    this.type = TrackType.COMPLEX;
                    break;
                }
                case 16: {
                    this.type = TrackType.LOGO;
                    break;
                }
                case 17: {
                    this.type = TrackType.SUBTITLE;
                    break;
                }
                case 18: {
                    this.type = TrackType.BUTTON;
                    break;
                }
                case 32: {
                    this.type = TrackType.CONTROL;
                }
            }
        } else if (elem.type.equals((Object)Type.ContentCompAlgo)) {
            UnsignedIntegerElement trackType = (UnsignedIntegerElement)elem;
            int val = (int)trackType.get();
            String[] algs = new String[]{"zlib", "bzlib", "lzo1x", "headerstripping"};
            System.err.println("Track content compression algorithm: " + (0 <= val && val <= 3 ? algs[val] : ""));
        }
        super.addChildElement(elem);
    }

    public static enum TrackType {
        VIDEO,
        AUDIO,
        COMPLEX,
        LOGO,
        SUBTITLE,
        BUTTON,
        CONTROL;

    }
}

