/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.ebml;

import org.jcodec.containers.mkv.ebml.BinaryElement;

public class UnsignedIntegerElement
extends BinaryElement {
    public UnsignedIntegerElement(byte[] typeID) {
        super(typeID);
    }

    public UnsignedIntegerElement(byte[] typeID, long value) {
        super(typeID);
        this.set(value);
    }

    public void set(long value) {
        this.setData(UnsignedIntegerElement.longToBytes(value));
    }

    public static byte[] longToBytes(long value) {
        byte[] b2 = new byte[UnsignedIntegerElement.getMinByteSizeUnsigned(value)];
        for (int i2 = b2.length - 1; i2 >= 0; --i2) {
            b2[i2] = (byte)(value >>> 8 * (b2.length - i2 - 1));
        }
        return b2;
    }

    public static int getMinByteSizeUnsigned(long value) {
        int size = 8;
        long mask = -72057594037927936L;
        for (int i2 = 0; i2 < 8; ++i2) {
            if ((value & mask) == 0L) {
                mask >>>= 8;
                --size;
                continue;
            }
            return size;
        }
        return 1;
    }

    public long get() {
        long l2 = 0L;
        long tmp = 0L;
        for (int i2 = 0; i2 < this.data.limit(); ++i2) {
            tmp = (long)this.data.get(this.data.limit() - 1 - i2) << 56;
            l2 |= (tmp >>>= 56 - i2 * 8);
        }
        return l2;
    }
}

