/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.ebml;

import java.io.UnsupportedEncodingException;
import org.jcodec.containers.mkv.ebml.BinaryElement;

public class StringElement
extends BinaryElement {
    private String charset = "UTF-8";

    public StringElement(byte[] typeID) {
        super(typeID);
    }

    public StringElement(byte[] typeID, String encoding) {
        super(typeID);
        this.charset = encoding;
    }

    private boolean checkForCharsetHack() {
        if (this.charset.compareTo("UTF-8") == 0) {
            this.charset = "UTF8";
            return true;
        }
        if (this.charset.compareTo("US-ASCII") == 0) {
            this.charset = "ASCII";
            return true;
        }
        return false;
    }

    public String get() {
        try {
            if (this.data == null) {
                throw new IllegalStateException("Call readData() before trying to extract the string value.");
            }
            return new String(this.data.array(), this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            if (this.checkForCharsetHack()) {
                return this.get();
            }
            ex.printStackTrace();
            return "";
        }
    }

    public void set(String value) {
        try {
            this.setData(value.getBytes(this.charset));
        }
        catch (UnsupportedEncodingException ex) {
            if (this.checkForCharsetHack()) {
                this.set(value);
                return;
            }
            ex.printStackTrace();
        }
    }

    public String getEncoding() {
        return this.charset;
    }
}

