/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.ebml;

import java.nio.ByteBuffer;
import org.jcodec.containers.mkv.ebml.BinaryElement;

public class FloatElement
extends BinaryElement {
    public FloatElement(byte[] type) {
        super(type);
    }

    public void set(double value) {
        if (value < 3.4028234663852886E38) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putFloat((float)value);
            bb.flip();
            this.data = bb;
        } else if (value < Double.MAX_VALUE) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putDouble(value);
            bb.flip();
            this.data = bb;
        } else {
            throw new ArithmeticException("80-bit floats are not supported, BTW How did you create such a large float in Java?");
        }
    }

    public double get() {
        if (this.data.limit() == 4) {
            return this.data.duplicate().getFloat();
        }
        if (this.data.limit() == 8) {
            return this.data.duplicate().getDouble();
        }
        throw new ArithmeticException("80-bit floats are not supported");
    }
}

