/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.ebml;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.jcodec.common.Assert;
import org.jcodec.containers.mkv.Type;

public class Element {
    protected Element parent;
    public Type type;
    public byte[] id = new byte[]{0};
    public long size = 0L;
    protected ByteBuffer data;
    protected boolean dataRead = false;
    public long offset;
    public long dataOffset;

    public Element(byte[] type) {
        this.id = type;
    }

    public void readData(FileChannel source) throws IOException {
        try {
            this.data = ByteBuffer.allocate((int)this.size);
            while (source.read(this.data) != -1 && this.data.hasRemaining()) {
            }
            this.dataRead = true;
            this.data.flip();
        }
        catch (OutOfMemoryError oome) {
            System.out.println("OutOfMemoryError while trying to read " + this.size + " bytes for element at " + this.offset);
            throw oome;
        }
    }

    public void skipData(FileChannel source) throws IOException {
        if (!this.dataRead) {
            source.position(this.dataOffset + this.size);
            this.dataRead = true;
        }
    }

    public long getSize() {
        long totalSize = 0L;
        if (this.data != null && this.data.limit() > 0) {
            totalSize += (long)this.data.limit();
            totalSize += (long)Element.getEbmlSize(this.data.limit());
        } else {
            totalSize += this.size;
            totalSize += (long)Element.getEbmlSize(this.size);
        }
        return totalSize += (long)this.id.length;
    }

    public byte[] getId() {
        return this.id;
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }

    public boolean isSameEbmlId(byte[] typeId) {
        return Arrays.equals(this.id, typeId);
    }

    public boolean isSameMatroskaType(Type elemType) {
        return this.isSameEbmlId(elemType.id);
    }

    public long mux(FileChannel os) throws IOException {
        ByteBuffer bb = this.mux();
        return os.write(bb);
    }

    public ByteBuffer mux() {
        int sizeSize = Element.getEbmlSize(this.data.limit());
        ByteBuffer bb = ByteBuffer.allocate(this.id.length + sizeSize + this.data.limit());
        bb.put(this.id);
        byte[] size = Element.ebmlBytes(this.data.limit(), sizeSize);
        bb.put(size);
        Assert.assertEquals((Object)((Object)this.type) + " data seems to be read already or not ready for reading", 0, this.data.position());
        Assert.assertEquals(this.data.capacity(), this.data.limit());
        bb.put(this.data);
        bb.flip();
        this.data.flip();
        return bb;
    }

    public static byte[] ebmlBytes(long value) {
        int size = Element.getEbmlSize(value);
        return Element.ebmlBytes(value, size);
    }

    public static byte[] ebmlBytes(long val, int num) {
        byte[] b2 = new byte[num];
        for (int idx = 0; idx < num; ++idx) {
            b2[num - idx - 1] = (byte)(val >>> 8 * idx & 0xFFL);
        }
        b2[0] = (byte)(b2[0] | 128 >>> num - 1);
        return b2;
    }

    public static int getEbmlSize(long v) {
        int size;
        if (v == 0L) {
            return 1;
        }
        long oneMask = 127L;
        long twoMask = 16256L;
        long threeMask = 2080768L;
        long fourMask = 0xFE00000L;
        long fiveMask = 0x7F0000000L;
        long sixMask = 4363686772736L;
        long sevenMask = 558551906910208L;
        long eightMask = 0xFE000000000000L;
        long[] allMasks = new long[]{0L, oneMask, twoMask, threeMask, fourMask, fiveMask, sixMask, sevenMask, eightMask};
        for (size = 8; size > 0 && (v & allMasks[size]) == 0L; --size) {
        }
        return size;
    }
}

