/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.model;

import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Rect;

public class Picture {
    private ColorSpace color;
    private int width;
    private int height;
    private int[][] data;
    private Rect crop;

    public Picture(int width, int height, int[][] data, ColorSpace color) {
        this(width, height, data, color, new Rect(0, 0, width, height));
    }

    public Picture(int width, int height, int[][] data, ColorSpace color, Rect crop) {
        this.width = width;
        this.height = height;
        this.data = data;
        this.color = color;
        this.crop = crop;
    }

    public Picture(Picture other) {
        this(other.width, other.height, other.data, other.color, other.crop);
    }

    public static Picture create(int width, int height, ColorSpace colorSpace) {
        return Picture.create(width, height, colorSpace, null);
    }

    public static Picture create(int width, int height, ColorSpace colorSpace, Rect crop) {
        int[] planeSizes = new int[4];
        for (int i2 = 0; i2 < colorSpace.nComp; ++i2) {
            int n2 = colorSpace.compPlane[i2];
            planeSizes[n2] = planeSizes[n2] + (width >> colorSpace.compWidth[i2]) * (height >> colorSpace.compHeight[i2]);
        }
        int nPlanes = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            nPlanes += planeSizes[i3] != 0 ? 1 : 0;
        }
        int[][] data = new int[nPlanes][];
        int plane = 0;
        for (int i4 = 0; i4 < 4; ++i4) {
            if (planeSizes[i4] == 0) continue;
            data[plane++] = new int[planeSizes[i4]];
        }
        return new Picture(width, height, data, colorSpace, crop);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getPlaneData(int plane) {
        return this.data[plane];
    }

    public ColorSpace getColor() {
        return this.color;
    }

    public int[][] getData() {
        return this.data;
    }

    public Rect getCrop() {
        return this.crop;
    }

    public int getPlaneWidth(int plane) {
        return this.width >> this.color.compWidth[plane];
    }

    public int getPlaneHeight(int plane) {
        return this.height >> this.color.compHeight[plane];
    }

    public boolean compatible(Picture src) {
        return src.color == this.color && src.width == this.width && src.height == this.height;
    }

    public Picture createCompatible() {
        return Picture.create(this.width, this.height, this.color);
    }

    public void copyFrom(Picture src) {
        if (!this.compatible(src)) {
            throw new IllegalArgumentException("Can not copy to incompatible picture");
        }
        for (int plane = 0; plane < this.color.nComp; ++plane) {
            if (this.data[plane] == null) continue;
            System.arraycopy(src.data[plane], 0, this.data[plane], 0, (this.width >> this.color.compWidth[plane]) * (this.height >> this.color.compHeight[plane]));
        }
    }

    public Picture cropped() {
        if (this.crop == null || this.crop.getX() == 0 && this.crop.getY() == 0 && this.crop.getWidth() == this.width && this.crop.getHeight() == this.height) {
            return this;
        }
        Picture result = Picture.create(this.crop.getWidth(), this.crop.getHeight(), this.color);
        for (int plane = 0; plane < this.color.nComp; ++plane) {
            if (this.data[plane] == null) continue;
            this.cropSub(this.data[plane], this.crop.getX() >> this.color.compWidth[plane], this.crop.getY() >> this.color.compHeight[plane], this.crop.getWidth() >> this.color.compWidth[plane], this.crop.getHeight() >> this.color.compHeight[plane], this.width >> this.color.compWidth[plane], result.data[plane]);
        }
        return result;
    }

    private void cropSub(int[] src, int x, int y, int w, int h2, int srcStride, int[] tgt) {
        int srcOff = y * srcStride + x;
        int dstOff = 0;
        for (int i2 = 0; i2 < h2; ++i2) {
            for (int j2 = 0; j2 < w; ++j2) {
                tgt[dstOff + j2] = src[srcOff + j2];
            }
            srcOff += srcStride;
            dstOff += w;
        }
    }

    public void setCrop(Rect crop) {
        this.crop = crop;
    }

    public int getCroppedWidth() {
        return this.crop == null ? this.width : this.crop.getWidth();
    }

    public int getCroppedHeight() {
        return this.crop == null ? this.height : this.crop.getHeight();
    }
}

