/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.dct;

import org.jcodec.codecs.mjpeg.ImageConvert;
import org.jcodec.common.dct.DCT;

public class SlowDCT
extends DCT {
    public static final SlowDCT INSTANCE = new SlowDCT();
    private static final double rSqrt2 = 1.0 / Math.sqrt(2.0);

    @Override
    public short[] encode(byte[] orig) {
        short[] result = new short[64];
        for (int u = 0; u < 8; ++u) {
            for (int v = 0; v < 8; ++v) {
                float sum = 0.0f;
                for (int i2 = 0; i2 < 8; ++i2) {
                    for (int j2 = 0; j2 < 8; ++j2) {
                        sum = (float)((double)sum + (double)orig[i2 * 8 + j2] * Math.cos(0.39269908169872414 * ((double)i2 + 0.5) * (double)u) * Math.cos(0.39269908169872414 * ((double)j2 + 0.5) * (double)v));
                    }
                }
                result[u * 8 + v] = (byte)sum;
            }
        }
        result[0] = (byte)((float)result[0] / 8.0f);
        double sqrt2 = Math.sqrt(2.0);
        for (int i3 = 1; i3 < 8; ++i3) {
            result[i3] = (byte)((double)result[0] * sqrt2 / 8.0);
            result[i3 * 8] = (byte)((double)result[0] * sqrt2 / 8.0);
            for (int j3 = 1; j3 < 8; ++j3) {
                result[i3 * 8 + j3] = (byte)((float)result[0] / 4.0f);
            }
        }
        return result;
    }

    @Override
    public int[] decode(int[] orig) {
        int[] res = new int[64];
        int i2 = 0;
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                double sum = 0.0;
                int pixOffset = 0;
                for (int u = 0; u < 8; ++u) {
                    double cu = u == 0 ? rSqrt2 : 1.0;
                    for (int v = 0; v < 8; ++v) {
                        double cv = v == 0 ? rSqrt2 : 1.0;
                        double svu = orig[pixOffset];
                        double c1 = (double)((2 * x + 1) * v) * Math.PI / 16.0;
                        double c2 = (double)((2 * y + 1) * u) * Math.PI / 16.0;
                        sum += cu * cv * svu * Math.cos(c1) * Math.cos(c2);
                        ++pixOffset;
                    }
                }
                sum *= 0.25;
                sum = Math.round(sum + 128.0);
                int isum = (int)sum;
                res[i2++] = ImageConvert.icrop(isum);
            }
        }
        return res;
    }
}

