/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.dct;

public class DCTRef {
    static double[] coefficients = new double[64];

    public static void fdct(int[] block, int off) {
        int k2;
        double tmp;
        int j2;
        int i2;
        double[] out = new double[64];
        for (i2 = 0; i2 < 64; i2 += 8) {
            for (j2 = 0; j2 < 8; ++j2) {
                tmp = 0.0;
                for (k2 = 0; k2 < 8; ++k2) {
                    tmp += coefficients[i2 + k2] * (double)block[k2 * 8 + j2 + off];
                }
                out[i2 + j2] = tmp * 4.0;
            }
        }
        for (j2 = 0; j2 < 8; ++j2) {
            for (i2 = 0; i2 < 64; i2 += 8) {
                tmp = 0.0;
                for (k2 = 0; k2 < 8; ++k2) {
                    tmp += out[i2 + k2] * coefficients[j2 * 8 + k2];
                }
                block[i2 + j2 + off] = (int)(tmp + 0.499999999999);
            }
        }
    }

    public static void idct(int[] block, int off) {
        int k2;
        double tmp;
        int j2;
        int i2;
        double[] out = new double[64];
        for (i2 = 0; i2 < 64; i2 += 8) {
            for (j2 = 0; j2 < 8; ++j2) {
                tmp = 0.0;
                for (k2 = 0; k2 < 8; ++k2) {
                    tmp += (double)block[i2 + k2] * coefficients[k2 * 8 + j2];
                }
                out[i2 + j2] = tmp;
            }
        }
        for (i2 = 0; i2 < 8; ++i2) {
            for (j2 = 0; j2 < 8; ++j2) {
                tmp = 0.0;
                for (k2 = 0; k2 < 64; k2 += 8) {
                    tmp += coefficients[k2 + i2] * out[k2 + j2];
                }
                block[i2 * 8 + j2] = (int)(tmp + 0.5);
            }
        }
    }

    static {
        for (int j2 = 0; j2 < 8; ++j2) {
            DCTRef.coefficients[j2] = Math.sqrt(0.125);
            for (int i2 = 8; i2 < 64; i2 += 8) {
                DCTRef.coefficients[i2 + j2] = 0.5 * Math.cos((double)i2 * ((double)j2 + 0.5) * Math.PI / 64.0);
            }
        }
    }
}

