/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.mpeg12.MPEGDecoder;
import org.jcodec.codecs.ppm.PPMEncoder;
import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.PriorityCallable;
import org.jcodec.common.PriorityFuture;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;
import org.jcodec.containers.mps.MPSDemuxer;
import org.jcodec.containers.mps.MTSDemuxer;
import org.jcodec.scale.AWTUtil;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform;

public class JCodecUtil {
    private static final VideoDecoder[] knownDecoders = new VideoDecoder[]{new ProresDecoder(), new MPEGDecoder(), new H264Decoder()};

    public static Format detectFormat(File f2) throws IOException {
        return JCodecUtil.detectFormat(NIOUtils.fetchFrom(f2, 204800));
    }

    public static Format detectFormat(ByteBuffer b2) {
        int movScore = MP4Demuxer.probe(b2.duplicate());
        int psScore = MPSDemuxer.probe(b2.duplicate());
        int tsScore = MTSDemuxer.probe(b2.duplicate());
        if (movScore == 0 && psScore == 0 && tsScore == 0) {
            return null;
        }
        return movScore > psScore ? (movScore > tsScore ? Format.MOV : Format.MPEG_TS) : (psScore > tsScore ? Format.MPEG_PS : Format.MPEG_TS);
    }

    public static VideoDecoder detectDecoder(ByteBuffer b2) {
        int maxProbe = 0;
        VideoDecoder selected = null;
        for (VideoDecoder vd : knownDecoders) {
            int probe = vd.probe(b2);
            if (probe <= maxProbe) continue;
            selected = vd;
            maxProbe = probe;
        }
        return selected;
    }

    public static VideoDecoder getVideoDecoder(String fourcc) {
        if ("apch".equals(fourcc) || "apcs".equals(fourcc) || "apco".equals(fourcc) || "apcn".equals(fourcc) || "ap4h".equals(fourcc)) {
            return new ProresDecoder();
        }
        if ("m2v1".equals(fourcc)) {
            return new MPEGDecoder();
        }
        return null;
    }

    public static void savePicture(Picture pic, String format, File file) throws IOException {
        ImageIO.write((RenderedImage)JCodecUtil.toBufferedImage(pic), format, file);
    }

    public static BufferedImage toBufferedImage(Picture pic) {
        Transform transform = ColorUtil.getTransform(pic.getColor(), ColorSpace.RGB);
        Picture rgb = Picture.create(pic.getWidth(), pic.getHeight(), ColorSpace.RGB);
        transform.transform(pic, rgb);
        BufferedImage bi = AWTUtil.toBufferedImage(rgb);
        return bi;
    }

    public static void savePictureAsPPM(Picture pic, File file) throws IOException {
        Transform transform = ColorUtil.getTransform(pic.getColor(), ColorSpace.RGB);
        Picture rgb = Picture.create(pic.getWidth(), pic.getHeight(), ColorSpace.RGB);
        transform.transform(pic, rgb);
        NIOUtils.writeTo(new PPMEncoder().encodeFrame(rgb), file);
    }

    public static byte[] asciiString(String fourcc) {
        char[] ch = fourcc.toCharArray();
        byte[] result = new byte[ch.length];
        for (int i2 = 0; i2 < ch.length; ++i2) {
            result[i2] = (byte)ch[i2];
        }
        return result;
    }

    public static void writeBER32(ByteBuffer buffer, int value) {
        buffer.put((byte)(value >> 21 | 0x80));
        buffer.put((byte)(value >> 14 | 0x80));
        buffer.put((byte)(value >> 7 | 0x80));
        buffer.put((byte)(value & 0x7F));
    }

    public static int readBER32(ByteBuffer input) {
        int size = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            byte b2 = input.get();
            size = size << 7 | b2 & 0x7F;
            if ((b2 & 0xFF) >> 7 == 0) break;
        }
        return size;
    }

    public static int[] getAsIntArray(ByteBuffer yuv, int size) {
        byte[] b2 = new byte[size];
        int[] result = new int[size];
        yuv.get(b2);
        for (int i2 = 0; i2 < b2.length; ++i2) {
            result[i2] = b2[i2] & 0xFF;
        }
        return result;
    }

    public static ThreadPoolExecutor getPriorityExecutor(int nThreads) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(10, PriorityFuture.COMP)){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                RunnableFuture<T> newTaskFor = super.newTaskFor(callable);
                return new PriorityFuture<T>(newTaskFor, ((PriorityCallable)callable).getPriority());
            }
        };
    }

    public static String removeExtension(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("\\.[^\\.]+$", "");
    }

    public static enum Format {
        MOV,
        MPEG_PS,
        MPEG_TS;

    }
}

