/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.s302;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import org.jcodec.common.AudioDecoder;
import org.jcodec.common.model.AudioBuffer;
import org.jcodec.common.tools.MathUtil;

public class S302MDecoder
implements AudioDecoder {
    public static int SAMPLE_RATE = 48000;

    @Override
    public AudioBuffer decodeFrame(ByteBuffer frame, ByteBuffer dst) {
        frame.order(ByteOrder.BIG_ENDIAN);
        ByteBuffer dup = dst.duplicate();
        int h2 = frame.getInt();
        int frameSize = h2 >> 16 & 0xFFFF;
        if (frame.remaining() != frameSize) {
            throw new IllegalArgumentException("Wrong s302m frame");
        }
        int channels = (h2 >> 14 & 3) * 2 + 2;
        int sampleSizeInBits = (h2 >> 4 & 3) * 4 + 16;
        if (sampleSizeInBits == 24) {
            int nSamples = frame.remaining() / 7 * 2;
            while (frame.remaining() > 6) {
                byte c2 = (byte)MathUtil.reverse(frame.get() & 0xFF);
                byte b2 = (byte)MathUtil.reverse(frame.get() & 0xFF);
                byte a2 = (byte)MathUtil.reverse(frame.get() & 0xFF);
                int g2 = MathUtil.reverse(frame.get() & 0xF);
                int f2 = MathUtil.reverse(frame.get() & 0xFF);
                int e2 = MathUtil.reverse(frame.get() & 0xFF);
                int d2 = MathUtil.reverse(frame.get() & 0xF0);
                dup.put(a2);
                dup.put(b2);
                dup.put(c2);
                dup.put((byte)(d2 << 4 | e2 >> 4));
                dup.put((byte)(e2 << 4 | f2 >> 4));
                dup.put((byte)(f2 << 4 | g2 >> 4));
            }
            dup.flip();
            return new AudioBuffer(dup, new AudioFormat(SAMPLE_RATE, 24, channels, true, true), nSamples / channels);
        }
        if (sampleSizeInBits == 20) {
            int nSamples = frame.remaining() / 6 * 2;
            while (frame.remaining() > 5) {
                int c3 = MathUtil.reverse(frame.get() & 0xFF);
                int b3 = MathUtil.reverse(frame.get() & 0xFF);
                int a3 = MathUtil.reverse(frame.get() & 0xF0);
                dup.put((byte)(a3 << 4 | b3 >> 4));
                dup.put((byte)(b3 << 4 | c3 >> 4));
                dup.put((byte)(c3 << 4));
                int cc = MathUtil.reverse(frame.get() & 0xFF);
                int bb = MathUtil.reverse(frame.get() & 0xFF);
                int aa = MathUtil.reverse(frame.get() & 0xF0);
                dup.put((byte)(aa << 4 | bb >> 4));
                dup.put((byte)(bb << 4 | cc >> 4));
                dup.put((byte)(cc << 4));
            }
            dup.flip();
            return new AudioBuffer(dup, new AudioFormat(SAMPLE_RATE, 24, channels, true, true), nSamples / channels);
        }
        int nSamples = frame.remaining() / 5 * 2;
        while (frame.remaining() > 4) {
            byte bb = (byte)MathUtil.reverse(frame.get() & 0xFF);
            byte aa = (byte)MathUtil.reverse(frame.get() & 0xFF);
            int c4 = MathUtil.reverse(frame.get() & 0xFF);
            int b4 = MathUtil.reverse(frame.get() & 0xFF);
            int a4 = MathUtil.reverse(frame.get() & 0xF0);
            dst.put(aa);
            dst.put(bb);
            dst.put((byte)(a4 << 4 | b4 >> 4));
            dst.put((byte)(b4 << 4 | c4 >> 4));
        }
        dup.flip();
        return new AudioBuffer(dup, new AudioFormat(SAMPLE_RATE, 16, channels, true, true), nSamples / channels);
    }
}

