/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg12.bitstream;

import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;

public class SequenceExtension {
    public static final int Chroma420 = 1;
    public static final int Chroma422 = 2;
    public static final int Chroma444 = 3;
    public int profile_and_level;
    public int progressive_sequence;
    public int chroma_format;
    public int horizontal_size_extension;
    public int vertical_size_extension;
    public int bit_rate_extension;
    public int vbv_buffer_size_extension;
    public int low_delay;
    public int frame_rate_extension_n;
    public int frame_rate_extension_d;

    public static SequenceExtension read(BitReader in) {
        SequenceExtension se = new SequenceExtension();
        se.profile_and_level = in.readNBit(8);
        se.progressive_sequence = in.read1Bit();
        se.chroma_format = in.readNBit(2);
        se.horizontal_size_extension = in.readNBit(2);
        se.vertical_size_extension = in.readNBit(2);
        se.bit_rate_extension = in.readNBit(12);
        se.vbv_buffer_size_extension = in.readNBit(8);
        se.low_delay = in.read1Bit();
        se.frame_rate_extension_n = in.readNBit(2);
        se.frame_rate_extension_d = in.readNBit(5);
        return se;
    }

    public void write(BitWriter out) {
        out.writeNBit(this.profile_and_level, 8);
        out.write1Bit(this.progressive_sequence);
        out.writeNBit(this.chroma_format, 2);
        out.writeNBit(this.horizontal_size_extension, 2);
        out.writeNBit(this.vertical_size_extension, 2);
        out.writeNBit(this.bit_rate_extension, 12);
        out.write1Bit(1);
        out.writeNBit(this.vbv_buffer_size_extension, 8);
        out.write1Bit(this.low_delay);
        out.writeNBit(this.frame_rate_extension_n, 2);
        out.writeNBit(this.frame_rate_extension_d, 5);
    }
}

