/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg12.bitstream;

import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;

public class SequenceDisplayExtension {
    public int video_format;
    public int display_horizontal_size;
    public int display_vertical_size;
    public ColorDescription colorDescription;

    public static SequenceDisplayExtension read(BitReader in) {
        SequenceDisplayExtension sde = new SequenceDisplayExtension();
        sde.video_format = in.readNBit(3);
        if (in.read1Bit() == 1) {
            sde.colorDescription = ColorDescription.read(in);
        }
        sde.display_horizontal_size = in.readNBit(14);
        in.read1Bit();
        sde.display_vertical_size = in.readNBit(14);
        return sde;
    }

    public void write(BitWriter out) {
        out.writeNBit(this.video_format, 3);
        out.write1Bit(this.colorDescription != null ? 1 : 0);
        if (this.colorDescription != null) {
            this.colorDescription.write(out);
        }
        out.writeNBit(this.display_horizontal_size, 14);
        out.write1Bit(1);
        out.writeNBit(this.display_vertical_size, 14);
    }

    public static class ColorDescription {
        int colour_primaries;
        int transfer_characteristics;
        int matrix_coefficients;

        public static ColorDescription read(BitReader in) {
            ColorDescription cd = new ColorDescription();
            cd.colour_primaries = in.readNBit(8);
            cd.transfer_characteristics = in.readNBit(8);
            cd.matrix_coefficients = in.readNBit(8);
            return cd;
        }

        public void write(BitWriter out) {
            out.writeNBit(this.colour_primaries, 8);
            out.writeNBit(this.transfer_characteristics, 8);
            out.writeNBit(this.matrix_coefficients, 8);
        }
    }
}

