/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mjpeg;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.codecs.mjpeg.CodedImage;
import org.jcodec.codecs.mjpeg.MCU;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.VLC;

public class JPEGBitStream {
    private VLC huffYDC;
    private VLC huffCDC;
    private VLC huffYAC;
    private VLC huffCAC;
    private BitReader in;
    private final int[] prevLumDC = new int[1];
    private final int[] prevCbDC = new int[1];
    private final int[] prevCrDC = new int[1];

    public JPEGBitStream(CodedImage coded) {
        this(coded, ByteBuffer.wrap(coded.getData()));
    }

    public JPEGBitStream(CodedImage coded, ByteBuffer b2) {
        this.in = new BitReader(b2);
        this.huffYDC = coded.getYdc();
        this.huffCDC = coded.getCdc();
        this.huffYAC = coded.getYac();
        this.huffCAC = coded.getCac();
    }

    public MCU readBlock(MCU block) throws IOException {
        int i2;
        block.clear();
        for (i2 = 0; i2 < block.lum.data.length; ++i2) {
            this.readDCValue(block.lum.data[i2], this.prevLumDC, this.huffYDC);
            this.readACValues(block.lum.data[i2], this.huffYAC);
        }
        for (i2 = 0; i2 < block.cb.data.length; ++i2) {
            this.readDCValue(block.cb.data[i2], this.prevCbDC, this.huffCDC);
            this.readACValues(block.cb.data[i2], this.huffCAC);
        }
        for (i2 = 0; i2 < block.cr.data.length; ++i2) {
            this.readDCValue(block.cr.data[i2], this.prevCrDC, this.huffCDC);
            this.readACValues(block.cr.data[i2], this.huffCAC);
        }
        return block;
    }

    public void readDCValue(int[] target, int[] prevDC, VLC table) {
        int code = table.readVLC(this.in);
        if (code != 0) {
            target[0] = this.toValue(this.in.readNBit(code), code);
            target[0] = target[0] + prevDC[0];
            prevDC[0] = target[0];
        } else {
            target[0] = prevDC[0];
        }
    }

    public void readACValues(int[] target, VLC table) throws IOException {
        int code;
        int curOff = 1;
        do {
            if ((code = table.readVLC(this.in)) == 240) {
                curOff += 16;
                continue;
            }
            if (code <= 0) continue;
            int rle = code >> 4;
            int len = code & 0xF;
            target[curOff += rle] = this.toValue(this.in.readNBit(len), len);
            ++curOff;
        } while (code != 0 && curOff < 64);
    }

    public final int toValue(int raw, int length) {
        return length >= 1 && raw < 1 << length - 1 ? -(1 << length) + 1 + raw : raw;
    }
}

