/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mjpeg;

import java.io.IOException;
import java.io.InputStream;

public class FrameHeader {
    int lf;
    int p;
    int y;
    int x;
    int nf;
    Component[] components;

    public int getHmax() {
        int max = 0;
        for (Component c2 : this.components) {
            max = Math.max(max, c2.h);
        }
        return max;
    }

    public int getVmax() {
        int max = 0;
        for (Component c2 : this.components) {
            max = Math.max(max, c2.v);
        }
        return max;
    }

    public static FrameHeader read(InputStream is) throws IOException {
        FrameHeader frame = new FrameHeader();
        frame.lf = FrameHeader.readShort(is);
        frame.p = is.read();
        frame.y = FrameHeader.readShort(is);
        frame.x = FrameHeader.readShort(is);
        frame.nf = is.read();
        frame.components = new Component[frame.nf];
        for (int i2 = 0; i2 < frame.components.length; ++i2) {
            Component c2 = frame.components[i2] = new Component();
            c2.ci = is.read();
            int hv = is.read();
            c2.h = (hv & 0xF0) >>> 4;
            c2.v = hv & 0xF;
            c2.tq = is.read();
        }
        return frame;
    }

    private static int readShort(InputStream is) throws IOException {
        int b1 = is.read();
        int b2 = is.read();
        return (b1 << 8) + b2;
    }

    public static class Component {
        int ci;
        int h;
        int v;
        int tq;
    }
}

