/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.io.write;

import org.jcodec.common.io.BitWriter;
import org.jcodec.common.tools.Debug;
import org.jcodec.common.tools.MathUtil;

public class CAVLCWriter {
    private CAVLCWriter() {
    }

    public static void writeU(BitWriter out, int value, int n2, String string) {
        Debug.print(string + "\t");
        out.writeNBit(value, n2);
        Debug.println("\t" + value);
    }

    public static void writeUE(BitWriter out, int value) {
        int bits = 0;
        int cumul = 0;
        for (int i2 = 0; i2 < 15; ++i2) {
            if (value < cumul + (1 << i2)) {
                bits = i2;
                break;
            }
            cumul += 1 << i2;
        }
        out.writeNBit(0, bits);
        out.write1Bit(1);
        out.writeNBit(value - cumul, bits);
    }

    public static void writeSE(BitWriter out, int value) {
        CAVLCWriter.writeUE(out, MathUtil.golomb(value));
    }

    public static void writeUE(BitWriter out, int value, String string) {
        Debug.print(string + "\t");
        CAVLCWriter.writeUE(out, value);
        Debug.println("\t" + value);
    }

    public static void writeSE(BitWriter out, int value, String string) {
        Debug.print(string + "\t");
        CAVLCWriter.writeUE(out, MathUtil.golomb(value));
        Debug.println("\t" + value);
    }

    public static void writeBool(BitWriter out, boolean value, String string) {
        Debug.print(string + "\t");
        out.write1Bit(value ? 1 : 0);
        Debug.println("\t" + value);
    }

    public static void writeU(BitWriter out, int i2, int n2) {
        out.writeNBit(i2, n2);
    }

    public static void writeNBit(BitWriter out, long value, int n2, String string) {
        Debug.print(string + "\t");
        for (int i2 = 0; i2 < n2; ++i2) {
            out.write1Bit((int)(value >> n2 - i2 - 1) & 1);
        }
        Debug.println("\t" + value);
    }

    public static void writeTrailingBits(BitWriter out) {
        out.write1Bit(1);
        out.flush();
    }

    public static void writeSliceTrailingBits() {
        throw new IllegalStateException("todo");
    }
}

