/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.common.tools.MathUtil;

public class Intra16x16PredictionBuilder {
    public static void predictWithMode(int predMode, int[] residual, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine, int[] topLeft, int x) {
        switch (predMode) {
            case 0: {
                Intra16x16PredictionBuilder.predictVertical(residual, topAvailable, topLine, x);
                break;
            }
            case 1: {
                Intra16x16PredictionBuilder.predictHorizontal(residual, leftAvailable, leftRow, x);
                break;
            }
            case 2: {
                Intra16x16PredictionBuilder.predictDC(residual, leftAvailable, topAvailable, leftRow, topLine, x);
                break;
            }
            case 3: {
                Intra16x16PredictionBuilder.predictPlane(residual, leftAvailable, topAvailable, leftRow, topLine, topLeft, x);
            }
        }
    }

    public static void predictVertical(int[] residual, boolean topAvailable, int[] topLine, int x) {
        int off = 0;
        for (int j2 = 0; j2 < 16; ++j2) {
            int i2 = 0;
            while (i2 < 16) {
                residual[off] = MathUtil.clip(residual[off] + topLine[x + i2], 0, 255);
                ++i2;
                ++off;
            }
        }
    }

    public static void predictHorizontal(int[] residual, boolean leftAvailable, int[] leftRow, int x) {
        int off = 0;
        for (int j2 = 0; j2 < 16; ++j2) {
            int i2 = 0;
            while (i2 < 16) {
                residual[off] = MathUtil.clip(residual[off] + leftRow[j2], 0, 255);
                ++i2;
                ++off;
            }
        }
    }

    public static void predictDC(int[] residual, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine, int x) {
        int i2;
        int s0;
        if (leftAvailable && topAvailable) {
            s0 = 0;
            for (i2 = 0; i2 < 16; ++i2) {
                s0 += leftRow[i2];
            }
            for (i2 = 0; i2 < 16; ++i2) {
                s0 += topLine[x + i2];
            }
            s0 = s0 + 16 >> 5;
        } else if (leftAvailable) {
            s0 = 0;
            for (i2 = 0; i2 < 16; ++i2) {
                s0 += leftRow[i2];
            }
            s0 = s0 + 8 >> 4;
        } else if (topAvailable) {
            s0 = 0;
            for (i2 = 0; i2 < 16; ++i2) {
                s0 += topLine[x + i2];
            }
            s0 = s0 + 8 >> 4;
        } else {
            s0 = 128;
        }
        for (i2 = 0; i2 < 256; ++i2) {
            residual[i2] = MathUtil.clip(residual[i2] + s0, 0, 255);
        }
    }

    public static void predictPlane(int[] residual, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine, int[] topLeft, int x) {
        int H = 0;
        for (int i2 = 0; i2 < 7; ++i2) {
            H += (i2 + 1) * (topLine[x + 8 + i2] - topLine[x + 6 - i2]);
        }
        H += 8 * (topLine[x + 15] - topLeft[0]);
        int V = 0;
        for (int j2 = 0; j2 < 7; ++j2) {
            V += (j2 + 1) * (leftRow[8 + j2] - leftRow[6 - j2]);
        }
        int c2 = 5 * (V += 8 * (leftRow[15] - topLeft[0])) + 32 >> 6;
        int b2 = 5 * H + 32 >> 6;
        int a2 = 16 * (leftRow[15] + topLine[x + 15]);
        int off = 0;
        for (int j3 = 0; j3 < 16; ++j3) {
            int i3 = 0;
            while (i3 < 16) {
                int val = MathUtil.clip(a2 + b2 * (i3 - 7) + c2 * (j3 - 7) + 16 >> 5, 0, 255);
                residual[off] = MathUtil.clip(residual[off] + val, 0, 255);
                ++i3;
                ++off;
            }
        }
    }
}

