/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

public class Interpolator {
    private static int PADDING = 16;

    public int[] interpolateChroma(int[] src, int width, int height) {
        int refWidth = width << 3;
        int refHeight = height << 3;
        int[] result = new int[refWidth * refHeight];
        for (int j2 = 0; j2 < height; ++j2) {
            for (int i2 = 0; i2 < width; ++i2) {
                for (int y = 0; y < 8; ++y) {
                    for (int x = 0; x < 8; ++x) {
                        int resultOff = ((j2 << 3) + y) * refWidth + (i2 << 3) + x;
                        int w00 = j2 * width + i2;
                        int w01 = w00 + (j2 < height - 1 ? width : 0);
                        int w10 = w00 + (i2 < width - 1 ? 1 : 0);
                        int w11 = w10 + w01 - w00;
                        int eMx = 8 - x;
                        int eMy = 8 - y;
                        result[resultOff] = eMx * eMy * src[w00] + x * eMy * src[w10] + eMx * y * src[w01] + x * y * src[w11] + 32 >> 6;
                    }
                }
            }
        }
        return result;
    }

    public int[] interpolateLuma(int[] src, int width, int height) {
        int refWidth = (width + PADDING * 2) * 4;
        int refHeight = (height + PADDING * 2) * 4;
        int[] result = new int[refWidth * refHeight];
        this.fillFullPel(src, width, height, result);
        this.scanHPelHorizontalWithRound(refWidth, refHeight, result);
        this.scanHPelVertical(refWidth, refHeight, result);
        this.scanHPelCenterWidhRound(refWidth, refHeight, result);
        this.roundHPelVertical(refWidth, refHeight, result);
        this.scanQPel(refWidth, refHeight, result);
        return result;
    }

    protected void scanQPel(int width, int height, int[] result) {
        for (int j2 = 0; j2 < height; j2 += 2) {
            for (int i2 = 0; i2 < width; i2 += 2) {
                int rightHpel;
                int pos = j2 * width + i2;
                int bottomHpel = j2 < height - 2 ? result[pos + 2 * width] : result[pos];
                int n2 = rightHpel = i2 < width - 2 ? result[pos + 2] : result[pos];
                int rightBottomHpel = j2 < height - 2 && i2 < width - 2 ? result[pos + 2 * width + 2] : (j2 < height - 2 ? result[pos + 2 * width] : (i2 < width - 2 ? result[pos + 2] : result[pos]));
                result[pos + width] = result[pos] + bottomHpel + 1 >> 1;
                result[pos + 1] = result[pos] + rightHpel + 1 >> 1;
                result[pos + width + 1] = i2 % 4 == j2 % 4 ? rightHpel + bottomHpel + 1 >> 1 : result[pos] + rightBottomHpel + 1 >> 1;
            }
        }
    }

    protected void fillFullPel(int[] src, int width, int height, int[] result) {
        int x;
        int i2;
        int y;
        int j2;
        int stride = (width + PADDING * 2) * 4;
        for (j2 = 0; j2 < height; ++j2) {
            y = (j2 + PADDING) * 4;
            for (i2 = 0; i2 < width; ++i2) {
                x = (i2 + PADDING) * 4;
                result[y * stride + x] = src[j2 * width + i2];
            }
            for (i2 = 0; i2 < PADDING; ++i2) {
                x = i2 * 4;
                result[y * stride + x] = src[j2 * width];
            }
            for (i2 = width + PADDING; i2 < width + PADDING * 2; ++i2) {
                x = i2 * 4;
                result[y * stride + x] = src[j2 * width + width - 1];
            }
        }
        for (j2 = 0; j2 < PADDING; ++j2) {
            y = j2 * 4;
            for (i2 = 0; i2 < width; ++i2) {
                x = (i2 + PADDING) * 4;
                result[y * stride + x] = src[i2];
            }
            for (i2 = 0; i2 < PADDING; ++i2) {
                x = i2 * 4;
                result[y * stride + x] = src[0];
            }
            for (i2 = width + PADDING; i2 < width + PADDING * 2; ++i2) {
                x = i2 * 4;
                result[y * stride + x] = src[width - 1];
            }
        }
        for (j2 = height + PADDING; j2 < height + PADDING * 2; ++j2) {
            y = j2 * 4;
            for (i2 = 0; i2 < width; ++i2) {
                x = (i2 + PADDING) * 4;
                result[y * stride + x] = src[(height - 1) * width + i2];
            }
            for (i2 = 0; i2 < PADDING; ++i2) {
                x = i2 * 4;
                result[y * stride + x] = src[(height - 1) * width];
            }
            for (i2 = width + PADDING; i2 < width + PADDING * 2; ++i2) {
                x = i2 * 4;
                result[y * stride + x] = src[(height - 1) * width + width - 1];
            }
        }
    }

    protected void scanHPelVertical(int width, int height, int[] result) {
        for (int i2 = 0; i2 < width; i2 += 4) {
            int E = result[i2];
            int F2 = result[i2];
            int G = result[i2];
            int H = result[i2 + 4 * width];
            int I = result[i2 + 8 * width];
            int J = result[i2 + 12 * width];
            for (int j2 = 0; j2 < height; j2 += 4) {
                int val;
                result[(j2 + 2) * width + i2] = val = E - 5 * F2 + 20 * G + 20 * H - 5 * I + J;
                E = F2;
                F2 = G;
                G = H;
                H = I;
                I = J;
                int nextPix = j2 + 16;
                if (nextPix >= height) continue;
                J = result[nextPix * width + i2];
            }
        }
    }

    protected void roundHPelVertical(int width, int height, int[] result) {
        for (int i2 = 0; i2 < width; i2 += 4) {
            for (int j2 = 0; j2 < height; j2 += 4) {
                result[(j2 + 2) * width + i2] = this.roundAndClip32(result[(j2 + 2) * width + i2]);
            }
        }
    }

    protected void scanHPelHorizontalWithRound(int width, int height, int[] result) {
        for (int j2 = 0; j2 < height; j2 += 4) {
            int lineStart = j2 * width;
            int E = result[lineStart];
            int F2 = result[lineStart];
            int G = result[lineStart];
            int H = result[lineStart + 4];
            int I = result[lineStart + 8];
            int J = result[lineStart + 12];
            for (int i2 = 0; i2 < width; i2 += 4) {
                int val = E - 5 * F2 + 20 * G + 20 * H - 5 * I + J;
                result[lineStart + i2 + 2] = this.roundAndClip32(val);
                E = F2;
                F2 = G;
                G = H;
                H = I;
                I = J;
                int nextPix = i2 + 16;
                if (nextPix >= width) continue;
                J = result[lineStart + nextPix];
            }
        }
    }

    protected void scanHPelCenterWidhRound(int width, int height, int[] result) {
        for (int j2 = 0; j2 < height; j2 += 4) {
            int lineStart = (j2 + 2) * width;
            int E = result[lineStart];
            int F2 = result[lineStart];
            int G = result[lineStart];
            int H = result[lineStart + 4];
            int I = result[lineStart + 8];
            int J = result[lineStart + 12];
            for (int i2 = 0; i2 < width; i2 += 4) {
                int val = E - 5 * F2 + 20 * G + 20 * H - 5 * I + J;
                result[lineStart + i2 + 2] = this.roundAndClip1024(val);
                E = F2;
                F2 = G;
                G = H;
                H = I;
                I = J;
                int nextPix = i2 + 16;
                if (nextPix >= width) continue;
                J = result[lineStart + nextPix];
            }
        }
    }

    private int roundAndClip32(int val) {
        val = (val = val + 16 >> 5) < 0 ? 0 : (val > 255 ? 255 : val);
        return val;
    }

    private int roundAndClip1024(int val) {
        val = (val = val + 512 >> 10) < 0 ? 0 : (val > 255 ? 255 : val);
        return val;
    }
}

