/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.common.tools.MathUtil;

public class ChromaPredictionBuilder {
    public static void predictWithMode(int[] planeData, int chromaMode, int mbX, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine, int[] topLeft) {
        switch (chromaMode) {
            case 0: {
                ChromaPredictionBuilder.predictDC(planeData, mbX, leftAvailable, topAvailable, leftRow, topLine);
                break;
            }
            case 1: {
                ChromaPredictionBuilder.predictHorizontal(planeData, mbX, leftAvailable, leftRow);
                break;
            }
            case 2: {
                ChromaPredictionBuilder.predictVertical(planeData, mbX, topAvailable, topLine);
                break;
            }
            case 3: {
                ChromaPredictionBuilder.predictPlane(planeData, mbX, leftAvailable, topAvailable, leftRow, topLine, topLeft);
            }
        }
    }

    public static void predictDC(int[] planeData, int mbX, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine) {
        ChromaPredictionBuilder.predictDCInside(planeData, 0, 0, mbX, leftAvailable, topAvailable, leftRow, topLine);
        ChromaPredictionBuilder.predictDCTopBorder(planeData, 1, 0, mbX, leftAvailable, topAvailable, leftRow, topLine);
        ChromaPredictionBuilder.predictDCLeftBorder(planeData, 0, 1, mbX, leftAvailable, topAvailable, leftRow, topLine);
        ChromaPredictionBuilder.predictDCInside(planeData, 1, 1, mbX, leftAvailable, topAvailable, leftRow, topLine);
    }

    public static void predictVertical(int[] planeData, int mbX, boolean topAvailable, int[] topLine) {
        int off = 0;
        for (int j2 = 0; j2 < 8; ++j2) {
            int i2 = 0;
            while (i2 < 8) {
                planeData[off] = MathUtil.clip(planeData[off] + topLine[(mbX << 3) + i2], 0, 255);
                ++i2;
                ++off;
            }
        }
    }

    public static void predictHorizontal(int[] planeData, int mbX, boolean leftAvailable, int[] leftRow) {
        int off = 0;
        for (int j2 = 0; j2 < 8; ++j2) {
            int i2 = 0;
            while (i2 < 8) {
                planeData[off] = MathUtil.clip(planeData[off] + leftRow[j2], 0, 255);
                ++i2;
                ++off;
            }
        }
    }

    public static void predictDCInside(int[] planeData, int blkX, int blkY, int mbX, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine) {
        int i2;
        int s0;
        int blkOffX = (blkX << 2) + (mbX << 3);
        int blkOffY = blkY << 2;
        if (leftAvailable && topAvailable) {
            s0 = 0;
            for (i2 = 0; i2 < 4; ++i2) {
                s0 += leftRow[i2 + blkOffY];
            }
            for (i2 = 0; i2 < 4; ++i2) {
                s0 += topLine[blkOffX + i2];
            }
            s0 = s0 + 4 >> 3;
        } else if (leftAvailable) {
            s0 = 0;
            for (i2 = 0; i2 < 4; ++i2) {
                s0 += leftRow[blkOffY + i2];
            }
            s0 = s0 + 2 >> 2;
        } else if (topAvailable) {
            s0 = 0;
            for (i2 = 0; i2 < 4; ++i2) {
                s0 += topLine[blkOffX + i2];
            }
            s0 = s0 + 2 >> 2;
        } else {
            s0 = 128;
        }
        int off = (blkY << 5) + (blkX << 2);
        int j2 = 0;
        while (j2 < 4) {
            planeData[off] = MathUtil.clip(planeData[off] + s0, 0, 255);
            planeData[off + 1] = MathUtil.clip(planeData[off + 1] + s0, 0, 255);
            planeData[off + 2] = MathUtil.clip(planeData[off + 2] + s0, 0, 255);
            planeData[off + 3] = MathUtil.clip(planeData[off + 3] + s0, 0, 255);
            ++j2;
            off += 8;
        }
    }

    public static void predictDCTopBorder(int[] planeData, int blkX, int blkY, int mbX, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine) {
        int i2;
        int s1;
        int blkOffX = (blkX << 2) + (mbX << 3);
        int blkOffY = blkY << 2;
        if (topAvailable) {
            s1 = 0;
            for (i2 = 0; i2 < 4; ++i2) {
                s1 += topLine[blkOffX + i2];
            }
            s1 = s1 + 2 >> 2;
        } else if (leftAvailable) {
            s1 = 0;
            for (i2 = 0; i2 < 4; ++i2) {
                s1 += leftRow[blkOffY + i2];
            }
            s1 = s1 + 2 >> 2;
        } else {
            s1 = 128;
        }
        int off = (blkY << 5) + (blkX << 2);
        int j2 = 0;
        while (j2 < 4) {
            planeData[off] = MathUtil.clip(planeData[off] + s1, 0, 255);
            planeData[off + 1] = MathUtil.clip(planeData[off + 1] + s1, 0, 255);
            planeData[off + 2] = MathUtil.clip(planeData[off + 2] + s1, 0, 255);
            planeData[off + 3] = MathUtil.clip(planeData[off + 3] + s1, 0, 255);
            ++j2;
            off += 8;
        }
    }

    public static void predictDCLeftBorder(int[] planeData, int blkX, int blkY, int mbX, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine) {
        int i2;
        int s2;
        int blkOffX = (blkX << 2) + (mbX << 3);
        int blkOffY = blkY << 2;
        if (leftAvailable) {
            s2 = 0;
            for (i2 = 0; i2 < 4; ++i2) {
                s2 += leftRow[blkOffY + i2];
            }
            s2 = s2 + 2 >> 2;
        } else if (topAvailable) {
            s2 = 0;
            for (i2 = 0; i2 < 4; ++i2) {
                s2 += topLine[blkOffX + i2];
            }
            s2 = s2 + 2 >> 2;
        } else {
            s2 = 128;
        }
        int off = (blkY << 5) + (blkX << 2);
        int j2 = 0;
        while (j2 < 4) {
            planeData[off] = MathUtil.clip(planeData[off] + s2, 0, 255);
            planeData[off + 1] = MathUtil.clip(planeData[off + 1] + s2, 0, 255);
            planeData[off + 2] = MathUtil.clip(planeData[off + 2] + s2, 0, 255);
            planeData[off + 3] = MathUtil.clip(planeData[off + 3] + s2, 0, 255);
            ++j2;
            off += 8;
        }
    }

    public static void predictPlane(int[] planeData, int mbX, boolean leftAvailable, boolean topAvailable, int[] leftRow, int[] topLine, int[] topLeft) {
        int H = 0;
        int blkOffX = mbX << 3;
        for (int i2 = 0; i2 < 3; ++i2) {
            H += (i2 + 1) * (topLine[blkOffX + 4 + i2] - topLine[blkOffX + 2 - i2]);
        }
        H += 4 * (topLine[blkOffX + 7] - topLeft[0]);
        int V = 0;
        for (int j2 = 0; j2 < 3; ++j2) {
            V += (j2 + 1) * (leftRow[4 + j2] - leftRow[2 - j2]);
        }
        int c2 = 34 * (V += 4 * (leftRow[7] - topLeft[0])) + 32 >> 6;
        int b2 = 34 * H + 32 >> 6;
        int a2 = 16 * (leftRow[7] + topLine[blkOffX + 7]);
        int off = 0;
        for (int j3 = 0; j3 < 8; ++j3) {
            int i3 = 0;
            while (i3 < 8) {
                int val = a2 + b2 * (i3 - 3) + c2 * (j3 - 3) + 16 >> 5;
                planeData[off] = MathUtil.clip(planeData[off] + MathUtil.clip(val, 0, 255), 0, 255);
                ++i3;
                ++off;
            }
        }
    }
}

