/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.aac.blocks;

import org.jcodec.codecs.aac.Profile;
import org.jcodec.codecs.aac.blocks.AACTab;
import org.jcodec.codecs.aac.blocks.Block;
import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.VLC;
import org.jcodec.common.io.VLCBuilder;
import org.jcodec.common.tools.MathUtil;

public class BlockICS
extends Block {
    private boolean commonWindow;
    private boolean scaleFlag;
    private Profile profile;
    private int samplingIndex;
    private static VLC[] spectral;
    private static VLC vlc;
    float[][] ff_aac_codebook_vector_vals = new float[][]{AACTab.codebook_vector0_vals, AACTab.codebook_vector0_vals, AACTab.codebook_vector10_vals, AACTab.codebook_vector10_vals, AACTab.codebook_vector4_vals, AACTab.codebook_vector4_vals, AACTab.codebook_vector10_vals, AACTab.codebook_vector10_vals, AACTab.codebook_vector10_vals, AACTab.codebook_vector10_vals, AACTab.codebook_vector10_vals};
    private static final int MAX_LTP_LONG_SFB = 40;
    private int windowSequence;
    int num_window_groups;
    private int[] group_len = new int[8];
    int maxSfb;
    private int[] band_type = new int[120];
    private int[] band_type_run_end = new int[120];
    private int globalGain;
    static float[] ff_aac_pow2sf_tab;
    private static final int POW_SF2_ZERO = 200;
    private double[] sfs;
    private int numSwb;
    private int[] swbOffset;
    private int numWindows;

    protected int parseICSInfo(BitReader in) {
        in.read1Bit();
        this.windowSequence = in.readNBit(2);
        int useKbWindow = in.read1Bit();
        this.num_window_groups = 1;
        this.group_len[0] = 1;
        if (this.windowSequence == WindowSequence.EIGHT_SHORT_SEQUENCE.ordinal()) {
            int max_sfb = in.readNBit(4);
            for (int i2 = 0; i2 < 7; ++i2) {
                if (in.read1Bit() != 0) {
                    int n2 = this.num_window_groups - 1;
                    this.group_len[n2] = this.group_len[n2] + 1;
                    continue;
                }
                ++this.num_window_groups;
                this.group_len[this.num_window_groups - 1] = 1;
            }
            this.numSwb = AACTab.ff_aac_num_swb_128[this.samplingIndex];
            this.swbOffset = AACTab.ff_swb_offset_128[this.samplingIndex];
            this.numWindows = 8;
        } else {
            this.maxSfb = in.readNBit(6);
            this.numSwb = AACTab.ff_aac_num_swb_1024[this.samplingIndex];
            this.swbOffset = AACTab.ff_swb_offset_1024[this.samplingIndex];
            this.numWindows = 1;
            int predictor_present = in.read1Bit();
            if (predictor_present != 0) {
                if (this.profile == Profile.MAIN) {
                    this.decodePrediction(in, this.maxSfb);
                } else {
                    if (this.profile == Profile.LC) {
                        throw new RuntimeException("Prediction is not allowed in AAC-LC.\n");
                    }
                    int ltpPresent = in.read1Bit();
                    if (ltpPresent != 0) {
                        this.decodeLtp(in, this.maxSfb);
                    }
                }
            }
        }
        return 0;
    }

    private void decodePrediction(BitReader in, int maxSfb) {
        if (in.read1Bit() != 0) {
            int predictorResetGroup = in.readNBit(5);
        }
        for (int sfb = 0; sfb < Math.min(maxSfb, AACTab.maxSfbTab[this.samplingIndex]); ++sfb) {
            in.read1Bit();
        }
    }

    private void decodeLtp(BitReader in, int maxSfb) {
        int lag = in.readNBit(11);
        float coef = AACTab.ltpCoefTab[in.readNBit(3)];
        for (int sfb = 0; sfb < Math.min(maxSfb, 40); ++sfb) {
            in.read1Bit();
        }
    }

    private void decodeBandTypes(BitReader in) {
        int idx = 0;
        int bits = this.windowSequence == WindowSequence.EIGHT_SHORT_SEQUENCE.ordinal() ? 3 : 5;
        for (int g2 = 0; g2 < this.num_window_groups; ++g2) {
            int k2 = 0;
            while (k2 < this.maxSfb) {
                int sect_len_incr;
                int sect_end = k2;
                int sect_band_type = in.readNBit(4);
                if (sect_band_type == 12) {
                    throw new RuntimeException("invalid band type");
                }
                while ((sect_len_incr = in.readNBit(bits)) == (1 << bits) - 1) {
                    sect_end += sect_len_incr;
                }
                sect_end += sect_len_incr;
                if (!in.moreData() || sect_len_incr == (1 << bits) - 1) {
                    throw new RuntimeException("Overread");
                }
                if (sect_end > this.maxSfb) {
                    throw new RuntimeException(String.format("Number of bands (%d) exceeds limit (%d).\n", sect_end, this.maxSfb));
                }
                while (k2 < sect_end) {
                    this.band_type[idx] = sect_band_type;
                    this.band_type_run_end[idx++] = sect_end;
                    ++k2;
                }
            }
        }
    }

    private void decodeScalefactors(BitReader in) {
        int[] offset = new int[]{this.globalGain, this.globalGain - 90, 0};
        int noise_flag = 1;
        String[] sf_str = new String[]{"Global gain", "Noise gain", "Intensity stereo position"};
        int idx = 0;
        for (int g2 = 0; g2 < this.num_window_groups; ++g2) {
            int i2 = 0;
            while (i2 < this.maxSfb) {
                int clipped_offset;
                int run_end = this.band_type_run_end[idx];
                if (this.band_type[idx] == BandType.ZERO_BT.ordinal()) {
                    while (i2 < run_end) {
                        this.sfs[idx] = 0.0;
                        ++i2;
                        ++idx;
                    }
                    continue;
                }
                if (this.band_type[idx] == BandType.INTENSITY_BT.ordinal() || this.band_type[idx] == BandType.INTENSITY_BT2.ordinal()) {
                    while (i2 < run_end) {
                        offset[2] = offset[2] + (vlc.readVLC(in) - 60);
                        clipped_offset = MathUtil.clip(offset[2], -155, 100);
                        if (offset[2] != clipped_offset) {
                            System.out.println(String.format("Intensity stereo position clipped (%d -> %d).\nIf you heard an audible artifact, there may be a bug in the decoder. ", offset[2], clipped_offset));
                        }
                        this.sfs[idx] = ff_aac_pow2sf_tab[-clipped_offset + 200];
                        ++i2;
                        ++idx;
                    }
                    continue;
                }
                if (this.band_type[idx] == BandType.NOISE_BT.ordinal()) {
                    while (i2 < run_end) {
                        offset[1] = noise_flag-- > 0 ? offset[1] + (in.readNBit(9) - 256) : offset[1] + (vlc.readVLC(in) - 60);
                        clipped_offset = MathUtil.clip(offset[1], -100, 155);
                        if (offset[1] != clipped_offset) {
                            System.out.println(String.format("Noise gain clipped (%d -> %d).\nIf you heard an audible artifact, there may be a bug in the decoder. ", offset[1], clipped_offset));
                        }
                        this.sfs[idx] = -ff_aac_pow2sf_tab[clipped_offset + 200];
                        ++i2;
                        ++idx;
                    }
                    continue;
                }
                while (i2 < run_end) {
                    offset[0] = offset[0] + (vlc.readVLC(in) - 60);
                    if (offset[0] > 255) {
                        throw new RuntimeException(String.format("%s (%d) out of range.\n", sf_str[0], offset[0]));
                    }
                    this.sfs[idx] = -ff_aac_pow2sf_tab[offset[0] - 100 + 200];
                    ++i2;
                    ++idx;
                }
            }
        }
    }

    private Pulse decodePulses(BitReader in) {
        int[] pos = new int[4];
        int[] amp = new int[4];
        int numPulse = in.readNBit(2) + 1;
        int pulseSwb = in.readNBit(6);
        if (pulseSwb >= this.numSwb) {
            throw new RuntimeException("pulseSwb >= numSwb");
        }
        pos[0] = this.swbOffset[pulseSwb];
        pos[0] = pos[0] + in.readNBit(5);
        if (pos[0] > 1023) {
            throw new RuntimeException("pos[0] > 1023");
        }
        amp[0] = in.readNBit(4);
        for (int i2 = 1; i2 < numPulse; ++i2) {
            pos[i2] = in.readNBit(5) + pos[i2 - 1];
            if (pos[i2] > 1023) {
                throw new RuntimeException("pos[" + i2 + "] > 1023");
            }
            amp[i2] = in.readNBit(5);
        }
        return new Pulse(numPulse, pos, amp);
    }

    private Tns decodeTns(BitReader in) {
        int is8;
        int n2 = is8 = this.windowSequence == WindowSequence.EIGHT_SHORT_SEQUENCE.ordinal() ? 1 : 0;
        int tns_max_order = is8 != 0 ? 7 : (this.profile == Profile.MAIN ? 20 : 12);
        int[] nFilt = new int[this.numWindows];
        int[][] length = new int[this.numWindows][2];
        int[][] order = new int[this.numWindows][2];
        int[][] direction = new int[this.numWindows][2];
        float[][][] coeff = new float[this.numWindows][2][1 << 5 - 2 * is8];
        for (int w = 0; w < this.numWindows; ++w) {
            nFilt[w] = in.readNBit(2 - is8);
            if (nFilt[w] == 0) continue;
            int coefRes = in.read1Bit();
            for (int filt = 0; filt < nFilt[w]; ++filt) {
                length[w][filt] = in.readNBit(6 - 2 * is8);
                order[w][filt] = in.readNBit(5 - 2 * is8);
                if (order[w][filt] > tns_max_order) {
                    throw new RuntimeException(String.format("TNS filter order %d is greater than maximum %d.\n", order[w][filt], tns_max_order));
                }
                if (order[w][filt] == 0) continue;
                direction[w][filt] = in.read1Bit();
                int coefCompress = in.read1Bit();
                int coefLen = coefRes + 3 - coefCompress;
                int tmp2_idx = 2 * coefCompress + coefRes;
                for (int i2 = 0; i2 < order[w][filt]; ++i2) {
                    coeff[w][filt][i2] = AACTab.tns_tmp2_map[tmp2_idx][in.readNBit(coefLen)];
                }
            }
        }
        return new Tns(nFilt, length, order, direction, coeff);
    }

    void VMUL4(float[] result, int idx, float[] v, int code, float scale) {
        result[idx] = v[code & 3] * scale;
        result[idx + 1] = v[code >> 2 & 3] * scale;
        result[idx + 2] = v[code >> 4 & 3] * scale;
        result[idx + 3] = v[code >> 6 & 3] * scale;
    }

    void VMUL4S(float[] result, int idx, float[] v, int code, int sign, float scale) {
        int nz = code >> 12;
        result[idx + 0] = v[idx & 3] * scale;
        sign <<= nz & 1;
        result[idx + 1] = v[idx >> 2 & 3] * scale;
        sign <<= (nz >>= 1) & 1;
        result[idx + 2] = v[idx >> 4 & 3] * scale;
        sign <<= (nz >>= 1) & 1;
        nz >>= 1;
        result[idx + 3] = v[idx >> 6 & 3] * scale;
    }

    void VMUL2(float[] result, int idx, float[] v, int code, float scale) {
        result[idx] = v[code & 0xF] * scale;
        result[idx + 1] = v[code >> 4 & 0xF] * scale;
    }

    void VMUL2S(float[] result, int idx, float[] v, int code, int sign, float scale) {
        result[idx] = v[code & 0xF] * scale;
        result[idx + 1] = v[code >> 4 & 0xF] * scale;
    }

    private void decodeSpectrum(BitReader in) {
        float[] coef = new float[1024];
        int idx = 0;
        for (int g2 = 0; g2 < this.num_window_groups; ++g2) {
            int i2 = 0;
            while (i2 < this.maxSfb) {
                int cbt_m1 = this.band_type[idx] - 1;
                if (cbt_m1 < BandType.INTENSITY_BT2.ordinal() - 1 && cbt_m1 != BandType.NOISE_BT.ordinal() - 1) {
                    float[] vq = this.ff_aac_codebook_vector_vals[cbt_m1];
                    VLC vlc = spectral[cbt_m1];
                    switch (cbt_m1 >> 1) {
                        case 0: {
                            this.readBandType1And2(in, coef, idx, g2, i2, vq, vlc);
                            break;
                        }
                        case 1: {
                            this.readBandType3And4(in, coef, idx, g2, i2, vq, vlc);
                            break;
                        }
                        case 2: {
                            this.readBandType5And6(in, coef, idx, g2, i2, vq, vlc);
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.readBandType7Through10(in, coef, idx, g2, i2, vq, vlc);
                            break;
                        }
                        default: {
                            this.readOther(in, coef, idx, g2, i2, vq, vlc);
                        }
                    }
                }
                ++i2;
                ++idx;
            }
        }
    }

    private void readBandType3And4(BitReader in, float[] coef, int idx, int g2, int sfb, float[] vq, VLC vlc) {
        int g_len = this.group_len[g2];
        int cfo = this.swbOffset[sfb];
        int off_len = this.swbOffset[sfb + 1] - this.swbOffset[sfb];
        int group = 0;
        while (group < g_len) {
            int cf = cfo;
            int len = off_len;
            do {
                int cb_idx;
                int nnz;
                int bits = (nnz = (cb_idx = vlc.readVLC(in)) >> 8 & 0xF) == 0 ? 0 : in.readNBit(nnz);
                this.VMUL4S(coef, cf, vq, cb_idx, bits, (float)this.sfs[idx]);
                cf += 4;
            } while ((len -= 4) > 0);
            ++group;
            cfo += 128;
        }
    }

    private void readBandType7Through10(BitReader in, float[] coef, int idx, int g2, int sfb, float[] vq, VLC vlc) {
        int g_len = this.group_len[g2];
        int cfo = this.swbOffset[sfb];
        int off_len = this.swbOffset[sfb + 1] - this.swbOffset[sfb];
        int group = 0;
        while (group < g_len) {
            int cf = cfo;
            int len = off_len;
            do {
                int cb_idx;
                int nnz;
                int bits = (nnz = (cb_idx = vlc.readVLC(in)) >> 8 & 0xF) == 0 ? 0 : in.readNBit(nnz) << (cb_idx >> 12);
                this.VMUL2S(coef, cf, vq, cb_idx, bits, (float)this.sfs[idx]);
                cf += 2;
            } while ((len -= 2) > 0);
            ++group;
            cfo += 128;
        }
    }

    private void readOther(BitReader in, float[] coef, int idx, int g2, int sfb, float[] vq, VLC vlc) {
        int g_len = this.group_len[g2];
        int cfo = this.swbOffset[sfb];
        int off_len = this.swbOffset[sfb + 1] - this.swbOffset[sfb];
        int group = 0;
        while (group < g_len) {
            int cf = cfo;
            int len = off_len;
            do {
                int cb_idx;
                if ((cb_idx = vlc.readVLC(in)) == 0) continue;
                int nnz = cb_idx >> 12;
                int nzt = cb_idx >> 8;
                int bits = in.readNBit(nnz) << 32 - nnz;
                for (int j2 = 0; j2 < 2; ++j2) {
                    if ((nzt & 1 << j2) != 0) {
                        int b2 = ProresDecoder.nZeros(~in.checkNBit(14));
                        if (b2 > 8) {
                            throw new RuntimeException("error in spectral data, ESC overflow\n");
                        }
                        in.skip(b2 + 1);
                        int n2 = (1 << (b2 += 4)) + in.readNBit(b2);
                        coef[cf++] = MathUtil.cubeRoot(n2) | bits & Integer.MIN_VALUE;
                        bits <<= 1;
                    } else {
                        int v = (int)vq[cb_idx & 0xF];
                        coef[cf++] = bits & Integer.MIN_VALUE | v;
                    }
                    cb_idx >>= 4;
                }
                cf += 2;
                len += 2;
            } while (len > 0);
            ++group;
            cfo += 128;
        }
    }

    private void readBandType1And2(BitReader in, float[] coef, int idx, int g2, int sfb, float[] vq, VLC vlc) {
        int g_len = this.group_len[g2];
        int cfo = this.swbOffset[sfb];
        int off_len = this.swbOffset[sfb + 1] - this.swbOffset[sfb];
        int group = 0;
        while (group < g_len) {
            int cf = cfo;
            int len = off_len;
            do {
                int cb_idx = vlc.readVLC(in);
                this.VMUL4(coef, cf, vq, cb_idx, (float)this.sfs[idx]);
                cf += 4;
            } while ((len -= 4) > 0);
            ++group;
            cfo += 128;
        }
    }

    private void readBandType5And6(BitReader in, float[] coef, int idx, int g2, int sfb, float[] vq, VLC vlc) {
        int g_len = this.group_len[g2];
        int cfo = this.swbOffset[sfb];
        int off_len = this.swbOffset[sfb + 1] - this.swbOffset[sfb];
        int group = 0;
        while (group < g_len) {
            int cf = cfo;
            int len = off_len;
            do {
                int cb_idx = vlc.readVLC(in);
                this.VMUL2(coef, cf, vq, cb_idx, (float)this.sfs[idx]);
                cf += 2;
            } while ((len -= 2) > 0);
            ++group;
            cfo += 128;
        }
    }

    @Override
    public void parse(BitReader in) {
        this.globalGain = in.readNBit(8);
        if (!this.commonWindow && !this.scaleFlag) {
            this.parseICSInfo(in);
        }
        this.decodeBandTypes(in);
        this.decodeScalefactors(in);
        int pulse_present = 0;
        if (!this.scaleFlag) {
            int tns_present;
            pulse_present = in.read1Bit();
            if (pulse_present != 0) {
                if (this.windowSequence == WindowSequence.EIGHT_SHORT_SEQUENCE.ordinal()) {
                    throw new RuntimeException("Pulse tool not allowed in eight short sequence.");
                }
                this.decodePulses(in);
            }
            if ((tns_present = in.read1Bit()) != 0) {
                this.decodeTns(in);
            }
            if (in.read1Bit() != 0) {
                throw new RuntimeException("SSR is not supported");
            }
        }
        this.decodeSpectrum(in);
    }

    static {
        vlc = new VLC(AACTab.ff_aac_scalefactor_code, AACTab.ff_aac_scalefactor_bits);
        spectral = new VLC[]{new VLCBuilder(AACTab.codes1, AACTab.bits1, AACTab.codebook_vector02_idx).getVLC(), new VLCBuilder(AACTab.codes2, AACTab.bits2, AACTab.codebook_vector02_idx).getVLC(), new VLCBuilder(AACTab.codes3, AACTab.bits3, AACTab.codebook_vector02_idx).getVLC(), new VLCBuilder(AACTab.codes4, AACTab.bits4, AACTab.codebook_vector02_idx).getVLC(), new VLCBuilder(AACTab.codes5, AACTab.bits5, AACTab.codebook_vector4_idx).getVLC(), new VLCBuilder(AACTab.codes6, AACTab.bits6, AACTab.codebook_vector4_idx).getVLC(), new VLCBuilder(AACTab.codes7, AACTab.bits7, AACTab.codebook_vector6_idx).getVLC(), new VLCBuilder(AACTab.codes8, AACTab.bits8, AACTab.codebook_vector6_idx).getVLC(), new VLCBuilder(AACTab.codes9, AACTab.bits9, AACTab.codebook_vector8_idx).getVLC(), new VLCBuilder(AACTab.codes10, AACTab.bits10, AACTab.codebook_vector8_idx).getVLC(), new VLCBuilder(AACTab.codes11, AACTab.bits11, AACTab.codebook_vector10_idx).getVLC()};
        ff_aac_pow2sf_tab = new float[428];
        for (int i2 = 0; i2 < 428; ++i2) {
            BlockICS.ff_aac_pow2sf_tab[i2] = (float)Math.pow(2.0, (double)(i2 - 200) / 4.0);
        }
    }

    public static class Tns {
        private int[] nFilt;
        private int[][] length;
        private int[][] order;
        private int[][] direction;
        private float[][][] coeff;

        public Tns(int[] nFilt, int[][] length, int[][] order, int[][] direction, float[][][] coeff) {
            this.nFilt = nFilt;
            this.length = length;
            this.order = order;
            this.direction = direction;
            this.coeff = coeff;
        }
    }

    public static class Pulse {
        private int numPulse;
        private int[] pos;
        private int[] amp;

        public Pulse(int numPulse, int[] pos, int[] amp) {
            this.numPulse = numPulse;
            this.pos = pos;
            this.amp = amp;
        }

        public int getNumPulse() {
            return this.numPulse;
        }

        public int[] getPos() {
            return this.pos;
        }

        public int[] getAmp() {
            return this.amp;
        }
    }

    static enum BandType {
        ZERO_BT,
        BT_1,
        BT_2,
        BT_3,
        BT_4,
        FIRST_PAIR_BT,
        BT_6,
        BT_7,
        BT_8,
        BT_9,
        BT_10,
        ESC_BT,
        BT_12,
        NOISE_BT,
        INTENSITY_BT2,
        INTENSITY_BT;

    }

    private static enum WindowSequence {
        ONLY_LONG_SEQUENCE,
        LONG_START_SEQUENCE,
        EIGHT_SHORT_SEQUENCE,
        LONG_STOP_SEQUENCE;

    }
}

