/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.algo;

public class DataConvert {
    public static int[] from16BE(byte[] b2) {
        int[] result = new int[b2.length >> 1];
        int off = 0;
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = (b2[off++] & 0xFF) << 8 | b2[off++] & 0xFF;
        }
        return result;
    }

    public static int[] from24BE(byte[] b2) {
        int[] result = new int[b2.length / 3];
        int off = 0;
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = (b2[off++] & 0xFF) << 16 | (b2[off++] & 0xFF) << 8 | b2[off++] & 0xFF;
        }
        return result;
    }

    public static int[] from16LE(byte[] b2) {
        int[] result = new int[b2.length >> 1];
        int off = 0;
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = b2[off++] & 0xFF | (b2[off++] & 0xFF) << 8;
        }
        return result;
    }

    public static int[] from24LE(byte[] b2) {
        int[] result = new int[b2.length / 3];
        int off = 0;
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = b2[off++] & 0xFF | (b2[off++] & 0xFF) << 8 | (b2[off++] & 0xFF) << 16;
        }
        return result;
    }

    public static byte[] to16BE(int[] ia) {
        byte[] result = new byte[ia.length << 1];
        int off = 0;
        for (int i2 = 0; i2 < ia.length; ++i2) {
            result[off++] = (byte)(ia[i2] >> 8 & 0xFF);
            result[off++] = (byte)(ia[i2] & 0xFF);
        }
        return result;
    }

    public static byte[] to24BE(int[] ia) {
        byte[] result = new byte[ia.length * 3];
        int off = 0;
        for (int i2 = 0; i2 < ia.length; ++i2) {
            result[off++] = (byte)(ia[i2] >> 16 & 0xFF);
            result[off++] = (byte)(ia[i2] >> 8 & 0xFF);
            result[off++] = (byte)(ia[i2] & 0xFF);
        }
        return result;
    }

    public static byte[] to16LE(int[] ia) {
        byte[] result = new byte[ia.length << 1];
        int off = 0;
        for (int i2 = 0; i2 < ia.length; ++i2) {
            result[off++] = (byte)(ia[i2] & 0xFF);
            result[off++] = (byte)(ia[i2] >> 8 & 0xFF);
        }
        return result;
    }

    public static byte[] to24LE(int[] ia) {
        byte[] result = new byte[ia.length * 3];
        int off = 0;
        for (int i2 = 0; i2 < ia.length; ++i2) {
            result[off++] = (byte)(ia[i2] & 0xFF);
            result[off++] = (byte)(ia[i2] >> 8 & 0xFF);
            result[off++] = (byte)(ia[i2] >> 16 & 0xFF);
        }
        return result;
    }

    public static int[] fromByte(byte[] b2, int depth, boolean isBe) {
        if (depth == 24) {
            if (isBe) {
                return DataConvert.from24BE(b2);
            }
            return DataConvert.from24LE(b2);
        }
        if (depth == 16) {
            if (isBe) {
                return DataConvert.from16BE(b2);
            }
            return DataConvert.from16LE(b2);
        }
        throw new IllegalArgumentException("Conversion from " + depth + "bit " + (isBe ? "big endian" : "little endian") + " is not supported.");
    }

    public static byte[] toByte(int[] ia, int depth, boolean isBe) {
        if (depth == 24) {
            if (isBe) {
                return DataConvert.to24BE(ia);
            }
            return DataConvert.to24LE(ia);
        }
        if (depth == 16) {
            if (isBe) {
                return DataConvert.to16BE(ia);
            }
            return DataConvert.to16LE(ia);
        }
        throw new IllegalArgumentException("Conversion to " + depth + "bit " + (isBe ? "big endian" : "little endian") + " is not supported.");
    }
}

