/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.algo;

import java.io.File;
import java.io.IOException;
import org.jcodec.algo.StreamInterpolator;
import org.jcodec.codecs.wav.WavHeader;
import org.jcodec.codecs.wav.WavInput;
import org.jcodec.codecs.wav.WavOutput;
import org.jcodec.common.Assert;
import org.jcodec.common.model.Rational;

public class BiliearStreamInterpolator
extends StreamInterpolator {
    private int pos;
    private int step;
    private int[] lastSamples;
    private int nLastSamples;
    public static final int ROUND = 128;
    public static final int SHIFT = 8;
    public static final int MASK = 255;
    private int c = 0;

    public BiliearStreamInterpolator(Rational r) {
        super(r);
        this.step = (r.getDen() << 8) / r.getNum();
        this.lastSamples = new int[256];
    }

    @Override
    public int[] interpolate(int[] in) {
        int[] result = new int[(int)(((long)in.length + (long)this.nLastSamples) * (long)this.ratio.getNum() / (long)this.ratio.getDen())];
        int[] in1 = new int[this.nLastSamples + in.length];
        System.arraycopy(this.lastSamples, 0, in1, 0, this.nLastSamples);
        System.arraycopy(in, 0, in1, this.nLastSamples, in.length);
        for (int i2 = 0; i2 < result.length - 1; ++i2) {
            int ind = this.pos >> 8;
            int s0 = in1[ind];
            int s1 = in1[ind + 1];
            result[i2] = this.interpolateH(s0, s1, this.pos & 0xFF);
            this.pos += this.step;
        }
        this.nLastSamples = in1.length - (this.pos >> 8);
        System.arraycopy(in1, this.pos >> 8, this.lastSamples, 0, this.nLastSamples);
        this.pos &= 0xFF;
        return result;
    }

    private final int interpolateH(int s0, int s1, int shift) {
        Assert.assertTrue(s0 >= 0);
        Assert.assertTrue(s1 >= 0);
        Assert.assertTrue(shift < 256);
        int s = (s0 << 8) + shift * (s1 - s0) + 128 >> 8;
        Assert.assertTrue("" + s + ", " + s0 + ", " + s1 + ", " + this.c++, s >= 0);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        WavInput inp = null;
        WavOutput out = null;
        try {
            int[] samples;
            inp = new WavInput(new File(args[0]));
            out = new WavOutput(new File(args[1]), new WavHeader(inp.getHeader(), 44100));
            BiliearStreamInterpolator in = new BiliearStreamInterpolator(new Rational(44100, 48000));
            while ((samples = inp.read(1024)) != null) {
                int[] outSamples = in.interpolate(samples);
                out.write(outSamples);
            }
        }
        finally {
            inp.close();
            out.close();
        }
    }
}

