/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.util.Vector;

class Tree
extends Panel {
    private static Font fFont = new Font("Dialog", 0, 12);
    private static FontMetrics fMetrics = Toolkit.getDefaultToolkit().getFontMetrics(fFont);
    private static int iRowHeight = Tree.getMaxHeight(fMetrics);
    private static int iIndentWidth = 12;
    private int iMaxTextLength;
    private Dimension dMinimum;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iFirstRow;
    private int iX;
    private int iY;
    private Vector vData = new Vector();
    private int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;

    Tree() {
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.dMinimum = dimension;
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = n5 - this.iSbHeight;
        this.iWidth = n4 - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    @Override
    public void removeAll() {
        this.vData = new Vector();
        this.iRowCount = 0;
        this.adjustScroll();
        this.iMaxTextLength = 10;
        this.repaint();
    }

    public void addRow(String string, String string2, String string3, int n2) {
        String[] stringArray = new String[4];
        if (string2 == null) {
            string2 = "";
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
        stringArray[3] = String.valueOf(n2);
        this.vData.addElement(stringArray);
        int n3 = fMetrics.stringWidth(string2);
        if (n3 > this.iMaxTextLength) {
            this.iMaxTextLength = n3;
        }
        ++this.iRowCount;
    }

    public void addRow(String string, String string2) {
        this.addRow(string, string2, null, 0);
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    void adjustScroll() {
        int n2 = iRowHeight * (this.iRowCount + 1);
        int n3 = this.iMaxTextLength * 2;
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, n3);
        int n4 = this.iY / iRowHeight;
        int n5 = this.iHeight / iRowHeight;
        this.sbVert.setValues(n4, n5, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = iRowHeight * this.sbVert.getValue();
    }

    @Override
    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null || this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        graphics.setColor(SystemColor.control);
        graphics.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(fFont);
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        int[] nArray = new int[100];
        String[] stringArray = new String[100];
        stringArray[0] = "";
        int n2 = 0;
        int n3 = iRowHeight;
        n3 -= this.iY;
        boolean bl = false;
        for (int i2 = 0; i2 < this.iRowCount; ++i2) {
            int n4;
            String[] stringArray2 = (String[])this.vData.elementAt(i2);
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            String string3 = stringArray2[2];
            for (n4 = n2; n4 > 0 && !string.startsWith(stringArray[n4]); --n4) {
            }
            if (stringArray[n4].length() < string.length()) {
                ++n4;
            }
            if (bl && n4 > n2) continue;
            bl = string3 != null && string3.equals("+");
            stringArray[n4] = string;
            int n5 = iIndentWidth * n4 - this.iX;
            this.gImage.setColor(Color.lightGray);
            this.gImage.drawLine(n5, n3, n5 + iIndentWidth, n3);
            this.gImage.drawLine(n5, n3, n5, nArray[n4]);
            nArray[n4 + 1] = n3;
            int n6 = n3 + iRowHeight / 3;
            int n7 = n5 + iIndentWidth * 2;
            if (string3 != null) {
                int n8 = n4 + 1;
                nArray[n8] = nArray[n8] + 4;
                int n9 = Integer.parseInt(stringArray2[3]);
                this.gImage.setColor(n9 == 0 ? Color.white : new Color(n9));
                this.gImage.fillRect(n5 + iIndentWidth - 3, n3 - 3, 7, 7);
                this.gImage.setColor(Color.black);
                this.gImage.drawRect(n5 + iIndentWidth - 4, n3 - 4, 8, 8);
                this.gImage.drawLine(n5 + iIndentWidth - 2, n3, n5 + iIndentWidth + 2, n3);
                if (string3.equals("+")) {
                    this.gImage.drawLine(n5 + iIndentWidth, n3 - 2, n5 + iIndentWidth, n3 + 2);
                }
            } else {
                n7 -= iIndentWidth;
            }
            this.gImage.setColor(Color.black);
            this.gImage.drawString(string2, n7, n6);
            n2 = n4;
            n3 += iRowHeight;
        }
        graphics.drawImage(this.iImage, 0, 0, this);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public Dimension preferredSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension minimumSize() {
        return this.dMinimum;
    }

    @Override
    public boolean mouseDown(Event event, int n2, int n3) {
        String string;
        String[] stringArray;
        int n4;
        if (iRowHeight == 0 || n2 > this.iWidth || n3 > this.iHeight) {
            return true;
        }
        n3 += iRowHeight / 2;
        String[] stringArray2 = new String[100];
        stringArray2[0] = "";
        int n5 = 0;
        int n6 = iRowHeight;
        boolean bl = false;
        n3 += this.iY;
        for (n4 = 0; n4 < this.iRowCount; ++n4) {
            int n7;
            stringArray = (String[])this.vData.elementAt(n4);
            string = stringArray[0];
            String string2 = stringArray[2];
            for (n7 = n5; n7 > 0 && !string.startsWith(stringArray2[n7]); --n7) {
            }
            if (stringArray2[n7].length() < string.length()) {
                ++n7;
            }
            if (bl && n7 > n5) continue;
            if (n6 <= n3 && n6 + iRowHeight > n3) break;
            stringArray2[n7] = string;
            bl = string2 != null && string2.equals("+");
            n5 = n7;
            n6 += iRowHeight;
        }
        if (n4 >= 0 && n4 < this.iRowCount) {
            stringArray = (String[])this.vData.elementAt(n4);
            string = stringArray[2];
            if (string != null && string.equals("+")) {
                string = "-";
            } else if (string != null && string.equals("-")) {
                string = "+";
            }
            stringArray[2] = string;
            this.vData.setElementAt(stringArray, n4);
            this.repaint();
        }
        return true;
    }

    private static int getMaxHeight(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() + 2;
    }
}

