/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.error.Error;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class IntervalSecondData {
    public static final IntervalSecondData oneDay = IntervalSecondData.newIntervalDay(1L, Type.SQL_INTERVAL_DAY);
    final long units;
    final int nanos;

    public static IntervalSecondData newInterval(double d2, int n2) {
        int n3 = DTIType.intervalIndexMap.get(n2);
        return new IntervalSecondData((long)(d2 *= (double)DTIType.yearToSecondFactors[n3]), 0);
    }

    public static IntervalSecondData newIntervalDay(long l2, IntervalType intervalType) {
        return new IntervalSecondData(l2 * 24L * 60L * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalHour(long l2, IntervalType intervalType) {
        return new IntervalSecondData(l2 * 60L * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalMinute(long l2, IntervalType intervalType) {
        return new IntervalSecondData(l2 * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalSeconds(long l2, IntervalType intervalType) {
        return new IntervalSecondData(l2, 0, intervalType);
    }

    public IntervalSecondData(long l2, int n2, IntervalType intervalType) {
        if (l2 >= intervalType.getIntervalValueLimit()) {
            throw Error.error(3435);
        }
        this.units = l2;
        this.nanos = n2;
    }

    public IntervalSecondData(long l2, int n2) {
        this.units = l2;
        this.nanos = n2;
    }

    public IntervalSecondData(long l2, long l3, IntervalType intervalType, boolean bl) {
        long l4;
        if (l3 >= 1000000000L) {
            l4 = l3 / 1000000000L;
            l3 %= 1000000000L;
            l2 += l4;
        } else if (l3 <= -1000000000L) {
            l4 = -l3 / 1000000000L;
            l3 = -(-l3 % 1000000000L);
            l2 -= l4;
        }
        int n2 = DTIType.nanoScaleFactors[intervalType.scale];
        l3 /= (long)n2;
        if (l2 > 0L && (l3 *= (long)n2) < 0L) {
            l3 += 1000000000L;
            --l2;
        } else if (l2 < 0L && l3 > 0L) {
            l3 -= 1000000000L;
            ++l2;
        }
        n2 = DTIType.yearToSecondFactors[intervalType.endPartIndex];
        l2 /= (long)n2;
        if ((l2 *= (long)n2) >= intervalType.getIntervalValueLimit()) {
            throw Error.error(3435);
        }
        this.units = l2;
        this.nanos = (int)l3;
    }

    public boolean equals(Object object) {
        if (object instanceof IntervalSecondData) {
            return this.units == ((IntervalSecondData)object).units && this.nanos == ((IntervalSecondData)object).nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.units ^ this.nanos;
    }

    public int compareTo(IntervalSecondData intervalSecondData) {
        if (this.units > intervalSecondData.units) {
            return 1;
        }
        if (this.units < intervalSecondData.units) {
            return -1;
        }
        if (this.nanos > intervalSecondData.nanos) {
            return 1;
        }
        if (this.nanos < intervalSecondData.nanos) {
            return -1;
        }
        return 0;
    }

    public long getSeconds() {
        return this.units;
    }

    public int getNanos() {
        return this.nanos;
    }

    public String toString() {
        return Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION.convertToString(this);
    }
}

